/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerpolicy;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.AttendeeInfo;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeLevel;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerpolicy.ActiveSpeakerPolicy;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/DefaultActiveSpeakerPolicy;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/ActiveSpeakerPolicy;", "speakerWeight", "", "cutoffThreshold", "takeoverRate", "silenceThreshold", "(DDDD)V", "normalizeFactor", "", "speakerScores", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;", "calculateScore", "attendeeInfo", "volume", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeLevel;", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultActiveSpeakerPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultActiveSpeakerPolicy.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/DefaultActiveSpeakerPolicy\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,69:1\n487#2,7:70\n216#3,2:77\n*S KotlinDebug\n*F\n+ 1 DefaultActiveSpeakerPolicy.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/DefaultActiveSpeakerPolicy\n*L\n58#1:70,7\n58#1:77,2\n*E\n"})
public final class DefaultActiveSpeakerPolicy
implements ActiveSpeakerPolicy {
    private final double speakerWeight;
    private final double cutoffThreshold;
    private final double takeoverRate;
    private final double silenceThreshold;
    @NotNull
    private Map<AttendeeInfo, Double> speakerScores;
    private final int normalizeFactor;

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight, double cutoffThreshold, double takeoverRate, double silenceThreshold) {
        this.speakerWeight = speakerWeight;
        this.cutoffThreshold = cutoffThreshold;
        this.takeoverRate = takeoverRate;
        this.silenceThreshold = silenceThreshold;
        this.speakerScores = new LinkedHashMap();
        this.normalizeFactor = 3;
    }

    public /* synthetic */ DefaultActiveSpeakerPolicy(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.9;
        }
        if ((n & 2) != 0) {
            d2 = 0.01;
        }
        if ((n & 4) != 0) {
            d3 = 0.2;
        }
        if ((n & 8) != 0) {
            d4 = 0.2;
        }
        this(d, d2, d3, d4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double calculateScore(@NotNull AttendeeInfo attendeeInfo, @NotNull VolumeLevel volume) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)attendeeInfo, (String)"attendeeInfo");
        Intrinsics.checkNotNullParameter((Object)((Object)volume), (String)"volume");
        double normalizedVolume = 0.0;
        normalizedVolume = (double)volume.getValue() / (double)this.normalizeFactor;
        if (!this.speakerScores.containsKey(attendeeInfo)) {
            this.speakerScores.put(attendeeInfo, 0.0);
        }
        normalizedVolume = normalizedVolume > this.silenceThreshold ? 1.0 : 0.0;
        double score = ((Number)MapsKt.getValue(this.speakerScores, (Object)attendeeInfo)).doubleValue() * this.speakerWeight + normalizedVolume * (1.0 - this.speakerWeight);
        Double d = score;
        this.speakerScores.put(attendeeInfo, d);
        Map $this$filterKeys$iv = this.speakerScores;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<AttendeeInfo, Double> result$iv = new LinkedHashMap<AttendeeInfo, Double>();
        for (Map.Entry<AttendeeInfo, Double> entry$iv : $this$filterKeys$iv.entrySet()) {
            AttendeeInfo it = entry$iv.getKey();
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)attendeeInfo))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            AttendeeInfo otherAttendee = (AttendeeInfo)entry.getKey();
            double currentScore = ((Number)entry.getValue()).doubleValue();
            double newOtherAttendeeScore = currentScore - this.takeoverRate * normalizedVolume;
            this.speakerScores.put(otherAttendee, Math.max(newOtherAttendeeScore, 0.0));
        }
        if (score < this.cutoffThreshold) {
            return 0.0;
        }
        return score;
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight, double cutoffThreshold, double takeoverRate) {
        this(speakerWeight, cutoffThreshold, takeoverRate, 0.0, 8, null);
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight, double cutoffThreshold) {
        this(speakerWeight, cutoffThreshold, 0.0, 0.0, 12, null);
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight) {
        this(speakerWeight, 0.0, 0.0, 0.0, 14, null);
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy() {
        this(0.0, 0.0, 0.0, 0.0, 15, null);
    }
}

