/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerdetector;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.AttendeeInfo;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.SignalUpdate;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeLevel;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeUpdate;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerdetector.ActiveSpeakerDetectorFacade;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerdetector.ActiveSpeakerObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerpolicy.ActiveSpeakerPolicy;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.realtime.RealtimeObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\rH\u0016J\u001b\u0010#\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010(\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010)\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010*\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010+\u001a\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0%H\u0016\u00a2\u0006\u0002\u0010.J\u001b\u0010/\u001a\u00020 2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010%H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010$\u001a\u00020\u0010H\u0002J\b\u00106\u001a\u00020 H\u0002J\u0010\u00107\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rH\u0002J\b\u00108\u001a\u00020 H\u0002J\u0010\u00109\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0010H\u0002J \u0010;\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/DefaultActiveSpeakerDetector;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/ActiveSpeakerDetectorFacade;", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/RealtimeObserver;", "audioClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;)V", "ACTIVITY_UPDATE_INTERVAL_MS", "", "ACTIVITY_WAIT_INTERVAL_MS", "TAG", "", "activeSpeakerObservers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/ActiveSpeakerObserver;", "activeSpeakers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;", "activityTimer", "Ljava/util/Timer;", "getAudioClientObserver", "()Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "mostRecentAttendeeVolumes", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeLevel;", "mostRecentUpdateTimestamp", "observerToPolicy", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/ActiveSpeakerPolicy;", "observerToScoresTimer", "speakerScores", "Ljava/util/concurrent/ConcurrentHashMap;", "", "addActiveSpeakerObserver", "", "policy", "observer", "onAttendeesDropped", "attendeeInfo", "", "([Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;)V", "onAttendeesJoined", "onAttendeesLeft", "onAttendeesMuted", "onAttendeesUnmuted", "onSignalStrengthChanged", "signalUpdates", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/SignalUpdate;", "([Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/SignalUpdate;)V", "onVolumeChanged", "volumeUpdates", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeUpdate;", "([Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeUpdate;)V", "removeActiveSpeakerObserver", "shouldUpdateActiveSpeakerList", "", "startActivityTimer", "startScoresTimerForObserver", "stopActivityTimer", "stopScoresTimerForObserver", "updateActiveSpeakers", "updateScore", "volume", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultActiveSpeakerDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultActiveSpeakerDetector.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/DefaultActiveSpeakerDetector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,190:1\n503#2,7:191\n1053#3:198\n1557#3:199\n1628#3,3:200\n1863#3:203\n1864#3:206\n37#4,2:204\n13409#5,2:207\n13409#5,2:209\n13409#5,2:211\n*S KotlinDebug\n*F\n+ 1 DefaultActiveSpeakerDetector.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/DefaultActiveSpeakerDetector\n*L\n139#1:191,7\n139#1:198\n139#1:199\n139#1:200,3\n140#1:203\n140#1:206\n141#1:204,2\n153#1:207,2\n159#1:209,2\n166#1:211,2\n*E\n"})
public final class DefaultActiveSpeakerDetector
implements ActiveSpeakerDetectorFacade,
RealtimeObserver {
    @NotNull
    private final AudioClientObserver audioClientObserver;
    @NotNull
    private ConcurrentHashMap<AttendeeInfo, Double> speakerScores;
    @NotNull
    private List<AttendeeInfo> activeSpeakers;
    @NotNull
    private Map<AttendeeInfo, Long> mostRecentUpdateTimestamp;
    @NotNull
    private Map<AttendeeInfo, VolumeLevel> mostRecentAttendeeVolumes;
    @NotNull
    private Set<ActiveSpeakerObserver> activeSpeakerObservers;
    @NotNull
    private Map<ActiveSpeakerObserver, ActiveSpeakerPolicy> observerToPolicy;
    @NotNull
    private Map<ActiveSpeakerObserver, Timer> observerToScoresTimer;
    @NotNull
    private Timer activityTimer;
    private final long ACTIVITY_WAIT_INTERVAL_MS;
    private final long ACTIVITY_UPDATE_INTERVAL_MS;
    @NotNull
    private final String TAG;

    public DefaultActiveSpeakerDetector(@NotNull AudioClientObserver audioClientObserver) {
        Intrinsics.checkNotNullParameter((Object)audioClientObserver, (String)"audioClientObserver");
        this.audioClientObserver = audioClientObserver;
        this.speakerScores = new ConcurrentHashMap();
        this.activeSpeakers = new ArrayList();
        this.mostRecentUpdateTimestamp = new LinkedHashMap();
        this.mostRecentAttendeeVolumes = new LinkedHashMap();
        this.activeSpeakerObservers = new LinkedHashSet();
        this.observerToPolicy = new LinkedHashMap();
        this.observerToScoresTimer = new LinkedHashMap();
        this.activityTimer = new Timer("ScheduleActivityTimer", false);
        this.ACTIVITY_WAIT_INTERVAL_MS = 1000L;
        this.ACTIVITY_UPDATE_INTERVAL_MS = 200L;
        this.TAG = "ActiveSpeakerDetector";
        this.audioClientObserver.subscribeToRealTimeEvents(this);
    }

    @NotNull
    public final AudioClientObserver getAudioClientObserver() {
        return this.audioClientObserver;
    }

    @Override
    public void addActiveSpeakerObserver(@NotNull ActiveSpeakerPolicy policy, @NotNull ActiveSpeakerObserver observer) {
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        boolean isFirstObserver = this.activeSpeakerObservers.isEmpty();
        this.activeSpeakerObservers.add(observer);
        this.observerToPolicy.put(observer, policy);
        if (isFirstObserver) {
            this.startActivityTimer();
        }
        this.startScoresTimerForObserver(observer);
    }

    @Override
    public void removeActiveSpeakerObserver(@NotNull ActiveSpeakerObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.activeSpeakerObservers.remove(observer);
        this.observerToPolicy.remove(observer);
        this.stopScoresTimerForObserver(observer);
        if (this.activeSpeakerObservers.isEmpty()) {
            this.stopActivityTimer();
        }
    }

    private final void startActivityTimer() {
        this.activityTimer = new Timer("ScheduleActivityTimer", false);
        this.activityTimer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ DefaultActiveSpeakerDetector this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void $this$forEach$iv;
                Iterator<V> iterator = DefaultActiveSpeakerDetector.access$getObserverToPolicy$p(this.this$0).values().iterator();
                DefaultActiveSpeakerDetector defaultActiveSpeakerDetector = this.this$0;
                boolean $i$f$forEach = false;
                void var4_4 = $this$forEach$iv;
                while (var4_4.hasNext()) {
                    E element$iv = var4_4.next();
                    ActiveSpeakerPolicy policy = (ActiveSpeakerPolicy)element$iv;
                    boolean bl = false;
                    Iterator<E> $this$forEach$iv2 = DefaultActiveSpeakerDetector.access$getSpeakerScores$p(defaultActiveSpeakerDetector).keySet().iterator();
                    boolean $i$f$forEach2 = false;
                    Iterator<E> iterator2 = $this$forEach$iv2;
                    while (iterator2.hasNext()) {
                        long lastTimestamp;
                        E element$iv2 = iterator2.next();
                        AttendeeInfo attendeeInfo = (AttendeeInfo)element$iv2;
                        boolean bl2 = false;
                        Long l = (Long)DefaultActiveSpeakerDetector.access$getMostRecentUpdateTimestamp$p(defaultActiveSpeakerDetector).get(attendeeInfo);
                        long l2 = lastTimestamp = l != null ? l : 0L;
                        if (System.currentTimeMillis() - lastTimestamp <= DefaultActiveSpeakerDetector.access$getACTIVITY_WAIT_INTERVAL_MS$p(defaultActiveSpeakerDetector)) continue;
                        Intrinsics.checkNotNull((Object)attendeeInfo);
                        VolumeLevel volumeLevel = (VolumeLevel)((Object)DefaultActiveSpeakerDetector.access$getMostRecentAttendeeVolumes$p(defaultActiveSpeakerDetector).get(attendeeInfo));
                        if (volumeLevel == null) {
                            volumeLevel = VolumeLevel.NotSpeaking;
                        }
                        DefaultActiveSpeakerDetector.access$updateScore(defaultActiveSpeakerDetector, policy, attendeeInfo, volumeLevel);
                    }
                }
            }
        }, this.ACTIVITY_UPDATE_INTERVAL_MS, this.ACTIVITY_UPDATE_INTERVAL_MS);
    }

    private final void startScoresTimerForObserver(ActiveSpeakerObserver observer) {
        block0: {
            Integer n = observer.getScoreCallbackIntervalMs();
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Timer scoresTimer = new Timer("ScheduleScoresTimer", false);
            scoresTimer.scheduleAtFixedRate(new TimerTask(observer, this){
                final /* synthetic */ ActiveSpeakerObserver $observer;
                final /* synthetic */ DefaultActiveSpeakerDetector this$0;
                {
                    this.$observer = $observer;
                    this.this$0 = $receiver;
                }

                public void run() {
                    this.$observer.onActiveSpeakerScoreChanged(DefaultActiveSpeakerDetector.access$getSpeakerScores$p(this.this$0));
                }
            }, it, (long)it);
            this.observerToScoresTimer.put(observer, scoresTimer);
        }
    }

    private final void stopActivityTimer() {
        if (this.activeSpeakerObservers.isEmpty()) {
            this.activityTimer.cancel();
        }
    }

    private final void stopScoresTimerForObserver(ActiveSpeakerObserver observer) {
        block0: {
            Timer timer = this.observerToScoresTimer.get(observer);
            if (timer == null) break block0;
            Timer it = timer;
            boolean bl = false;
            it.cancel();
            this.observerToScoresTimer.remove(observer);
        }
    }

    private final void updateScore(ActiveSpeakerPolicy policy, AttendeeInfo attendeeInfo, VolumeLevel volume) {
        double activeScore = policy.calculateScore(attendeeInfo, volume);
        if (!Intrinsics.areEqual((Double)this.speakerScores.get(attendeeInfo), (double)activeScore)) {
            Double d = activeScore;
            ((Map)this.speakerScores).put(attendeeInfo, d);
            this.mostRecentUpdateTimestamp.put(attendeeInfo, System.currentTimeMillis());
            this.updateActiveSpeakers(attendeeInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateActiveSpeakers(AttendeeInfo attendeeInfo) {
        void $this$mapTo$iv$iv;
        if (!this.shouldUpdateActiveSpeakerList(attendeeInfo)) {
            return;
        }
        Map $this$filterValues$iv = this.speakerScores;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            double it = ((Number)entry$iv.getValue()).doubleValue();
            boolean bl = false;
            if (!(!(it == 0.0))) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$sortedBy$iv = MapsKt.toList((Map)((Map)result$iv));
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                double value = ((Number)pair.component2()).doubleValue();
                pair = (Pair)b;
                Comparable comparable = Double.valueOf(value);
                bl = false;
                value = ((Number)pair.component2()).doubleValue();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(value));
            }
        });
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add((AttendeeInfo)it.getFirst());
        }
        List sortedSpeakers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = this.activeSpeakerObservers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ActiveSpeakerObserver it = (ActiveSpeakerObserver)element$iv;
            boolean bl = false;
            Collection $this$toTypedArray$iv = sortedSpeakers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            it.onActiveSpeakerDetected(thisCollection$iv.toArray(new AttendeeInfo[0]));
        }
        this.activeSpeakers = CollectionsKt.toMutableList((Collection)sortedSpeakers);
    }

    private final boolean shouldUpdateActiveSpeakerList(AttendeeInfo attendeeInfo) {
        double score;
        Double d = this.speakerScores.get(attendeeInfo);
        if (d == null) {
            d = 0.0;
        }
        return (score = ((Number)d).doubleValue()) == 0.0 && this.activeSpeakers.contains(attendeeInfo) || score > 0.0 && !this.activeSpeakers.contains(attendeeInfo);
    }

    @Override
    public void onVolumeChanged(@NotNull VolumeUpdate[] volumeUpdates) {
        Intrinsics.checkNotNullParameter((Object)volumeUpdates, (String)"volumeUpdates");
        VolumeUpdate[] $this$forEach$iv = volumeUpdates;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            VolumeUpdate element$iv;
            VolumeUpdate it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.mostRecentAttendeeVolumes.put(it.getAttendeeInfo(), it.getVolumeLevel());
        }
    }

    @Override
    public void onAttendeesJoined(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkNotNullParameter((Object)attendeeInfo, (String)"attendeeInfo");
        AttendeeInfo[] $this$forEach$iv = attendeeInfo;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            AttendeeInfo element$iv;
            AttendeeInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ((Map)this.speakerScores).put(it, 0.0);
            this.mostRecentAttendeeVolumes.put(it, VolumeLevel.NotSpeaking);
        }
    }

    @Override
    public void onAttendeesLeft(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkNotNullParameter((Object)attendeeInfo, (String)"attendeeInfo");
        AttendeeInfo[] $this$forEach$iv = attendeeInfo;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            AttendeeInfo element$iv;
            AttendeeInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.speakerScores.remove(it);
            this.mostRecentAttendeeVolumes.remove(it);
            this.mostRecentUpdateTimestamp.remove(it);
            this.updateActiveSpeakers(it);
        }
    }

    @Override
    public void onAttendeesDropped(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkNotNullParameter((Object)attendeeInfo, (String)"attendeeInfo");
        this.onAttendeesLeft(attendeeInfo);
    }

    @Override
    public void onSignalStrengthChanged(@NotNull SignalUpdate[] signalUpdates) {
        Intrinsics.checkNotNullParameter((Object)signalUpdates, (String)"signalUpdates");
    }

    @Override
    public void onAttendeesMuted(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkNotNullParameter((Object)attendeeInfo, (String)"attendeeInfo");
    }

    @Override
    public void onAttendeesUnmuted(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkNotNullParameter((Object)attendeeInfo, (String)"attendeeInfo");
    }

    public static final /* synthetic */ Map access$getObserverToPolicy$p(DefaultActiveSpeakerDetector $this) {
        return $this.observerToPolicy;
    }

    public static final /* synthetic */ Map access$getMostRecentUpdateTimestamp$p(DefaultActiveSpeakerDetector $this) {
        return $this.mostRecentUpdateTimestamp;
    }

    public static final /* synthetic */ long access$getACTIVITY_WAIT_INTERVAL_MS$p(DefaultActiveSpeakerDetector $this) {
        return $this.ACTIVITY_WAIT_INTERVAL_MS;
    }

    public static final /* synthetic */ void access$updateScore(DefaultActiveSpeakerDetector $this, ActiveSpeakerPolicy policy, AttendeeInfo attendeeInfo, VolumeLevel volume) {
        $this.updateScore(policy, attendeeInfo, volume);
    }

    public static final /* synthetic */ Map access$getMostRecentAttendeeVolumes$p(DefaultActiveSpeakerDetector $this) {
        return $this.mostRecentAttendeeVolumes;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSpeakerScores$p(DefaultActiveSpeakerDetector $this) {
        return $this.speakerScores;
    }
}

