/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.session;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoResolution;
import com.amazonaws.services.chime.sdk.meetings.session.CreateMeetingResponse;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingFeatures;", "", "createMeetingResponse", "Lcom/amazonaws/services/chime/sdk/meetings/session/CreateMeetingResponse;", "(Lcom/amazonaws/services/chime/sdk/meetings/session/CreateMeetingResponse;)V", "videoMaxResolution", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "contentMaxResolution", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;)V", "getContentMaxResolution", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "getVideoMaxResolution", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "amazon-chime-sdk_release"})
public final class MeetingFeatures {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VideoResolution videoMaxResolution;
    @NotNull
    private final VideoResolution contentMaxResolution;

    public MeetingFeatures(@NotNull VideoResolution videoMaxResolution, @NotNull VideoResolution contentMaxResolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)videoMaxResolution), (String)"videoMaxResolution");
        Intrinsics.checkNotNullParameter((Object)((Object)contentMaxResolution), (String)"contentMaxResolution");
        this.videoMaxResolution = videoMaxResolution;
        this.contentMaxResolution = contentMaxResolution;
    }

    public /* synthetic */ MeetingFeatures(VideoResolution videoResolution, VideoResolution videoResolution2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            videoResolution = VideoResolution.VideoResolutionHD;
        }
        if ((n & 2) != 0) {
            videoResolution2 = VideoResolution.VideoResolutionFHD;
        }
        this(videoResolution, videoResolution2);
    }

    @NotNull
    public final VideoResolution getVideoMaxResolution() {
        return this.videoMaxResolution;
    }

    @NotNull
    public final VideoResolution getContentMaxResolution() {
        return this.contentMaxResolution;
    }

    @JvmOverloads
    public MeetingFeatures(@NotNull CreateMeetingResponse createMeetingResponse) {
        Intrinsics.checkNotNullParameter((Object)createMeetingResponse, (String)"createMeetingResponse");
        this(createMeetingResponse.getMeeting().getMeetingFeatures().videoMaxResolution, createMeetingResponse.getMeeting().getMeetingFeatures().contentMaxResolution);
    }

    @NotNull
    public final VideoResolution component1() {
        return this.videoMaxResolution;
    }

    @NotNull
    public final VideoResolution component2() {
        return this.contentMaxResolution;
    }

    @NotNull
    public final MeetingFeatures copy(@NotNull VideoResolution videoMaxResolution, @NotNull VideoResolution contentMaxResolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)videoMaxResolution), (String)"videoMaxResolution");
        Intrinsics.checkNotNullParameter((Object)((Object)contentMaxResolution), (String)"contentMaxResolution");
        return new MeetingFeatures(videoMaxResolution, contentMaxResolution);
    }

    public static /* synthetic */ MeetingFeatures copy$default(MeetingFeatures meetingFeatures, VideoResolution videoResolution, VideoResolution videoResolution2, int n, Object object) {
        if ((n & 1) != 0) {
            videoResolution = meetingFeatures.videoMaxResolution;
        }
        if ((n & 2) != 0) {
            videoResolution2 = meetingFeatures.contentMaxResolution;
        }
        return meetingFeatures.copy(videoResolution, videoResolution2);
    }

    @NotNull
    public String toString() {
        return "MeetingFeatures(videoMaxResolution=" + this.videoMaxResolution + ", contentMaxResolution=" + this.contentMaxResolution + ")";
    }

    public int hashCode() {
        int result = this.videoMaxResolution.hashCode();
        result = result * 31 + this.contentMaxResolution.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MeetingFeatures)) {
            return false;
        }
        MeetingFeatures meetingFeatures = (MeetingFeatures)other;
        if (this.videoMaxResolution != meetingFeatures.videoMaxResolution) {
            return false;
        }
        return this.contentMaxResolution == meetingFeatures.contentMaxResolution;
    }

    public MeetingFeatures() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0086\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingFeatures$Companion;", "", "()V", "invoke", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingFeatures;", "video", "", "content", "parseMaxResolution", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "resolution", "amazon-chime-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VideoResolution parseMaxResolution(@NotNull String resolution) {
            Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
            VideoResolution maxResolution = null;
            String string = resolution.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
            switch (string) {
                case "none": {
                    maxResolution = VideoResolution.Disabled;
                    break;
                }
                case "hd": {
                    maxResolution = VideoResolution.VideoResolutionHD;
                    break;
                }
                case "fhd": {
                    maxResolution = VideoResolution.VideoResolutionFHD;
                    break;
                }
                default: {
                    maxResolution = VideoResolution.VideoResolutionUHD;
                }
            }
            return maxResolution;
        }

        @NotNull
        public final MeetingFeatures invoke(@Nullable String video, @Nullable String content) {
            String string = video;
            if (string == null) {
                string = "HD";
            }
            VideoResolution videoResolution = this.parseMaxResolution(string);
            String string2 = content;
            if (string2 == null) {
                string2 = "FHD";
            }
            return new MeetingFeatures(videoResolution, this.parseMaxResolution(string2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

