/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/TimezoneUtils;", "", "()V", "Companion", "amazon-chime-sdk_release"})
public final class TimezoneUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String UTC_OFFSET_FORMAT = "%02d:%02d";

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/TimezoneUtils$Companion;", "", "()V", "UTC_OFFSET_FORMAT", "", "getUtcOffset", "timezone", "Ljava/util/TimeZone;", "amazon-chime-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUtcOffset(@NotNull TimeZone timezone) {
            Intrinsics.checkNotNullParameter((Object)timezone, (String)"timezone");
            int offsetMillis = timezone.getOffset(GregorianCalendar.getInstance(timezone).getTimeInMillis());
            int offsetHours = Math.abs(offsetMillis / 60000 / 60);
            int offsetMinutes = Math.abs(offsetMillis / 60000 % 60);
            String string = TimezoneUtils.UTC_OFFSET_FORMAT;
            Object[] objectArray = new Object[]{offsetHours, offsetMinutes};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            Object offset = string2;
            offset = (offsetMillis >= 0 ? "+" : "-") + (String)offset;
            return offset;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

