/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import com.amazonaws.services.chime.sdk.meetings.internal.video.TURNCredentials;
import com.amazonaws.services.chime.sdk.meetings.internal.video.TURNRequestParams;
import com.amazonaws.services.chime.sdk.meetings.utils.DefaultModality;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/TURNRequestUtils;", "", "()V", "CONTENT_TYPE", "", "CONTENT_TYPE_HEADER", "MEETING_ID_KEY", "SYSPROP_USER_AGENT", "TAG", "TOKEN_HEADER", "TOKEN_KEY", "USER_AGENT_HEADER", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "doTurnRequest", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNCredentials;", "turnRequestParams", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNRequestParams;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/video/TURNRequestParams;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "amazon-chime-sdk_release"})
public final class TURNRequestUtils {
    @NotNull
    public static final TURNRequestUtils INSTANCE = new TURNRequestUtils();
    @NotNull
    private static final String TOKEN_HEADER = "X-Chime-Auth-Token";
    @NotNull
    private static final String SYSPROP_USER_AGENT = "http.agent";
    @NotNull
    private static final String USER_AGENT_HEADER = "User-Agent";
    @NotNull
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    @NotNull
    private static final String CONTENT_TYPE = "application/json";
    @NotNull
    private static final String MEETING_ID_KEY = "meetingId";
    @NotNull
    private static final String TOKEN_KEY = "_aws_wt_session";
    @NotNull
    private static final String TAG = "TURNRequestUtils";
    @NotNull
    private static final CoroutineDispatcher ioDispatcher = Dispatchers.getIO();

    private TURNRequestUtils() {
    }

    @Nullable
    public final Object doTurnRequest(@NotNull TURNRequestParams turnRequestParams, @NotNull Logger logger, @NotNull Continuation<? super TURNCredentials> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)ioDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TURNCredentials>, Object>(logger, turnRequestParams, null){
            int label;
            final /* synthetic */ Logger $logger;
            final /* synthetic */ TURNRequestParams $turnRequestParams;
            {
                this.$logger = $logger;
                this.$turnRequestParams = $turnRequestParams;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        TURNCredentials tURNCredentials;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            TURNCredentials tURNCredentials2;
                            StringBuffer response = new StringBuffer();
                            this.$logger.info(TURNRequestUtils.access$getTAG$p(), "Making TURN Request");
                            URLConnection uRLConnection = new URL(this.$turnRequestParams.getTurnControlUrl()).openConnection();
                            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                            TURNRequestParams tURNRequestParams = this.$turnRequestParams;
                            Logger logger = this.$logger;
                            HttpURLConnection $this$invokeSuspend_u24lambda_u241 = httpURLConnection;
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u241.setRequestMethod("POST");
                            $this$invokeSuspend_u24lambda_u241.setDoInput(true);
                            $this$invokeSuspend_u24lambda_u241.setDoOutput(true);
                            $this$invokeSuspend_u24lambda_u241.addRequestProperty(TURNRequestUtils.access$getTOKEN_HEADER$p(), TURNRequestUtils.access$getTOKEN_KEY$p() + "=" + new DefaultModality(tURNRequestParams.getJoinToken()).base());
                            $this$invokeSuspend_u24lambda_u241.setRequestProperty(TURNRequestUtils.access$getCONTENT_TYPE_HEADER$p(), TURNRequestUtils.access$getCONTENT_TYPE$p());
                            String user_agent = System.getProperty(TURNRequestUtils.access$getSYSPROP_USER_AGENT$p());
                            logger.info(TURNRequestUtils.access$getTAG$p(), "User Agent while doing TURN request is " + user_agent);
                            $this$invokeSuspend_u24lambda_u241.setRequestProperty(TURNRequestUtils.access$getUSER_AGENT_HEADER$p(), user_agent);
                            BufferedWriter out = new BufferedWriter(new OutputStreamWriter($this$invokeSuspend_u24lambda_u241.getOutputStream()));
                            out.write(new JSONObject().put(TURNRequestUtils.access$getMEETING_ID_KEY$p(), (Object)tURNRequestParams.getMeetingId()).toString());
                            out.flush();
                            out.close();
                            Closeable closeable = new BufferedReader(new InputStreamReader($this$invokeSuspend_u24lambda_u241.getInputStream()));
                            Throwable throwable = null;
                            try {
                                BufferedReader it = (BufferedReader)closeable;
                                boolean bl2 = false;
                                String inputLine = it.readLine();
                                while (inputLine != null) {
                                    response.append(inputLine);
                                    inputLine = it.readLine();
                                }
                                it.close();
                                it = Unit.INSTANCE;
                            }
                            catch (Throwable it) {
                                throwable = it;
                                throw it;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            if ($this$invokeSuspend_u24lambda_u241.getResponseCode() == 200) {
                                logger.info(TURNRequestUtils.access$getTAG$p(), "TURN Request Success");
                                JSONObject responseObject = new JSONObject(response.toString());
                                JSONArray jsonArray = responseObject.getJSONArray("uris");
                                String[] uris = new String[jsonArray.length()];
                                int n = jsonArray.length();
                                for (int i = 0; i < n; ++i) {
                                    uris[i] = jsonArray.getString(i);
                                }
                                String string = responseObject.getString("username");
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                                String string2 = responseObject.getString("password");
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                                String string3 = responseObject.getString("ttl");
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                                tURNCredentials2 = new TURNCredentials(string, string2, string3, uris);
                            } else {
                                logger.error(TURNRequestUtils.access$getTAG$p(), "TURN Request got error with Response code: " + $this$invokeSuspend_u24lambda_u241.getResponseCode());
                                tURNCredentials2 = null;
                            }
                            tURNCredentials = tURNCredentials2;
                        }
                        catch (Exception exception) {
                            this.$logger.error(TURNRequestUtils.access$getTAG$p(), "Exception while doing TURN Request: " + exception);
                            tURNCredentials = null;
                        }
                        return tURNCredentials;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super TURNCredentials> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ String access$getTAG$p() {
        return TAG;
    }

    public static final /* synthetic */ String access$getTOKEN_HEADER$p() {
        return TOKEN_HEADER;
    }

    public static final /* synthetic */ String access$getTOKEN_KEY$p() {
        return TOKEN_KEY;
    }

    public static final /* synthetic */ String access$getCONTENT_TYPE_HEADER$p() {
        return CONTENT_TYPE_HEADER;
    }

    public static final /* synthetic */ String access$getCONTENT_TYPE$p() {
        return CONTENT_TYPE;
    }

    public static final /* synthetic */ String access$getSYSPROP_USER_AGENT$p() {
        return SYSPROP_USER_AGENT;
    }

    public static final /* synthetic */ String access$getUSER_AGENT_HEADER$p() {
        return USER_AGENT_HEADER;
    }

    public static final /* synthetic */ String access$getMEETING_ID_KEY$p() {
        return MEETING_ID_KEY;
    }
}

