/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.DeviceUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.TimezoneUtils;
import com.xodee.client.audio.audioclient.AppInfo;
import com.xodee.client.video.VideoClient;
import java.util.Arrays;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/AppInfoUtil;", "", "()V", "appCode", "", "appName", "clientSource", "clientUtcOffset", "manufacturer", "model", "osVersion", "sdkVersion", "initializeAppInfo", "", "context", "Landroid/content/Context;", "initializeAudioClientAppInfo", "Lcom/xodee/client/audio/audioclient/AppInfo;", "initializeVideoClientAppDetailedInfo", "amazon-chime-sdk_release"})
public final class AppInfoUtil {
    @NotNull
    public static final AppInfoUtil INSTANCE = new AppInfoUtil();
    private static String manufacturer;
    private static String model;
    private static String osVersion;
    private static String appName;
    private static String appCode;
    @NotNull
    private static final String clientSource = "amazon-chime-sdk";
    private static String sdkVersion;
    private static String clientUtcOffset;

    private AppInfoUtil() {
    }

    private final void initializeAppInfo(Context context) {
        manufacturer = String.valueOf(DeviceUtils.Companion.getDeviceManufacturer());
        model = String.valueOf(DeviceUtils.Companion.getDeviceModel());
        osVersion = String.valueOf(DeviceUtils.Companion.getOsVersion());
        String packageName = context.getPackageName();
        PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        String string = "Android %s";
        Object[] objectArray = new Object[]{packageInfo.versionName};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        appName = string2;
        appCode = String.valueOf(packageInfo.versionCode);
        sdkVersion = DeviceUtils.Companion.getSdkVersion();
        TimeZone deviceTimezone = TimeZone.getDefault();
        Intrinsics.checkNotNull((Object)deviceTimezone);
        clientUtcOffset = TimezoneUtils.Companion.getUtcOffset(deviceTimezone);
    }

    public final void initializeVideoClientAppDetailedInfo(@NotNull Context context) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initializeAppInfo(context);
        String string7 = appName;
        if (string7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appName");
            string7 = null;
        }
        if ((string6 = appCode) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appCode");
            string6 = null;
        }
        if ((string5 = model) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            string5 = null;
        }
        if ((string4 = manufacturer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manufacturer");
            string4 = null;
        }
        if ((string3 = osVersion) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osVersion");
            string3 = null;
        }
        if ((string2 = sdkVersion) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sdkVersion");
            string2 = null;
        }
        if ((string = clientUtcOffset) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientUtcOffset");
            string = null;
        }
        VideoClient.AppDetailedInfo.initialize((String)string7, (String)string6, (String)string5, (String)string4, (String)string3, (String)clientSource, (String)string2, (String)string);
    }

    @NotNull
    public final AppInfo initializeAudioClientAppInfo(@NotNull Context context) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.initializeAppInfo(context);
        String string7 = appName;
        if (string7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appName");
            string7 = null;
        }
        if ((string6 = appCode) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appCode");
            string6 = null;
        }
        if ((string5 = manufacturer) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manufacturer");
            string5 = null;
        }
        if ((string4 = model) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            string4 = null;
        }
        if ((string3 = osVersion) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osVersion");
            string3 = null;
        }
        if ((string2 = sdkVersion) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sdkVersion");
            string2 = null;
        }
        if ((string = clientUtcOffset) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientUtcOffset");
            string = null;
        }
        return new AppInfo(string7, string6, string5, string4, string3, clientSource, string2, string);
    }
}

