/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture;

import android.content.Context;
import android.graphics.Matrix;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEventName;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoResolution;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoRotation;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CameraCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceError;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultCameraCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSourceFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.VideoCaptureFormat;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDevice;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDeviceType;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.android.HandlerDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00cb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0003\u0015\u0018\u001f\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020?H\u0016J\u0010\u0010L\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0002H\u0016J \u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020:2\u0006\u0010R\u001a\u00020\u000fH\u0002J\b\u0010S\u001a\u00020JH\u0002J\b\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020J2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020J2\u0006\u0010Z\u001a\u00020[H\u0016J\u0006\u0010\\\u001a\u00020JJ\u0010\u0010]\u001a\u00020J2\u0006\u0010K\u001a\u00020?H\u0016J\u0010\u0010^\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0002H\u0016J\u0010\u0010_\u001a\u00020J2\u0006\u0010`\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020J2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010c\u001a\u00020J2\u0006\u0010`\u001a\u00020aH\u0002J\b\u0010d\u001a\u00020JH\u0016J\b\u0010e\u001a\u00020JH\u0016J\b\u0010f\u001a\u00020JH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010'\u001a\u0004\u0018\u00010&2\b\u0010%\u001a\u0004\u0018\u00010&@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R(\u0010-\u001a\u0004\u0018\u00010,2\b\u0010%\u001a\u0004\u0018\u00010,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00102\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010D\u001a\u00020:2\u0006\u0010%\u001a\u00020:@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\u00a8\u0006g"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CameraCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "surfaceTextureCaptureSourceFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;", "cameraManager", "Landroid/hardware/camera2/CameraManager;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;Landroid/hardware/camera2/CameraManager;)V", "DESIRED_CAPTURE_FORMAT", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;", "ROTATION_360_DEGREES", "", "TAG", "", "cameraCaptureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "cameraCaptureSessionCaptureCallback", "com/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionCaptureCallback$1", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionCaptureCallback$1;", "cameraCaptureSessionStateCallback", "com/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionStateCallback$1", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionStateCallback$1;", "cameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "cameraDevice", "Landroid/hardware/camera2/CameraDevice;", "cameraDeviceStateCallback", "com/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraDeviceStateCallback$1", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraDeviceStateCallback$1;", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "value", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "device", "getDevice", "()Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "setDevice", "(Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;)V", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "eventAnalyticsController", "getEventAnalyticsController", "()Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "setEventAnalyticsController", "(Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;)V", "format", "getFormat", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;", "setFormat", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;)V", "handler", "Landroid/os/Handler;", "isCameraFrontFacing", "", "maxResolution", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "observers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceObserver;", "sensorOrientation", "sinks", "surfaceTextureSource", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSource;", "torchEnabled", "getTorchEnabled", "()Z", "setTorchEnabled", "(Z)V", "addCaptureSourceObserver", "", "observer", "addVideoSink", "sink", "createBufferWithUpdatedTransformMatrix", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameTextureBuffer;", "buffer", "mirror", "rotation", "createCaptureRequest", "getCaptureFrameRotation", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRotation;", "handleCameraCaptureFail", "error", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceError;", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "release", "removeCaptureSourceObserver", "removeVideoSink", "setFocusMode", "captureRequestBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "setMaxResolution", "setStabilizationMode", "start", "stop", "switchCamera", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultCameraCaptureSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCameraCaptureSource.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 Runnable.kt\nkotlinx/coroutines/RunnableKt\n*L\n1#1,547:1\n288#2,2:548\n288#2,2:550\n288#2,2:552\n288#2,2:554\n2333#2,14:557\n2333#2,14:576\n1#3:556\n32#4,2:571\n3792#5:573\n4307#5,2:574\n16482#5,14:590\n12504#5,2:604\n12504#5,2:606\n12504#5,2:608\n17#6:610\n*S KotlinDebug\n*F\n+ 1 DefaultCameraCaptureSource.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource\n*L\n115#1:548,2\n116#1:550,2\n140#1:552,2\n141#1:554,2\n220#1:557,14\n397#1:576,14\n267#1:571,2\n396#1:573\n396#1:574,2\n401#1:590,14\n460#1:604,2\n473#1:606,2\n489#1:608,2\n544#1:610\n*E\n"})
public final class DefaultCameraCaptureSource
implements CameraCaptureSource,
VideoSink {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory;
    @NotNull
    private final CameraManager cameraManager;
    @NotNull
    private final Handler handler;
    @Nullable
    private CameraCaptureSession cameraCaptureSession;
    @Nullable
    private CameraDevice cameraDevice;
    @Nullable
    private CameraCharacteristics cameraCharacteristics;
    private int sensorOrientation;
    private boolean isCameraFrontFacing;
    @Nullable
    private SurfaceTextureCaptureSource surfaceTextureSource;
    @NotNull
    private final Set<CaptureSourceObserver> observers;
    @NotNull
    private final Set<VideoSink> sinks;
    @NotNull
    private final VideoContentHint contentHint;
    @NotNull
    private final VideoCaptureFormat DESIRED_CAPTURE_FORMAT;
    private final int ROTATION_360_DEGREES;
    @NotNull
    private VideoResolution maxResolution;
    @NotNull
    private final String TAG;
    @Nullable
    private EventAnalyticsController eventAnalyticsController;
    @Nullable
    private MediaDevice device;
    private boolean torchEnabled;
    @NotNull
    private VideoCaptureFormat format;
    @NotNull
    private final cameraDeviceStateCallback.1 cameraDeviceStateCallback;
    @NotNull
    private final cameraCaptureSessionStateCallback.1 cameraCaptureSessionStateCallback;
    @NotNull
    private final cameraCaptureSessionCaptureCallback.1 cameraCaptureSessionCaptureCallback;

    @JvmOverloads
    public DefaultCameraCaptureSource(@NotNull Context context, @NotNull Logger logger, @NotNull SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, @NotNull CameraManager cameraManager) {
        Object v0;
        MediaDevice it;
        Iterable $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        DefaultCameraCaptureSource defaultCameraCaptureSource;
        block5: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)surfaceTextureCaptureSourceFactory, (String)"surfaceTextureCaptureSourceFactory");
            Intrinsics.checkNotNullParameter((Object)cameraManager, (String)"cameraManager");
            this.context = context;
            this.logger = logger;
            this.surfaceTextureCaptureSourceFactory = surfaceTextureCaptureSourceFactory;
            this.cameraManager = cameraManager;
            this.observers = ConcurrentSet.Companion.createConcurrentSet();
            this.sinks = ConcurrentSet.Companion.createConcurrentSet();
            this.contentHint = VideoContentHint.Motion;
            this.DESIRED_CAPTURE_FORMAT = new VideoCaptureFormat(960, 720, 30);
            this.ROTATION_360_DEGREES = 360;
            this.maxResolution = VideoResolution.VideoResolutionHD;
            this.TAG = "DefaultCameraCaptureSource";
            try {
                System.loadLibrary("amazon_chime_media_client");
            }
            catch (UnsatisfiedLinkError e) {
                this.logger.error(this.TAG, "Unable to load native media libraries: " + e.getLocalizedMessage());
            }
            HandlerThread thread = new HandlerThread(this.TAG);
            thread.start();
            this.handler = new Handler(thread.getLooper());
            Iterable iterable = MediaDevice.Companion.listVideoDevices(this.cameraManager);
            defaultCameraCaptureSource = this;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (MediaDevice)element$iv;
                boolean bl = false;
                if (!(it.getType() == MediaDeviceType.VIDEO_FRONT_CAMERA)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        DefaultCameraCaptureSource defaultCameraCaptureSource2 = defaultCameraCaptureSource;
        MediaDevice mediaDevice = v0;
        if (mediaDevice == null) {
            Object v3;
            block6: {
                $this$firstOrNull$iv = MediaDevice.Companion.listVideoDevices(this.cameraManager);
                defaultCameraCaptureSource = defaultCameraCaptureSource2;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (MediaDevice)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == MediaDeviceType.VIDEO_BACK_CAMERA)) continue;
                    v3 = element$iv;
                    break block6;
                }
                v3 = null;
            }
            defaultCameraCaptureSource2 = defaultCameraCaptureSource;
            mediaDevice = v3;
        }
        defaultCameraCaptureSource2.device = mediaDevice;
        this.format = this.DESIRED_CAPTURE_FORMAT;
        this.cameraDeviceStateCallback = new CameraDevice.StateCallback(this){
            final /* synthetic */ DefaultCameraCaptureSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOpened(@NotNull CameraDevice device) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device opened for ID " + device.getId());
                DefaultCameraCaptureSource.access$setCameraDevice$p(this.this$0, device);
                try {
                    CameraDevice cameraDevice = DefaultCameraCaptureSource.access$getCameraDevice$p(this.this$0);
                    if (cameraDevice != null) {
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        cameraDevice.createCaptureSession(CollectionsKt.listOf((Object)(surfaceTextureCaptureSource != null ? surfaceTextureCaptureSource.getSurface() : null)), (CameraCaptureSession.StateCallback)DefaultCameraCaptureSource.access$getCameraCaptureSessionStateCallback$p(this.this$0), DefaultCameraCaptureSource.access$getHandler$p(this.this$0));
                    }
                }
                catch (CameraAccessException exception) {
                    DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Exception encountered creating capture session: " + exception.getReason());
                    DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.SystemFailure);
                    return;
                }
            }

            public void onClosed(@NotNull CameraDevice device) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device closed for ID " + device.getId());
                ObserverUtils.Companion.notifyObserverOnMainThread(DefaultCameraCaptureSource.access$getObservers$p(this.this$0), cameraDeviceStateCallback.onClosed.1.INSTANCE);
            }

            public void onDisconnected(@NotNull CameraDevice device) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device disconnected for ID " + device.getId());
                ObserverUtils.Companion.notifyObserverOnMainThread(DefaultCameraCaptureSource.access$getObservers$p(this.this$0), cameraDeviceStateCallback.onDisconnected.1.INSTANCE);
            }

            public void onError(@NotNull CameraDevice device, int error) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device encountered error: " + error + " for ID " + device.getId());
                DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.SystemFailure);
            }
        };
        this.cameraCaptureSessionStateCallback = new CameraCaptureSession.StateCallback(this){
            final /* synthetic */ DefaultCameraCaptureSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void onConfigured(@NotNull CameraCaptureSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera capture session configured for session with device ID: " + session.getDevice().getId());
                DefaultCameraCaptureSource.access$setCameraCaptureSession$p(this.this$0, session);
                DefaultCameraCaptureSource.access$createCaptureRequest(this.this$0);
            }

            public void onConfigureFailed(@NotNull CameraCaptureSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).error(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera session configuration failed with device ID: " + session.getDevice().getId());
                DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.ConfigurationFailure);
                session.close();
            }
        };
        this.cameraCaptureSessionCaptureCallback = new CameraCaptureSession.CaptureCallback(this){
            final /* synthetic */ DefaultCameraCaptureSource this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCaptureFailed(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull CaptureFailure failure) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).error(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera capture session failed: " + failure);
                DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.SystemFailure);
            }
        };
    }

    public /* synthetic */ DefaultCameraCaptureSource(Context context, Logger logger, SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, CameraManager cameraManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Object object = context.getSystemService("camera");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            cameraManager = (CameraManager)object;
        }
        this(context, logger, surfaceTextureCaptureSourceFactory, cameraManager);
    }

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    @Nullable
    public final EventAnalyticsController getEventAnalyticsController() {
        return this.eventAnalyticsController;
    }

    public final void setEventAnalyticsController(@Nullable EventAnalyticsController value) {
        this.eventAnalyticsController = value;
    }

    @Override
    @Nullable
    public MediaDevice getDevice() {
        return this.device;
    }

    @Override
    public void setDevice(@Nullable MediaDevice value) {
        block1: {
            this.logger.info(this.TAG, "Setting capture device: " + value);
            if (Intrinsics.areEqual((Object)this.device, (Object)value)) {
                this.logger.info(this.TAG, "Already using device: " + value + "; ignoring");
                return;
            }
            this.device = value;
            SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
            if (surfaceTextureCaptureSource == null) break block1;
            SurfaceTextureCaptureSource it = surfaceTextureCaptureSource;
            boolean bl = false;
            this.stop();
            this.start();
        }
    }

    @Override
    public void switchCamera() {
        block6: {
            Object v1;
            MediaDevice it;
            Iterable $this$firstOrNull$iv;
            boolean $i$f$firstOrNull;
            DefaultCameraCaptureSource defaultCameraCaptureSource;
            block4: {
                MediaDevice mediaDevice = this.getDevice();
                MediaDeviceType desiredDeviceType = (mediaDevice != null ? mediaDevice.getType() : null) == MediaDeviceType.VIDEO_FRONT_CAMERA ? MediaDeviceType.VIDEO_BACK_CAMERA : MediaDeviceType.VIDEO_FRONT_CAMERA;
                Iterable iterable = MediaDevice.Companion.listVideoDevices(this.cameraManager);
                defaultCameraCaptureSource = this;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (MediaDevice)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == desiredDeviceType)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            DefaultCameraCaptureSource defaultCameraCaptureSource2 = defaultCameraCaptureSource;
            MediaDevice mediaDevice = v1;
            if (mediaDevice == null) {
                Object v4;
                block5: {
                    $this$firstOrNull$iv = MediaDevice.Companion.listVideoDevices(this.cameraManager);
                    defaultCameraCaptureSource = defaultCameraCaptureSource2;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (MediaDevice)element$iv;
                        boolean bl = false;
                        if (!(it.getType() == MediaDeviceType.VIDEO_BACK_CAMERA)) continue;
                        v4 = element$iv;
                        break block5;
                    }
                    v4 = null;
                }
                defaultCameraCaptureSource2 = defaultCameraCaptureSource;
                mediaDevice = v4;
            }
            defaultCameraCaptureSource2.setDevice(mediaDevice);
            if (this.getDevice() == null) break block6;
            EventAnalyticsController eventAnalyticsController = this.eventAnalyticsController;
            if (eventAnalyticsController != null) {
                eventAnalyticsController.pushHistory(MeetingHistoryEventName.videoInputSelected);
            }
        }
    }

    @Override
    public void setMaxResolution(@NotNull VideoResolution maxResolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)maxResolution), (String)"maxResolution");
        this.maxResolution = maxResolution;
    }

    @Override
    public boolean getTorchEnabled() {
        return this.torchEnabled;
    }

    @Override
    @RequiresApi(value=23)
    public void setTorchEnabled(boolean value) {
        CameraCharacteristics cameraCharacteristics = this.cameraCharacteristics;
        if (cameraCharacteristics != null ? Intrinsics.areEqual((Object)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE), (Object)false) : false) {
            this.logger.warn(this.TAG, "Torch not supported on current camera, setting value and returning");
            return;
        }
        this.torchEnabled = value;
        if (this.cameraDevice == null) {
            Object object = this.getDevice();
            if (object != null && (object = ((MediaDevice)object).getId()) != null) {
                Object it = object;
                boolean bl = false;
                this.cameraManager.setTorchMode((String)it, this.torchEnabled);
            }
        } else {
            this.createCaptureRequest();
        }
    }

    @Override
    @NotNull
    public VideoCaptureFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@NotNull VideoCaptureFormat value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.logger.info(this.TAG, "Setting capture format: " + value);
            if (Intrinsics.areEqual((Object)this.format, (Object)value)) {
                this.logger.info(this.TAG, "Already using format: " + value + "; ignoring");
                return;
            }
            this.format = new VideoCaptureFormat(value.getWidth(), value.getHeight(), value.getMaxFps());
            SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
            if (surfaceTextureCaptureSource == null) break block1;
            SurfaceTextureCaptureSource it = surfaceTextureCaptureSource;
            boolean bl = false;
            this.stop();
            this.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        VideoCaptureFormat chosenCaptureFormat;
        Object v5;
        int n;
        void it;
        Integer n22;
        CameraCharacteristics cameraCharacteristics;
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") != 0) {
            this.handleCameraCaptureFail(CaptureSourceError.PermissionError);
            throw new SecurityException("Missing necessary camera permissions");
        }
        this.stop();
        this.logger.info(this.TAG, "Camera capture start requested with device: " + this.getDevice());
        MediaDevice mediaDevice = this.getDevice();
        if (mediaDevice == null) {
            DefaultCameraCaptureSource $this$start_u24lambda_u247 = this;
            boolean bl = false;
            $this$start_u24lambda_u247.logger.info($this$start_u24lambda_u247.TAG, "Cannot start camera capture with null device");
            return;
        }
        MediaDevice device = mediaDevice;
        String string = device.getId();
        if (string == null) {
            DefaultCameraCaptureSource $this$start_u24lambda_u248 = this;
            boolean n22 = false;
            $this$start_u24lambda_u248.logger.info($this$start_u24lambda_u248.TAG, "Cannot start camera capture with null device id");
            return;
        }
        String id = string;
        CameraCharacteristics $this$start_u24lambda_u247 = cameraCharacteristics = this.cameraManager.getCameraCharacteristics(id);
        DefaultCameraCaptureSource defaultCameraCaptureSource = this;
        boolean bl = false;
        Integer n3 = n22 = (Integer)it.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (n3 == null) {
            n = 0;
        } else {
            Intrinsics.checkNotNull((Object)n3);
            n = n22;
        }
        this.sensorOrientation = n;
        Integer n4 = (Integer)it.get(CameraCharacteristics.LENS_FACING);
        this.isCameraFrontFacing = n4 != null && n4 == 0;
        defaultCameraCaptureSource.cameraCharacteristics = cameraCharacteristics;
        int maxWidth = this.maxResolution.getWidth();
        int maxHeight = this.maxResolution.getHeight();
        int maxFps = 30;
        Iterable $this$minByOrNull$iv = MediaDevice.Companion.listSupportedVideoCaptureFormats(this.cameraManager, device, maxFps, maxWidth, maxHeight);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v5 = minElem$iv;
            } else {
                VideoCaptureFormat format = (VideoCaptureFormat)minElem$iv;
                boolean bl2 = false;
                int minValue$iv = Math.abs(format.getWidth() - this.getFormat().getWidth()) + Math.abs(format.getHeight() - this.getFormat().getHeight());
                do {
                    Object e$iv = iterator$iv.next();
                    VideoCaptureFormat format2 = (VideoCaptureFormat)e$iv;
                    $i$a$-minByOrNull-DefaultCameraCaptureSource$start$chosenCaptureFormat$1 = false;
                    int v$iv = Math.abs(format2.getWidth() - this.getFormat().getWidth()) + Math.abs(format2.getHeight() - this.getFormat().getHeight());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v5 = minElem$iv;
            }
        }
        VideoCaptureFormat videoCaptureFormat = chosenCaptureFormat = (VideoCaptureFormat)v5;
        if (videoCaptureFormat == null) {
            DefaultCameraCaptureSource $this$start_u24lambda_u2411 = this;
            boolean bl3 = false;
            $this$start_u24lambda_u2411.handleCameraCaptureFail(CaptureSourceError.ConfigurationFailure);
            return;
        }
        VideoCaptureFormat surfaceTextureFormat = videoCaptureFormat;
        SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource = this.surfaceTextureCaptureSourceFactory.createSurfaceTextureCaptureSource(surfaceTextureFormat.getWidth(), surfaceTextureFormat.getHeight(), this.getContentHint());
        if (surfaceTextureCaptureSource != null) {
            surfaceTextureCaptureSource.addVideoSink(this);
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource2 != null) {
            surfaceTextureCaptureSource2.start();
        }
        this.cameraManager.openCamera(id, (CameraDevice.StateCallback)this.cameraDeviceStateCallback, this.handler);
    }

    @Override
    public void stop() {
        this.logger.info(this.TAG, "Stopping camera capture source");
        VideoSink sink = this;
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sink, null){
            int label;
            final /* synthetic */ DefaultCameraCaptureSource this$0;
            final /* synthetic */ VideoSink $sink;
            {
                this.this$0 = $receiver;
                this.$sink = $sink;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CameraCaptureSession cameraCaptureSession = DefaultCameraCaptureSource.access$getCameraCaptureSession$p(this.this$0);
                        if (cameraCaptureSession != null) {
                            cameraCaptureSession.close();
                        }
                        DefaultCameraCaptureSource.access$setCameraCaptureSession$p(this.this$0, null);
                        CameraDevice cameraDevice = DefaultCameraCaptureSource.access$getCameraDevice$p(this.this$0);
                        if (cameraDevice != null) {
                            cameraDevice.close();
                        }
                        DefaultCameraCaptureSource.access$setCameraDevice$p(this.this$0, null);
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        if (surfaceTextureCaptureSource != null) {
                            surfaceTextureCaptureSource.removeVideoSink(this.$sink);
                        }
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        if (surfaceTextureCaptureSource2 != null) {
                            surfaceTextureCaptureSource2.stop();
                        }
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource3 = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        if (surfaceTextureCaptureSource3 != null) {
                            surfaceTextureCaptureSource3.release();
                        }
                        DefaultCameraCaptureSource.access$setSurfaceTextureSource$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        VideoFrameBuffer videoFrameBuffer = frame.getBuffer();
        Intrinsics.checkNotNull((Object)videoFrameBuffer, (String)"null cannot be cast to non-null type com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer");
        VideoFrameBuffer processedBuffer = this.createBufferWithUpdatedTransformMatrix((VideoFrameTextureBuffer)videoFrameBuffer, this.isCameraFrontFacing, -this.sensorOrientation);
        VideoFrame processedFrame = new VideoFrame(frame.getTimestampNs(), processedBuffer, this.getCaptureFrameRotation());
        Iterator<VideoSink> $this$forEach$iv = this.sinks.iterator();
        boolean $i$f$forEach = false;
        Iterator<VideoSink> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            VideoSink element$iv;
            VideoSink it = element$iv = iterator.next();
            boolean bl = false;
            it.onVideoFrameReceived(processedFrame);
        }
        processedBuffer.release();
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    @Override
    public void addCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observers.add(observer);
    }

    @Override
    public void removeCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observers.remove(observer);
    }

    public final void release() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultCameraCaptureSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Stopping handler looper");
                        DefaultCameraCaptureSource.access$getHandler$p(this.this$0).removeCallbacksAndMessages(null);
                        DefaultCameraCaptureSource.access$getHandler$p(this.this$0).getLooper().quit();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void handleCameraCaptureFail(CaptureSourceError error) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.videoInputError), (Object)((Object)error))};
        Map attributes = MapsKt.mutableMapOf((Pair[])pairArray);
        EventAnalyticsController eventAnalyticsController = this.eventAnalyticsController;
        if (eventAnalyticsController != null) {
            eventAnalyticsController.publishEvent(EventName.videoInputFailed, attributes);
        }
        ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, (Function1)new Function1<CaptureSourceObserver, Unit>(error){
            final /* synthetic */ CaptureSourceError $error;
            {
                this.$error = $error;
                super(1);
            }

            public final void invoke(@NotNull CaptureSourceObserver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.onCaptureFailed(this.$error);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void createCaptureRequest() {
        CameraDevice cameraDevice = this.cameraDevice;
        if (cameraDevice == null) {
            DefaultCameraCaptureSource $this$createCaptureRequest_u24lambda_u2413 = this;
            boolean bl = false;
            $this$createCaptureRequest_u24lambda_u2413.logger.warn($this$createCaptureRequest_u24lambda_u2413.TAG, "createCaptureRequest called without device set, may be mid restart");
            return;
        }
        CameraDevice cameraDevice2 = cameraDevice;
        try {
            CameraCaptureSession cameraCaptureSession;
            Range range;
            Object v5;
            void $this$minByOrNull$iv;
            Range it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object[] fpsRanges;
            Object[] $this$createCaptureRequest_u24lambda_u2413;
            CaptureRequest.Builder builder = cameraDevice2.createCaptureRequest(3);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createCaptureRequest(...)");
            CaptureRequest.Builder captureRequestBuilder = builder;
            CameraCharacteristics cameraCharacteristics = this.cameraCharacteristics;
            Object[] objectArray = $this$createCaptureRequest_u24lambda_u2413 = cameraCharacteristics != null ? (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES) : null;
            if ($this$createCaptureRequest_u24lambda_u2413 == null) {
                DefaultCameraCaptureSource $this$createCaptureRequest_u24lambda_u2414 = this;
                boolean bl = false;
                $this$createCaptureRequest_u24lambda_u2414.logger.error($this$createCaptureRequest_u24lambda_u2414.TAG, "Could not retrieve camera FPS ranges");
                $this$createCaptureRequest_u24lambda_u2414.handleCameraCaptureFail(CaptureSourceError.ConfigurationFailure);
                return;
            }
            Object[] $this$createCaptureRequest_u24lambda_u2414 = fpsRanges = $this$createCaptureRequest_u24lambda_u2413;
            boolean $i$f$filter = false;
            void var8_12 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                it = element$iv$iv;
                boolean bl = false;
                Comparable comparable = it.getUpper();
                Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getUpper(...)");
                if (!(((Number)((Object)comparable)).intValue() <= this.getFormat().getMaxFps())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v5 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v5 = minElem$iv;
                } else {
                    Range it2 = (Range)minElem$iv;
                    boolean bl = false;
                    int n = this.getFormat().getMaxFps();
                    Comparable comparable = it2.getUpper();
                    Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getUpper(...)");
                    int minValue$iv = n - ((Number)((Object)comparable)).intValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Range it3 = (Range)e$iv;
                        $i$a$-minByOrNull-DefaultCameraCaptureSource$createCaptureRequest$bestFpsRange$2 = false;
                        int n2 = this.getFormat().getMaxFps();
                        Comparable comparable2 = it3.getUpper();
                        Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getUpper(...)");
                        int v$iv = n2 - ((Number)((Object)comparable2)).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v5 = minElem$iv;
                }
            }
            if ((range = (Range)v5) == null) {
                Range range2;
                DefaultCameraCaptureSource $this$createCaptureRequest_u24lambda_u2418 = this;
                boolean bl = false;
                $this$createCaptureRequest_u24lambda_u2418.logger.warn($this$createCaptureRequest_u24lambda_u2418.TAG, "No FPS ranges below set max FPS");
                Object[] $this$minByOrNull$iv2 = fpsRanges;
                boolean $i$f$minByOrNull2 = false;
                if ($this$minByOrNull$iv2.length == 0) {
                    range2 = null;
                } else {
                    Object minElem$iv = $this$minByOrNull$iv2[0];
                    int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$minByOrNull$iv2);
                    if (lastIndex$iv == 0) {
                        range2 = minElem$iv;
                    } else {
                        it = minElem$iv;
                        boolean bl2 = false;
                        int n = $this$createCaptureRequest_u24lambda_u2418.getFormat().getMaxFps();
                        Comparable comparable = it.getUpper();
                        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getUpper(...)");
                        int minValue$iv = Math.abs(n - ((Number)((Object)comparable)).intValue());
                        IntIterator intIterator = new IntRange(1, lastIndex$iv).iterator();
                        while (intIterator.hasNext()) {
                            Object e$iv;
                            int i$iv = intIterator.nextInt();
                            Object it4 = e$iv = $this$minByOrNull$iv2[i$iv];
                            $i$a$-minByOrNull-DefaultCameraCaptureSource$createCaptureRequest$bestFpsRange$3$1 = false;
                            int n3 = $this$createCaptureRequest_u24lambda_u2418.getFormat().getMaxFps();
                            Comparable comparable3 = it4.getUpper();
                            Intrinsics.checkNotNullExpressionValue((Object)comparable3, (String)"getUpper(...)");
                            int v$iv = Math.abs(n3 - ((Number)((Object)comparable3)).intValue());
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        }
                        range2 = minElem$iv;
                    }
                }
                range = range2;
                if (range2 == null) {
                    DefaultCameraCaptureSource $this$createCaptureRequest_u24lambda_u2419 = this;
                    boolean bl3 = false;
                    $this$createCaptureRequest_u24lambda_u2419.logger.error($this$createCaptureRequest_u24lambda_u2419.TAG, "No valid FPS ranges");
                    $this$createCaptureRequest_u24lambda_u2419.handleCameraCaptureFail(CaptureSourceError.ConfigurationFailure);
                    return;
                }
            }
            Range bestFpsRange = range;
            this.logger.info(this.TAG, "Setting target FPS range to " + bestFpsRange);
            captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range(bestFpsRange.getLower(), bestFpsRange.getUpper()));
            captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            captureRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
            if (this.getTorchEnabled()) {
                captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else {
                captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
            this.setStabilizationMode(captureRequestBuilder);
            this.setFocusMode(captureRequestBuilder);
            SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
            if (surfaceTextureCaptureSource == null || (surfaceTextureCaptureSource = surfaceTextureCaptureSource.getSurface()) == null) {
                throw new UnknownError("Surface texture source should not be null");
            }
            captureRequestBuilder.addTarget((Surface)surfaceTextureCaptureSource);
            CameraCaptureSession cameraCaptureSession2 = this.cameraCaptureSession;
            if (cameraCaptureSession2 != null) {
                cameraCaptureSession2.setRepeatingRequest(captureRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.cameraCaptureSessionCaptureCallback, this.handler);
            }
            this.logger.info(this.TAG, "Capture request completed with device ID: " + ((cameraCaptureSession = this.cameraCaptureSession) != null && (cameraCaptureSession = cameraCaptureSession.getDevice()) != null ? cameraCaptureSession.getId() : null));
            ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, createCaptureRequest.1.INSTANCE);
        }
        catch (CameraAccessException exception) {
            CameraCaptureSession cameraCaptureSession = this.cameraCaptureSession;
            this.logger.error(this.TAG, "Failed to start capture request with device ID: " + (cameraCaptureSession != null && (cameraCaptureSession = cameraCaptureSession.getDevice()) != null ? cameraCaptureSession.getId() : null) + ", exception:" + exception);
            this.handleCameraCaptureFail(CaptureSourceError.SystemFailure);
            return;
        }
    }

    private final void setStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
        boolean bl;
        boolean bl2;
        int it;
        int element$iv;
        int n;
        int n2;
        int[] $this$any$iv;
        boolean $i$f$any;
        int[] nArray;
        CameraCharacteristics cameraCharacteristics = this.cameraCharacteristics;
        if (cameraCharacteristics != null && (nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION)) != null) {
            boolean bl3;
            block8: {
                int[] nArray2 = nArray;
                $i$f$any = false;
                n2 = $this$any$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$any$iv[n];
                    boolean bl4 = false;
                    if (!(it == 1)) continue;
                    bl3 = true;
                    break block8;
                }
                bl3 = false;
            }
            bl2 = bl3;
        } else {
            bl2 = false;
        }
        if (bl2) {
            captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
            captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
            this.logger.info(this.TAG, "Using optical stabilization.");
            return;
        }
        cameraCharacteristics = this.cameraCharacteristics;
        if (cameraCharacteristics != null && (nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) != null) {
            boolean bl5;
            block9: {
                $this$any$iv = nArray;
                $i$f$any = false;
                n2 = $this$any$iv.length;
                for (n = 0; n < n2; ++n) {
                    it = element$iv = $this$any$iv[n];
                    boolean bl6 = false;
                    if (!(it == 1)) continue;
                    bl5 = true;
                    break block9;
                }
                bl5 = false;
            }
            bl = bl5;
        } else {
            bl = false;
        }
        if (bl) {
            captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
            captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
            this.logger.info(this.TAG, "Using video stabilization.");
            return;
        }
        this.logger.info(this.TAG, "Stabilization not available.");
    }

    /*
     * WARNING - void declaration
     */
    private final void setFocusMode(CaptureRequest.Builder captureRequestBuilder) {
        boolean bl;
        int[] nArray;
        CameraCharacteristics cameraCharacteristics = this.cameraCharacteristics;
        if (cameraCharacteristics != null && (nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) != null) {
            boolean bl2;
            block4: {
                void $this$any$iv;
                int[] nArray2 = nArray;
                boolean $i$f$any = false;
                int n = ((void)$this$any$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void it = element$iv = $this$any$iv[i];
                    boolean bl3 = false;
                    if (!(it == 3)) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (bl) {
            captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
            this.logger.info(this.TAG, "Using optical stabilization.");
            return;
        }
        this.logger.info(this.TAG, "Auto-focus is not available.");
    }

    private final VideoRotation getCaptureFrameRotation() {
        VideoRotation videoRotation;
        int rotation;
        Object object = this.context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager windowManager = (WindowManager)object;
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                int n = 90;
                break;
            }
            case 2: {
                int n = 180;
                break;
            }
            case 3: {
                int n = 270;
                break;
            }
            case 0: {
                int n = 0;
                break;
            }
            default: {
                int n = rotation = 0;
            }
        }
        if (!this.isCameraFrontFacing) {
            rotation = this.ROTATION_360_DEGREES - rotation;
        }
        if ((videoRotation = VideoRotation.Companion.from(rotation = (this.sensorOrientation + rotation) % this.ROTATION_360_DEGREES)) == null) {
            videoRotation = VideoRotation.Rotation0;
        }
        return videoRotation;
    }

    private final VideoFrameTextureBuffer createBufferWithUpdatedTransformMatrix(VideoFrameTextureBuffer buffer, boolean mirror, int rotation) {
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (mirror) {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preRotate((float)rotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        Matrix newMatrix = new Matrix(buffer.getTransformMatrix());
        newMatrix.preConcat(transformMatrix);
        buffer.retain();
        boolean $i$f$Runnable = false;
        return new VideoFrameTextureBuffer(buffer.getWidth(), buffer.getHeight(), buffer.getTextureId(), newMatrix, buffer.getType(), new Runnable(buffer){
            final /* synthetic */ VideoFrameTextureBuffer $buffer$inlined;
            {
                this.$buffer$inlined = videoFrameTextureBuffer;
            }

            public final void run() {
                boolean bl = false;
                this.$buffer$inlined.release();
            }
        });
    }

    @JvmOverloads
    public DefaultCameraCaptureSource(@NotNull Context context, @NotNull Logger logger, @NotNull SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)surfaceTextureCaptureSourceFactory, (String)"surfaceTextureCaptureSourceFactory");
        this(context, logger, surfaceTextureCaptureSourceFactory, null, 8, null);
    }

    public static final /* synthetic */ CameraCaptureSession access$getCameraCaptureSession$p(DefaultCameraCaptureSource $this) {
        return $this.cameraCaptureSession;
    }

    public static final /* synthetic */ void access$setCameraCaptureSession$p(DefaultCameraCaptureSource $this, CameraCaptureSession cameraCaptureSession) {
        $this.cameraCaptureSession = cameraCaptureSession;
    }

    public static final /* synthetic */ CameraDevice access$getCameraDevice$p(DefaultCameraCaptureSource $this) {
        return $this.cameraDevice;
    }

    public static final /* synthetic */ void access$setCameraDevice$p(DefaultCameraCaptureSource $this, CameraDevice cameraDevice) {
        $this.cameraDevice = cameraDevice;
    }

    public static final /* synthetic */ SurfaceTextureCaptureSource access$getSurfaceTextureSource$p(DefaultCameraCaptureSource $this) {
        return $this.surfaceTextureSource;
    }

    public static final /* synthetic */ void access$setSurfaceTextureSource$p(DefaultCameraCaptureSource $this, SurfaceTextureCaptureSource surfaceTextureCaptureSource) {
        $this.surfaceTextureSource = surfaceTextureCaptureSource;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultCameraCaptureSource $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultCameraCaptureSource $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Handler access$getHandler$p(DefaultCameraCaptureSource $this) {
        return $this.handler;
    }

    public static final /* synthetic */ cameraCaptureSessionStateCallback.1 access$getCameraCaptureSessionStateCallback$p(DefaultCameraCaptureSource $this) {
        return $this.cameraCaptureSessionStateCallback;
    }

    public static final /* synthetic */ void access$handleCameraCaptureFail(DefaultCameraCaptureSource $this, CaptureSourceError error) {
        $this.handleCameraCaptureFail(error);
    }

    public static final /* synthetic */ Set access$getObservers$p(DefaultCameraCaptureSource $this) {
        return $this.observers;
    }

    public static final /* synthetic */ void access$createCaptureRequest(DefaultCameraCaptureSource $this) {
        $this.createCaptureRequest();
    }
}

