/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.PrimaryMeetingPromotionObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.AudioDeviceCapabilities;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.AudioMode;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.AudioRecordingPresetOverride;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.AudioStreamType;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.AppInfoUtil;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionCredentials;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatus;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.audio.audioclient.AppInfo;
import com.xodee.client.audio.audioclient.AudioClient;
import com.xodee.client.audio.audioclient.AudioClientSessionConfig;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 E2\u00020\u0001:\u0001EB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0010H\u0016J\b\u0010#\u001a\u00020\u0014H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001fH\u0002J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u001fH\u0002J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u0014H\u0016J\u0010\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0010H\u0016J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u0014H\u0016J`\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020\u00162\u0006\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\u0006\u0010&\u001a\u00020'2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u0010H\u0016J\b\u0010D\u001a\u00020\u001fH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "audioClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "audioClient", "Lcom/xodee/client/audio/audioclient/AudioClient;", "meetingStatsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;Lcom/xodee/client/audio/audioclient/AudioClient;Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;)V", "AUDIO_CLIENT_RESULT_SUCCESS", "", "AUDIO_PORT_OFFSET", "DEFAULT_PORT", "DEFAULT_PRESENTER", "", "TAG", "", "audioManager", "Landroid/media/AudioManager;", "audioModePreCall", "muteMicAndSpeaker", "speakerphoneStatePreCall", "uiScope", "Lkotlinx/coroutines/CoroutineScope;", "demoteFromPrimaryMeeting", "", "getDefaultRecordingPreset", "Lcom/xodee/client/audio/audioclient/AudioClient$AudioRecordingPreset;", "getRoute", "isVoiceFocusEnabled", "mapAudioDeviceCapabilitiesToInternal", "Lcom/xodee/client/audio/audioclient/AudioClient$AudioDeviceCapabilitiesInternal;", "audioDeviceCapabilities", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/AudioDeviceCapabilities;", "notifyStop", "promoteToPrimaryMeeting", "credentials", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "resetAudioManager", "setMute", "isMuted", "setRoute", "route", "setUpAudioConfiguration", "audioMode", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/AudioMode;", "setVoiceFocusEnabled", "enabled", "start", "audioFallbackUrl", "audioHostUrl", "meetingId", "attendeeId", "joinToken", "audioStreamType", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/AudioStreamType;", "audioRecordingPresetOverride", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/AudioRecordingPresetOverride;", "enableAudioRedundancy", "reconnectTimeoutMs", "stop", "Companion", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultAudioClientController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAudioClientController.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n731#2,9:356\n*S KotlinDebug\n*F\n+ 1 DefaultAudioClientController.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientController\n*L\n163#1:356,9\n*E\n"})
public final class DefaultAudioClientController
implements AudioClientController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AudioClientObserver audioClientObserver;
    @NotNull
    private final AudioClient audioClient;
    @NotNull
    private final MeetingStatsCollector meetingStatsCollector;
    @NotNull
    private final EventAnalyticsController eventAnalyticsController;
    @NotNull
    private final String TAG;
    private final int DEFAULT_PORT;
    private final int AUDIO_PORT_OFFSET;
    private final boolean DEFAULT_PRESENTER;
    private final int AUDIO_CLIENT_RESULT_SUCCESS;
    private boolean muteMicAndSpeaker;
    @NotNull
    private final CoroutineScope uiScope;
    @NotNull
    private final AudioManager audioManager;
    private int audioModePreCall;
    private boolean speakerphoneStatePreCall;
    @NotNull
    private static AudioClientState audioClientState = AudioClientState.INITIALIZED;

    public DefaultAudioClientController(@NotNull Context context, @NotNull Logger logger, @NotNull AudioClientObserver audioClientObserver, @NotNull AudioClient audioClient, @NotNull MeetingStatsCollector meetingStatsCollector, @NotNull EventAnalyticsController eventAnalyticsController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)audioClientObserver, (String)"audioClientObserver");
        Intrinsics.checkNotNullParameter((Object)audioClient, (String)"audioClient");
        Intrinsics.checkNotNullParameter((Object)meetingStatsCollector, (String)"meetingStatsCollector");
        Intrinsics.checkNotNullParameter((Object)eventAnalyticsController, (String)"eventAnalyticsController");
        this.context = context;
        this.logger = logger;
        this.audioClientObserver = audioClientObserver;
        this.audioClient = audioClient;
        this.meetingStatsCollector = meetingStatsCollector;
        this.eventAnalyticsController = eventAnalyticsController;
        this.TAG = "DefaultAudioClientController";
        this.AUDIO_PORT_OFFSET = 200;
        this.DEFAULT_PRESENTER = true;
        this.uiScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain()));
        Object object = this.context.getSystemService("audio");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.AudioManager");
        this.audioManager = (AudioManager)object;
        this.audioModePreCall = this.audioManager.getMode();
        this.speakerphoneStatePreCall = this.audioManager.isSpeakerphoneOn();
    }

    private final void setUpAudioConfiguration(AudioMode audioMode) {
        int n;
        int n2;
        int nativeSR = AudioTrack.getNativeOutputSampleRate((int)1);
        this.audioClient.sendMessage(4, nativeSR);
        switch (WhenMappings.$EnumSwitchMapping$0[audioMode.ordinal()]) {
            case 1: {
                n2 = 16000;
                break;
            }
            case 2: {
                n2 = 48000;
                break;
            }
            case 3: {
                n2 = 48000;
                break;
            }
            default: {
                n2 = 48000;
            }
        }
        int samplingRateConfig = n2;
        this.audioClient.sendMessage(5, samplingRateConfig);
        switch (WhenMappings.$EnumSwitchMapping$0[audioMode.ordinal()]) {
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 12;
                break;
            }
            default: {
                n = 12;
            }
        }
        int outputChannelConfig = n;
        int spkMinBufSizeInSamples = AudioTrack.getMinBufferSize((int)nativeSR, (int)outputChannelConfig, (int)2) / 2;
        int micMinBufSizeInSamples = AudioRecord.getMinBufferSize((int)nativeSR, (int)16, (int)2) / 2;
        this.logger.info(this.TAG, "spkMinBufSizeInSamples " + spkMinBufSizeInSamples + " micMinBufSizeInSamples " + micMinBufSizeInSamples);
        this.audioClient.sendMessage(2, micMinBufSizeInSamples);
        this.audioClient.sendMessage(3, spkMinBufSizeInSamples);
        this.audioClient.sendMessage(6, 1);
        this.audioClient.sendMessage(7, 0);
        this.audioClient.sendMessage(8, 0);
    }

    @Override
    public int getRoute() {
        return this.audioClient.getRoute();
    }

    @Override
    public boolean setRoute(int route) {
        if (this.getRoute() == route) {
            return true;
        }
        this.logger.info(this.TAG, "Setting route to " + route);
        return this.audioClient.setRoute(route) == this.AUDIO_CLIENT_RESULT_SUCCESS;
    }

    private final AudioClient.AudioRecordingPreset getDefaultRecordingPreset() {
        AudioClient.AudioRecordingPreset recordingPreset = AudioClient.AudioRecordingPreset.VOICE_COMMUNICATION;
        this.logger.info(this.TAG, "No AudioRecordingPreseOverride provided, using recording preset " + recordingPreset);
        return recordingPreset;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(@NotNull String audioFallbackUrl, @NotNull String audioHostUrl, @NotNull String meetingId, @NotNull String attendeeId, @NotNull String joinToken, @NotNull AudioMode audioMode, @NotNull AudioDeviceCapabilities audioDeviceCapabilities, @NotNull AudioStreamType audioStreamType, @NotNull AudioRecordingPresetOverride audioRecordingPresetOverride, boolean enableAudioRedundancy, int reconnectTimeoutMs) {
        List list;
        List audioUrlParts;
        List list2;
        int n;
        void $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)audioFallbackUrl, (String)"audioFallbackUrl");
        Intrinsics.checkNotNullParameter((Object)audioHostUrl, (String)"audioHostUrl");
        Intrinsics.checkNotNullParameter((Object)meetingId, (String)"meetingId");
        Intrinsics.checkNotNullParameter((Object)attendeeId, (String)"attendeeId");
        Intrinsics.checkNotNullParameter((Object)joinToken, (String)"joinToken");
        Intrinsics.checkNotNullParameter((Object)((Object)audioMode), (String)"audioMode");
        Intrinsics.checkNotNullParameter((Object)((Object)audioDeviceCapabilities), (String)"audioDeviceCapabilities");
        Intrinsics.checkNotNullParameter((Object)((Object)audioStreamType), (String)"audioStreamType");
        Intrinsics.checkNotNullParameter((Object)((Object)audioRecordingPresetOverride), (String)"audioRecordingPresetOverride");
        if (audioClientState != AudioClientState.INITIALIZED && audioClientState != AudioClientState.STOPPED) {
            this.logger.warn(this.TAG, "Current audio client state " + (Object)((Object)audioClientState) + " is invalid to start audio, ignoring");
            return;
        }
        if (StringsKt.isBlank((CharSequence)audioHostUrl) || StringsKt.isBlank((CharSequence)audioFallbackUrl)) {
            this.logger.error(this.TAG, "`audioHostUrl` or `audioFallbackUrl` is blank");
            throw new Exception("Audio failed to start");
        }
        Object object = audioHostUrl;
        Regex regex = new Regex(":");
        int n2 = 0;
        object = regex.split((CharSequence)object, n2);
        boolean $i$f$dropLastWhile2 = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                n = 0;
                if (((CharSequence)it).length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = audioUrlParts = CollectionsKt.emptyList();
        }
        if (audioUrlParts.size() == 2) {
            list = audioUrlParts;
        } else {
            Object[] $i$f$dropLastWhile2 = new String[]{audioUrlParts.get(0), String.valueOf(this.AUDIO_PORT_OFFSET)};
            list = CollectionsKt.listOf((Object[])$i$f$dropLastWhile2);
        }
        object = list;
        String host = (String)object.get(0);
        String portStr = (String)object.get(1);
        try {
            n = Integer.parseInt(portStr) - this.AUDIO_PORT_OFFSET;
        }
        catch (Exception exception) {
            this.logger.warn(this.TAG, "Error parsing int. Using default value. Exception: " + exception.getMessage());
            n = this.DEFAULT_PORT;
        }
        int port = n;
        this.setUpAudioConfiguration(audioMode);
        this.meetingStatsCollector.updateMeetingStartConnectingTimeMs();
        EventAnalyticsController.publishEvent$default(this.eventAnalyticsController, EventName.meetingStartRequested, null, 2, null);
        this.audioClientObserver.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)start.1.INSTANCE));
        this.logger.info(this.TAG, "audioMode: " + (Object)((Object)audioMode) + ", audioStreamType: " + (Object)((Object)audioStreamType) + ", audioRecordingPresetOverride: " + (Object)((Object)audioRecordingPresetOverride) + ", enableAudioRedundancy: " + enableAudioRedundancy);
        this.audioManager.setMode(3);
        AppInfo appInfo = AppInfoUtil.INSTANCE.initializeAudioClientAppInfo(this.context);
        BuildersKt.launch$default((CoroutineScope)this.uiScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(audioMode, this, audioDeviceCapabilities, audioStreamType, audioRecordingPresetOverride, host, port, joinToken, meetingId, attendeeId, audioFallbackUrl, appInfo, enableAudioRedundancy, reconnectTimeoutMs, null){
            int label;
            final /* synthetic */ AudioMode $audioMode;
            final /* synthetic */ DefaultAudioClientController this$0;
            final /* synthetic */ AudioDeviceCapabilities $audioDeviceCapabilities;
            final /* synthetic */ AudioStreamType $audioStreamType;
            final /* synthetic */ AudioRecordingPresetOverride $audioRecordingPresetOverride;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            final /* synthetic */ String $joinToken;
            final /* synthetic */ String $meetingId;
            final /* synthetic */ String $attendeeId;
            final /* synthetic */ String $audioFallbackUrl;
            final /* synthetic */ AppInfo $appInfo;
            final /* synthetic */ boolean $enableAudioRedundancy;
            final /* synthetic */ int $reconnectTimeoutMs;
            {
                this.$audioMode = $audioMode;
                this.this$0 = $receiver;
                this.$audioDeviceCapabilities = $audioDeviceCapabilities;
                this.$audioStreamType = $audioStreamType;
                this.$audioRecordingPresetOverride = $audioRecordingPresetOverride;
                this.$host = $host;
                this.$port = $port;
                this.$joinToken = $joinToken;
                this.$meetingId = $meetingId;
                this.$attendeeId = $attendeeId;
                this.$audioFallbackUrl = $audioFallbackUrl;
                this.$appInfo = $appInfo;
                this.$enableAudioRedundancy = $enableAudioRedundancy;
                this.$reconnectTimeoutMs = $reconnectTimeoutMs;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var3_3;
                        void var2_2;
                        AudioClient.AudioRecordingPreset audioRecordingPreset;
                        AudioClient.AudioStreamType audioStreamType;
                        AudioClient.AudioModeInternal audioModeInternal;
                        ResultKt.throwOnFailure((Object)object);
                        switch (start.WhenMappings.$EnumSwitchMapping$0[this.$audioMode.ordinal()]) {
                            case 1: {
                                audioModeInternal = AudioClient.AudioModeInternal.MONO_16K;
                                break;
                            }
                            case 2: {
                                audioModeInternal = AudioClient.AudioModeInternal.MONO_48K;
                                break;
                            }
                            case 3: {
                                audioModeInternal = AudioClient.AudioModeInternal.STEREO_48K;
                                break;
                            }
                            default: {
                                audioModeInternal = AudioClient.AudioModeInternal.STEREO_48K;
                            }
                        }
                        AudioClient.AudioModeInternal audioModeInternal2 = audioModeInternal;
                        AudioClient.AudioDeviceCapabilitiesInternal audioDeviceCapabilitiesInternal = DefaultAudioClientController.access$mapAudioDeviceCapabilitiesToInternal(this.this$0, this.$audioDeviceCapabilities);
                        switch (start.WhenMappings.$EnumSwitchMapping$1[this.$audioStreamType.ordinal()]) {
                            case 1: {
                                audioStreamType = AudioClient.AudioStreamType.VOICE_CALL;
                                break;
                            }
                            case 2: {
                                audioStreamType = AudioClient.AudioStreamType.MUSIC;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        AudioClient.AudioStreamType audioStreamTypeInternal = audioStreamType;
                        switch (start.WhenMappings.$EnumSwitchMapping$2[this.$audioRecordingPresetOverride.ordinal()]) {
                            case 1: {
                                audioRecordingPreset = DefaultAudioClientController.access$getDefaultRecordingPreset(this.this$0);
                                break;
                            }
                            case 2: {
                                audioRecordingPreset = AudioClient.AudioRecordingPreset.GENERIC;
                                break;
                            }
                            case 3: {
                                audioRecordingPreset = AudioClient.AudioRecordingPreset.CAMCORDER;
                                break;
                            }
                            case 4: {
                                audioRecordingPreset = AudioClient.AudioRecordingPreset.VOICE_RECOGNITION;
                                break;
                            }
                            case 5: {
                                audioRecordingPreset = AudioClient.AudioRecordingPreset.VOICE_COMMUNICATION;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        AudioClient.AudioRecordingPreset audioRecordingPresetInternal = audioRecordingPreset;
                        AudioClientSessionConfig config = ((AudioClientSessionConfig.Builder)((AudioClientSessionConfig.Builder)((AudioClientSessionConfig.Builder)((AudioClientSessionConfig.Builder)((AudioClientSessionConfig.Builder)((AudioClientSessionConfig.Builder)new AudioClientSessionConfig.Builder(this.$host, this.$port, this.$joinToken, this.$meetingId, this.$attendeeId, this.$audioFallbackUrl, this.$appInfo, (AudioClient.AudioModeInternal)var2_2, (AudioClient.AudioDeviceCapabilitiesInternal)var3_3, audioStreamTypeInternal, audioRecordingPresetInternal, this.$enableAudioRedundancy).withTransportMode(3)).withMicMute(DefaultAudioClientController.access$getMuteMicAndSpeaker$p(this.this$0))).withSpkMute(DefaultAudioClientController.access$getMuteMicAndSpeaker$p(this.this$0))).withPresenter(DefaultAudioClientController.access$getDEFAULT_PRESENTER$p(this.this$0))).withProxyConfig(null)).withReconnectTimeoutMs(this.$reconnectTimeoutMs)).build();
                        int res = DefaultAudioClientController.access$getAudioClient$p(this.this$0).startSession(config);
                        if (res != DefaultAudioClientController.access$getAUDIO_CLIENT_RESULT_SUCCESS$p(this.this$0)) {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).error(DefaultAudioClientController.access$getTAG$p(this.this$0), "Failed to start audio session. Response code: " + res);
                            EventAnalyticsController eventAnalyticsController = DefaultAudioClientController.access$getEventAnalyticsController$p(this.this$0);
                            Pair[] pairArray = new Pair[1];
                            MeetingSessionStatusCode meetingSessionStatusCode = DefaultAudioClientController.access$getAudioClientObserver$p(this.this$0).getCurrentAudioStatus();
                            Intrinsics.checkNotNull((Object)((Object)meetingSessionStatusCode), (String)"null cannot be cast to non-null type com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode");
                            pairArray[0] = TuplesKt.to((Object)((Object)EventAttributeName.meetingStatus), (Object)((Object)meetingSessionStatusCode));
                            eventAnalyticsController.publishEvent(EventName.meetingStartFailed, MapsKt.mutableMapOf((Pair[])pairArray));
                        } else {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).info(DefaultAudioClientController.access$getTAG$p(this.this$0), "Started audio session.");
                            DefaultAudioClientController.Companion.setAudioClientState(AudioClientState.STARTED);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void stop() {
        if (audioClientState != AudioClientState.STARTED) {
            this.logger.error(this.TAG, "Current audio client state " + (Object)((Object)audioClientState) + " is invalid to stop audio, ignoring");
            return;
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultAudioClientController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        int res = DefaultAudioClientController.access$getAudioClient$p(this.this$0).stopSession();
                        if (res != DefaultAudioClientController.access$getAUDIO_CLIENT_RESULT_SUCCESS$p(this.this$0)) {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).error(DefaultAudioClientController.access$getTAG$p(this.this$0), "Failed to stop audio session. Response code: " + res);
                        } else {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).info(DefaultAudioClientController.access$getTAG$p(this.this$0), "Stopped audio session.");
                            DefaultAudioClientController.Companion.setAudioClientState(AudioClientState.STOPPED);
                            DefaultAudioClientController.access$resetAudioManager(this.this$0);
                            DefaultAudioClientController.access$notifyStop(this.this$0);
                            DefaultAudioClientController.access$getAudioClientObserver$p(this.this$0).notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)stop.1.INSTANCE));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void notifyStop() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.meetingStatus), (Object)((Object)MeetingSessionStatusCode.OK))};
        this.eventAnalyticsController.publishEvent(EventName.meetingEnded, MapsKt.mutableMapOf((Pair[])pairArray));
        this.meetingStatsCollector.resetMeetingStats();
    }

    private final void resetAudioManager() {
        AudioManager audioManager;
        AudioManager $this$resetAudioManager_u24lambda_u241 = audioManager = this.audioManager;
        boolean bl = false;
        $this$resetAudioManager_u24lambda_u241.setBluetoothScoOn(false);
        $this$resetAudioManager_u24lambda_u241.stopBluetoothSco();
        this.audioManager.setMode(this.audioModePreCall);
        this.audioManager.setSpeakerphoneOn(this.speakerphoneStatePreCall);
    }

    @Override
    public boolean setMute(boolean isMuted) {
        return audioClientState == AudioClientState.STARTED && this.audioClient.setMicMute(isMuted) == 0;
    }

    @Override
    public boolean setVoiceFocusEnabled(boolean enabled) {
        if (audioClientState == AudioClientState.STARTED) {
            return this.audioClient.setVoiceFocusNoiseSuppression(enabled) == 0;
        }
        this.logger.error(this.TAG, "Failed to set VoiceFocus to " + enabled + "; audio client state is " + (Object)((Object)audioClientState));
        return false;
    }

    @Override
    public boolean isVoiceFocusEnabled() {
        if (audioClientState == AudioClientState.STARTED) {
            return this.audioClient.getVoiceFocusNoiseSuppression();
        }
        this.logger.error(this.TAG, "Failed to get VoiceFocus enabled state; audio client state is " + (Object)((Object)audioClientState));
        return false;
    }

    @Override
    public void promoteToPrimaryMeeting(@NotNull MeetingSessionCredentials credentials, @NotNull PrimaryMeetingPromotionObserver observer) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        if (audioClientState != AudioClientState.STARTED) {
            observer.onPrimaryMeetingPromotion(new MeetingSessionStatus(MeetingSessionStatusCode.AudioServiceUnavailable));
            return;
        }
        this.audioClientObserver.setPrimaryMeetingPromotionObserver(observer);
        this.audioClient.promoteToPrimaryMeeting(credentials.getAttendeeId(), credentials.getExternalUserId(), credentials.getJoinToken());
    }

    @Override
    public void demoteFromPrimaryMeeting() {
        if (audioClientState != AudioClientState.STARTED) {
            return;
        }
        this.audioClient.demoteFromPrimaryMeeting();
    }

    private final AudioClient.AudioDeviceCapabilitiesInternal mapAudioDeviceCapabilitiesToInternal(AudioDeviceCapabilities audioDeviceCapabilities) {
        AudioClient.AudioDeviceCapabilitiesInternal audioDeviceCapabilitiesInternal;
        switch (WhenMappings.$EnumSwitchMapping$1[audioDeviceCapabilities.ordinal()]) {
            case 1: {
                audioDeviceCapabilitiesInternal = AudioClient.AudioDeviceCapabilitiesInternal.NONE;
                break;
            }
            case 2: {
                audioDeviceCapabilitiesInternal = AudioClient.AudioDeviceCapabilitiesInternal.OUTPUT_ONLY;
                break;
            }
            case 3: {
                audioDeviceCapabilitiesInternal = AudioClient.AudioDeviceCapabilitiesInternal.INPUT_AND_OUTPUT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return audioDeviceCapabilitiesInternal;
    }

    public static final /* synthetic */ AudioClient.AudioDeviceCapabilitiesInternal access$mapAudioDeviceCapabilitiesToInternal(DefaultAudioClientController $this, AudioDeviceCapabilities audioDeviceCapabilities) {
        return $this.mapAudioDeviceCapabilitiesToInternal(audioDeviceCapabilities);
    }

    public static final /* synthetic */ AudioClient.AudioRecordingPreset access$getDefaultRecordingPreset(DefaultAudioClientController $this) {
        return $this.getDefaultRecordingPreset();
    }

    public static final /* synthetic */ boolean access$getMuteMicAndSpeaker$p(DefaultAudioClientController $this) {
        return $this.muteMicAndSpeaker;
    }

    public static final /* synthetic */ boolean access$getDEFAULT_PRESENTER$p(DefaultAudioClientController $this) {
        return $this.DEFAULT_PRESENTER;
    }

    public static final /* synthetic */ AudioClient access$getAudioClient$p(DefaultAudioClientController $this) {
        return $this.audioClient;
    }

    public static final /* synthetic */ int access$getAUDIO_CLIENT_RESULT_SUCCESS$p(DefaultAudioClientController $this) {
        return $this.AUDIO_CLIENT_RESULT_SUCCESS;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultAudioClientController $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultAudioClientController $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ EventAnalyticsController access$getEventAnalyticsController$p(DefaultAudioClientController $this) {
        return $this.eventAnalyticsController;
    }

    public static final /* synthetic */ AudioClientObserver access$getAudioClientObserver$p(DefaultAudioClientController $this) {
        return $this.audioClientObserver;
    }

    public static final /* synthetic */ void access$resetAudioManager(DefaultAudioClientController $this) {
        $this.resetAudioManager();
    }

    public static final /* synthetic */ void access$notifyStop(DefaultAudioClientController $this) {
        $this.notifyStop();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientController$Companion;", "", "()V", "audioClientState", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientState;", "getAudioClientState", "()Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientState;", "setAudioClientState", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientState;)V", "amazon-chime-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AudioClientState getAudioClientState() {
            return audioClientState;
        }

        public final void setAudioClientState(@NotNull AudioClientState audioClientState) {
            Intrinsics.checkNotNullParameter((Object)((Object)audioClientState), (String)"<set-?>");
            DefaultAudioClientController.audioClientState = audioClientState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AudioMode.values().length];
            try {
                nArray[AudioMode.Mono16K.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioMode.Mono48K.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioMode.Stereo48K.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AudioDeviceCapabilities.values().length];
            try {
                nArray[AudioDeviceCapabilities.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioDeviceCapabilities.OutputOnly.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AudioDeviceCapabilities.InputAndOutput.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

