/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Surface;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoResolution;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultScreenCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.ScreenCaptureResolutionCalculator;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSourceFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.VideoCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.android.HandlerDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020$H\u0016J\u0010\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020\u0002H\u0016J\u0010\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nH\u0002J\u0014\u00105\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n06H\u0002J\b\u00107\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020:H\u0016J\u0006\u0010;\u001a\u00020/J\u0010\u0010<\u001a\u00020/2\u0006\u00100\u001a\u00020$H\u0016J\u0010\u0010=\u001a\u00020/2\u0006\u00102\u001a\u00020\u0002H\u0016J\b\u0010>\u001a\u00020/H\u0002J\u0010\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020+H\u0016J\b\u0010A\u001a\u00020/H\u0016J\b\u0010B\u001a\u00020\u001eH\u0002J\b\u0010C\u001a\u00020/H\u0016J\b\u0010D\u001a\u00020/H\u0002R\u000e\u0010\u0012\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultScreenCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "surfaceTextureCaptureSourceFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;", "activityResultCode", "", "activityData", "Landroid/content/Intent;", "displayManager", "Landroid/hardware/display/DisplayManager;", "mediaProjectionManager", "Landroid/media/projection/MediaProjectionManager;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;ILandroid/content/Intent;Landroid/hardware/display/DisplayManager;Landroid/media/projection/MediaProjectionManager;)V", "MIN_FPS", "TAG", "", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "displayMetrics", "Landroid/util/DisplayMetrics;", "handler", "Landroid/os/Handler;", "isOrientationInPortrait", "", "isResizingForOrientationChange", "mediaProjection", "Landroid/media/projection/MediaProjection;", "observers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceObserver;", "screenCaptureResolutionCalculator", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/ScreenCaptureResolutionCalculator;", "sinks", "surfaceTextureSource", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSource;", "targetResolution", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "addCaptureSourceObserver", "", "observer", "addVideoSink", "sink", "alignNumberBy16", "number", "getAdjustedWidthAndHeight", "Lkotlin/Pair;", "getStatusBarHeight", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "release", "removeCaptureSourceObserver", "removeVideoSink", "resize", "setMaxResolution", "maxResolution", "start", "startInternal", "stop", "stopInternal", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultScreenCaptureSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultScreenCaptureSource.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultScreenCaptureSource\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,368:1\n32#2,2:369\n*S KotlinDebug\n*F\n+ 1 DefaultScreenCaptureSource.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultScreenCaptureSource\n*L\n322#1:369,2\n*E\n"})
public final class DefaultScreenCaptureSource
implements VideoCaptureSource,
VideoSink {
    @NotNull
    private final Context context;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory;
    private final int activityResultCode;
    @NotNull
    private final Intent activityData;
    @NotNull
    private final DisplayManager displayManager;
    @NotNull
    private final MediaProjectionManager mediaProjectionManager;
    private DisplayMetrics displayMetrics;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private SurfaceTextureCaptureSource surfaceTextureSource;
    private final int MIN_FPS;
    @Nullable
    private MediaProjection mediaProjection;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Set<CaptureSourceObserver> observers;
    @NotNull
    private VideoResolution targetResolution;
    @NotNull
    private final ScreenCaptureResolutionCalculator screenCaptureResolutionCalculator;
    @NotNull
    private final Set<VideoSink> sinks;
    @NotNull
    private final VideoContentHint contentHint;
    private boolean isOrientationInPortrait;
    private boolean isResizingForOrientationChange;
    @NotNull
    private final String TAG;

    public DefaultScreenCaptureSource(@NotNull Context context, @NotNull Logger logger, @NotNull SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, int activityResultCode, @NotNull Intent activityData, @NotNull DisplayManager displayManager, @NotNull MediaProjectionManager mediaProjectionManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)surfaceTextureCaptureSourceFactory, (String)"surfaceTextureCaptureSourceFactory");
        Intrinsics.checkNotNullParameter((Object)activityData, (String)"activityData");
        Intrinsics.checkNotNullParameter((Object)displayManager, (String)"displayManager");
        Intrinsics.checkNotNullParameter((Object)mediaProjectionManager, (String)"mediaProjectionManager");
        this.context = context;
        this.logger = logger;
        this.surfaceTextureCaptureSourceFactory = surfaceTextureCaptureSourceFactory;
        this.activityResultCode = activityResultCode;
        this.activityData = activityData;
        this.displayManager = displayManager;
        this.mediaProjectionManager = mediaProjectionManager;
        this.MIN_FPS = 15;
        this.observers = new LinkedHashSet();
        this.targetResolution = VideoResolution.VideoResolutionFHD;
        this.screenCaptureResolutionCalculator = new ScreenCaptureResolutionCalculator();
        this.sinks = ConcurrentSet.Companion.createConcurrentSet();
        this.contentHint = VideoContentHint.Text;
        this.isOrientationInPortrait = true;
        this.TAG = "DefaultScreenCaptureSource";
        HandlerThread thread = new HandlerThread(this.TAG);
        thread.start();
        this.handler = new Handler(thread.getLooper());
    }

    public /* synthetic */ DefaultScreenCaptureSource(Context context, Logger logger, SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, int n, Intent intent, DisplayManager displayManager, MediaProjectionManager mediaProjectionManager, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            Object object = context.getSystemService("display");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.display.DisplayManager");
            displayManager = (DisplayManager)object;
        }
        if ((n2 & 0x40) != 0) {
            Object object = context.getSystemService("media_projection");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
            mediaProjectionManager = (MediaProjectionManager)object;
        }
        this(context, logger, surfaceTextureCaptureSourceFactory, n, intent, displayManager, mediaProjectionManager);
    }

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    @Override
    public void start() {
        this.handler.post(() -> DefaultScreenCaptureSource.start$lambda$0(this));
    }

    @Override
    public void setMaxResolution(@NotNull VideoResolution maxResolution) {
        Intrinsics.checkNotNullParameter((Object)((Object)maxResolution), (String)"maxResolution");
        this.targetResolution = maxResolution == VideoResolution.VideoResolutionUHD ? VideoResolution.VideoResolutionUHD : VideoResolution.VideoResolutionFHD;
    }

    private final int alignNumberBy16(int number) {
        int maxIntAlignedBy16 = 0x7FFFFFF0;
        return number & maxIntAlignedBy16;
    }

    private final boolean startInternal() {
        VirtualDisplay virtualDisplay;
        SurfaceTextureCaptureSource newSurfaceTextureSource;
        SurfaceTextureCaptureSource surfaceTextureCaptureSource;
        if (this.mediaProjection != null) {
            this.logger.warn(this.TAG, "Screen capture has not been stopped before start request, stopping to release resources");
            this.stop();
        }
        this.logger.info(this.TAG, "Starting screen capture source");
        try {
            this.mediaProjection = this.mediaProjectionManager.getMediaProjection(this.activityResultCode, this.activityData);
        }
        catch (SecurityException exception) {
            this.logger.error(this.TAG, "Failed to retrieve media projection due to SecurityException. The foreground service may not have finished starting before start was called.");
            ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, startInternal.1.INSTANCE);
            return false;
        }
        if (this.mediaProjection == null) {
            this.logger.error(this.TAG, "Failed to retrieve media projection. The resultCode or data may have been invalid.");
            ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, startInternal.2.INSTANCE);
            return false;
        }
        this.isOrientationInPortrait = this.isOrientationInPortrait();
        Pair<Integer, Integer> size = this.getAdjustedWidthAndHeight();
        SurfaceTextureCaptureSource $this$startInternal_u24lambda_u241 = surfaceTextureCaptureSource = this.surfaceTextureCaptureSourceFactory.createSurfaceTextureCaptureSource(((Number)size.getFirst()).intValue(), ((Number)size.getSecond()).intValue(), this.getContentHint());
        boolean bl = false;
        $this$startInternal_u24lambda_u241.setMinFps(this.MIN_FPS);
        $this$startInternal_u24lambda_u241.addVideoSink(this);
        $this$startInternal_u24lambda_u241.start();
        this.surfaceTextureSource = newSurfaceTextureSource = surfaceTextureCaptureSource;
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            mediaProjection.registerCallback(new MediaProjection.Callback(this){
                final /* synthetic */ DefaultScreenCaptureSource this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onStop() {
                    DefaultScreenCaptureSource.access$stopInternal(this.this$0);
                }
            }, this.handler);
        }
        MediaProjection mediaProjection2 = this.mediaProjection;
        if (mediaProjection2 != null) {
            int n = ((Number)size.getFirst()).intValue();
            int n2 = ((Number)size.getSecond()).intValue();
            DisplayMetrics displayMetrics = this.displayMetrics;
            if (displayMetrics == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics = null;
            }
            SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = this.surfaceTextureSource;
            virtualDisplay = mediaProjection2.createVirtualDisplay(this.TAG, n, n2, displayMetrics.densityDpi, 16, (Surface)(surfaceTextureCaptureSource2 != null ? surfaceTextureCaptureSource2.getSurface() : null), new VirtualDisplay.Callback(this){
                final /* synthetic */ DefaultScreenCaptureSource this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onStopped() {
                    if (!DefaultScreenCaptureSource.access$isResizingForOrientationChange$p(this.this$0)) {
                        ObserverUtils.Companion.notifyObserverOnMainThread(DefaultScreenCaptureSource.access$getObservers$p(this.this$0), startInternal.onStopped.1.INSTANCE);
                    }
                }
            }, this.handler);
        } else {
            virtualDisplay = null;
        }
        this.virtualDisplay = virtualDisplay;
        this.logger.info(this.TAG, "Media projection adapter activity succeeded, virtual display created");
        return true;
    }

    private final boolean isOrientationInPortrait() {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"getDisplayMetrics(...)");
        this.displayMetrics = displayMetrics;
        Display display = this.displayManager.getDisplay(0);
        if (display == null) {
            throw new RuntimeException("No display found.");
        }
        Display display2 = display;
        DisplayMetrics displayMetrics2 = this.displayMetrics;
        if (displayMetrics2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
            displayMetrics2 = null;
        }
        display2.getRealMetrics(displayMetrics2);
        int rotation = display2.getRotation();
        boolean isInPortrait = rotation == 0 || rotation == 2;
        this.logger.info(this.TAG, "isOrientationInPortrait: " + isInPortrait);
        return isInPortrait;
    }

    private final Pair<Integer, Integer> getAdjustedWidthAndHeight() {
        Integer[] integerArray;
        int n;
        int n2;
        Integer[] integerArray2;
        if (this.isOrientationInPortrait) {
            integerArray2 = new Integer[2];
            DisplayMetrics displayMetrics = this.displayMetrics;
            if (displayMetrics == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics = null;
            }
            n2 = displayMetrics.widthPixels;
            DisplayMetrics displayMetrics2 = this.displayMetrics;
            if (displayMetrics2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics2 = null;
            }
            n = displayMetrics2.heightPixels;
            integerArray2[0] = Math.min(n2, n);
            DisplayMetrics displayMetrics3 = this.displayMetrics;
            if (displayMetrics3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics3 = null;
            }
            n2 = displayMetrics3.widthPixels;
            DisplayMetrics displayMetrics4 = this.displayMetrics;
            if (displayMetrics4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics4 = null;
            }
            n = displayMetrics4.heightPixels;
            integerArray2[1] = Math.max(n2, n);
            integerArray = integerArray2;
        } else {
            integerArray2 = new Integer[2];
            DisplayMetrics displayMetrics = this.displayMetrics;
            if (displayMetrics == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics = null;
            }
            n2 = displayMetrics.widthPixels;
            DisplayMetrics displayMetrics5 = this.displayMetrics;
            if (displayMetrics5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics5 = null;
            }
            n = displayMetrics5.heightPixels;
            integerArray2[0] = Math.max(n2, n);
            DisplayMetrics displayMetrics6 = this.displayMetrics;
            if (displayMetrics6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics6 = null;
            }
            n2 = displayMetrics6.widthPixels;
            DisplayMetrics displayMetrics7 = this.displayMetrics;
            if (displayMetrics7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics7 = null;
            }
            n = displayMetrics7.heightPixels;
            integerArray2[1] = Math.min(n2, n);
            integerArray = integerArray2;
        }
        Integer[] displayWidthAndHeight = integerArray;
        this.logger.info(this.TAG, "displayMetrics - width: " + displayWidthAndHeight[0] + ", height: " + displayWidthAndHeight[1]);
        int[] targetSize = this.screenCaptureResolutionCalculator.computeTargetSize(displayWidthAndHeight[0], displayWidthAndHeight[1], this.targetResolution.getWidth(), this.targetResolution.getHeight());
        int width = this.screenCaptureResolutionCalculator.alignToEven(targetSize[0]);
        int height = this.screenCaptureResolutionCalculator.alignToEven(targetSize[1]);
        int adjustedWidth = this.alignNumberBy16(width - (this.isOrientationInPortrait ? 0 : this.getStatusBarHeight()));
        int adjustedHeight = this.alignNumberBy16(height);
        this.logger.info(this.TAG, "width: " + adjustedWidth + ", adjustedHeight: " + adjustedHeight);
        return new Pair((Object)adjustedWidth, (Object)adjustedHeight);
    }

    @Override
    public void stop() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultScreenCaptureSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultScreenCaptureSource.access$stopInternal(this.this$0);
                        DefaultScreenCaptureSource.access$setResizingForOrientationChange$p(this.this$0, false);
                        ObserverUtils.Companion.notifyObserverOnMainThread(DefaultScreenCaptureSource.access$getObservers$p(this.this$0), stop.1.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void stopInternal() {
        this.logger.info(this.TAG, "Stopping screen capture source");
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            mediaProjection.stop();
        }
        this.mediaProjection = null;
        VirtualDisplay virtualDisplay = this.virtualDisplay;
        if (virtualDisplay != null) {
            virtualDisplay.release();
        }
        this.virtualDisplay = null;
        SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource != null) {
            surfaceTextureCaptureSource.removeVideoSink(this);
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource2 != null) {
            surfaceTextureCaptureSource2.stop();
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource3 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource3 != null) {
            surfaceTextureCaptureSource3.release();
        }
        this.surfaceTextureSource = null;
    }

    @Override
    public void addCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observers.add(observer);
    }

    @Override
    public void removeCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observers.remove(observer);
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        boolean isOrientationInPortrait;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Display display = this.displayManager.getDisplay(0);
        if (display == null) {
            throw new RuntimeException("No display found.");
        }
        Display display2 = display;
        int rotation = display2.getRotation();
        boolean bl = isOrientationInPortrait = rotation == 0 || rotation == 2;
        if (this.isOrientationInPortrait != isOrientationInPortrait) {
            this.isResizingForOrientationChange = true;
            this.logger.info(this.TAG, "Orientation changed from " + (this.isOrientationInPortrait ? "portrait" : "landscape") + " to " + (isOrientationInPortrait ? "portrait" : "landscape") + ", resize virtual display to update dimensions");
            this.handler.post(() -> DefaultScreenCaptureSource.onVideoFrameReceived$lambda$2(this));
            return;
        }
        if (this.isResizingForOrientationChange) {
            return;
        }
        Iterator<VideoSink> $this$forEach$iv = this.sinks.iterator();
        boolean $i$f$forEach = false;
        Iterator<VideoSink> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            VideoSink element$iv;
            VideoSink it = element$iv = iterator.next();
            boolean bl2 = false;
            it.onVideoFrameReceived(frame);
        }
    }

    private final void resize() {
        SurfaceTextureCaptureSource newSurfaceTextureSource;
        SurfaceTextureCaptureSource surfaceTextureCaptureSource;
        this.isOrientationInPortrait = this.isOrientationInPortrait();
        Pair<Integer, Integer> size = this.getAdjustedWidthAndHeight();
        this.logger.info(this.TAG, "resize to width: " + ((Number)size.getFirst()).intValue() + ", height: " + ((Number)size.getSecond()).intValue());
        VirtualDisplay virtualDisplay = this.virtualDisplay;
        if (virtualDisplay != null && (virtualDisplay = virtualDisplay.getSurface()) != null) {
            virtualDisplay.release();
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource2 != null) {
            surfaceTextureCaptureSource2.removeVideoSink(this);
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource3 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource3 != null) {
            surfaceTextureCaptureSource3.stop();
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource4 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource4 != null) {
            surfaceTextureCaptureSource4.release();
        }
        this.surfaceTextureSource = null;
        SurfaceTextureCaptureSource $this$resize_u24lambda_u244 = surfaceTextureCaptureSource = this.surfaceTextureCaptureSourceFactory.createSurfaceTextureCaptureSource(((Number)size.getFirst()).intValue(), ((Number)size.getSecond()).intValue(), this.getContentHint());
        boolean bl = false;
        $this$resize_u24lambda_u244.setMinFps(this.MIN_FPS);
        $this$resize_u24lambda_u244.addVideoSink(this);
        $this$resize_u24lambda_u244.start();
        this.surfaceTextureSource = newSurfaceTextureSource = surfaceTextureCaptureSource;
        VirtualDisplay virtualDisplay2 = this.virtualDisplay;
        if (virtualDisplay2 != null) {
            int n = ((Number)size.getFirst()).intValue();
            int n2 = ((Number)size.getSecond()).intValue();
            DisplayMetrics displayMetrics = this.displayMetrics;
            if (displayMetrics == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
                displayMetrics = null;
            }
            virtualDisplay2.resize(n, n2, displayMetrics.densityDpi);
        }
        VirtualDisplay virtualDisplay3 = this.virtualDisplay;
        if (virtualDisplay3 != null) {
            virtualDisplay3.setSurface(newSurfaceTextureSource.getSurface());
        }
        this.logger.info(this.TAG, "resize done!");
    }

    public final void release() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultScreenCaptureSource this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DefaultScreenCaptureSource.access$getLogger$p(this.this$0).info(DefaultScreenCaptureSource.access$getTAG$p(this.this$0), "Stopping handler looper");
                        DefaultScreenCaptureSource.access$getHandler$p(this.this$0).removeCallbacksAndMessages(null);
                        DefaultScreenCaptureSource.access$getHandler$p(this.this$0).getLooper().quit();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final int getStatusBarHeight() {
        Resources resources = this.context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"getResources(...)");
        Resources resources2 = resources;
        int resourceId = resources2.getIdentifier("status_bar_height", "dimen", "android");
        return resourceId > 0 ? resources2.getDimensionPixelSize(resourceId) : (int)Math.ceil((float)(Build.VERSION.SDK_INT >= 23 ? 24 : 25) * resources2.getDisplayMetrics().density);
    }

    private static final void start$lambda$0(DefaultScreenCaptureSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        boolean success = this$0.startInternal();
        this$0.isResizingForOrientationChange = false;
        if (success) {
            ObserverUtils.Companion.notifyObserverOnMainThread(this$0.observers, start.1.1.INSTANCE);
        }
    }

    private static final void onVideoFrameReceived$lambda$2(DefaultScreenCaptureSource this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isResizingForOrientationChange) {
            this$0.resize();
            this$0.isResizingForOrientationChange = false;
        }
    }

    public static final /* synthetic */ void access$stopInternal(DefaultScreenCaptureSource $this) {
        $this.stopInternal();
    }

    public static final /* synthetic */ boolean access$isResizingForOrientationChange$p(DefaultScreenCaptureSource $this) {
        return $this.isResizingForOrientationChange;
    }

    public static final /* synthetic */ Set access$getObservers$p(DefaultScreenCaptureSource $this) {
        return $this.observers;
    }

    public static final /* synthetic */ void access$setResizingForOrientationChange$p(DefaultScreenCaptureSource $this, boolean bl) {
        $this.isResizingForOrientationChange = bl;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultScreenCaptureSource $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultScreenCaptureSource $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Handler access$getHandler$p(DefaultScreenCaptureSource $this) {
        return $this.handler;
    }
}

