/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video;

import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoPauseState;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoRenderView;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoTile;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoTileController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoTileFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoTileObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglVideoRenderView;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientController;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J+\u0010\u001e\u001a\u00020\u00192!\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00190 H\u0002J2\u0010#\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0002J,\u0010)\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u00142\b\u0010$\u001a\u0004\u0018\u00010\u000e2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u0010/\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0010\u00102\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0014H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/DefaultVideoTileController;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileController;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "videoClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;", "videoTileFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileFactory;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "meetingStatsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileFactory;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;)V", "TAG", "", "renderViewToBoundVideoTileMap", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRenderView;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTile;", "videoTileMap", "", "videoTileObservers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoTileObserver;", "addVideoTileObserver", "", "observer", "bindVideoView", "videoView", "tileId", "forEachObserver", "observerFunction", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "onAddVideoTile", "attendeeId", "pauseState", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoPauseState;", "videoStreamContentWidth", "videoStreamContentHeight", "onReceiveFrame", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "videoId", "onRemoveVideoTile", "pauseRemoteVideoTile", "removeRenderViewFromBoundVideoTileMap", "removeVideoTileObserver", "resumeRemoteVideoTile", "unbindVideoView", "amazon-chime-sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultVideoTileController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultVideoTileController.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/DefaultVideoTileController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,226:1\n1#2:227\n288#3,2:228\n*S KotlinDebug\n*F\n+ 1 DefaultVideoTileController.kt\ncom/amazonaws/services/chime/sdk/meetings/audiovideo/video/DefaultVideoTileController\n*L\n178#1:228,2\n*E\n"})
public final class DefaultVideoTileController
implements VideoTileController {
    @NotNull
    private final Logger logger;
    @NotNull
    private final VideoClientController videoClientController;
    @NotNull
    private final VideoTileFactory videoTileFactory;
    @NotNull
    private final EglCoreFactory eglCoreFactory;
    @NotNull
    private final MeetingStatsCollector meetingStatsCollector;
    @NotNull
    private final Map<Integer, VideoTile> videoTileMap;
    @NotNull
    private final Map<VideoRenderView, VideoTile> renderViewToBoundVideoTileMap;
    @NotNull
    private final String TAG;
    @NotNull
    private Set<VideoTileObserver> videoTileObservers;

    public DefaultVideoTileController(@NotNull Logger logger, @NotNull VideoClientController videoClientController, @NotNull VideoTileFactory videoTileFactory, @NotNull EglCoreFactory eglCoreFactory, @NotNull MeetingStatsCollector meetingStatsCollector) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)videoClientController, (String)"videoClientController");
        Intrinsics.checkNotNullParameter((Object)videoTileFactory, (String)"videoTileFactory");
        Intrinsics.checkNotNullParameter((Object)eglCoreFactory, (String)"eglCoreFactory");
        Intrinsics.checkNotNullParameter((Object)meetingStatsCollector, (String)"meetingStatsCollector");
        this.logger = logger;
        this.videoClientController = videoClientController;
        this.videoTileFactory = videoTileFactory;
        this.eglCoreFactory = eglCoreFactory;
        this.meetingStatsCollector = meetingStatsCollector;
        this.videoTileMap = new LinkedHashMap();
        this.renderViewToBoundVideoTileMap = new LinkedHashMap();
        this.TAG = "DefaultVideoTileController";
        this.videoTileObservers = ConcurrentSet.Companion.createConcurrentSet();
    }

    @Override
    public void onReceiveFrame(@Nullable VideoFrame frame, int videoId, @Nullable String attendeeId, @NotNull VideoPauseState pauseState) {
        int videoStreamContentHeight;
        Intrinsics.checkNotNullParameter((Object)((Object)pauseState), (String)"pauseState");
        VideoTile tile = this.videoTileMap.get(videoId);
        VideoFrame videoFrame = frame;
        int videoStreamContentWidth = videoFrame != null ? videoFrame.getWidth() : 0;
        VideoFrame videoFrame2 = frame;
        int n = videoStreamContentHeight = videoFrame2 != null ? videoFrame2.getHeight() : 0;
        if (tile != null) {
            if (frame == null && pauseState == VideoPauseState.Unpaused) {
                this.logger.info(this.TAG, "Removing video tile with videoId = " + videoId + " & attendeeId = " + attendeeId);
                this.onRemoveVideoTile(videoId);
                return;
            }
            if (frame != null && (videoStreamContentWidth != tile.getState().getVideoStreamContentWidth() || videoStreamContentHeight != tile.getState().getVideoStreamContentHeight())) {
                tile.getState().setVideoStreamContentWidth(videoStreamContentWidth);
                tile.getState().setVideoStreamContentHeight(videoStreamContentHeight);
                this.forEachObserver((Function1<? super VideoTileObserver, Unit>)((Function1)new Function1<VideoTileObserver, Unit>(tile){
                    final /* synthetic */ VideoTile $tile;
                    {
                        this.$tile = $tile;
                        super(1);
                    }

                    public final void invoke(@NotNull VideoTileObserver observer) {
                        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                        observer.onVideoTileSizeChanged(this.$tile.getState());
                    }
                }));
            }
            if (pauseState != tile.getState().getPauseState() && tile.getState().getPauseState() != VideoPauseState.PausedByUserRequest) {
                tile.setPauseState(pauseState);
                if (pauseState == VideoPauseState.Unpaused) {
                    this.forEachObserver((Function1<? super VideoTileObserver, Unit>)((Function1)new Function1<VideoTileObserver, Unit>(tile){
                        final /* synthetic */ VideoTile $tile;
                        {
                            this.$tile = $tile;
                            super(1);
                        }

                        public final void invoke(@NotNull VideoTileObserver observer) {
                            Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                            observer.onVideoTileResumed(this.$tile.getState());
                        }
                    }));
                } else {
                    this.forEachObserver((Function1<? super VideoTileObserver, Unit>)((Function1)new Function1<VideoTileObserver, Unit>(tile){
                        final /* synthetic */ VideoTile $tile;
                        {
                            this.$tile = $tile;
                            super(1);
                        }

                        public final void invoke(@NotNull VideoTileObserver observer) {
                            Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                            observer.onVideoTilePaused(this.$tile.getState());
                        }
                    }));
                }
            }
            if (tile.getState().getPauseState() == VideoPauseState.Unpaused) {
                VideoFrame videoFrame3 = frame;
                if (videoFrame3 != null) {
                    VideoFrame $this$onReceiveFrame_u24lambda_u240 = videoFrame3;
                    boolean bl = false;
                    tile.onVideoFrameReceived(frame);
                }
            } else {
                this.logger.verbose(this.TAG, "Ignoring video frame received on paused tile");
            }
        } else if (frame != null || pauseState != VideoPauseState.Unpaused) {
            DefaultVideoTileController $this$onReceiveFrame_u24lambda_u241 = this;
            boolean bl = false;
            $this$onReceiveFrame_u24lambda_u241.logger.info($this$onReceiveFrame_u24lambda_u241.TAG, "Adding video tile with videoId = " + videoId + ", attendeeId = " + attendeeId + ", pauseState = " + (Object)((Object)pauseState));
            $this$onReceiveFrame_u24lambda_u241.onAddVideoTile(videoId, attendeeId, pauseState, videoStreamContentWidth, videoStreamContentHeight);
        }
    }

    @Override
    public void addVideoTileObserver(@NotNull VideoTileObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.videoTileObservers.add(observer);
    }

    @Override
    public void removeVideoTileObserver(@NotNull VideoTileObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.videoTileObservers.remove(observer);
    }

    @Override
    public void pauseRemoteVideoTile(int tileId) {
        block2: {
            VideoTile videoTile = this.videoTileMap.get(tileId);
            if (videoTile == null) break block2;
            VideoTile it = videoTile;
            boolean bl = false;
            if (it.getState().isLocalTile()) {
                this.logger.warn(this.TAG, "Cannot pause local video tile " + tileId + '!');
                return;
            }
            this.logger.info(this.TAG, "Pausing tile " + tileId);
            this.videoClientController.setRemotePaused(true, tileId);
            if (it.getState().getPauseState() != VideoPauseState.PausedByUserRequest) {
                it.setPauseState(VideoPauseState.PausedByUserRequest);
                this.forEachObserver((Function1<? super VideoTileObserver, Unit>)((Function1)new Function1<VideoTileObserver, Unit>(it){
                    final /* synthetic */ VideoTile $it;
                    {
                        this.$it = $it;
                        super(1);
                    }

                    public final void invoke(@NotNull VideoTileObserver observer) {
                        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                        observer.onVideoTilePaused(this.$it.getState());
                    }
                }));
            }
        }
    }

    @Override
    public void resumeRemoteVideoTile(int tileId) {
        block2: {
            VideoTile videoTile = this.videoTileMap.get(tileId);
            if (videoTile == null) break block2;
            VideoTile it = videoTile;
            boolean bl = false;
            if (it.getState().isLocalTile()) {
                this.logger.warn(this.TAG, "Cannot resume local video tile " + tileId + '!');
                return;
            }
            this.logger.info(this.TAG, "Resuming tile " + tileId);
            this.videoClientController.setRemotePaused(false, tileId);
            if (it.getState().getPauseState() == VideoPauseState.PausedByUserRequest) {
                it.setPauseState(VideoPauseState.Unpaused);
                this.forEachObserver((Function1<? super VideoTileObserver, Unit>)((Function1)new Function1<VideoTileObserver, Unit>(it){
                    final /* synthetic */ VideoTile $it;
                    {
                        this.$it = $it;
                        super(1);
                    }

                    public final void invoke(@NotNull VideoTileObserver observer) {
                        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                        observer.onVideoTileResumed(this.$it.getState());
                    }
                }));
            }
        }
    }

    @Override
    public void bindVideoView(@NotNull VideoRenderView videoView, int tileId) {
        block4: {
            VideoTile it;
            Intrinsics.checkNotNullParameter((Object)videoView, (String)"videoView");
            this.logger.info(this.TAG, "Binding VideoView to Tile with tileId = " + tileId);
            VideoTile videoTile = this.renderViewToBoundVideoTileMap.get(videoView);
            if (videoTile != null) {
                it = videoTile;
                boolean bl = false;
                if (it.getState().getTileId() == tileId) {
                    this.logger.info(this.TAG, "Already binding with the tile Id " + tileId + ", ignore...");
                    return;
                }
                this.logger.warn(this.TAG, "Override the binding from " + it.getState().getTileId() + " to " + tileId);
                this.removeRenderViewFromBoundVideoTileMap(it.getState().getTileId());
            }
            VideoTile videoTile2 = this.videoTileMap.get(tileId);
            if (videoTile2 == null) break block4;
            it = videoTile2;
            boolean bl = false;
            VideoRenderView videoRenderView = it.getVideoRenderView();
            if (videoRenderView != null) {
                VideoRenderView it2 = videoRenderView;
                boolean bl2 = false;
                this.logger.info(this.TAG, "tileId = " + tileId + " already had a different video view. Unbinding the old one and associating the new one");
                this.removeRenderViewFromBoundVideoTileMap(tileId);
            }
            if (videoView instanceof EglVideoRenderView) {
                this.logger.info(this.TAG, "Initializing EGL state on EGL render view");
                ((EglVideoRenderView)videoView).init(this.eglCoreFactory);
            }
            it.bind(videoView);
            this.renderViewToBoundVideoTileMap.put(videoView, it);
        }
    }

    private final void removeRenderViewFromBoundVideoTileMap(int tileId) {
        block3: {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = this.renderViewToBoundVideoTileMap.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!(((VideoTile)it.getValue()).getState().getTileId() == tileId)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            if (entry == null) break block3;
            Map.Entry it = entry;
            boolean bl = false;
            VideoRenderView renderView = (VideoRenderView)it.getKey();
            VideoTile videoTile = (VideoTile)it.getValue();
            videoTile.unbind();
            if (renderView instanceof EglVideoRenderView) {
                this.logger.info(this.TAG, "Releasing EGL state on EGL render view");
                ((EglVideoRenderView)renderView).release();
            }
            this.renderViewToBoundVideoTileMap.remove(renderView);
        }
    }

    @Override
    public void unbindVideoView(int tileId) {
        this.logger.info(this.TAG, "Unbinding Tile with tileId = " + tileId);
        this.videoTileMap.remove(tileId);
        this.removeRenderViewFromBoundVideoTileMap(tileId);
    }

    private final void onRemoveVideoTile(int tileId) {
        block0: {
            VideoTile videoTile = this.videoTileMap.get(tileId);
            if (videoTile == null) break block0;
            VideoTile it = videoTile;
            boolean bl = false;
            this.forEachObserver((Function1<? super VideoTileObserver, Unit>)((Function1)new Function1<VideoTileObserver, Unit>(it){
                final /* synthetic */ VideoTile $it;
                {
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull VideoTileObserver observer) {
                    Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                    observer.onVideoTileRemoved(this.$it.getState());
                }
            }));
            this.videoTileMap.remove(tileId);
        }
    }

    private final void onAddVideoTile(int tileId, String attendeeId, VideoPauseState pauseState, int videoStreamContentWidth, int videoStreamContentHeight) {
        boolean isLocalTile = false;
        String thisAttendeeId = null;
        if (attendeeId != null) {
            thisAttendeeId = attendeeId;
            isLocalTile = false;
        } else {
            thisAttendeeId = this.videoClientController.getConfiguration().getCredentials().getAttendeeId();
            isLocalTile = true;
        }
        VideoTile tile = this.videoTileFactory.makeTile(tileId, thisAttendeeId, videoStreamContentWidth, videoStreamContentHeight, isLocalTile);
        Integer n = tileId;
        this.videoTileMap.put(n, tile);
        this.meetingStatsCollector.updateMaxVideoTile(this.videoTileMap.size());
        tile.setPauseState(pauseState);
        this.forEachObserver((Function1<? super VideoTileObserver, Unit>)((Function1)new Function1<VideoTileObserver, Unit>(tile){
            final /* synthetic */ VideoTile $tile;
            {
                this.$tile = $tile;
                super(1);
            }

            public final void invoke(@NotNull VideoTileObserver observer) {
                Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
                observer.onVideoTileAdded(this.$tile.getState());
            }
        }));
    }

    private final void forEachObserver(Function1<? super VideoTileObserver, Unit> observerFunction) {
        ObserverUtils.Companion.notifyObserverOnMainThread(this.videoTileObservers, observerFunction);
    }
}

