/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.contentshare;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.contentshare.ContentShareController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.contentshare.ContentShareObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.contentshare.ContentShareSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.LocalVideoConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.internal.contentshare.ContentShareVideoClientController;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/contentshare/DefaultContentShareController;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/contentshare/ContentShareController;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "contentShareVideoClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/contentshare/ContentShareVideoClientController;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/contentshare/ContentShareVideoClientController;)V", "TAG", "", "addContentShareObserver", "", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/contentshare/ContentShareObserver;", "removeContentShareObserver", "startContentShare", "source", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/contentshare/ContentShareSource;", "config", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/LocalVideoConfiguration;", "stopContentShare", "amazon-chime-sdk_release"})
public final class DefaultContentShareController
implements ContentShareController {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ContentShareVideoClientController contentShareVideoClientController;
    @NotNull
    private final String TAG;

    public DefaultContentShareController(@NotNull Logger logger, @NotNull ContentShareVideoClientController contentShareVideoClientController) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)contentShareVideoClientController, (String)"contentShareVideoClientController");
        this.logger = logger;
        this.contentShareVideoClientController = contentShareVideoClientController;
        this.TAG = "DefaultContentShareController";
    }

    @Override
    public void startContentShare(@NotNull ContentShareSource source) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            VideoSource videoSource = source.getVideoSource();
            if (videoSource == null) break block0;
            VideoSource it = videoSource;
            boolean bl = false;
            this.contentShareVideoClientController.startVideoShare(it);
        }
    }

    @Override
    public void startContentShare(@NotNull ContentShareSource source, @NotNull LocalVideoConfiguration config) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            VideoSource videoSource = source.getVideoSource();
            if (videoSource == null) break block0;
            VideoSource it = videoSource;
            boolean bl = false;
            this.contentShareVideoClientController.startVideoShare(it, config);
        }
    }

    @Override
    public void stopContentShare() {
        this.contentShareVideoClientController.stopVideoShare();
    }

    @Override
    public void addContentShareObserver(@NotNull ContentShareObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.contentShareVideoClientController.subscribeToVideoClientStateChange(observer);
    }

    @Override
    public void removeContentShareObserver(@NotNull ContentShareObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.contentShareVideoClientController.unsubscribeFromVideoClientStateChange(observer);
    }
}

