/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoControllerFacade;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.PrimaryMeetingPromotionObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.metric.MetricsObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.LocalVideoConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.RemoteVideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoResolution;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSubscriptionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.metric.ClientMetricsCollector;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionCredentials;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatus;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 92\u00020\u0001:\u00019B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\u0016\u0010&\u001a\u00020\u00182\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00180(H\u0002J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010-\u001a\u00020\u0018H\u0016J\b\u0010.\u001a\u00020\u0018H\u0016J\b\u0010/\u001a\u00020\u0018H\u0016J\b\u00100\u001a\u00020\u0018H\u0016J/\u00101\u001a\u00020\u00182\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205032\f\u00106\u001a\b\u0012\u0004\u0012\u00020407H\u0016\u00a2\u0006\u0002\u00108R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/DefaultAudioVideoController;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoControllerFacade;", "audioClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;", "audioClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "clientMetricsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;", "configuration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "videoClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;", "videoClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "TAG", "", "VideoHighResolutionBitrateKbps", "", "primaryMeetingPromotionObserver", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "addAudioVideoObserver", "", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoObserver;", "addMetricsObserver", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/metric/MetricsObserver;", "demoteFromPrimaryMeeting", "promoteToPrimaryMeeting", "credentials", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;", "removeAudioVideoObserver", "removeMetricsObserver", "start", "audioVideoConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoConfiguration;", "startLocalVideo", "action", "Lkotlin/Function0;", "config", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/LocalVideoConfiguration;", "source", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "startRemoteVideo", "stop", "stopLocalVideo", "stopRemoteVideo", "updateVideoSourceSubscriptions", "addedOrUpdated", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSubscriptionConfiguration;", "removed", "", "(Ljava/util/Map;[Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;)V", "Companion", "amazon-chime-sdk_release"})
public final class DefaultAudioVideoController
implements AudioVideoControllerFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AudioClientController audioClientController;
    @NotNull
    private final AudioClientObserver audioClientObserver;
    @NotNull
    private final ClientMetricsCollector clientMetricsCollector;
    @NotNull
    private final MeetingSessionConfiguration configuration;
    @NotNull
    private final VideoClientController videoClientController;
    @NotNull
    private final VideoClientObserver videoClientObserver;
    @Nullable
    private final Logger logger;
    @NotNull
    private final String TAG;
    private final int VideoHighResolutionBitrateKbps;
    @Nullable
    private PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver;
    private static final long PRIMARY_MEETING_PROMOTION_TIMEOUT = 5000L;

    public DefaultAudioVideoController(@NotNull AudioClientController audioClientController, @NotNull AudioClientObserver audioClientObserver, @NotNull ClientMetricsCollector clientMetricsCollector, @NotNull MeetingSessionConfiguration configuration, @NotNull VideoClientController videoClientController, @NotNull VideoClientObserver videoClientObserver, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)audioClientController, (String)"audioClientController");
        Intrinsics.checkNotNullParameter((Object)audioClientObserver, (String)"audioClientObserver");
        Intrinsics.checkNotNullParameter((Object)clientMetricsCollector, (String)"clientMetricsCollector");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)videoClientController, (String)"videoClientController");
        Intrinsics.checkNotNullParameter((Object)videoClientObserver, (String)"videoClientObserver");
        this.audioClientController = audioClientController;
        this.audioClientObserver = audioClientObserver;
        this.clientMetricsCollector = clientMetricsCollector;
        this.configuration = configuration;
        this.videoClientController = videoClientController;
        this.videoClientObserver = videoClientObserver;
        this.logger = logger;
        this.TAG = "DefaultAudioVideoController";
        this.VideoHighResolutionBitrateKbps = 2500;
    }

    @Override
    public void start() {
        this.start(new AudioVideoConfiguration(null, null, null, null, false, 0, 63, null));
    }

    @Override
    public void start(@NotNull AudioVideoConfiguration audioVideoConfiguration) {
        Intrinsics.checkNotNullParameter((Object)audioVideoConfiguration, (String)"audioVideoConfiguration");
        this.audioClientController.start(this.configuration.getUrls().getAudioFallbackURL(), this.configuration.getUrls().getAudioHostURL(), this.configuration.getMeetingId(), this.configuration.getCredentials().getAttendeeId(), this.configuration.getCredentials().getJoinToken(), audioVideoConfiguration.getAudioMode(), audioVideoConfiguration.getAudioDeviceCapabilities(), audioVideoConfiguration.getAudioStreamType(), audioVideoConfiguration.getAudioRecordingPresetOverride(), audioVideoConfiguration.getEnableAudioRedundancy(), audioVideoConfiguration.getReconnectTimeoutMs());
        this.videoClientController.start();
    }

    @Override
    public void stop() {
        this.audioClientController.stop();
        this.videoClientController.stopAndDestroy();
    }

    @Override
    public void startLocalVideo() {
        this.startLocalVideo((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultAudioVideoController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                DefaultAudioVideoController.access$getVideoClientController$p(this.this$0).startLocalVideo();
            }
        }));
    }

    @Override
    public void startLocalVideo(@NotNull LocalVideoConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.startLocalVideo((Function0<Unit>)((Function0)new Function0<Unit>(this, config){
            final /* synthetic */ DefaultAudioVideoController this$0;
            final /* synthetic */ LocalVideoConfiguration $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(0);
            }

            public final void invoke() {
                DefaultAudioVideoController.access$getVideoClientController$p(this.this$0).startLocalVideo(this.$config);
            }
        }));
    }

    @Override
    public void startLocalVideo(@NotNull VideoSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.startLocalVideo((Function0<Unit>)((Function0)new Function0<Unit>(this, source){
            final /* synthetic */ DefaultAudioVideoController this$0;
            final /* synthetic */ VideoSource $source;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                super(0);
            }

            public final void invoke() {
                DefaultAudioVideoController.access$getVideoClientController$p(this.this$0).startLocalVideo(this.$source);
            }
        }));
    }

    @Override
    public void startLocalVideo(@NotNull VideoSource source, @NotNull LocalVideoConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.startLocalVideo((Function0<Unit>)((Function0)new Function0<Unit>(this, source, config){
            final /* synthetic */ DefaultAudioVideoController this$0;
            final /* synthetic */ VideoSource $source;
            final /* synthetic */ LocalVideoConfiguration $config;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                this.$config = $config;
                super(0);
            }

            public final void invoke() {
                DefaultAudioVideoController.access$getVideoClientController$p(this.this$0).startLocalVideo(this.$source, this.$config);
            }
        }));
    }

    private final void startLocalVideo(Function0<Unit> action) {
        if (this.configuration.getFeatures().getVideoMaxResolution() == VideoResolution.Disabled) {
            Logger logger = this.logger;
            if (logger != null) {
                logger.info(this.TAG, "Could not start local video because video max resolution is set to disabled");
            }
            return;
        }
        action.invoke();
        if (this.configuration.getFeatures().getVideoMaxResolution() == VideoResolution.VideoResolutionFHD) {
            Logger logger = this.logger;
            if (logger != null) {
                logger.info(this.TAG, "Set max bitrate to " + this.VideoHighResolutionBitrateKbps + " for FHD");
            }
            this.videoClientController.setMaxBitRateKbps(this.VideoHighResolutionBitrateKbps);
        }
    }

    @Override
    public void stopLocalVideo() {
        this.videoClientController.stopLocalVideo();
    }

    @Override
    public void startRemoteVideo() {
        this.videoClientController.startRemoteVideo();
    }

    @Override
    public void stopRemoteVideo() {
        this.videoClientController.stopRemoteVideo();
    }

    @Override
    public void addAudioVideoObserver(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.audioClientObserver.subscribeToAudioClientStateChange(observer);
        this.videoClientObserver.subscribeToVideoClientStateChange(observer);
    }

    @Override
    public void removeAudioVideoObserver(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.audioClientObserver.unsubscribeFromAudioClientStateChange(observer);
        this.videoClientObserver.unsubscribeFromVideoClientStateChange(observer);
    }

    @Override
    public void addMetricsObserver(@NotNull MetricsObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.clientMetricsCollector.subscribeToMetrics(observer);
    }

    @Override
    public void removeMetricsObserver(@NotNull MetricsObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.clientMetricsCollector.unsubscribeFromMetrics(observer);
    }

    @Override
    public void updateVideoSourceSubscriptions(@NotNull Map<RemoteVideoSource, VideoSubscriptionConfiguration> addedOrUpdated, @NotNull RemoteVideoSource[] removed) {
        Intrinsics.checkNotNullParameter(addedOrUpdated, (String)"addedOrUpdated");
        Intrinsics.checkNotNullParameter((Object)removed, (String)"removed");
        this.videoClientController.updateVideoSourceSubscriptions(addedOrUpdated, removed);
    }

    @Override
    public void promoteToPrimaryMeeting(@NotNull MeetingSessionCredentials credentials, @NotNull PrimaryMeetingPromotionObserver observer) {
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        AtomicInteger audioVideoPromotionsToComplete = new AtomicInteger();
        audioVideoPromotionsToComplete.addAndGet(2);
        Ref.ObjectRef audioClientStatus = new Ref.ObjectRef();
        audioClientStatus.element = new MeetingSessionStatus(MeetingSessionStatusCode.OK);
        Ref.ObjectRef videoClientStatus = new Ref.ObjectRef();
        videoClientStatus.element = new MeetingSessionStatus(MeetingSessionStatusCode.OK);
        Function2 mergeAndReturnPromotionStatuses2 = (Function2)new Function2<MeetingSessionStatus, MeetingSessionStatus, Unit>(this){
            final /* synthetic */ DefaultAudioVideoController this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull MeetingSessionStatus firstStatus, @NotNull MeetingSessionStatus secondStatus) {
                Intrinsics.checkNotNullParameter((Object)firstStatus, (String)"firstStatus");
                Intrinsics.checkNotNullParameter((Object)secondStatus, (String)"secondStatus");
                MeetingSessionStatus mergedStatus = firstStatus.getStatusCode() != MeetingSessionStatusCode.OK ? firstStatus : (secondStatus.getStatusCode() != MeetingSessionStatusCode.OK ? secondStatus : firstStatus);
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, mergedStatus, null){
                    int label;
                    final /* synthetic */ DefaultAudioVideoController this$0;
                    final /* synthetic */ MeetingSessionStatus $mergedStatus;
                    {
                        this.this$0 = $receiver;
                        this.$mergedStatus = $mergedStatus;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = DefaultAudioVideoController.access$getPrimaryMeetingPromotionObserver$p(this.this$0);
                                if (primaryMeetingPromotionObserver != null) {
                                    primaryMeetingPromotionObserver.onPrimaryMeetingPromotion(this.$mergedStatus);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        };
        this.primaryMeetingPromotionObserver = observer;
        PrimaryMeetingPromotionObserver audioPrimaryMeetingPromotionObserverAdapter2 = new PrimaryMeetingPromotionObserver((Ref.ObjectRef<MeetingSessionStatus>)audioClientStatus, audioVideoPromotionsToComplete, (Function2<? super MeetingSessionStatus, ? super MeetingSessionStatus, Unit>)mergeAndReturnPromotionStatuses2, (Ref.ObjectRef<MeetingSessionStatus>)videoClientStatus, this){
            final /* synthetic */ Ref.ObjectRef<MeetingSessionStatus> $audioClientStatus;
            final /* synthetic */ AtomicInteger $audioVideoPromotionsToComplete;
            final /* synthetic */ Function2<MeetingSessionStatus, MeetingSessionStatus, Unit> $mergeAndReturnPromotionStatuses;
            final /* synthetic */ Ref.ObjectRef<MeetingSessionStatus> $videoClientStatus;
            final /* synthetic */ DefaultAudioVideoController this$0;
            {
                this.$audioClientStatus = $audioClientStatus;
                this.$audioVideoPromotionsToComplete = $audioVideoPromotionsToComplete;
                this.$mergeAndReturnPromotionStatuses = $mergeAndReturnPromotionStatuses;
                this.$videoClientStatus = $videoClientStatus;
                this.this$0 = $receiver;
            }

            public void onPrimaryMeetingPromotion(@NotNull MeetingSessionStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$audioClientStatus.element = status;
                if (this.$audioVideoPromotionsToComplete.decrementAndGet() == 0) {
                    this.$mergeAndReturnPromotionStatuses.invoke(this.$audioClientStatus.element, this.$videoClientStatus.element);
                }
            }

            public void onPrimaryMeetingDemotion(@NotNull MeetingSessionStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                DefaultAudioVideoController.access$getVideoClientController$p(this.this$0).demoteFromPrimaryMeeting();
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, status, null){
                    int label;
                    final /* synthetic */ DefaultAudioVideoController this$0;
                    final /* synthetic */ MeetingSessionStatus $status;
                    {
                        this.this$0 = $receiver;
                        this.$status = $status;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = DefaultAudioVideoController.access$getPrimaryMeetingPromotionObserver$p(this.this$0);
                                if (primaryMeetingPromotionObserver != null) {
                                    primaryMeetingPromotionObserver.onPrimaryMeetingDemotion(this.$status);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        };
        PrimaryMeetingPromotionObserver videoPrimaryMeetingPromotionObserverAdapter2 = new PrimaryMeetingPromotionObserver((Ref.ObjectRef<MeetingSessionStatus>)videoClientStatus, audioVideoPromotionsToComplete, (Function2<? super MeetingSessionStatus, ? super MeetingSessionStatus, Unit>)mergeAndReturnPromotionStatuses2, (Ref.ObjectRef<MeetingSessionStatus>)audioClientStatus, this){
            final /* synthetic */ Ref.ObjectRef<MeetingSessionStatus> $videoClientStatus;
            final /* synthetic */ AtomicInteger $audioVideoPromotionsToComplete;
            final /* synthetic */ Function2<MeetingSessionStatus, MeetingSessionStatus, Unit> $mergeAndReturnPromotionStatuses;
            final /* synthetic */ Ref.ObjectRef<MeetingSessionStatus> $audioClientStatus;
            final /* synthetic */ DefaultAudioVideoController this$0;
            {
                this.$videoClientStatus = $videoClientStatus;
                this.$audioVideoPromotionsToComplete = $audioVideoPromotionsToComplete;
                this.$mergeAndReturnPromotionStatuses = $mergeAndReturnPromotionStatuses;
                this.$audioClientStatus = $audioClientStatus;
                this.this$0 = $receiver;
            }

            public void onPrimaryMeetingPromotion(@NotNull MeetingSessionStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$videoClientStatus.element = status;
                if (this.$audioVideoPromotionsToComplete.decrementAndGet() == 0) {
                    this.$mergeAndReturnPromotionStatuses.invoke(this.$audioClientStatus.element, this.$videoClientStatus.element);
                }
            }

            public void onPrimaryMeetingDemotion(@NotNull MeetingSessionStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                DefaultAudioVideoController.access$getAudioClientController$p(this.this$0).demoteFromPrimaryMeeting();
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, status, null){
                    int label;
                    final /* synthetic */ DefaultAudioVideoController this$0;
                    final /* synthetic */ MeetingSessionStatus $status;
                    {
                        this.this$0 = $receiver;
                        this.$status = $status;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = DefaultAudioVideoController.access$getPrimaryMeetingPromotionObserver$p(this.this$0);
                                if (primaryMeetingPromotionObserver != null) {
                                    primaryMeetingPromotionObserver.onPrimaryMeetingDemotion(this.$status);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        };
        this.audioClientController.promoteToPrimaryMeeting(credentials, audioPrimaryMeetingPromotionObserverAdapter2);
        this.videoClientController.promoteToPrimaryMeeting(credentials, videoPrimaryMeetingPromotionObserverAdapter2);
        new Timer().schedule(new TimerTask(audioVideoPromotionsToComplete, this, observer){
            final /* synthetic */ AtomicInteger $audioVideoPromotionsToComplete$inlined;
            final /* synthetic */ DefaultAudioVideoController this$0;
            final /* synthetic */ PrimaryMeetingPromotionObserver $observer$inlined;
            {
                this.$audioVideoPromotionsToComplete$inlined = atomicInteger;
                this.this$0 = defaultAudioVideoController;
                this.$observer$inlined = primaryMeetingPromotionObserver;
            }

            public void run() {
                TimerTask $this$promoteToPrimaryMeeting_u24lambda_u240 = this;
                boolean bl = false;
                if (this.$audioVideoPromotionsToComplete$inlined.getAndSet(-1) != 0) {
                    DefaultAudioVideoController.access$setPrimaryMeetingPromotionObserver$p(this.this$0, null);
                    DefaultAudioVideoController.access$getVideoClientController$p(this.this$0).demoteFromPrimaryMeeting();
                    DefaultAudioVideoController.access$getAudioClientController$p(this.this$0).demoteFromPrimaryMeeting();
                    BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$observer$inlined, null){
                        int label;
                        final /* synthetic */ PrimaryMeetingPromotionObserver $observer;
                        {
                            this.$observer = $observer;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.$observer.onPrimaryMeetingPromotion(new MeetingSessionStatus(MeetingSessionStatusCode.AudioInternalServerError));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        }, 5000L);
    }

    @Override
    public void demoteFromPrimaryMeeting() {
        this.audioClientController.demoteFromPrimaryMeeting();
        this.videoClientController.demoteFromPrimaryMeeting();
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultAudioVideoController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver = DefaultAudioVideoController.access$getPrimaryMeetingPromotionObserver$p(this.this$0);
                        if (primaryMeetingPromotionObserver != null) {
                            primaryMeetingPromotionObserver.onPrimaryMeetingDemotion(new MeetingSessionStatus(MeetingSessionStatusCode.OK));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ VideoClientController access$getVideoClientController$p(DefaultAudioVideoController $this) {
        return $this.videoClientController;
    }

    public static final /* synthetic */ PrimaryMeetingPromotionObserver access$getPrimaryMeetingPromotionObserver$p(DefaultAudioVideoController $this) {
        return $this.primaryMeetingPromotionObserver;
    }

    public static final /* synthetic */ AudioClientController access$getAudioClientController$p(DefaultAudioVideoController $this) {
        return $this.audioClientController;
    }

    public static final /* synthetic */ void access$setPrimaryMeetingPromotionObserver$p(DefaultAudioVideoController $this, PrimaryMeetingPromotionObserver primaryMeetingPromotionObserver) {
        $this.primaryMeetingPromotionObserver = primaryMeetingPromotionObserver;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/DefaultAudioVideoController$Companion;", "", "()V", "PRIMARY_MEETING_PROMOTION_TIMEOUT", "", "amazon-chime-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

