/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video.gl;

import android.graphics.Matrix;
import android.opengl.GLES20;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameI420Buffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlVideoFrameDrawer;
import com.xodee.client.video.YuvUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J:\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\rH\u0016J:\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J:\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J<\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u001a\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010*\u001a\u00020\u0015H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/GlVideoFrameDrawer;", "()V", "currentShaderType", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$Companion$ShaderType;", "i420Uploader", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$I420BufferTextureUploader;", "program", "", "renderDestinationPoints", "", "renderHeight", "renderMatrix", "Landroid/graphics/Matrix;", "renderWidth", "rgbaUploader", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$RGBABufferTextureUploader;", "textureCoordinateLocation", "textureMatrixLocation", "vertexPositionLocation", "calculateTransformedRenderSize", "", "frameWidth", "frameHeight", "drawFrame", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "viewportX", "viewportY", "viewportWidth", "viewportHeight", "additionalRenderMatrix", "drawTexture2d", "textureId", "texMatrix", "drawTextureOes", "oesTextureId", "drawYuv", "yuvTextures", "", "prepareShader", "shaderType", "release", "Companion", "I420BufferTextureUploader", "RGBABufferTextureUploader", "amazon-chime-sdk_release"})
public final class DefaultGlVideoFrameDrawer
implements GlVideoFrameDrawer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Companion.ShaderType currentShaderType;
    private int program = -1;
    private int vertexPositionLocation;
    private int textureCoordinateLocation;
    private int textureMatrixLocation;
    @NotNull
    private final Matrix renderMatrix = new Matrix();
    @NotNull
    private final float[] renderDestinationPoints = new float[6];
    private int renderWidth;
    private int renderHeight;
    @Nullable
    private I420BufferTextureUploader i420Uploader = new I420BufferTextureUploader();
    @Nullable
    private RGBABufferTextureUploader rgbaUploader = new RGBABufferTextureUploader();
    @NotNull
    private static final float[] srcPoints;
    @NotNull
    private static final String INPUT_VERTEX_COORDINATE_NAME;
    @NotNull
    private static final String INPUT_TEXTURE_COORDINATE_NAME;
    @NotNull
    private static final String TEXTURE_MATRIX_NAME;
    @NotNull
    private static final String VERTEX_SHADER;
    @NotNull
    private static final String INPUT_TEXTURE_NAME;
    @NotNull
    private static final String FRAGMENT_SHADER_OES;
    @NotNull
    private static final String FRAGMENT_SHADER_RGB;
    @NotNull
    private static final String INPUT_TEXTURE_Y_NAME;
    @NotNull
    private static final String INPUT_TEXTURE_U_NAME;
    @NotNull
    private static final String INPUT_TEXTURE_V_NAME;
    @NotNull
    private static final String FRAGMENT_SHADER_YUV;

    @Override
    public void drawFrame(@NotNull VideoFrame frame, int viewportX, int viewportY, int viewportWidth, int viewportHeight, @Nullable Matrix additionalRenderMatrix) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        boolean isTextureFrame = frame.getBuffer() instanceof VideoFrameTextureBuffer;
        int width = frame.getRotatedWidth();
        int height = frame.getRotatedHeight();
        this.calculateTransformedRenderSize(width, height, additionalRenderMatrix);
        if (this.renderWidth <= 0 || this.renderHeight <= 0) {
            return;
        }
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (frame.getBuffer() instanceof VideoFrameI420Buffer) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)frame.getRotation().getDegrees());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (additionalRenderMatrix != null) {
            this.renderMatrix.preConcat(additionalRenderMatrix);
        }
        if (isTextureFrame) {
            VideoFrameBuffer videoFrameBuffer = frame.getBuffer();
            Intrinsics.checkNotNull((Object)videoFrameBuffer, (String)"null cannot be cast to non-null type com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer");
            VideoFrameTextureBuffer textureBuffer = (VideoFrameTextureBuffer)videoFrameBuffer;
            Matrix finalMatrix = new Matrix(textureBuffer.getTransformMatrix());
            finalMatrix.preConcat(this.renderMatrix);
            float[] finalGlMatrix = GlUtil.INSTANCE.convertToGlTransformMatrix(finalMatrix);
            switch (WhenMappings.$EnumSwitchMapping$0[textureBuffer.getType().ordinal()]) {
                case 1: {
                    this.drawTextureOes(textureBuffer.getTextureId(), finalGlMatrix, viewportX, viewportY, viewportWidth, viewportHeight);
                    break;
                }
                case 2: {
                    this.drawTexture2d(textureBuffer.getTextureId(), finalGlMatrix, viewportX, viewportY, viewportWidth, viewportHeight);
                }
            }
        } else if (frame.getBuffer() instanceof VideoFrameI420Buffer) {
            if (this.i420Uploader == null) {
                this.i420Uploader = new I420BufferTextureUploader();
            }
            I420BufferTextureUploader i420BufferTextureUploader = this.i420Uploader;
            if (i420BufferTextureUploader != null) {
                I420BufferTextureUploader it = i420BufferTextureUploader;
                boolean bl = false;
                it.uploadFromBuffer((VideoFrameI420Buffer)frame.getBuffer());
                this.drawYuv(it.getYuvTextures(), GlUtil.INSTANCE.convertToGlTransformMatrix(this.renderMatrix), viewportX, viewportY, viewportWidth, viewportHeight);
            }
        } else if (frame.getBuffer() instanceof VideoFrameRGBABuffer) {
            Integer textureId;
            RGBABufferTextureUploader rGBABufferTextureUploader = this.rgbaUploader;
            Integer n = textureId = rGBABufferTextureUploader != null ? Integer.valueOf(rGBABufferTextureUploader.uploadFromBuffer((VideoFrameRGBABuffer)frame.getBuffer())) : null;
            if (textureId != null) {
                this.drawTexture2d(textureId, GlUtil.INSTANCE.convertToGlTransformMatrix(this.renderMatrix), viewportX, viewportY, viewportWidth, viewportHeight);
            }
        }
    }

    private final void calculateTransformedRenderSize(int frameWidth, int frameHeight, Matrix renderMatrix) {
        if (renderMatrix == null) {
            this.renderWidth = frameWidth;
            this.renderHeight = frameHeight;
            return;
        }
        renderMatrix.mapPoints(this.renderDestinationPoints, srcPoints);
        for (int i = 0; i < 3; ++i) {
            this.renderDestinationPoints[i * 2 + 0] = this.renderDestinationPoints[i * 2 + 0] * (float)frameWidth;
            this.renderDestinationPoints[i * 2 + 1] = this.renderDestinationPoints[i * 2 + 1] * (float)frameHeight;
        }
        this.renderWidth = DefaultGlVideoFrameDrawer.calculateTransformedRenderSize$distance(this.renderDestinationPoints[0], this.renderDestinationPoints[1], this.renderDestinationPoints[2], this.renderDestinationPoints[3]);
        this.renderHeight = DefaultGlVideoFrameDrawer.calculateTransformedRenderSize$distance(this.renderDestinationPoints[0], this.renderDestinationPoints[1], this.renderDestinationPoints[4], this.renderDestinationPoints[5]);
    }

    private final void drawTextureOes(int oesTextureId, float[] texMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(Companion.ShaderType.TEXTURE_OES, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)oesTextureId);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.INSTANCE.checkGlError("Failed to draw GL_TEXTURE_EXTERNAL_OES texture");
        GLES20.glBindTexture((int)36197, (int)0);
    }

    private final void drawTexture2d(int textureId, float[] texMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(Companion.ShaderType.TEXTURE_2D, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.INSTANCE.checkGlError("Failed to draw GL_TEXTURE_2D texture");
        GLES20.glBindTexture((int)3553, (int)0);
    }

    private final void drawYuv(int[] yuvTextures, float[] texMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        int i;
        this.prepareShader(Companion.ShaderType.YUV, texMatrix);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            Intrinsics.checkNotNull((Object)yuvTextures);
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i]);
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.INSTANCE.checkGlError("Failed to draw YUV textures");
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    private final void prepareShader(Companion.ShaderType shaderType, float[] texMatrix) {
        if (this.currentShaderType != shaderType) {
            String string;
            Companion.ShaderType shaderType2;
            String fragmentShader = null;
            Companion.ShaderType shaderType3 = shaderType2 = shaderType;
            DefaultGlVideoFrameDrawer defaultGlVideoFrameDrawer = this;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$1[shaderType.ordinal()]) {
                case 1: {
                    string = FRAGMENT_SHADER_OES;
                    break;
                }
                case 2: {
                    string = FRAGMENT_SHADER_RGB;
                    break;
                }
                case 3: {
                    string = FRAGMENT_SHADER_YUV;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            fragmentShader = string;
            defaultGlVideoFrameDrawer.currentShaderType = shaderType2;
            if (this.program != -1) {
                GLES20.glDeleteProgram((int)this.program);
            }
            this.program = GlUtil.INSTANCE.createProgram(VERTEX_SHADER, fragmentShader);
            GLES20.glUseProgram((int)this.program);
            GlUtil.INSTANCE.checkGlError("Failed to create program");
            if (shaderType == Companion.ShaderType.YUV) {
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_Y_NAME), (int)0);
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_U_NAME), (int)1);
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_V_NAME), (int)2);
            } else {
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_NAME), (int)0);
            }
            GlUtil.INSTANCE.checkGlError("Failed to setup program texture inputs");
            this.textureMatrixLocation = GLES20.glGetUniformLocation((int)this.program, (String)TEXTURE_MATRIX_NAME);
            this.vertexPositionLocation = GLES20.glGetAttribLocation((int)this.program, (String)INPUT_VERTEX_COORDINATE_NAME);
            this.textureCoordinateLocation = GLES20.glGetAttribLocation((int)this.program, (String)INPUT_TEXTURE_COORDINATE_NAME);
            if (this.textureMatrixLocation == -1 || this.vertexPositionLocation == -1 || this.textureCoordinateLocation == -1) {
                throw new InvalidParameterException("Failed to get shader locations");
            }
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.INSTANCE.checkGlError("Failed to use program");
        GLES20.glEnableVertexAttribArray((int)this.vertexPositionLocation);
        GLES20.glVertexAttribPointer((int)this.vertexPositionLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)GlUtil.INSTANCE.getFULL_RECTANGLE_VERTEX_COORDINATES());
        GLES20.glEnableVertexAttribArray((int)this.textureCoordinateLocation);
        GLES20.glVertexAttribPointer((int)this.textureCoordinateLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)GlUtil.INSTANCE.getFULL_RECTANGLE_TEXTURE_COORDINATES());
        GLES20.glUniformMatrix4fv((int)this.textureMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GlUtil.INSTANCE.checkGlError("Failed to upload shader inputs");
    }

    @Override
    public void release() {
        I420BufferTextureUploader i420BufferTextureUploader = this.i420Uploader;
        if (i420BufferTextureUploader != null) {
            i420BufferTextureUploader.release();
        }
        this.i420Uploader = null;
        RGBABufferTextureUploader rGBABufferTextureUploader = this.rgbaUploader;
        if (rGBABufferTextureUploader != null) {
            rGBABufferTextureUploader.release();
        }
        this.rgbaUploader = null;
        this.currentShaderType = null;
        if (this.program != -1) {
            GLES20.glUseProgram((int)0);
            GLES20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
    }

    private static final int calculateTransformedRenderSize$distance(float x0, float y0, float x1, float y1) {
        return MathKt.roundToInt((double)Math.hypot((double)x1 - (double)x0, (double)y1 - (double)y0));
    }

    static {
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        srcPoints = fArray;
        INPUT_VERTEX_COORDINATE_NAME = "aPosition";
        INPUT_TEXTURE_COORDINATE_NAME = "aTextureCoordinate";
        TEXTURE_MATRIX_NAME = "uTextureMatrix";
        VERTEX_SHADER = "\n        varying vec2 vTextureCoordinate;\n        attribute vec4 aPosition;\n        attribute vec4 aTextureCoordinate;\n        uniform mat4 uTextureMatrix;\n        void main() {\n            gl_Position = aPosition;\n            vTextureCoordinate = (uTextureMatrix * aTextureCoordinate).xy;\n        }\n        ";
        INPUT_TEXTURE_NAME = "sTexture";
        FRAGMENT_SHADER_OES = "\n        #extension GL_OES_EGL_image_external : require\n        precision mediump float;\n        varying vec2 vTextureCoordinate;\n        uniform samplerExternalOES sTexture;\n        void main() {\n            gl_FragColor = texture2D(sTexture, vTextureCoordinate);\n        }\n        ";
        FRAGMENT_SHADER_RGB = "\n        precision mediump float;\n        varying vec2 vTextureCoordinate;\n        uniform sampler2D sTexture;\n        void main() {\n            gl_FragColor = texture2D(sTexture, vTextureCoordinate);\n        }\n        ";
        INPUT_TEXTURE_Y_NAME = "sTextureY";
        INPUT_TEXTURE_U_NAME = "sTextureU";
        INPUT_TEXTURE_V_NAME = "sTextureV";
        FRAGMENT_SHADER_YUV = "\n        precision mediump float;\n        varying vec2 vTextureCoordinate;\n        uniform sampler2D sTextureY;\n        uniform sampler2D sTextureU;\n        uniform sampler2D sTextureV;\n        vec4 sample(vec2 p) {\n            float y = texture2D(sTextureY, p).r * 1.16438;\n            float u = texture2D(sTextureU, p).r;\n            float v = texture2D(sTextureV, p).r;\n            return vec4(y + 1.59603 * v - 0.874202,\n                        y - 0.391762 * u - 0.812968 * v + 0.531668,\n                        y + 2.01723 * u - 1.08563, 1);\n        }\n        void main() {\n            gl_FragColor = sample(vTextureCoordinate);\n        }\n        ";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$Companion;", "", "()V", "FRAGMENT_SHADER_OES", "", "FRAGMENT_SHADER_RGB", "FRAGMENT_SHADER_YUV", "INPUT_TEXTURE_COORDINATE_NAME", "INPUT_TEXTURE_NAME", "INPUT_TEXTURE_U_NAME", "INPUT_TEXTURE_V_NAME", "INPUT_TEXTURE_Y_NAME", "INPUT_VERTEX_COORDINATE_NAME", "TEXTURE_MATRIX_NAME", "VERTEX_SHADER", "srcPoints", "", "ShaderType", "amazon-chime-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$Companion$ShaderType;", "", "(Ljava/lang/String;I)V", "TEXTURE_OES", "TEXTURE_2D", "YUV", "amazon-chime-sdk_release"})
        private static final class ShaderType
        extends Enum<ShaderType> {
            public static final /* enum */ ShaderType TEXTURE_OES = new ShaderType();
            public static final /* enum */ ShaderType TEXTURE_2D = new ShaderType();
            public static final /* enum */ ShaderType YUV = new ShaderType();
            private static final /* synthetic */ ShaderType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ShaderType[] values() {
                return (ShaderType[])$VALUES.clone();
            }

            public static ShaderType valueOf(String value) {
                return Enum.valueOf(ShaderType.class, value);
            }

            @NotNull
            public static EnumEntries<ShaderType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = shaderTypeArray = new ShaderType[]{ShaderType.TEXTURE_OES, ShaderType.TEXTURE_2D, ShaderType.YUV};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ3\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$I420BufferTextureUploader;", "", "()V", "copyBuffer", "Ljava/nio/ByteBuffer;", "yuvTextures", "", "getYuvTextures", "()[I", "setYuvTextures", "([I)V", "release", "", "uploadFromBuffer", "buffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameI420Buffer;", "uploadYuvData", "width", "", "height", "strides", "planes", "", "(II[I[Ljava/nio/ByteBuffer;)[I", "amazon-chime-sdk_release"})
    @SourceDebugExtension(value={"SMAP\nDefaultGlVideoFrameDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultGlVideoFrameDrawer.kt\ncom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$I420BufferTextureUploader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,524:1\n1#2:525\n*E\n"})
    private static final class I420BufferTextureUploader {
        @Nullable
        private ByteBuffer copyBuffer;
        @Nullable
        private int[] yuvTextures;

        @Nullable
        public final int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public final void setYuvTextures(@Nullable int[] nArray) {
            this.yuvTextures = nArray;
        }

        @NotNull
        public final int[] uploadFromBuffer(@NotNull VideoFrameI420Buffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int[] nArray = new int[]{buffer.getStrideY(), buffer.getStrideU(), buffer.getStrideV()};
            int[] strides = nArray;
            ByteBuffer[] byteBufferArray = new ByteBuffer[]{buffer.getDataY(), buffer.getDataU(), buffer.getDataV()};
            ByteBuffer[] planes = byteBufferArray;
            return this.uploadYuvData(buffer.getWidth(), buffer.getHeight(), strides, planes);
        }

        public final void release() {
            block0: {
                this.copyBuffer = null;
                if (this.yuvTextures == null) break block0;
                int[] it = this.yuvTextures;
                boolean bl = false;
                GLES20.glDeleteTextures((int)3, (int[])it, (int)0);
            }
        }

        private final int[] uploadYuvData(int width, int height, int[] strides, ByteBuffer[] planes) {
            int[] nArray = new int[]{width, width / 2, width / 2};
            int[] planeWidths = nArray;
            int[] nArray2 = new int[]{height, height / 2, height / 2};
            int[] planeHeights = nArray2;
            int copyCapacityNeeded = 0;
            for (int i = 0; i < 3; ++i) {
                if (strides[i] <= planeWidths[i]) continue;
                copyCapacityNeeded = Math.max(copyCapacityNeeded, planeWidths[i] * planeHeights[i]);
            }
            ByteBuffer byteBuffer = this.copyBuffer;
            if ((byteBuffer != null ? byteBuffer.capacity() : 0) < copyCapacityNeeded) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            int[] nArray3 = this.yuvTextures;
            if (this.yuvTextures == null) {
                int[] nArray4;
                I420BufferTextureUploader $this$uploadYuvData_u24lambda_u242 = this;
                boolean bl = false;
                int[] nArray5 = nArray4 = new int[3];
                I420BufferTextureUploader i420BufferTextureUploader = $this$uploadYuvData_u24lambda_u242;
                boolean bl2 = false;
                for (int i = 0; i < 3; ++i) {
                    it[i] = GlUtil.INSTANCE.generateTexture(3553);
                }
                i420BufferTextureUploader.yuvTextures = nArray4;
                nArray3 = $this$uploadYuvData_u24lambda_u242.yuvTextures;
                Intrinsics.checkNotNull((Object)$this$uploadYuvData_u24lambda_u242.yuvTextures, (String)"null cannot be cast to non-null type kotlin.IntArray");
            }
            int[] validYuvTextures = nArray3;
            for (int i = 0; i < 3; ++i) {
                ByteBuffer byteBuffer2;
                GLES20.glActiveTexture((int)(33984 + i));
                GLES20.glBindTexture((int)3553, (int)validYuvTextures[i]);
                if (strides[i] == planeWidths[i]) {
                    byteBuffer2 = planes[i];
                } else {
                    YuvUtil.copyPlane((ByteBuffer)planes[i], (int)strides[i], (ByteBuffer)this.copyBuffer, (int)planeWidths[i], (int)planeWidths[i], (int)planeHeights[i]);
                    byteBuffer2 = this.copyBuffer;
                    if (byteBuffer2 == null) {
                        return new int[0];
                    }
                }
                ByteBuffer packedByteBuffer = byteBuffer2;
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)planeWidths[i], (int)planeHeights[i], (int)0, (int)6409, (int)5121, (Buffer)packedByteBuffer);
            }
            return validYuvTextures;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$RGBABufferTextureUploader;", "", "()V", "copyBuffer", "Ljava/nio/ByteBuffer;", "textureId", "", "getTextureId", "()I", "setTextureId", "(I)V", "release", "", "uploadFromBuffer", "buffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameRGBABuffer;", "uploadRgbaData", "width", "height", "data", "stride", "amazon-chime-sdk_release"})
    private static final class RGBABufferTextureUploader {
        @Nullable
        private ByteBuffer copyBuffer;
        private int textureId;

        public final int getTextureId() {
            return this.textureId;
        }

        public final void setTextureId(int n) {
            this.textureId = n;
        }

        public final int uploadFromBuffer(@NotNull VideoFrameRGBABuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return this.uploadRgbaData(buffer.getWidth(), buffer.getHeight(), buffer.getData(), buffer.getStride());
        }

        public final void release() {
            this.copyBuffer = null;
            int[] nArray = new int[]{this.textureId};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.textureId = 0;
        }

        private final int uploadRgbaData(int width, int height, ByteBuffer data, int stride) {
            ByteBuffer byteBuffer;
            int copyCapacityNeeded = 0;
            if (stride > width * 4) {
                copyCapacityNeeded = Math.max(copyCapacityNeeded, width * 4 * height);
            }
            ByteBuffer byteBuffer2 = this.copyBuffer;
            if ((byteBuffer2 != null ? byteBuffer2.capacity() : 0) < copyCapacityNeeded) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            if (this.textureId == 0) {
                this.textureId = GlUtil.INSTANCE.generateTexture(3553);
            }
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.textureId);
            if (stride == width * 4) {
                byteBuffer = data;
            } else {
                YuvUtil.copyPlane((ByteBuffer)data, (int)stride, (ByteBuffer)this.copyBuffer, (int)(width * 4), (int)width, (int)height);
                byteBuffer = this.copyBuffer;
                if (byteBuffer == null) {
                    return 0;
                }
            }
            ByteBuffer packedByteBuffer = byteBuffer;
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)packedByteBuffer);
            return this.textureId;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VideoFrameTextureBuffer.Type.values().length];
            try {
                nArray[VideoFrameTextureBuffer.Type.TEXTURE_OES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoFrameTextureBuffer.Type.TEXTURE_2D.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Companion.ShaderType.values().length];
            try {
                nArray[Companion.ShaderType.TEXTURE_OES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.ShaderType.TEXTURE_2D.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.ShaderType.YUV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

