/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.utils;

import android.opengl.GLES20;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\u0004R\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/utils/GlTextureFrameBufferHelper;", "", "pixelFormat", "", "(I)V", "frameBufferId", "getFrameBufferId", "()I", "setFrameBufferId", "height", "getHeight", "setHeight", "textureId", "getTextureId", "setTextureId", "width", "getWidth", "setWidth", "release", "", "setSize", "amazon-chime-sdk_release"})
public final class GlTextureFrameBufferHelper {
    private int frameBufferId;
    private int textureId;
    private int width;
    private int height;
    private final int pixelFormat;

    public final int getFrameBufferId() {
        return this.frameBufferId;
    }

    public final void setFrameBufferId(int n) {
        this.frameBufferId = n;
    }

    public final int getTextureId() {
        return this.textureId;
    }

    public final void setTextureId(int n) {
        this.textureId = n;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final void setSize(int width, int height) {
        boolean bl = width > 0 && height > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid size: " + width + "x" + height;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (width == this.width && height == this.height) {
            return;
        }
        this.width = width;
        this.height = height;
        if (this.textureId == 0) {
            this.textureId = GlUtil.INSTANCE.generateTexture(3553);
        }
        if (this.frameBufferId == 0) {
            int[] frameBuffers = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
            this.frameBufferId = frameBuffers[0];
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.textureId);
        GLES20.glTexImage2D((int)3553, (int)0, (int)this.pixelFormat, (int)width, (int)height, (int)0, (int)this.pixelFormat, (int)5121, null);
        GLES20.glBindTexture((int)3553, (int)0);
        GlUtil.INSTANCE.checkGlError("Failed to bind texture");
        GLES20.glBindFramebuffer((int)36160, (int)this.frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.textureId, (int)0);
        GlUtil.INSTANCE.checkGlError("Failed to bind and create framebuffer");
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        bl2 = status == 36053;
        bl3 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Framebuffer not complete, status: " + status;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public final void release() {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        this.textureId = 0;
        GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.frameBufferId}, (int)0);
        this.frameBufferId = 0;
        this.width = 0;
        this.height = 0;
    }

    public GlTextureFrameBufferHelper(int pixelFormat) {
        this.pixelFormat = pixelFormat;
        switch (this.pixelFormat) {
            case 6407: 
            case 6408: 
            case 6409: {
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Invalid pixel format: " + this.pixelFormat);
            }
        }
    }

    public /* synthetic */ GlTextureFrameBufferHelper(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n);
    }

    public GlTextureFrameBufferHelper() {
        this(0, 1, null);
    }
}

