/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.DeviceUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.TimezoneUtils;
import com.xodee.client.audio.audioclient.AppInfo;
import com.xodee.client.video.VideoClient;
import java.util.Arrays;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/AppInfoUtil;", "", "()V", "appCode", "", "appName", "clientSource", "clientUtcOffset", "manufacturer", "model", "osVersion", "sdkVersion", "initializeAppInfo", "", "context", "Landroid/content/Context;", "initializeAudioClientAppInfo", "Lcom/xodee/client/audio/audioclient/AppInfo;", "initializeVideoClientAppDetailedInfo", "amazon-chime-sdk_release"})
public final class AppInfoUtil {
    private static String manufacturer;
    private static String model;
    private static String osVersion;
    private static String appName;
    private static String appCode;
    private static final String clientSource = "amazon-chime-sdk";
    private static String sdkVersion;
    private static String clientUtcOffset;
    public static final AppInfoUtil INSTANCE;

    private final void initializeAppInfo(Context context) {
        TimeZone deviceTimezone;
        manufacturer = DeviceUtils.Companion.getDeviceManufacturer();
        model = DeviceUtils.Companion.getDeviceModel();
        osVersion = DeviceUtils.Companion.getOsVersion();
        String packageName = context.getPackageName();
        PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Android %s";
        Object[] objectArray = new Object[]{packageInfo.versionName};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        appName = string2;
        appCode = String.valueOf(packageInfo.versionCode);
        sdkVersion = DeviceUtils.Companion.getSdkVersion();
        TimeZone timeZone = deviceTimezone = TimeZone.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)timeZone, (String)"deviceTimezone");
        clientUtcOffset = TimezoneUtils.Companion.getUtcOffset(timeZone);
    }

    public final void initializeVideoClientAppDetailedInfo(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.initializeAppInfo(context);
        String string = appName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appName");
        }
        String string2 = appCode;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appCode");
        }
        String string3 = model;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        }
        String string4 = manufacturer;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manufacturer");
        }
        String string5 = osVersion;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osVersion");
        }
        String string6 = sdkVersion;
        if (string6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sdkVersion");
        }
        String string7 = clientUtcOffset;
        if (string7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientUtcOffset");
        }
        VideoClient.AppDetailedInfo.initialize((String)string, (String)string2, (String)string3, (String)string4, (String)string5, (String)clientSource, (String)string6, (String)string7);
    }

    @NotNull
    public final AppInfo initializeAudioClientAppInfo(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.initializeAppInfo(context);
        String string = appName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appName");
        }
        String string2 = appCode;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appCode");
        }
        String string3 = manufacturer;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"manufacturer");
        }
        String string4 = model;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
        }
        String string5 = osVersion;
        if (string5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"osVersion");
        }
        String string6 = sdkVersion;
        if (string6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sdkVersion");
        }
        String string7 = clientUtcOffset;
        if (string7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientUtcOffset");
        }
        return new AppInfo(string, string2, string3, string4, string5, clientSource, string6, string7);
    }

    private AppInfoUtil() {
    }

    static {
        AppInfoUtil appInfoUtil;
        INSTANCE = appInfoUtil = new AppInfoUtil();
    }
}

