/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion;

import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributesKt;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEventName;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\b\b\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\nB!\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u0013\u001a\u00020\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/SDKEvent;", "", "eventName", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventName;", "eventAttributes", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributeName;", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributes;", "(Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventName;Ljava/util/Map;)V", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEventName;", "(Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEventName;Ljava/util/Map;)V", "name", "", "", "(Ljava/lang/String;Ljava/util/Map;)V", "getEventAttributes", "()Ljava/util/Map;", "getName", "()Ljava/lang/String;", "putAttributes", "attributes", "amazon-chime-sdk_release"})
public final class SDKEvent {
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, Object> eventAttributes;

    @NotNull
    public final SDKEvent putAttributes(@NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkParameterIsNotNull(attributes, (String)"attributes");
        Map updatedEventAttributes = MapsKt.toMutableMap(this.eventAttributes);
        updatedEventAttributes.putAll(attributes);
        return new SDKEvent(this.name, updatedEventAttributes);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Map<String, Object> getEventAttributes() {
        return this.eventAttributes;
    }

    public SDKEvent(@NotNull String name, @NotNull Map<String, ? extends Object> eventAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(eventAttributes, (String)"eventAttributes");
        this.name = name;
        this.eventAttributes = eventAttributes;
    }

    public SDKEvent(@NotNull EventName eventName, @NotNull Map<EventAttributeName, Object> eventAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)eventName), (String)"eventName");
        Intrinsics.checkParameterIsNotNull(eventAttributes, (String)"eventAttributes");
        this(eventName.name(), EventAttributesKt.toStringKeyMap(eventAttributes));
    }

    public SDKEvent(@NotNull MeetingHistoryEventName eventName, @NotNull Map<EventAttributeName, Object> eventAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)eventName), (String)"eventName");
        Intrinsics.checkParameterIsNotNull(eventAttributes, (String)"eventAttributes");
        this(eventName.name(), EventAttributesKt.toStringKeyMap(eventAttributes));
    }
}

