/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoResolution;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultSurfaceTextureCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.TimestampAligner;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.android.HandlerDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u00020#H\u0016J\b\u00108\u001a\u000203H\u0002J\b\u00109\u001a\u000203H\u0002J\b\u0010:\u001a\u000203H\u0016J\u0010\u0010;\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u0010<\u001a\u0002032\u0006\u00107\u001a\u00020#H\u0016J\u0010\u0010=\u001a\u0002032\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u000203H\u0016J\b\u0010A\u001a\u000203H\u0016J\b\u0010B\u001a\u000203H\u0002R\u000e\u0010\f\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultSurfaceTextureCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSource;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "width", "", "height", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;IILcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;)V", "DUMMY_PBUFFER_OFFSET", "RESEND_DELAY_BUFFER_MS", "TAG", "", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "handler", "Landroid/os/Handler;", "lastAlignedTimestamp", "", "Ljava/lang/Long;", "minFps", "getMinFps", "()I", "setMinFps", "(I)V", "pendingAvailableFrame", "", "releasePending", "sinks", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "surface", "Landroid/view/Surface;", "getSurface", "()Landroid/view/Surface;", "setSurface", "(Landroid/view/Surface;)V", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "textureBufferInFlight", "textureId", "thread", "Landroid/os/HandlerThread;", "timestampAligner", "Lcom/xodee/client/video/TimestampAligner;", "addCaptureSourceObserver", "", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceObserver;", "addVideoSink", "sink", "completeRelease", "onFrameReleased", "release", "removeCaptureSourceObserver", "removeVideoSink", "setMaxResolution", "maxResolution", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "start", "stop", "tryCapturingFrame", "amazon-chime-sdk_release"})
public final class DefaultSurfaceTextureCaptureSource
implements SurfaceTextureCaptureSource {
    @NotNull
    public Surface surface;
    private int textureId;
    private SurfaceTexture surfaceTexture;
    private EglCore eglCore;
    private final HandlerThread thread;
    private final Handler handler;
    private final TimestampAligner timestampAligner;
    private boolean pendingAvailableFrame;
    private boolean textureBufferInFlight;
    private boolean releasePending;
    private int minFps;
    private final int RESEND_DELAY_BUFFER_MS = 10;
    private Long lastAlignedTimestamp;
    private Set<VideoSink> sinks;
    private final String TAG = "SurfaceTextureCaptureSource";
    private final int DUMMY_PBUFFER_OFFSET = 0;
    private final Logger logger;
    private final int width;
    private final int height;
    @NotNull
    private final VideoContentHint contentHint;
    private final EglCoreFactory eglCoreFactory;

    @Override
    @NotNull
    public Surface getSurface() {
        Surface surface = this.surface;
        if (surface == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surface");
        }
        return surface;
    }

    public void setSurface(@NotNull Surface surface) {
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"<set-?>");
        this.surface = surface;
    }

    @Override
    public int getMinFps() {
        return this.minFps;
    }

    @Override
    public void setMinFps(int n) {
        this.minFps = n;
    }

    @Override
    public void start() {
        this.handler.post(new Runnable(this){
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;

            public final void run() {
                DefaultSurfaceTextureCaptureSource.access$getSurfaceTexture$p(this.this$0).setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(this){
                    final /* synthetic */ start.1 this$0;

                    public final void onFrameAvailable(SurfaceTexture it) {
                        DefaultSurfaceTextureCaptureSource.access$setPendingAvailableFrame$p(this.this$0.this$0, true);
                        DefaultSurfaceTextureCaptureSource.access$tryCapturingFrame(this.this$0.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, DefaultSurfaceTextureCaptureSource.access$getHandler$p(this.this$0));
            }
            {
                this.this$0 = defaultSurfaceTextureCaptureSource;
            }
        });
    }

    @Override
    public void setMaxResolution(@NotNull VideoResolution maxResolution) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)maxResolution), (String)"maxResolution");
    }

    @Override
    public void stop() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        DefaultSurfaceTextureCaptureSource.access$getLogger$p(this.this$0).info(DefaultSurfaceTextureCaptureSource.access$getTAG$p(this.this$0), "Setting on frame available listener to null");
                        DefaultSurfaceTextureCaptureSource.access$getSurfaceTexture$p(this.this$0).setOnFrameAvailableListener(null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultSurfaceTextureCaptureSource;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void addCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
    }

    @Override
    public void removeCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    @Override
    public void release() {
        this.handler.post(new Runnable(this){
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;

            public final void run() {
                DefaultSurfaceTextureCaptureSource.access$getLogger$p(this.this$0).info(DefaultSurfaceTextureCaptureSource.access$getTAG$p(this.this$0), "Releasing surface texture capture source");
                if (!DefaultSurfaceTextureCaptureSource.access$getTextureBufferInFlight$p(this.this$0)) {
                    DefaultSurfaceTextureCaptureSource.access$completeRelease(this.this$0);
                } else {
                    DefaultSurfaceTextureCaptureSource.access$setReleasePending$p(this.this$0, true);
                }
            }
            {
                this.this$0 = defaultSurfaceTextureCaptureSource;
            }
        });
    }

    private final void tryCapturingFrame() {
        if (this.releasePending || !this.pendingAvailableFrame || this.textureBufferInFlight) {
            return;
        }
        this.textureBufferInFlight = true;
        this.pendingAvailableFrame = false;
        SurfaceTexture surfaceTexture = this.surfaceTexture;
        if (surfaceTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
        }
        surfaceTexture.updateTexImage();
        float[] transformMatrix = new float[16];
        SurfaceTexture surfaceTexture2 = this.surfaceTexture;
        if (surfaceTexture2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
        }
        surfaceTexture2.getTransformMatrix(transformMatrix);
        VideoFrameTextureBuffer buffer2 = new VideoFrameTextureBuffer(this.width, this.height, this.textureId, GlUtil.INSTANCE.convertToMatrix(transformMatrix), VideoFrameTextureBuffer.Type.TEXTURE_OES, new Runnable(this){
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;

            public final void run() {
                DefaultSurfaceTextureCaptureSource.access$onFrameReleased(this.this$0);
            }
            {
                this.this$0 = defaultSurfaceTextureCaptureSource;
            }
        });
        SurfaceTexture surfaceTexture3 = this.surfaceTexture;
        if (surfaceTexture3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
        }
        long alignedTimestamp = this.timestampAligner.translateTimestamp(surfaceTexture3.getTimestamp());
        VideoFrame frame = new VideoFrame(alignedTimestamp, buffer2, null, 4, null);
        Iterable $this$forEach$iv = this.sinks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoSink it = (VideoSink)element$iv;
            boolean bl = false;
            it.onVideoFrameReceived(frame);
        }
        frame.release();
        if (this.getMinFps() > 0) {
            this.lastAlignedTimestamp = alignedTimestamp;
            float resendDelayMs = (float)this.RESEND_DELAY_BUFFER_MS + 1.0f / (float)this.getMinFps() * (float)1000;
            this.handler.postDelayed(new Runnable(this, alignedTimestamp){
                final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;
                final /* synthetic */ long $alignedTimestamp;

                public final void run() {
                    Long l = DefaultSurfaceTextureCaptureSource.access$getLastAlignedTimestamp$p(this.this$0);
                    if (l != null && this.$alignedTimestamp == l) {
                        DefaultSurfaceTextureCaptureSource.access$setPendingAvailableFrame$p(this.this$0, true);
                        DefaultSurfaceTextureCaptureSource.access$tryCapturingFrame(this.this$0);
                    }
                }
                {
                    this.this$0 = defaultSurfaceTextureCaptureSource;
                    this.$alignedTimestamp = l;
                }
            }, (long)resendDelayMs);
        }
    }

    private final void onFrameReleased() {
        this.handler.post(new Runnable(this){
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;

            public final void run() {
                DefaultSurfaceTextureCaptureSource.access$setTextureBufferInFlight$p(this.this$0, false);
                if (DefaultSurfaceTextureCaptureSource.access$getReleasePending$p(this.this$0)) {
                    DefaultSurfaceTextureCaptureSource.access$completeRelease(this.this$0);
                } else {
                    DefaultSurfaceTextureCaptureSource.access$tryCapturingFrame(this.this$0);
                }
            }
            {
                this.this$0 = defaultSurfaceTextureCaptureSource;
            }
        });
    }

    private final void completeRelease() {
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
        SurfaceTexture surfaceTexture = this.surfaceTexture;
        if (surfaceTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
        }
        surfaceTexture.release();
        this.getSurface().release();
        EglCore eglCore = this.eglCore;
        if (eglCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
        }
        eglCore.release();
        this.timestampAligner.dispose();
        this.logger.info(this.TAG, "Finished releasing surface texture capture source");
        this.handler.getLooper().quit();
    }

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    public DefaultSurfaceTextureCaptureSource(@NotNull Logger logger, int width, int height, @NotNull VideoContentHint contentHint, @NotNull EglCoreFactory eglCoreFactory) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)((Object)contentHint), (String)"contentHint");
        Intrinsics.checkParameterIsNotNull((Object)eglCoreFactory, (String)"eglCoreFactory");
        this.logger = logger;
        this.width = width;
        this.height = height;
        this.contentHint = contentHint;
        this.eglCoreFactory = eglCoreFactory;
        this.thread = new HandlerThread("DefaultSurfaceTextureCaptureSource");
        this.timestampAligner = new TimestampAligner();
        this.RESEND_DELAY_BUFFER_MS = 10;
        this.sinks = ConcurrentSet.Companion.createConcurrentSet();
        this.TAG = "SurfaceTextureCaptureSource";
        this.thread.start();
        this.handler = new Handler(this.thread.getLooper());
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultSurfaceTextureCaptureSource this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        this.this$0.eglCore = this.this$0.eglCoreFactory.createEglCore();
                        int[] surfaceAttributes = new int[]{12375, this.this$0.width, 12374, this.this$0.height, 12344};
                        EglCore eglCore = DefaultSurfaceTextureCaptureSource.access$getEglCore$p(this.this$0);
                        EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)DefaultSurfaceTextureCaptureSource.access$getEglCore$p(this.this$0).getEglDisplay(), (EGLConfig)DefaultSurfaceTextureCaptureSource.access$getEglCore$p(this.this$0).getEglConfig(), (int[])surfaceAttributes, (int)this.this$0.DUMMY_PBUFFER_OFFSET);
                        Intrinsics.checkExpressionValueIsNotNull((Object)eGLSurface, (String)"EGL14.eglCreatePbufferSu\u2026FFER_OFFSET\n            )");
                        eglCore.setEglSurface(eGLSurface);
                        EGL14.eglMakeCurrent((EGLDisplay)DefaultSurfaceTextureCaptureSource.access$getEglCore$p(this.this$0).getEglDisplay(), (EGLSurface)DefaultSurfaceTextureCaptureSource.access$getEglCore$p(this.this$0).getEglSurface(), (EGLSurface)DefaultSurfaceTextureCaptureSource.access$getEglCore$p(this.this$0).getEglSurface(), (EGLContext)DefaultSurfaceTextureCaptureSource.access$getEglCore$p(this.this$0).getEglContext());
                        GlUtil.INSTANCE.checkGlError("Failed to set dummy surface to initialize surface texture video source");
                        this.this$0.textureId = GlUtil.INSTANCE.generateTexture(36197);
                        this.this$0.surfaceTexture = new SurfaceTexture(this.this$0.textureId);
                        DefaultSurfaceTextureCaptureSource.access$getSurfaceTexture$p(this.this$0).setDefaultBufferSize(this.this$0.width, this.this$0.height);
                        this.this$0.setSurface(new Surface(DefaultSurfaceTextureCaptureSource.access$getSurfaceTexture$p(this.this$0)));
                        this.this$0.logger.info(this.this$0.TAG, "Created surface texture for video source with dimensions " + this.this$0.width + " x " + this.this$0.height);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultSurfaceTextureCaptureSource;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public /* synthetic */ DefaultSurfaceTextureCaptureSource(Logger logger, int n, int n2, VideoContentHint videoContentHint, EglCoreFactory eglCoreFactory, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            videoContentHint = VideoContentHint.None;
        }
        this(logger, n, n2, videoContentHint, eglCoreFactory);
    }

    public static final /* synthetic */ SurfaceTexture access$getSurfaceTexture$p(DefaultSurfaceTextureCaptureSource $this) {
        SurfaceTexture surfaceTexture = $this.surfaceTexture;
        if (surfaceTexture == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"surfaceTexture");
        }
        return surfaceTexture;
    }

    public static final /* synthetic */ boolean access$getPendingAvailableFrame$p(DefaultSurfaceTextureCaptureSource $this) {
        return $this.pendingAvailableFrame;
    }

    public static final /* synthetic */ void access$setPendingAvailableFrame$p(DefaultSurfaceTextureCaptureSource $this, boolean bl) {
        $this.pendingAvailableFrame = bl;
    }

    public static final /* synthetic */ void access$tryCapturingFrame(DefaultSurfaceTextureCaptureSource $this) {
        $this.tryCapturingFrame();
    }

    public static final /* synthetic */ Handler access$getHandler$p(DefaultSurfaceTextureCaptureSource $this) {
        return $this.handler;
    }

    public static final /* synthetic */ boolean access$getTextureBufferInFlight$p(DefaultSurfaceTextureCaptureSource $this) {
        return $this.textureBufferInFlight;
    }

    public static final /* synthetic */ void access$setTextureBufferInFlight$p(DefaultSurfaceTextureCaptureSource $this, boolean bl) {
        $this.textureBufferInFlight = bl;
    }

    public static final /* synthetic */ void access$completeRelease(DefaultSurfaceTextureCaptureSource $this) {
        $this.completeRelease();
    }

    public static final /* synthetic */ boolean access$getReleasePending$p(DefaultSurfaceTextureCaptureSource $this) {
        return $this.releasePending;
    }

    public static final /* synthetic */ void access$setReleasePending$p(DefaultSurfaceTextureCaptureSource $this, boolean bl) {
        $this.releasePending = bl;
    }

    public static final /* synthetic */ void access$onFrameReleased(DefaultSurfaceTextureCaptureSource $this) {
        $this.onFrameReleased();
    }

    public static final /* synthetic */ Long access$getLastAlignedTimestamp$p(DefaultSurfaceTextureCaptureSource $this) {
        return $this.lastAlignedTimestamp;
    }

    public static final /* synthetic */ void access$setLastAlignedTimestamp$p(DefaultSurfaceTextureCaptureSource $this, Long l) {
        $this.lastAlignedTimestamp = l;
    }

    public static final /* synthetic */ EglCore access$getEglCore$p(DefaultSurfaceTextureCaptureSource $this) {
        EglCore eglCore = $this.eglCore;
        if (eglCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
        }
        return eglCore;
    }
}

