/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import com.amazonaws.services.chime.cwt.InputModelConfig;
import com.amazonaws.services.chime.cwt.ModelState;
import com.amazonaws.services.chime.cwt.PredictResult;
import com.amazonaws.services.chime.cwt.TfLiteModel;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.ModelShape;
import java.io.InputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/SegmentationProcessor;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "bytes", "", "getContext", "()Landroid/content/Context;", "modelState", "Lcom/amazonaws/services/chime/cwt/ModelState;", "getModelState", "()Lcom/amazonaws/services/chime/cwt/ModelState;", "setModelState", "(Lcom/amazonaws/services/chime/cwt/ModelState;)V", "segmentationModel", "Lcom/amazonaws/services/chime/cwt/TfLiteModel;", "getInputBuffer", "Ljava/nio/ByteBuffer;", "getOutputBuffer", "initialize", "", "width", "", "height", "modelShape", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/ModelShape;", "predict", "Lcom/amazonaws/services/chime/cwt/PredictResult;", "Companion", "amazon-chime-sdk_release"})
public final class SegmentationProcessor {
    private TfLiteModel segmentationModel;
    @NotNull
    public ModelState modelState;
    private byte[] bytes;
    @NotNull
    private final Context context;
    private static boolean isMachineLearningLibraryLoaded;
    public static final Companion Companion;

    @NotNull
    public final ModelState getModelState() {
        ModelState modelState = this.modelState;
        if (modelState == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"modelState");
        }
        return modelState;
    }

    public final void setModelState(@NotNull ModelState modelState) {
        Intrinsics.checkParameterIsNotNull((Object)modelState, (String)"<set-?>");
        this.modelState = modelState;
    }

    public final void initialize(int width, int height, @NotNull ModelShape modelShape) {
        Intrinsics.checkParameterIsNotNull((Object)modelShape, (String)"modelShape");
        if (isMachineLearningLibraryLoaded) {
            this.segmentationModel = new TfLiteModel();
            InputStream inputStream = this.context.getAssets().open("selfie_segmentation_landscape.tflite");
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.assets.open(\"sel\u2026tation_landscape.tflite\")");
            this.bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
            InputModelConfig config = new InputModelConfig(height, width, modelShape.getChannels(), modelShape.getModelRangeMin(), modelShape.getModelRangeMax());
            TfLiteModel tfLiteModel = this.segmentationModel;
            if (tfLiteModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"segmentationModel");
            }
            if (this.bytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"bytes");
            }
            ModelState modelState = tfLiteModel.loadModelBytes(this.bytes, config);
            Intrinsics.checkExpressionValueIsNotNull((Object)modelState, (String)"segmentationModel.loadModelBytes(bytes, config)");
            this.modelState = modelState;
        }
    }

    @NotNull
    public final PredictResult predict() {
        TfLiteModel tfLiteModel = this.segmentationModel;
        if (tfLiteModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"segmentationModel");
        }
        PredictResult predictResult = tfLiteModel.predict();
        Intrinsics.checkExpressionValueIsNotNull((Object)predictResult, (String)"segmentationModel.predict()");
        return predictResult;
    }

    @NotNull
    public final ByteBuffer getInputBuffer() {
        TfLiteModel tfLiteModel = this.segmentationModel;
        if (tfLiteModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"segmentationModel");
        }
        ByteBuffer byteBuffer = tfLiteModel.getInputBuffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"segmentationModel.getInputBuffer()");
        return byteBuffer;
    }

    @NotNull
    public final ByteBuffer getOutputBuffer() {
        TfLiteModel tfLiteModel = this.segmentationModel;
        if (tfLiteModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"segmentationModel");
        }
        ByteBuffer byteBuffer = tfLiteModel.getOutputBuffer();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"segmentationModel.getOutputBuffer()");
        return byteBuffer;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public SegmentationProcessor(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    static {
        Companion = new Companion(null);
        try {
            System.loadLibrary("amazon-chime-sdk-machine-learning_jni");
            isMachineLearningLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.e((String)"BackgroundFilterVideoFrameProcessor", (String)"Unable to load Machine Learning Library. Use `implementation(name: 'amazon-chime-sdk-machine-learning', ext: 'aar')` under dependencies in build.gradle file.");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/SegmentationProcessor$Companion;", "", "()V", "isMachineLearningLibraryLoaded", "", "()Z", "setMachineLearningLibraryLoaded", "(Z)V", "amazon-chime-sdk_release"})
    @SuppressLint(value={"LongLogTag"})
    public static final class Companion {
        public final boolean isMachineLearningLibraryLoaded() {
            return isMachineLearningLibraryLoaded;
        }

        public final void setMachineLearningLibraryLoaded(boolean bl) {
            isMachineLearningLibraryLoaded = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

