/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerdetector;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.AttendeeInfo;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.SignalUpdate;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeLevel;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeUpdate;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerdetector.ActiveSpeakerDetectorFacade;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerdetector.ActiveSpeakerObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerpolicy.ActiveSpeakerPolicy;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.realtime.RealtimeObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\rH\u0016J\u001b\u0010#\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010(\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010)\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010*\u001a\u00020 2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010+\u001a\u00020 2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0%H\u0016\u00a2\u0006\u0002\u0010.J\u001b\u0010/\u001a\u00020 2\f\u00100\u001a\b\u0012\u0004\u0012\u0002010%H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010$\u001a\u00020\u0010H\u0002J\b\u00106\u001a\u00020 H\u0002J\u0010\u00107\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rH\u0002J\b\u00108\u001a\u00020 H\u0002J\u0010\u00109\u001a\u00020 2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0010H\u0002J \u0010;\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/DefaultActiveSpeakerDetector;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/ActiveSpeakerDetectorFacade;", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/RealtimeObserver;", "audioClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;)V", "ACTIVITY_UPDATE_INTERVAL_MS", "", "ACTIVITY_WAIT_INTERVAL_MS", "TAG", "", "activeSpeakerObservers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerdetector/ActiveSpeakerObserver;", "activeSpeakers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;", "activityTimer", "Ljava/util/Timer;", "getAudioClientObserver", "()Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "mostRecentAttendeeVolumes", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeLevel;", "mostRecentUpdateTimestamp", "observerToPolicy", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/ActiveSpeakerPolicy;", "observerToScoresTimer", "speakerScores", "Ljava/util/concurrent/ConcurrentHashMap;", "", "addActiveSpeakerObserver", "", "policy", "observer", "onAttendeesDropped", "attendeeInfo", "", "([Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;)V", "onAttendeesJoined", "onAttendeesLeft", "onAttendeesMuted", "onAttendeesUnmuted", "onSignalStrengthChanged", "signalUpdates", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/SignalUpdate;", "([Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/SignalUpdate;)V", "onVolumeChanged", "volumeUpdates", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeUpdate;", "([Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeUpdate;)V", "removeActiveSpeakerObserver", "shouldUpdateActiveSpeakerList", "", "startActivityTimer", "startScoresTimerForObserver", "stopActivityTimer", "stopScoresTimerForObserver", "updateActiveSpeakers", "updateScore", "volume", "amazon-chime-sdk_release"})
public final class DefaultActiveSpeakerDetector
implements ActiveSpeakerDetectorFacade,
RealtimeObserver {
    private ConcurrentHashMap<AttendeeInfo, Double> speakerScores;
    private List<AttendeeInfo> activeSpeakers;
    private Map<AttendeeInfo, Long> mostRecentUpdateTimestamp;
    private Map<AttendeeInfo, VolumeLevel> mostRecentAttendeeVolumes;
    private Set<ActiveSpeakerObserver> activeSpeakerObservers;
    private Map<ActiveSpeakerObserver, ActiveSpeakerPolicy> observerToPolicy;
    private Map<ActiveSpeakerObserver, Timer> observerToScoresTimer;
    private Timer activityTimer;
    private final long ACTIVITY_WAIT_INTERVAL_MS = 1000L;
    private final long ACTIVITY_UPDATE_INTERVAL_MS = 200L;
    private final String TAG = "ActiveSpeakerDetector";
    @NotNull
    private final AudioClientObserver audioClientObserver;

    @Override
    public void addActiveSpeakerObserver(@NotNull ActiveSpeakerPolicy policy, @NotNull ActiveSpeakerObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)policy, (String)"policy");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        boolean isFirstObserver = this.activeSpeakerObservers.isEmpty();
        this.activeSpeakerObservers.add(observer);
        this.observerToPolicy.put(observer, policy);
        if (isFirstObserver) {
            this.startActivityTimer();
        }
        this.startScoresTimerForObserver(observer);
    }

    @Override
    public void removeActiveSpeakerObserver(@NotNull ActiveSpeakerObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.activeSpeakerObservers.remove(observer);
        this.observerToPolicy.remove(observer);
        this.stopScoresTimerForObserver(observer);
        if (this.activeSpeakerObservers.isEmpty()) {
            this.stopActivityTimer();
        }
    }

    private final void startActivityTimer() {
        this.activityTimer = new Timer("ScheduleActivityTimer", false);
        this.activityTimer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ DefaultActiveSpeakerDetector this$0;

            public void run() {
                Iterable $this$forEach$iv = DefaultActiveSpeakerDetector.access$getObserverToPolicy$p(this.this$0).values();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ActiveSpeakerPolicy policy = (ActiveSpeakerPolicy)element$iv;
                    boolean bl = false;
                    Set set = DefaultActiveSpeakerDetector.access$getSpeakerScores$p(this.this$0).keySet();
                    Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"speakerScores.keys");
                    Iterable $this$forEach$iv2 = set;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        long lastTimestamp;
                        AttendeeInfo attendeeInfo = (AttendeeInfo)element$iv2;
                        boolean bl2 = false;
                        Long l = (Long)DefaultActiveSpeakerDetector.access$getMostRecentUpdateTimestamp$p(this.this$0).get(attendeeInfo);
                        long l2 = lastTimestamp = l != null ? l : 0L;
                        if (System.currentTimeMillis() - lastTimestamp <= DefaultActiveSpeakerDetector.access$getACTIVITY_WAIT_INTERVAL_MS$p(this.this$0)) continue;
                        AttendeeInfo attendeeInfo2 = attendeeInfo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)attendeeInfo2, (String)"attendeeInfo");
                        VolumeLevel volumeLevel = (VolumeLevel)((Object)DefaultActiveSpeakerDetector.access$getMostRecentAttendeeVolumes$p(this.this$0).get(attendeeInfo));
                        if (volumeLevel == null) {
                            volumeLevel = VolumeLevel.NotSpeaking;
                        }
                        DefaultActiveSpeakerDetector.access$updateScore(this.this$0, policy, attendeeInfo2, volumeLevel);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        }, this.ACTIVITY_UPDATE_INTERVAL_MS, this.ACTIVITY_UPDATE_INTERVAL_MS);
    }

    private final void startScoresTimerForObserver(ActiveSpeakerObserver observer) {
        block0: {
            Integer n = observer.getScoreCallbackIntervalMs();
            if (n == null) break block0;
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            Timer scoresTimer = new Timer("ScheduleScoresTimer", false);
            scoresTimer.scheduleAtFixedRate(new TimerTask(this, observer){
                final /* synthetic */ DefaultActiveSpeakerDetector this$0;
                final /* synthetic */ ActiveSpeakerObserver $observer$inlined;
                {
                    this.this$0 = defaultActiveSpeakerDetector;
                    this.$observer$inlined = activeSpeakerObserver;
                }

                public void run() {
                    this.$observer$inlined.onActiveSpeakerScoreChanged(DefaultActiveSpeakerDetector.access$getSpeakerScores$p(this.this$0));
                }
            }, it, (long)it);
            this.observerToScoresTimer.put(observer, scoresTimer);
        }
    }

    private final void stopActivityTimer() {
        if (this.activeSpeakerObservers.isEmpty()) {
            this.activityTimer.cancel();
        }
    }

    private final void stopScoresTimerForObserver(ActiveSpeakerObserver observer) {
        block0: {
            Timer timer = this.observerToScoresTimer.get(observer);
            if (timer == null) break block0;
            Timer timer2 = timer;
            boolean bl = false;
            boolean bl2 = false;
            Timer it = timer2;
            boolean bl3 = false;
            it.cancel();
            this.observerToScoresTimer.remove(observer);
        }
    }

    private final void updateScore(ActiveSpeakerPolicy policy, AttendeeInfo attendeeInfo, VolumeLevel volume) {
        double activeScore = policy.calculateScore(attendeeInfo, volume);
        if (Intrinsics.areEqual((Double)this.speakerScores.get(attendeeInfo), (double)activeScore) ^ true) {
            ((Map)this.speakerScores).put(attendeeInfo, activeScore);
            this.mostRecentUpdateTimestamp.put(attendeeInfo, System.currentTimeMillis());
            this.updateActiveSpeakers(attendeeInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateActiveSpeakers(AttendeeInfo attendeeInfo) {
        void $this$mapTo$iv$iv;
        if (!this.shouldUpdateActiveSpeakerList(attendeeInfo)) {
            return;
        }
        Map $this$filterValues$iv = this.speakerScores;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        Map map = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : map.entrySet()) {
            double it = ((Number)entry$iv.getValue()).doubleValue();
            boolean bl2 = false;
            if (!(it != 0.0)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$sortedBy$iv = MapsKt.toList((Map)((Map)result$iv));
        boolean $i$f$sortedBy = false;
        result$iv = $this$sortedBy$iv;
        boolean bl3 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair $dstr$_u24__u24$value = (Pair)a;
                boolean bl2 = false;
                double value = ((Number)$dstr$_u24__u24$value.component2()).doubleValue();
                $dstr$_u24__u24$value = (Pair)b;
                Comparable comparable = Double.valueOf(value);
                bl2 = false;
                value = ((Number)$dstr$_u24__u24$value.component2()).doubleValue();
                Double d = value;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)d);
            }
        };
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)result$iv, (Comparator)comparator);
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair it = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            AttendeeInfo attendeeInfo2 = (AttendeeInfo)it.getFirst();
            collection.add(attendeeInfo2);
        }
        List sortedSpeakers = (List)destination$iv$iv;
        Iterable $this$forEach$iv = this.activeSpeakerObservers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AttendeeInfo[] attendeeInfoArray;
            void $this$toTypedArray$iv;
            Object item$iv$iv;
            ActiveSpeakerObserver it = (ActiveSpeakerObserver)element$iv;
            boolean bl5 = false;
            item$iv$iv = sortedSpeakers;
            ActiveSpeakerObserver activeSpeakerObserver = it;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            if (thisCollection$iv.toArray(new AttendeeInfo[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            activeSpeakerObserver.onActiveSpeakerDetected(attendeeInfoArray);
        }
        this.activeSpeakers = CollectionsKt.toMutableList((Collection)sortedSpeakers);
    }

    private final boolean shouldUpdateActiveSpeakerList(AttendeeInfo attendeeInfo) {
        Double d = this.speakerScores.get(attendeeInfo);
        if (d == null) {
            d = 0.0;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)d, (String)"speakerScores[attendeeInfo] ?: 0.0");
        double score = d;
        return score == 0.0 && this.activeSpeakers.contains(attendeeInfo) || score > 0.0 && !this.activeSpeakers.contains(attendeeInfo);
    }

    @Override
    public void onVolumeChanged(@NotNull VolumeUpdate[] volumeUpdates) {
        Intrinsics.checkParameterIsNotNull((Object)volumeUpdates, (String)"volumeUpdates");
        VolumeUpdate[] $this$forEach$iv = volumeUpdates;
        boolean $i$f$forEach = false;
        VolumeUpdate[] volumeUpdateArray = $this$forEach$iv;
        int n = volumeUpdateArray.length;
        for (int j = 0; j < n; ++j) {
            VolumeUpdate element$iv;
            VolumeUpdate it = element$iv = volumeUpdateArray[j];
            boolean bl = false;
            this.mostRecentAttendeeVolumes.put(it.getAttendeeInfo(), it.getVolumeLevel());
        }
    }

    @Override
    public void onAttendeesJoined(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)attendeeInfo, (String)"attendeeInfo");
        AttendeeInfo[] $this$forEach$iv = attendeeInfo;
        boolean $i$f$forEach = false;
        AttendeeInfo[] attendeeInfoArray = $this$forEach$iv;
        int n = attendeeInfoArray.length;
        for (int j = 0; j < n; ++j) {
            AttendeeInfo element$iv;
            AttendeeInfo it = element$iv = attendeeInfoArray[j];
            boolean bl = false;
            ((Map)this.speakerScores).put(it, 0.0);
            this.mostRecentAttendeeVolumes.put(it, VolumeLevel.NotSpeaking);
        }
    }

    @Override
    public void onAttendeesLeft(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)attendeeInfo, (String)"attendeeInfo");
        AttendeeInfo[] $this$forEach$iv = attendeeInfo;
        boolean $i$f$forEach = false;
        AttendeeInfo[] attendeeInfoArray = $this$forEach$iv;
        int n = attendeeInfoArray.length;
        for (int j = 0; j < n; ++j) {
            AttendeeInfo element$iv;
            AttendeeInfo it = element$iv = attendeeInfoArray[j];
            boolean bl = false;
            this.speakerScores.remove(it);
            this.mostRecentAttendeeVolumes.remove(it);
            this.mostRecentUpdateTimestamp.remove(it);
            this.updateActiveSpeakers(it);
        }
    }

    @Override
    public void onAttendeesDropped(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)attendeeInfo, (String)"attendeeInfo");
        this.onAttendeesLeft(attendeeInfo);
    }

    @Override
    public void onSignalStrengthChanged(@NotNull SignalUpdate[] signalUpdates) {
        Intrinsics.checkParameterIsNotNull((Object)signalUpdates, (String)"signalUpdates");
    }

    @Override
    public void onAttendeesMuted(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)attendeeInfo, (String)"attendeeInfo");
    }

    @Override
    public void onAttendeesUnmuted(@NotNull AttendeeInfo[] attendeeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)attendeeInfo, (String)"attendeeInfo");
    }

    @NotNull
    public final AudioClientObserver getAudioClientObserver() {
        return this.audioClientObserver;
    }

    public DefaultActiveSpeakerDetector(@NotNull AudioClientObserver audioClientObserver) {
        Intrinsics.checkParameterIsNotNull((Object)audioClientObserver, (String)"audioClientObserver");
        this.audioClientObserver = audioClientObserver;
        this.speakerScores = new ConcurrentHashMap();
        DefaultActiveSpeakerDetector defaultActiveSpeakerDetector = this;
        boolean bl = false;
        Object object = new ArrayList();
        defaultActiveSpeakerDetector.activeSpeakers = object;
        defaultActiveSpeakerDetector = this;
        bl = false;
        defaultActiveSpeakerDetector.mostRecentUpdateTimestamp = object = (Map)new LinkedHashMap();
        defaultActiveSpeakerDetector = this;
        bl = false;
        defaultActiveSpeakerDetector.mostRecentAttendeeVolumes = object = (Map)new LinkedHashMap();
        defaultActiveSpeakerDetector = this;
        bl = false;
        defaultActiveSpeakerDetector.activeSpeakerObservers = object = (Set)new LinkedHashSet();
        defaultActiveSpeakerDetector = this;
        bl = false;
        defaultActiveSpeakerDetector.observerToPolicy = object = (Map)new LinkedHashMap();
        defaultActiveSpeakerDetector = this;
        bl = false;
        defaultActiveSpeakerDetector.observerToScoresTimer = object = (Map)new LinkedHashMap();
        this.activityTimer = new Timer("ScheduleActivityTimer", false);
        this.ACTIVITY_WAIT_INTERVAL_MS = 1000L;
        this.ACTIVITY_UPDATE_INTERVAL_MS = 200L;
        this.TAG = "ActiveSpeakerDetector";
        this.audioClientObserver.subscribeToRealTimeEvents(this);
    }

    public static final /* synthetic */ Map access$getObserverToPolicy$p(DefaultActiveSpeakerDetector $this) {
        return $this.observerToPolicy;
    }

    public static final /* synthetic */ void access$setObserverToPolicy$p(DefaultActiveSpeakerDetector $this, Map map) {
        $this.observerToPolicy = map;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSpeakerScores$p(DefaultActiveSpeakerDetector $this) {
        return $this.speakerScores;
    }

    public static final /* synthetic */ void access$setSpeakerScores$p(DefaultActiveSpeakerDetector $this, ConcurrentHashMap concurrentHashMap) {
        $this.speakerScores = concurrentHashMap;
    }

    public static final /* synthetic */ Map access$getMostRecentUpdateTimestamp$p(DefaultActiveSpeakerDetector $this) {
        return $this.mostRecentUpdateTimestamp;
    }

    public static final /* synthetic */ void access$setMostRecentUpdateTimestamp$p(DefaultActiveSpeakerDetector $this, Map map) {
        $this.mostRecentUpdateTimestamp = map;
    }

    public static final /* synthetic */ long access$getACTIVITY_WAIT_INTERVAL_MS$p(DefaultActiveSpeakerDetector $this) {
        return $this.ACTIVITY_WAIT_INTERVAL_MS;
    }

    public static final /* synthetic */ void access$updateScore(DefaultActiveSpeakerDetector $this, ActiveSpeakerPolicy policy, AttendeeInfo attendeeInfo, VolumeLevel volume) {
        $this.updateScore(policy, attendeeInfo, volume);
    }

    public static final /* synthetic */ Map access$getMostRecentAttendeeVolumes$p(DefaultActiveSpeakerDetector $this) {
        return $this.mostRecentAttendeeVolumes;
    }

    public static final /* synthetic */ void access$setMostRecentAttendeeVolumes$p(DefaultActiveSpeakerDetector $this, Map map) {
        $this.mostRecentAttendeeVolumes = map;
    }
}

