/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture;

import android.content.Context;
import android.graphics.Matrix;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEventName;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoResolution;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoRotation;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CameraCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceError;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultCameraCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSourceFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.VideoCaptureFormat;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDevice;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDeviceType;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.android.HandlerDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0003\u0015\u0018\u001f\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020?H\u0016J\u0010\u0010L\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0002H\u0016J \u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020:2\u0006\u0010R\u001a\u00020\u000fH\u0002J\b\u0010S\u001a\u00020JH\u0002J\b\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020J2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020J2\u0006\u0010Z\u001a\u00020[H\u0016J\u0006\u0010\\\u001a\u00020JJ\u0010\u0010]\u001a\u00020J2\u0006\u0010K\u001a\u00020?H\u0016J\u0010\u0010^\u001a\u00020J2\u0006\u0010M\u001a\u00020\u0002H\u0016J\u0010\u0010_\u001a\u00020J2\u0006\u0010`\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020J2\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010c\u001a\u00020J2\u0006\u0010`\u001a\u00020aH\u0002J\b\u0010d\u001a\u00020JH\u0016J\b\u0010e\u001a\u00020JH\u0016J\b\u0010f\u001a\u00020JH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010'\u001a\u0004\u0018\u00010&2\b\u0010%\u001a\u0004\u0018\u00010&@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R(\u0010-\u001a\u0004\u0018\u00010,2\b\u0010%\u001a\u0004\u0018\u00010,@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00102\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010CX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010D\u001a\u00020:2\u0006\u0010%\u001a\u00020:@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010H\u00a8\u0006g"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CameraCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "surfaceTextureCaptureSourceFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;", "cameraManager", "Landroid/hardware/camera2/CameraManager;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;Landroid/hardware/camera2/CameraManager;)V", "DESIRED_CAPTURE_FORMAT", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;", "ROTATION_360_DEGREES", "", "TAG", "", "cameraCaptureSession", "Landroid/hardware/camera2/CameraCaptureSession;", "cameraCaptureSessionCaptureCallback", "com/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionCaptureCallback$1", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionCaptureCallback$1;", "cameraCaptureSessionStateCallback", "com/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionStateCallback$1", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraCaptureSessionStateCallback$1;", "cameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "cameraDevice", "Landroid/hardware/camera2/CameraDevice;", "cameraDeviceStateCallback", "com/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraDeviceStateCallback$1", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource$cameraDeviceStateCallback$1;", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "value", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "device", "getDevice", "()Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "setDevice", "(Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;)V", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "eventAnalyticsController", "getEventAnalyticsController", "()Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "setEventAnalyticsController", "(Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;)V", "format", "getFormat", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;", "setFormat", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;)V", "handler", "Landroid/os/Handler;", "isCameraFrontFacing", "", "maxResolution", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoResolution;", "observers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceObserver;", "sensorOrientation", "sinks", "surfaceTextureSource", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSource;", "torchEnabled", "getTorchEnabled", "()Z", "setTorchEnabled", "(Z)V", "addCaptureSourceObserver", "", "observer", "addVideoSink", "sink", "createBufferWithUpdatedTransformMatrix", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameTextureBuffer;", "buffer", "mirror", "rotation", "createCaptureRequest", "getCaptureFrameRotation", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRotation;", "handleCameraCaptureFail", "error", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceError;", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "release", "removeCaptureSourceObserver", "removeVideoSink", "setFocusMode", "captureRequestBuilder", "Landroid/hardware/camera2/CaptureRequest$Builder;", "setMaxResolution", "setStabilizationMode", "start", "stop", "switchCamera", "amazon-chime-sdk_release"})
public final class DefaultCameraCaptureSource
implements CameraCaptureSource,
VideoSink {
    private final Handler handler;
    private CameraCaptureSession cameraCaptureSession;
    private CameraDevice cameraDevice;
    private CameraCharacteristics cameraCharacteristics;
    private int sensorOrientation;
    private boolean isCameraFrontFacing;
    private SurfaceTextureCaptureSource surfaceTextureSource;
    private final Set<CaptureSourceObserver> observers;
    private final Set<VideoSink> sinks;
    @NotNull
    private final VideoContentHint contentHint;
    private final VideoCaptureFormat DESIRED_CAPTURE_FORMAT;
    private final int ROTATION_360_DEGREES = 360;
    private VideoResolution maxResolution;
    private final String TAG = "DefaultCameraCaptureSource";
    @Nullable
    private EventAnalyticsController eventAnalyticsController;
    @Nullable
    private MediaDevice device;
    private boolean torchEnabled;
    @NotNull
    private VideoCaptureFormat format;
    private final cameraDeviceStateCallback.1 cameraDeviceStateCallback;
    private final cameraCaptureSessionStateCallback.1 cameraCaptureSessionStateCallback;
    private final cameraCaptureSessionCaptureCallback.1 cameraCaptureSessionCaptureCallback;
    private final Context context;
    private final Logger logger;
    private final SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory;
    private final CameraManager cameraManager;

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    @Nullable
    public final EventAnalyticsController getEventAnalyticsController() {
        return this.eventAnalyticsController;
    }

    public final void setEventAnalyticsController(@Nullable EventAnalyticsController value) {
        this.eventAnalyticsController = value;
    }

    @Override
    @Nullable
    public MediaDevice getDevice() {
        return this.device;
    }

    @Override
    public void setDevice(@Nullable MediaDevice value) {
        block1: {
            this.logger.info(this.TAG, "Setting capture device: " + value);
            if (Intrinsics.areEqual((Object)this.device, (Object)value)) {
                this.logger.info(this.TAG, "Already using device: " + value + "; ignoring");
                return;
            }
            this.device = value;
            SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
            if (surfaceTextureCaptureSource == null) break block1;
            SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = surfaceTextureCaptureSource;
            boolean bl = false;
            boolean bl2 = false;
            SurfaceTextureCaptureSource it = surfaceTextureCaptureSource2;
            boolean bl3 = false;
            this.stop();
            this.start();
        }
    }

    @Override
    public void switchCamera() {
        block6: {
            Object v1;
            MediaDevice it;
            Iterable $this$firstOrNull$iv;
            boolean $i$f$firstOrNull;
            DefaultCameraCaptureSource defaultCameraCaptureSource;
            block4: {
                MediaDevice mediaDevice = this.getDevice();
                MediaDeviceType desiredDeviceType = (mediaDevice != null ? mediaDevice.getType() : null) == MediaDeviceType.VIDEO_FRONT_CAMERA ? MediaDeviceType.VIDEO_BACK_CAMERA : MediaDeviceType.VIDEO_FRONT_CAMERA;
                Iterable iterable = MediaDevice.Companion.listVideoDevices(this.cameraManager);
                defaultCameraCaptureSource = this;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (MediaDevice)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == desiredDeviceType)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Object var9_9 = v1;
            DefaultCameraCaptureSource defaultCameraCaptureSource2 = defaultCameraCaptureSource;
            MediaDevice mediaDevice = var9_9;
            if (mediaDevice == null) {
                Object v4;
                block5: {
                    $this$firstOrNull$iv = MediaDevice.Companion.listVideoDevices(this.cameraManager);
                    defaultCameraCaptureSource = defaultCameraCaptureSource2;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (MediaDevice)element$iv;
                        boolean bl = false;
                        if (!(it.getType() == MediaDeviceType.VIDEO_BACK_CAMERA)) continue;
                        v4 = element$iv;
                        break block5;
                    }
                    v4 = null;
                }
                var9_9 = v4;
                defaultCameraCaptureSource2 = defaultCameraCaptureSource;
                mediaDevice = var9_9;
            }
            defaultCameraCaptureSource2.setDevice(mediaDevice);
            if (this.getDevice() == null) break block6;
            EventAnalyticsController eventAnalyticsController = this.eventAnalyticsController;
            if (eventAnalyticsController != null) {
                eventAnalyticsController.pushHistory(MeetingHistoryEventName.videoInputSelected);
            }
        }
    }

    @Override
    public void setMaxResolution(@NotNull VideoResolution maxResolution) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)maxResolution), (String)"maxResolution");
        this.maxResolution = maxResolution;
    }

    @Override
    public boolean getTorchEnabled() {
        return this.torchEnabled;
    }

    @Override
    @RequiresApi(value=23)
    public void setTorchEnabled(boolean value) {
        CameraCharacteristics cameraCharacteristics = this.cameraCharacteristics;
        if (Intrinsics.areEqual((Object)(cameraCharacteristics != null ? (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE) : null), (Object)false)) {
            this.logger.warn(this.TAG, "Torch not supported on current camera, setting value and returning");
            return;
        }
        this.torchEnabled = value;
        if (this.cameraDevice == null) {
            Object object = this.getDevice();
            if (object != null && (object = ((MediaDevice)object).getId()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                this.cameraManager.setTorchMode((String)it, this.torchEnabled);
            }
        } else {
            this.createCaptureRequest();
        }
    }

    @Override
    @NotNull
    public VideoCaptureFormat getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(@NotNull VideoCaptureFormat value) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.logger.info(this.TAG, "Setting capture format: " + value);
            if (Intrinsics.areEqual((Object)this.format, (Object)value)) {
                this.logger.info(this.TAG, "Already using format: " + value + "; ignoring");
                return;
            }
            this.format = new VideoCaptureFormat(value.getWidth(), value.getHeight(), value.getMaxFps());
            SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
            if (surfaceTextureCaptureSource == null) break block1;
            SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = surfaceTextureCaptureSource;
            boolean bl = false;
            boolean bl2 = false;
            SurfaceTextureCaptureSource it = surfaceTextureCaptureSource2;
            boolean bl3 = false;
            this.stop();
            this.start();
        }
    }

    @Override
    public void start() {
        VideoCaptureFormat chosenCaptureFormat;
        Object v4;
        CameraCharacteristics cameraCharacteristics;
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") != 0) {
            this.handleCameraCaptureFail(CaptureSourceError.PermissionError);
            throw (Throwable)new SecurityException("Missing necessary camera permissions");
        }
        this.stop();
        this.logger.info(this.TAG, "Camera capture start requested with device: " + this.getDevice());
        MediaDevice mediaDevice = this.getDevice();
        if (mediaDevice == null) {
            DefaultCameraCaptureSource defaultCameraCaptureSource = this;
            boolean bl = false;
            boolean bl2 = false;
            DefaultCameraCaptureSource $this$run = defaultCameraCaptureSource;
            boolean bl3 = false;
            $this$run.logger.info($this$run.TAG, "Cannot start camera capture with null device");
            return;
        }
        MediaDevice device = mediaDevice;
        String string = device.getId();
        if (string == null) {
            DefaultCameraCaptureSource defaultCameraCaptureSource = this;
            boolean bl = false;
            boolean $this$run = false;
            DefaultCameraCaptureSource $this$run2 = defaultCameraCaptureSource;
            boolean bl4 = false;
            $this$run2.logger.info($this$run2.TAG, "Cannot start camera capture with null device id");
            return;
        }
        String id = string;
        CameraCharacteristics cameraCharacteristics2 = this.cameraManager.getCameraCharacteristics(id);
        DefaultCameraCaptureSource defaultCameraCaptureSource = this;
        boolean bl = false;
        boolean $this$run = false;
        CameraCharacteristics it = cameraCharacteristics2;
        boolean bl5 = false;
        Integer n = (Integer)it.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.sensorOrientation = n != null ? n : 0;
        Integer n2 = (Integer)it.get(CameraCharacteristics.LENS_FACING);
        boolean bl6 = false;
        this.isCameraFrontFacing = n2 != null && n2 == 0;
        defaultCameraCaptureSource.cameraCharacteristics = cameraCharacteristics = cameraCharacteristics2;
        int maxWidth = this.maxResolution.getWidth();
        int maxHeight = this.maxResolution.getHeight();
        int maxFps = 30;
        Iterable $this$minBy$iv = MediaDevice.Companion.listSupportedVideoCaptureFormats(this.cameraManager, device, maxFps, maxWidth, maxHeight);
        boolean $i$f$minBy = false;
        Iterator iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v4 = minElem$iv;
            } else {
                VideoCaptureFormat format = (VideoCaptureFormat)minElem$iv;
                boolean bl7 = false;
                int n3 = format.getWidth() - this.getFormat().getWidth();
                boolean bl8 = false;
                int n4 = Math.abs(n3);
                n3 = format.getHeight() - this.getFormat().getHeight();
                int n5 = n4;
                bl8 = false;
                int n6 = Math.abs(n3);
                int minValue$iv = n5 + n6;
                do {
                    Object e$iv = iterator$iv.next();
                    VideoCaptureFormat format2 = (VideoCaptureFormat)e$iv;
                    $i$a$-minBy-DefaultCameraCaptureSource$start$chosenCaptureFormat$1 = false;
                    n5 = format2.getWidth() - this.getFormat().getWidth();
                    n6 = 0;
                    int n7 = Math.abs(n5);
                    n5 = format2.getHeight() - this.getFormat().getHeight();
                    int n8 = n7;
                    n6 = 0;
                    int n9 = Math.abs(n5);
                    int v$iv = n8 + n9;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v4 = minElem$iv;
            }
        }
        VideoCaptureFormat videoCaptureFormat = chosenCaptureFormat = (VideoCaptureFormat)v4;
        if (videoCaptureFormat == null) {
            DefaultCameraCaptureSource defaultCameraCaptureSource2 = this;
            boolean bl9 = false;
            boolean bl10 = false;
            DefaultCameraCaptureSource $this$run3 = defaultCameraCaptureSource2;
            boolean bl11 = false;
            $this$run3.handleCameraCaptureFail(CaptureSourceError.ConfigurationFailure);
            return;
        }
        VideoCaptureFormat surfaceTextureFormat = videoCaptureFormat;
        SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource = this.surfaceTextureCaptureSourceFactory.createSurfaceTextureCaptureSource(surfaceTextureFormat.getWidth(), surfaceTextureFormat.getHeight(), this.getContentHint());
        if (surfaceTextureCaptureSource != null) {
            surfaceTextureCaptureSource.addVideoSink(this);
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource2 != null) {
            surfaceTextureCaptureSource2.start();
        }
        this.cameraManager.openCamera(id, (CameraDevice.StateCallback)this.cameraDeviceStateCallback, this.handler);
    }

    @Override
    public void stop() {
        this.logger.info(this.TAG, "Stopping camera capture source");
        VideoSink sink = this;
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sink, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultCameraCaptureSource this$0;
            final /* synthetic */ VideoSink $sink;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        CameraCaptureSession cameraCaptureSession = DefaultCameraCaptureSource.access$getCameraCaptureSession$p(this.this$0);
                        if (cameraCaptureSession != null) {
                            cameraCaptureSession.close();
                        }
                        DefaultCameraCaptureSource.access$setCameraCaptureSession$p(this.this$0, null);
                        CameraDevice cameraDevice = DefaultCameraCaptureSource.access$getCameraDevice$p(this.this$0);
                        if (cameraDevice != null) {
                            cameraDevice.close();
                        }
                        DefaultCameraCaptureSource.access$setCameraDevice$p(this.this$0, null);
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        if (surfaceTextureCaptureSource != null) {
                            surfaceTextureCaptureSource.removeVideoSink(this.$sink);
                        }
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        if (surfaceTextureCaptureSource2 != null) {
                            surfaceTextureCaptureSource2.stop();
                        }
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource3 = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        if (surfaceTextureCaptureSource3 != null) {
                            surfaceTextureCaptureSource3.release();
                        }
                        DefaultCameraCaptureSource.access$setSurfaceTextureSource$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultCameraCaptureSource;
                this.$sink = videoSink;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        VideoFrameBuffer videoFrameBuffer = frame.getBuffer();
        if (videoFrameBuffer == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer");
        }
        VideoFrameBuffer processedBuffer = this.createBufferWithUpdatedTransformMatrix((VideoFrameTextureBuffer)videoFrameBuffer, this.isCameraFrontFacing, -this.sensorOrientation);
        VideoFrame processedFrame = new VideoFrame(frame.getTimestampNs(), processedBuffer, this.getCaptureFrameRotation());
        Iterable $this$forEach$iv = this.sinks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoSink it = (VideoSink)element$iv;
            boolean bl = false;
            it.onVideoFrameReceived(processedFrame);
        }
        processedBuffer.release();
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    @Override
    public void addCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.observers.add(observer);
    }

    @Override
    public void removeCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.observers.remove(observer);
    }

    public final void release() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultCameraCaptureSource this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Stopping handler looper");
                        DefaultCameraCaptureSource.access$getHandler$p(this.this$0).removeCallbacksAndMessages(null);
                        DefaultCameraCaptureSource.access$getHandler$p(this.this$0).getLooper().quit();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultCameraCaptureSource;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void handleCameraCaptureFail(CaptureSourceError error) {
        Map attributes = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.videoInputError), (Object)((Object)error))});
        EventAnalyticsController eventAnalyticsController = this.eventAnalyticsController;
        if (eventAnalyticsController != null) {
            eventAnalyticsController.publishEvent(EventName.videoInputFailed, attributes);
        }
        ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, (Function1)new Function1<CaptureSourceObserver, Unit>(error){
            final /* synthetic */ CaptureSourceError $error;

            public final void invoke(@NotNull CaptureSourceObserver it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                it.onCaptureFailed(this.$error);
            }
            {
                this.$error = captureSourceError;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void createCaptureRequest() {
        CameraDevice cameraDevice = this.cameraDevice;
        if (cameraDevice == null) {
            DefaultCameraCaptureSource defaultCameraCaptureSource = this;
            boolean bl = false;
            boolean bl2 = false;
            DefaultCameraCaptureSource $this$run2 = defaultCameraCaptureSource;
            boolean bl3 = false;
            $this$run2.logger.warn($this$run2.TAG, "createCaptureRequest called without device set, may be mid restart");
            return;
        }
        CameraDevice cameraDevice2 = cameraDevice;
        try {
            CameraCaptureSession cameraCaptureSession;
            DefaultCameraCaptureSource $this$run;
            boolean bl;
            DefaultCameraCaptureSource defaultCameraCaptureSource;
            Range range;
            Object v3;
            Range it;
            void $this$filterTo$iv$iv;
            Object[] fpsRanges;
            CaptureRequest.Builder builder = cameraDevice2.createCaptureRequest(3);
            Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"cameraDevice.createCaptu\u2026raDevice.TEMPLATE_RECORD)");
            CaptureRequest.Builder captureRequestBuilder = builder;
            Object[] objectArray = this.cameraCharacteristics;
            if (this.cameraCharacteristics == null || (objectArray = (Range[])objectArray.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) == null) {
                DefaultCameraCaptureSource defaultCameraCaptureSource2 = this;
                boolean $this$run2 = false;
                boolean bl3 = false;
                DefaultCameraCaptureSource $this$run3 = defaultCameraCaptureSource2;
                boolean bl4 = false;
                $this$run3.logger.error($this$run3.TAG, "Could not retrieve camera FPS ranges");
                $this$run3.handleCameraCaptureFail(CaptureSourceError.ConfigurationFailure);
                return;
            }
            Object[] $this$filter$iv = fpsRanges = objectArray;
            boolean $i$f$filter = false;
            Object[] $this$run3 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                it = element$iv$iv;
                boolean bl5 = false;
                if (!(Intrinsics.compare((int)((Number)((Object)it.getUpper())).intValue(), (int)this.getFormat().getMaxFps()) <= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$minBy$iv = (List)destination$iv$iv;
            boolean $i$f$minBy = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = minElem$iv;
                } else {
                    Range it2 = (Range)minElem$iv;
                    boolean bl6 = false;
                    int n = this.getFormat().getMaxFps();
                    Comparable comparable = it2.getUpper();
                    Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"it.upper");
                    int minValue$iv = n - ((Number)((Object)comparable)).intValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Range it3 = (Range)e$iv;
                        objectArray2 = false;
                        int n2 = this.getFormat().getMaxFps();
                        Comparable comparable2 = it3.getUpper();
                        Intrinsics.checkExpressionValueIsNotNull((Object)comparable2, (String)"it.upper");
                        int v$iv = n2 - ((Number)((Object)comparable2)).intValue();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = minElem$iv;
                }
            }
            if ((range = (Range)v3) == null) {
                defaultCameraCaptureSource = this;
                bl = false;
                boolean bl7 = false;
                $this$run = defaultCameraCaptureSource;
                boolean bl8 = false;
                $this$run.logger.warn($this$run.TAG, "No FPS ranges below set max FPS");
                Object[] $this$minBy$iv2 = fpsRanges;
                boolean $i$f$minBy2 = false;
                Object[] objectArray2 = $this$minBy$iv2;
                boolean element$iv$iv = false;
                if (objectArray2.length == 0) {
                    range = null;
                } else {
                    Object minElem$iv = $this$minBy$iv2[0];
                    int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$minBy$iv2);
                    if (lastIndex$iv == 0) {
                        range = minElem$iv;
                    } else {
                        it = minElem$iv;
                        int n = 0;
                        int n3 = $this$run.getFormat().getMaxFps();
                        Comparable comparable = it.getUpper();
                        Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"it.upper");
                        int n4 = n3 - ((Number)((Object)comparable)).intValue();
                        boolean bl9 = false;
                        int minValue$iv = Math.abs(n4);
                        n = 1;
                        n4 = lastIndex$iv;
                        if (n <= n4) {
                            while (true) {
                                void i$iv;
                                Object e$iv;
                                Object it4 = e$iv = $this$minBy$iv2[i$iv];
                                boolean bl10 = false;
                                int n5 = $this$run.getFormat().getMaxFps();
                                Comparable comparable3 = it4.getUpper();
                                Intrinsics.checkExpressionValueIsNotNull((Object)comparable3, (String)"it.upper");
                                int n6 = n5 - ((Number)((Object)comparable3)).intValue();
                                boolean bl11 = false;
                                int v$iv = Math.abs(n6);
                                if (minValue$iv > v$iv) {
                                    minElem$iv = e$iv;
                                    minValue$iv = v$iv;
                                }
                                if (i$iv == n4) break;
                                ++i$iv;
                            }
                        }
                        range = minElem$iv;
                    }
                }
            }
            if (range == null) {
                defaultCameraCaptureSource = this;
                bl = false;
                boolean bl12 = false;
                $this$run = defaultCameraCaptureSource;
                boolean bl13 = false;
                $this$run.logger.error($this$run.TAG, "No valid FPS ranges");
                $this$run.handleCameraCaptureFail(CaptureSourceError.ConfigurationFailure);
                return;
            }
            Range bestFpsRange = range;
            this.logger.info(this.TAG, "Setting target FPS range to " + bestFpsRange);
            captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range(bestFpsRange.getLower(), bestFpsRange.getUpper()));
            captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            captureRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
            if (this.getTorchEnabled()) {
                captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
            } else {
                captureRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
            }
            this.setStabilizationMode(captureRequestBuilder);
            this.setFocusMode(captureRequestBuilder);
            SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
            if (surfaceTextureCaptureSource == null || (surfaceTextureCaptureSource = surfaceTextureCaptureSource.getSurface()) == null) {
                throw (Throwable)new UnknownError("Surface texture source should not be null");
            }
            captureRequestBuilder.addTarget((Surface)surfaceTextureCaptureSource);
            CameraCaptureSession cameraCaptureSession2 = this.cameraCaptureSession;
            if (cameraCaptureSession2 != null) {
                cameraCaptureSession2.setRepeatingRequest(captureRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)this.cameraCaptureSessionCaptureCallback, this.handler);
            }
            this.logger.info(this.TAG, "Capture request completed with device ID: " + ((cameraCaptureSession = this.cameraCaptureSession) != null && (cameraCaptureSession = cameraCaptureSession.getDevice()) != null ? cameraCaptureSession.getId() : null));
            ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, createCaptureRequest.1.INSTANCE);
        }
        catch (CameraAccessException exception) {
            CameraCaptureSession cameraCaptureSession;
            this.logger.error(this.TAG, "Failed to start capture request with device ID: " + ((cameraCaptureSession = this.cameraCaptureSession) != null && (cameraCaptureSession = cameraCaptureSession.getDevice()) != null ? cameraCaptureSession.getId() : null) + ", exception:" + (Object)((Object)exception));
            this.handleCameraCaptureFail(CaptureSourceError.SystemFailure);
            return;
        }
    }

    private final void setStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
        Object object;
        CameraCharacteristics it;
        CameraCharacteristics element$iv;
        int n;
        int n2;
        Object object2;
        boolean $i$f$any;
        Object $this$any$iv;
        Object object3 = this.cameraCharacteristics;
        if (object3 != null) {
            int[] nArray = (int[])object3.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            object3 = nArray;
            if (nArray != null) {
                boolean bl;
                block8: {
                    $this$any$iv = object3;
                    $i$f$any = false;
                    object2 = $this$any$iv;
                    n2 = ((CameraCharacteristics)object2).length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = object2[n];
                        boolean bl2 = false;
                        if (!(it == true)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                if (bl) {
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    this.logger.info(this.TAG, "Using optical stabilization.");
                    return;
                }
            }
        }
        if ((object = this.cameraCharacteristics) != null) {
            int[] nArray = (int[])object.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES);
            object = nArray;
            if (nArray != null) {
                boolean bl;
                block9: {
                    $this$any$iv = object;
                    $i$f$any = false;
                    object2 = $this$any$iv;
                    n2 = ((CameraCharacteristics)object2).length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = object2[n];
                        boolean bl3 = false;
                        if (!(it == true)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
                if (bl) {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                    this.logger.info(this.TAG, "Using video stabilization.");
                    return;
                }
            }
        }
        this.logger.info(this.TAG, "Stabilization not available.");
    }

    private final void setFocusMode(CaptureRequest.Builder captureRequestBuilder) {
        Object object = this.cameraCharacteristics;
        if (object != null) {
            int[] nArray = (int[])object.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
            object = nArray;
            if (nArray != null) {
                boolean bl;
                block4: {
                    Object $this$any$iv = object;
                    boolean $i$f$any = false;
                    Object object2 = $this$any$iv;
                    int n = ((CameraCharacteristics)object2).length;
                    for (int j = 0; j < n; ++j) {
                        CameraCharacteristics element$iv;
                        CameraCharacteristics it = element$iv = object2[j];
                        boolean bl2 = false;
                        if (!(it == 3)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                if (bl) {
                    captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                    this.logger.info(this.TAG, "Using optical stabilization.");
                    return;
                }
            }
        }
        this.logger.info(this.TAG, "Auto-focus is not available.");
    }

    private final VideoRotation getCaptureFrameRotation() {
        VideoRotation videoRotation;
        int rotation;
        Object object = this.context.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        Intrinsics.checkExpressionValueIsNotNull((Object)display, (String)"windowManager.defaultDisplay");
        switch (display.getRotation()) {
            case 1: {
                int n = 90;
                break;
            }
            case 2: {
                int n = 180;
                break;
            }
            case 3: {
                int n = 270;
                break;
            }
            case 0: {
                int n = 0;
                break;
            }
            default: {
                int n = rotation = 0;
            }
        }
        if (!this.isCameraFrontFacing) {
            rotation = this.ROTATION_360_DEGREES - rotation;
        }
        if ((videoRotation = VideoRotation.Companion.from(rotation = (this.sensorOrientation + rotation) % this.ROTATION_360_DEGREES)) == null) {
            videoRotation = VideoRotation.Rotation0;
        }
        return videoRotation;
    }

    private final VideoFrameTextureBuffer createBufferWithUpdatedTransformMatrix(VideoFrameTextureBuffer buffer2, boolean mirror, int rotation) {
        Runnable runnable;
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (mirror) {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preRotate((float)rotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        Matrix newMatrix = new Matrix(buffer2.getTransformMatrix());
        newMatrix.preConcat(transformMatrix);
        buffer2.retain();
        VideoFrameTextureBuffer.Type type = buffer2.getType();
        Matrix matrix = newMatrix;
        int n = buffer2.getTextureId();
        int n2 = buffer2.getHeight();
        int n3 = buffer2.getWidth();
        boolean $i$f$Runnable = false;
        Runnable runnable2 = runnable = (Runnable)new Runnable(buffer2){
            final /* synthetic */ VideoFrameTextureBuffer $buffer$inlined;
            {
                this.$buffer$inlined = videoFrameTextureBuffer;
            }

            public final void run() {
                boolean bl = false;
                this.$buffer$inlined.release();
            }
        };
        VideoFrameTextureBuffer.Type type2 = type;
        Matrix matrix2 = matrix;
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        return new VideoFrameTextureBuffer(n6, n5, n4, matrix2, type2, runnable2);
    }

    @JvmOverloads
    public DefaultCameraCaptureSource(@NotNull Context context, @NotNull Logger logger, @NotNull SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, @NotNull CameraManager cameraManager) {
        Object v0;
        MediaDevice it;
        Iterable $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        DefaultCameraCaptureSource defaultCameraCaptureSource;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
            Intrinsics.checkParameterIsNotNull((Object)surfaceTextureCaptureSourceFactory, (String)"surfaceTextureCaptureSourceFactory");
            Intrinsics.checkParameterIsNotNull((Object)cameraManager, (String)"cameraManager");
            this.context = context;
            this.logger = logger;
            this.surfaceTextureCaptureSourceFactory = surfaceTextureCaptureSourceFactory;
            this.cameraManager = cameraManager;
            this.observers = ConcurrentSet.Companion.createConcurrentSet();
            this.sinks = ConcurrentSet.Companion.createConcurrentSet();
            this.contentHint = VideoContentHint.Motion;
            this.DESIRED_CAPTURE_FORMAT = new VideoCaptureFormat(960, 720, 30);
            this.ROTATION_360_DEGREES = 360;
            this.maxResolution = VideoResolution.VideoResolutionHD;
            this.TAG = "DefaultCameraCaptureSource";
            System.loadLibrary("amazon_chime_media_client");
            Object thread = new HandlerThread("DefaultCameraCaptureSource");
            thread.start();
            this.handler = new Handler(thread.getLooper());
            thread = MediaDevice.Companion.listVideoDevices(this.cameraManager);
            defaultCameraCaptureSource = this;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (MediaDevice)element$iv;
                boolean bl = false;
                if (!(it.getType() == MediaDeviceType.VIDEO_FRONT_CAMERA)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Object var12_12 = v0;
        DefaultCameraCaptureSource defaultCameraCaptureSource2 = defaultCameraCaptureSource;
        MediaDevice mediaDevice = var12_12;
        if (mediaDevice == null) {
            Object v3;
            block4: {
                $this$firstOrNull$iv = MediaDevice.Companion.listVideoDevices(this.cameraManager);
                defaultCameraCaptureSource = defaultCameraCaptureSource2;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (MediaDevice)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == MediaDeviceType.VIDEO_BACK_CAMERA)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            var12_12 = v3;
            defaultCameraCaptureSource2 = defaultCameraCaptureSource;
            mediaDevice = var12_12;
        }
        defaultCameraCaptureSource2.device = mediaDevice;
        this.format = this.DESIRED_CAPTURE_FORMAT;
        this.cameraDeviceStateCallback = new CameraDevice.StateCallback(this){
            final /* synthetic */ DefaultCameraCaptureSource this$0;

            public void onOpened(@NotNull CameraDevice device) {
                Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device opened for ID " + device.getId());
                DefaultCameraCaptureSource.access$setCameraDevice$p(this.this$0, device);
                try {
                    CameraDevice cameraDevice = DefaultCameraCaptureSource.access$getCameraDevice$p(this.this$0);
                    if (cameraDevice != null) {
                        SurfaceTextureCaptureSource surfaceTextureCaptureSource = DefaultCameraCaptureSource.access$getSurfaceTextureSource$p(this.this$0);
                        cameraDevice.createCaptureSession(CollectionsKt.listOf((Object)(surfaceTextureCaptureSource != null ? surfaceTextureCaptureSource.getSurface() : null)), (CameraCaptureSession.StateCallback)DefaultCameraCaptureSource.access$getCameraCaptureSessionStateCallback$p(this.this$0), DefaultCameraCaptureSource.access$getHandler$p(this.this$0));
                    }
                }
                catch (CameraAccessException exception) {
                    DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Exception encountered creating capture session: " + exception.getReason());
                    DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.SystemFailure);
                    return;
                }
            }

            public void onClosed(@NotNull CameraDevice device) {
                Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device closed for ID " + device.getId());
                ObserverUtils.Companion.notifyObserverOnMainThread(DefaultCameraCaptureSource.access$getObservers$p(this.this$0), cameraDeviceStateCallback.onClosed.1.INSTANCE);
            }

            public void onDisconnected(@NotNull CameraDevice device) {
                Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device disconnected for ID " + device.getId());
                ObserverUtils.Companion.notifyObserverOnMainThread(DefaultCameraCaptureSource.access$getObservers$p(this.this$0), cameraDeviceStateCallback.onDisconnected.1.INSTANCE);
            }

            public void onError(@NotNull CameraDevice device, int error) {
                Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).info(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera device encountered error: " + error + " for ID " + device.getId());
                DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.SystemFailure);
            }
            {
                this.this$0 = $outer;
            }
        };
        this.cameraCaptureSessionStateCallback = new CameraCaptureSession.StateCallback(this){
            final /* synthetic */ DefaultCameraCaptureSource this$0;

            public void onConfigured(@NotNull CameraCaptureSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                Logger logger = DefaultCameraCaptureSource.access$getLogger$p(this.this$0);
                String string = DefaultCameraCaptureSource.access$getTAG$p(this.this$0);
                StringBuilder stringBuilder = new StringBuilder().append("Camera capture session configured for session with device ID: ");
                CameraDevice cameraDevice = session.getDevice();
                Intrinsics.checkExpressionValueIsNotNull((Object)cameraDevice, (String)"session.device");
                logger.info(string, stringBuilder.append(cameraDevice.getId()).toString());
                DefaultCameraCaptureSource.access$setCameraCaptureSession$p(this.this$0, session);
                DefaultCameraCaptureSource.access$createCaptureRequest(this.this$0);
            }

            public void onConfigureFailed(@NotNull CameraCaptureSession session) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                Logger logger = DefaultCameraCaptureSource.access$getLogger$p(this.this$0);
                String string = DefaultCameraCaptureSource.access$getTAG$p(this.this$0);
                StringBuilder stringBuilder = new StringBuilder().append("Camera session configuration failed with device ID: ");
                CameraDevice cameraDevice = session.getDevice();
                Intrinsics.checkExpressionValueIsNotNull((Object)cameraDevice, (String)"session.device");
                logger.error(string, stringBuilder.append(cameraDevice.getId()).toString());
                DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.ConfigurationFailure);
                session.close();
            }
            {
                this.this$0 = $outer;
            }
        };
        this.cameraCaptureSessionCaptureCallback = new CameraCaptureSession.CaptureCallback(this){
            final /* synthetic */ DefaultCameraCaptureSource this$0;

            public void onCaptureFailed(@NotNull CameraCaptureSession session, @NotNull CaptureRequest request, @NotNull CaptureFailure failure) {
                Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
                Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                Intrinsics.checkParameterIsNotNull((Object)failure, (String)"failure");
                DefaultCameraCaptureSource.access$getLogger$p(this.this$0).error(DefaultCameraCaptureSource.access$getTAG$p(this.this$0), "Camera capture session failed: " + failure);
                DefaultCameraCaptureSource.access$handleCameraCaptureFail(this.this$0, CaptureSourceError.SystemFailure);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public /* synthetic */ DefaultCameraCaptureSource(Context context, Logger logger, SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, CameraManager cameraManager, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Object object = context.getSystemService("camera");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
            }
            cameraManager = (CameraManager)object;
        }
        this(context, logger, surfaceTextureCaptureSourceFactory, cameraManager);
    }

    @JvmOverloads
    public DefaultCameraCaptureSource(@NotNull Context context, @NotNull Logger logger, @NotNull SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory) {
        this(context, logger, surfaceTextureCaptureSourceFactory, null, 8, null);
    }

    public static final /* synthetic */ CameraCaptureSession access$getCameraCaptureSession$p(DefaultCameraCaptureSource $this) {
        return $this.cameraCaptureSession;
    }

    public static final /* synthetic */ void access$setCameraCaptureSession$p(DefaultCameraCaptureSource $this, CameraCaptureSession cameraCaptureSession) {
        $this.cameraCaptureSession = cameraCaptureSession;
    }

    public static final /* synthetic */ CameraDevice access$getCameraDevice$p(DefaultCameraCaptureSource $this) {
        return $this.cameraDevice;
    }

    public static final /* synthetic */ void access$setCameraDevice$p(DefaultCameraCaptureSource $this, CameraDevice cameraDevice) {
        $this.cameraDevice = cameraDevice;
    }

    public static final /* synthetic */ SurfaceTextureCaptureSource access$getSurfaceTextureSource$p(DefaultCameraCaptureSource $this) {
        return $this.surfaceTextureSource;
    }

    public static final /* synthetic */ void access$setSurfaceTextureSource$p(DefaultCameraCaptureSource $this, SurfaceTextureCaptureSource surfaceTextureCaptureSource) {
        $this.surfaceTextureSource = surfaceTextureCaptureSource;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultCameraCaptureSource $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultCameraCaptureSource $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Handler access$getHandler$p(DefaultCameraCaptureSource $this) {
        return $this.handler;
    }

    public static final /* synthetic */ cameraCaptureSessionStateCallback.1 access$getCameraCaptureSessionStateCallback$p(DefaultCameraCaptureSource $this) {
        return $this.cameraCaptureSessionStateCallback;
    }

    public static final /* synthetic */ void access$handleCameraCaptureFail(DefaultCameraCaptureSource $this, CaptureSourceError error) {
        $this.handleCameraCaptureFail(error);
    }

    public static final /* synthetic */ Set access$getObservers$p(DefaultCameraCaptureSource $this) {
        return $this.observers;
    }

    public static final /* synthetic */ void access$createCaptureRequest(DefaultCameraCaptureSource $this) {
        $this.createCaptureRequest();
    }
}

