/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.realtime;

import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.realtime.RealtimeControllerFacade;
import com.amazonaws.services.chime.sdk.meetings.realtime.RealtimeObserver;
import com.amazonaws.services.chime.sdk.meetings.realtime.TranscriptEventObserver;
import com.amazonaws.services.chime.sdk.meetings.realtime.datamessage.DataMessageObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u0016H\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/realtime/DefaultRealtimeController;", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/RealtimeControllerFacade;", "audioClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;", "audioClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "videoClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;", "videoClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;)V", "addRealtimeDataMessageObserver", "", "topic", "", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/datamessage/DataMessageObserver;", "addRealtimeObserver", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/RealtimeObserver;", "addRealtimeTranscriptEventObserver", "Lcom/amazonaws/services/chime/sdk/meetings/realtime/TranscriptEventObserver;", "realtimeIsVoiceFocusEnabled", "", "realtimeLocalMute", "realtimeLocalUnmute", "realtimeSendDataMessage", "data", "", "lifetimeMs", "", "realtimeSetVoiceFocusEnabled", "enabled", "removeRealtimeDataMessageObserverFromTopic", "removeRealtimeObserver", "removeRealtimeTranscriptEventObserver", "amazon-chime-sdk_release"})
public final class DefaultRealtimeController
implements RealtimeControllerFacade {
    private final AudioClientController audioClientController;
    private final AudioClientObserver audioClientObserver;
    private final VideoClientController videoClientController;
    private final VideoClientObserver videoClientObserver;

    @Override
    public boolean realtimeLocalMute() {
        return this.audioClientController.setMute(true);
    }

    @Override
    public boolean realtimeLocalUnmute() {
        return this.audioClientController.setMute(false);
    }

    @Override
    public void addRealtimeObserver(@NotNull RealtimeObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.audioClientObserver.subscribeToRealTimeEvents(observer);
    }

    @Override
    public void removeRealtimeObserver(@NotNull RealtimeObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.audioClientObserver.unsubscribeFromRealTimeEvents(observer);
    }

    @Override
    public void realtimeSendDataMessage(@NotNull String topic, @NotNull Object data, int lifetimeMs) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        this.videoClientController.sendDataMessage(topic, data, lifetimeMs);
    }

    @Override
    public void addRealtimeDataMessageObserver(@NotNull String topic, @NotNull DataMessageObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.videoClientObserver.subscribeToReceiveDataMessage(topic, observer);
    }

    @Override
    public void removeRealtimeDataMessageObserverFromTopic(@NotNull String topic) {
        Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
        this.videoClientObserver.unsubscribeFromReceiveDataMessage(topic);
    }

    @Override
    public boolean realtimeSetVoiceFocusEnabled(boolean enabled) {
        return this.audioClientController.setVoiceFocusEnabled(enabled);
    }

    @Override
    public boolean realtimeIsVoiceFocusEnabled() {
        return this.audioClientController.isVoiceFocusEnabled();
    }

    @Override
    public void addRealtimeTranscriptEventObserver(@NotNull TranscriptEventObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.audioClientObserver.subscribeToTranscriptEvent(observer);
    }

    @Override
    public void removeRealtimeTranscriptEventObserver(@NotNull TranscriptEventObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.audioClientObserver.unsubscribeFromTranscriptEvent(observer);
    }

    public DefaultRealtimeController(@NotNull AudioClientController audioClientController, @NotNull AudioClientObserver audioClientObserver, @NotNull VideoClientController videoClientController, @NotNull VideoClientObserver videoClientObserver) {
        Intrinsics.checkParameterIsNotNull((Object)audioClientController, (String)"audioClientController");
        Intrinsics.checkParameterIsNotNull((Object)audioClientObserver, (String)"audioClientObserver");
        Intrinsics.checkParameterIsNotNull((Object)videoClientController, (String)"videoClientController");
        Intrinsics.checkParameterIsNotNull((Object)videoClientObserver, (String)"videoClientObserver");
        this.audioClientController = audioClientController;
        this.audioClientObserver = audioClientObserver;
        this.videoClientController = videoClientController;
        this.videoClientObserver = videoClientObserver;
    }
}

