/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl;

import android.content.Context;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoRotation;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoScalingType;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglVideoRenderView;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.VideoLayoutMeasure;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultEglRenderer;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.ConsoleLogger;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J0\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\tH\u0014J\u0018\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\tH\u0014J \u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0016J\u0010\u0010>\u001a\u00020\u00162\u0006\u0010:\u001a\u00020;H\u0016J \u0010?\u001a\u00020-2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\t2\u0006\u0010=\u001a\u00020\tH\u0016J\u0010\u0010@\u001a\u00020-2\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010A\u001a\u00020-2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020-H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/TextureRenderView;", "Landroid/view/TextureView;", "Landroid/view/TextureView$SurfaceTextureListener;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglVideoRenderView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "TAG", "", "frameRotation", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoRotation;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "getLogger", "()Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "setLogger", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "value", "", "mirror", "getMirror", "()Z", "setMirror", "(Z)V", "renderer", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultEglRenderer;", "getRenderer", "()Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultEglRenderer;", "renderer$delegate", "Lkotlin/Lazy;", "rotatedFrameHeight", "rotatedFrameWidth", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;", "scalingType", "getScalingType", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;", "setScalingType", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoScalingType;)V", "videoLayoutMeasure", "Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/VideoLayoutMeasure;", "init", "", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthSpec", "heightSpec", "onSurfaceTextureAvailable", "surface", "Landroid/graphics/SurfaceTexture;", "width", "height", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "onSurfaceTextureUpdated", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "release", "amazon-chime-sdk_release"})
public class TextureRenderView
extends TextureView
implements TextureView.SurfaceTextureListener,
EglVideoRenderView {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private VideoRotation frameRotation;
    private final VideoLayoutMeasure videoLayoutMeasure;
    private final Lazy renderer$delegate;
    @NotNull
    private Logger logger;
    private final String TAG = "TextureRenderView";
    private boolean mirror;
    @NotNull
    private VideoScalingType scalingType;
    private HashMap _$_findViewCache;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TextureRenderView.class), "renderer", "getRenderer()Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultEglRenderer;"))};
    }

    private final DefaultEglRenderer getRenderer() {
        Lazy lazy = this.renderer$delegate;
        TextureRenderView textureRenderView = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (DefaultEglRenderer)lazy.getValue();
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"<set-?>");
        this.logger = logger;
    }

    public final boolean getMirror() {
        return this.mirror;
    }

    public final void setMirror(boolean value) {
        this.logger.debug(this.TAG, "Setting mirror from " + this.mirror + " to " + value);
        this.getRenderer().setMirror(value);
        this.mirror = value;
    }

    @NotNull
    public final VideoScalingType getScalingType() {
        return this.scalingType;
    }

    public final void setScalingType(@NotNull VideoScalingType value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)value), (String)"value");
        this.logger.debug(this.TAG, "Setting scaling type from " + (Object)((Object)this.scalingType) + " to " + (Object)((Object)value));
        this.videoLayoutMeasure.setScalingType(value);
        this.scalingType = value;
    }

    @Override
    public void init(@NotNull EglCoreFactory eglCoreFactory) {
        Intrinsics.checkParameterIsNotNull((Object)eglCoreFactory, (String)"eglCoreFactory");
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.logger.info(this.TAG, "Initializing render view");
        this.getRenderer().init(eglCoreFactory);
    }

    @Override
    public void release() {
        this.logger.info(this.TAG, "Releasing render view");
        this.getRenderer().release();
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        Point size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        this.logger.debug(this.TAG, "Setting measured dimensions " + size.x + 'x' + size.y);
        this.setMeasuredDimension(size.x, size.y);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.getRenderer().setAspectRatio((float)(right - left) / (float)(bottom - top));
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        if (this.rotatedFrameWidth != frame.getRotatedWidth() || this.rotatedFrameHeight != frame.getRotatedHeight() || this.frameRotation != frame.getRotation()) {
            this.rotatedFrameWidth = frame.getRotatedWidth();
            this.rotatedFrameHeight = frame.getRotatedHeight();
            this.frameRotation = frame.getRotation();
            this.logger.info(this.TAG, "Video frame rotated size changed to " + this.rotatedFrameWidth + 'x' + this.rotatedFrameHeight);
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ TextureRenderView this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            this.this$0.requestLayout();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = textureRenderView;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        this.getRenderer().onVideoFrameReceived(frame);
    }

    public void onSurfaceTextureSizeChanged(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
    }

    public void onSurfaceTextureUpdated(@NotNull SurfaceTexture surface) {
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
    }

    public boolean onSurfaceTextureDestroyed(@NotNull SurfaceTexture surface) {
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
        this.logger.info(this.TAG, "Surface destroyed, releasing EGL surface");
        this.getRenderer().releaseEglSurface();
        return true;
    }

    public void onSurfaceTextureAvailable(@NotNull SurfaceTexture surface, int width, int height) {
        Intrinsics.checkParameterIsNotNull((Object)surface, (String)"surface");
        SurfaceTexture surfaceTexture = surface;
        boolean bl = false;
        boolean bl2 = false;
        SurfaceTexture it = surfaceTexture;
        boolean bl3 = false;
        this.logger.info(this.TAG, "Surface created, creating EGL surface with resource");
        this.getRenderer().createEglSurface(it);
    }

    @JvmOverloads
    public TextureRenderView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.frameRotation = VideoRotation.Rotation0;
        this.videoLayoutMeasure = new VideoLayoutMeasure();
        this.renderer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultEglRenderer>(this){
            final /* synthetic */ TextureRenderView this$0;

            @NotNull
            public final DefaultEglRenderer invoke() {
                return new DefaultEglRenderer(this.this$0.getLogger());
            }
            {
                this.this$0 = textureRenderView;
                super(0);
            }
        }));
        this.logger = new ConsoleLogger(null, 1, null);
        this.TAG = "TextureRenderView";
        this.scalingType = VideoScalingType.AspectFill;
        this.setSurfaceTextureListener(this);
    }

    public /* synthetic */ TextureRenderView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public TextureRenderView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TextureRenderView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

