/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerpolicy;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.AttendeeInfo;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.VolumeLevel;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.activespeakerpolicy.ActiveSpeakerPolicy;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/DefaultActiveSpeakerPolicy;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/activespeakerpolicy/ActiveSpeakerPolicy;", "speakerWeight", "", "cutoffThreshold", "takeoverRate", "silenceThreshold", "(DDDD)V", "normalizeFactor", "", "speakerScores", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AttendeeInfo;", "calculateScore", "attendeeInfo", "volume", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/VolumeLevel;", "amazon-chime-sdk_release"})
public final class DefaultActiveSpeakerPolicy
implements ActiveSpeakerPolicy {
    private Map<AttendeeInfo, Double> speakerScores;
    private final int normalizeFactor = 3;
    private final double speakerWeight;
    private final double cutoffThreshold;
    private final double takeoverRate;
    private final double silenceThreshold;

    @Override
    public double calculateScore(@NotNull AttendeeInfo attendeeInfo, @NotNull VolumeLevel volume) {
        Intrinsics.checkParameterIsNotNull((Object)attendeeInfo, (String)"attendeeInfo");
        Intrinsics.checkParameterIsNotNull((Object)((Object)volume), (String)"volume");
        double normalizedVolume = (double)volume.getValue() / (double)this.normalizeFactor;
        if (!this.speakerScores.containsKey(attendeeInfo)) {
            this.speakerScores.put(attendeeInfo, 0.0);
        }
        normalizedVolume = normalizedVolume > this.silenceThreshold ? 1.0 : 0.0;
        double score = ((Number)MapsKt.getValue(this.speakerScores, (Object)attendeeInfo)).doubleValue() * this.speakerWeight + normalizedVolume * (1.0 - this.speakerWeight);
        this.speakerScores.put(attendeeInfo, score);
        Map<AttendeeInfo, Double> $this$filterKeys$iv = this.speakerScores;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<AttendeeInfo, Double> result$iv = new LinkedHashMap<AttendeeInfo, Double>();
        Map<AttendeeInfo, Double> map = $this$filterKeys$iv;
        boolean bl = false;
        for (Map.Entry<AttendeeInfo, Double> entry$iv : map.entrySet()) {
            AttendeeInfo it = entry$iv.getKey();
            boolean bl2 = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)attendeeInfo) ^ true)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$otherAttendee$currentScore = element$iv = iterator.next();
            boolean bl4 = false;
            Map.Entry entry = $dstr$otherAttendee$currentScore;
            boolean bl5 = false;
            AttendeeInfo otherAttendee = (AttendeeInfo)entry.getKey();
            entry = $dstr$otherAttendee$currentScore;
            bl5 = false;
            double currentScore = ((Number)entry.getValue()).doubleValue();
            double newOtherAttendeeScore = currentScore - this.takeoverRate * normalizedVolume;
            double d = 0.0;
            AttendeeInfo attendeeInfo2 = otherAttendee;
            Map<AttendeeInfo, Double> map3 = this.speakerScores;
            boolean bl6 = false;
            double d2 = Math.max(newOtherAttendeeScore, d);
            map3.put(attendeeInfo2, d2);
        }
        if (score < this.cutoffThreshold) {
            return 0.0;
        }
        return score;
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight, double cutoffThreshold, double takeoverRate, double silenceThreshold) {
        Map map;
        this.speakerWeight = speakerWeight;
        this.cutoffThreshold = cutoffThreshold;
        this.takeoverRate = takeoverRate;
        this.silenceThreshold = silenceThreshold;
        DefaultActiveSpeakerPolicy defaultActiveSpeakerPolicy = this;
        boolean bl = false;
        defaultActiveSpeakerPolicy.speakerScores = map = (Map)new LinkedHashMap();
        this.normalizeFactor = 3;
    }

    public /* synthetic */ DefaultActiveSpeakerPolicy(double d, double d2, double d3, double d4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = 0.9;
        }
        if ((n & 2) != 0) {
            d2 = 0.01;
        }
        if ((n & 4) != 0) {
            d3 = 0.2;
        }
        if ((n & 8) != 0) {
            d4 = 0.2;
        }
        this(d, d2, d3, d4);
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight, double cutoffThreshold, double takeoverRate) {
        this(speakerWeight, cutoffThreshold, takeoverRate, 0.0, 8, null);
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight, double cutoffThreshold) {
        this(speakerWeight, cutoffThreshold, 0.0, 0.0, 12, null);
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy(double speakerWeight) {
        this(speakerWeight, 0.0, 0.0, 0.0, 14, null);
    }

    @JvmOverloads
    public DefaultActiveSpeakerPolicy() {
        this(0.0, 0.0, 0.0, 0.0, 15, null);
    }
}

