/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.opengl.GLES20;
import com.amazonaws.services.chime.cwt.ModelState;
import com.amazonaws.services.chime.cwt.PredictResult;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.ModelShape;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.SegmentationProcessor;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultGlVideoFrameDrawer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.utils.GlTextureFrameBufferHelper;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.JniUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001dJ\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#J \u0010%\u001a\u00020#2\u0006\u0010\"\u001a\u00020#2\b\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010&\u001a\u00020\u0013J\u0016\u0010'\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020\u001dJ\u0010\u0010)\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010*\u001a\u00020+R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/BackgroundFilterVideoFrameProcessor;", "", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "context", "Landroid/content/Context;", "tag", "", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Landroid/content/Context;Ljava/lang/String;)V", "TAG", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "cachedHeight", "", "cachedWidth", "channels", "defaultInputModelShape", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/ModelShape;", "filteredByteBuffer", "Ljava/nio/ByteBuffer;", "modelStateMsg", "predictMsg", "rectDrawer", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer;", "segmentationProcessor", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/SegmentationProcessor;", "textureFrameBuffer", "Lcom/amazonaws/services/chime/sdk/meetings/utils/GlTextureFrameBufferHelper;", "drawImageWithMask", "Landroid/graphics/Bitmap;", "scaledInputBitmap", "outputBitmap", "filteredBitmap", "getByteBufferFromInputVideoFrame", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "getInputBitmap", "getProcessedFrame", "rgbaData", "getScaledInputBitmap", "inputBitmap", "getSegmentationMask", "release", "", "amazon-chime-sdk_release"})
public final class BackgroundFilterVideoFrameProcessor {
    private final DefaultGlVideoFrameDrawer rectDrawer;
    private final GlTextureFrameBufferHelper textureFrameBuffer;
    private final String TAG;
    private final SegmentationProcessor segmentationProcessor;
    private String modelStateMsg;
    private String predictMsg;
    private int cachedWidth;
    private int cachedHeight;
    private ByteBuffer filteredByteBuffer;
    private final ModelShape defaultInputModelShape;
    private final int channels;
    private final Bitmap.Config bitmapConfig;
    private final Logger logger;

    @NotNull
    public final Bitmap getInputBitmap(@NotNull VideoFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        ByteBuffer rgbaData = this.getByteBufferFromInputVideoFrame(frame);
        Bitmap inputBitmap = Bitmap.createBitmap((int)frame.getRotatedWidth(), (int)frame.getRotatedHeight(), (Bitmap.Config)this.bitmapConfig);
        inputBitmap.copyPixelsFromBuffer((Buffer)rgbaData);
        JniUtil.nativeFreeByteBuffer((ByteBuffer)rgbaData);
        Bitmap bitmap = inputBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"inputBitmap");
        return bitmap;
    }

    @NotNull
    public final ByteBuffer getByteBufferFromInputVideoFrame(@NotNull VideoFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        this.textureFrameBuffer.setSize(frame.getRotatedWidth(), frame.getRotatedHeight());
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        Matrix matrix = new Matrix();
        matrix.preTranslate(0.5f, 0.5f);
        matrix.preScale(1.0f, -1.0f);
        matrix.preTranslate(-0.5f, -0.5f);
        this.rectDrawer.drawFrame(frame, 0, 0, frame.getRotatedWidth(), frame.getRotatedHeight(), matrix);
        ByteBuffer rgbaData = JniUtil.nativeAllocateByteBuffer((int)(frame.getRotatedWidth() * frame.getRotatedHeight() * this.channels));
        GLES20.glReadPixels((int)0, (int)0, (int)frame.getRotatedWidth(), (int)frame.getRotatedHeight(), (int)6408, (int)5121, (Buffer)rgbaData);
        GlUtil.INSTANCE.checkGlError("glReadPixels");
        ByteBuffer byteBuffer = rgbaData;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"rgbaData");
        return byteBuffer;
    }

    @NotNull
    public final Bitmap getScaledInputBitmap(@NotNull VideoFrame frame, @NotNull Bitmap inputBitmap) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)inputBitmap, (String)"inputBitmap");
        int scaledHeight = this.defaultInputModelShape.getHeight();
        int scaledWidth = this.defaultInputModelShape.getWidth();
        if (frame.getRotation().getDegrees() % 180 == 0) {
            scaledHeight = this.defaultInputModelShape.getWidth();
            scaledWidth = this.defaultInputModelShape.getHeight();
        }
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)inputBitmap, (int)scaledWidth, (int)scaledHeight, (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"Bitmap.createScaledBitma\u2026dth, scaledHeight, false)");
        return bitmap;
    }

    @NotNull
    public final VideoFrame getProcessedFrame(@NotNull VideoFrame frame, @Nullable Bitmap filteredBitmap, @NotNull ByteBuffer rgbaData) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)rgbaData, (String)"rgbaData");
        if (filteredBitmap == null) {
            this.filteredByteBuffer = rgbaData;
        } else {
            ByteBuffer byteBuffer = JniUtil.nativeAllocateByteBuffer((int)(frame.getRotatedWidth() * frame.getRotatedHeight() * this.channels));
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"JniUtil.nativeAllocateBy\u2026tatedHeight() * channels)");
            ByteBuffer byteBuffer2 = this.filteredByteBuffer = byteBuffer;
            if (byteBuffer2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filteredByteBuffer");
            }
            filteredBitmap.copyPixelsToBuffer((Buffer)byteBuffer2);
            ByteBuffer byteBuffer3 = this.filteredByteBuffer;
            if (byteBuffer3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filteredByteBuffer");
            }
            byteBuffer3.position(0);
        }
        int n = frame.getRotatedWidth();
        int n2 = frame.getRotatedHeight();
        ByteBuffer byteBuffer = this.filteredByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filteredByteBuffer");
        }
        VideoFrameRGBABuffer rgbaBuffer2 = new VideoFrameRGBABuffer(n, n2, byteBuffer, frame.getRotatedWidth() * this.channels, new Runnable(this){
            final /* synthetic */ BackgroundFilterVideoFrameProcessor this$0;

            public final void run() {
                JniUtil.nativeFreeByteBuffer((ByteBuffer)BackgroundFilterVideoFrameProcessor.access$getFilteredByteBuffer$p(this.this$0));
            }
            {
                this.this$0 = backgroundFilterVideoFrameProcessor;
            }
        });
        return new VideoFrame(frame.getTimestampNs(), rgbaBuffer2, null, 4, null);
    }

    @Nullable
    public final Bitmap getSegmentationMask(@NotNull Bitmap scaledInputBitmap) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)scaledInputBitmap, (String)"scaledInputBitmap");
        if (scaledInputBitmap.getWidth() != this.cachedWidth || scaledInputBitmap.getHeight() != this.cachedHeight) {
            boolean bl2;
            String string;
            this.cachedWidth = scaledInputBitmap.getWidth();
            this.cachedHeight = scaledInputBitmap.getHeight();
            this.segmentationProcessor.initialize(scaledInputBitmap.getWidth(), scaledInputBitmap.getHeight(), this.defaultInputModelShape);
            ModelState modelState = this.segmentationProcessor.getModelState();
            if (modelState != ModelState.LOADING && modelState != ModelState.LOADED && this.modelStateMsg == null) {
                String string2 = this.modelStateMsg = "Failed to load model with model state " + modelState;
                if (string2 != null) {
                    string = string2;
                    bl2 = false;
                    bl = false;
                    String it = string;
                    boolean bl3 = false;
                    this.logger.error(this.TAG, it);
                }
            } else if (this.modelStateMsg == null) {
                String string3 = this.modelStateMsg = "Model State " + modelState;
                if (string3 != null) {
                    string = string3;
                    bl2 = false;
                    bl = false;
                    String it = string;
                    boolean bl4 = false;
                    this.logger.info(this.TAG, it);
                }
            }
        }
        ByteBuffer inputBuffer = this.segmentationProcessor.getInputBuffer();
        scaledInputBitmap.copyPixelsToBuffer((Buffer)inputBuffer);
        PredictResult predictResult = this.segmentationProcessor.predict();
        if (predictResult == PredictResult.ERROR && this.predictMsg == null) {
            String string = this.predictMsg = "Error segmenting background from foreground";
            if (string != null) {
                String string4 = string;
                bl = false;
                boolean bl5 = false;
                String it = string4;
                boolean bl6 = false;
                this.logger.error(this.TAG, it);
            }
        }
        ByteBuffer outputBuffer = this.segmentationProcessor.getOutputBuffer();
        Bitmap outputBitmap = Bitmap.createBitmap((int)scaledInputBitmap.getWidth(), (int)scaledInputBitmap.getHeight(), (Bitmap.Config)this.bitmapConfig);
        outputBitmap.copyPixelsFromBuffer((Buffer)outputBuffer);
        return outputBitmap;
    }

    @Nullable
    public final Bitmap drawImageWithMask(@NotNull Bitmap scaledInputBitmap, @Nullable Bitmap outputBitmap, @Nullable Bitmap filteredBitmap) {
        block4: {
            Canvas canvas;
            Canvas canvas2;
            Intrinsics.checkParameterIsNotNull((Object)scaledInputBitmap, (String)"scaledInputBitmap");
            Paint paint = new Paint();
            PorterDuff.Mode paintMode = PorterDuff.Mode.SRC_IN;
            paint.setXfermode((Xfermode)new PorterDuffXfermode(paintMode));
            Bitmap bitmap = outputBitmap;
            if (bitmap != null) {
                Bitmap bitmap2 = bitmap;
                boolean bl = false;
                boolean bl2 = false;
                Bitmap it = bitmap2;
                boolean bl3 = false;
                canvas2 = new Canvas(it);
            } else {
                canvas2 = null;
            }
            Canvas canvas3 = canvas = canvas2;
            if (canvas3 != null) {
                canvas3.drawBitmap(scaledInputBitmap, 0.0f, 0.0f, paint);
            }
            paintMode = PorterDuff.Mode.DST_OVER;
            paint.setXfermode((Xfermode)new PorterDuffXfermode(paintMode));
            if (filteredBitmap == null) break block4;
            Canvas canvas4 = canvas;
            if (canvas4 != null) {
                canvas4.drawBitmap(filteredBitmap, 0.0f, 0.0f, paint);
            }
        }
        return outputBitmap;
    }

    public final void release() {
        this.rectDrawer.release();
        this.textureFrameBuffer.release();
    }

    public BackgroundFilterVideoFrameProcessor(@NotNull Logger logger, @NotNull Context context, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.logger = logger;
        this.rectDrawer = new DefaultGlVideoFrameDrawer();
        this.textureFrameBuffer = new GlTextureFrameBufferHelper(6408);
        this.TAG = tag;
        this.segmentationProcessor = new SegmentationProcessor(context);
        this.defaultInputModelShape = new ModelShape(0, 0, 0, 0, 0, 31, null);
        this.channels = this.defaultInputModelShape.getChannels();
        this.bitmapConfig = Bitmap.Config.ARGB_8888;
    }

    public static final /* synthetic */ ByteBuffer access$getFilteredByteBuffer$p(BackgroundFilterVideoFrameProcessor $this) {
        ByteBuffer byteBuffer = $this.filteredByteBuffer;
        if (byteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filteredByteBuffer");
        }
        return byteBuffer;
    }

    public static final /* synthetic */ void access$setFilteredByteBuffer$p(BackgroundFilterVideoFrameProcessor $this, ByteBuffer byteBuffer) {
        $this.filteredByteBuffer = byteBuffer;
    }
}

