/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.os.Build;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/utils/DNSServerUtils;", "", "()V", "TAG", "", "getAvailableDnsServers", "", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)[Ljava/lang/String;", "amazon-chime-sdk_release"})
public final class DNSServerUtils {
    private static final String TAG = "DNSServerUtils";
    public static final DNSServerUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String[] getAvailableDnsServers(@NotNull Context context, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        List dnsHosts = new ArrayList();
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                Object object = context.getSystemService("connectivity");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
                }
                ConnectivityManager connectivityManager = (ConnectivityManager)object;
                LinkProperties linkProperties = connectivityManager.getLinkProperties(connectivityManager.getActiveNetwork());
                if (linkProperties != null) {
                    List list = linkProperties.getDnsServers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"linkProperties.dnsServers");
                    List addresses = list;
                    int n = 0;
                    int n2 = ((Collection)addresses).size();
                    while (n < n2) {
                        void i2;
                        String string = ((InetAddress)addresses.get((int)i2)).getHostAddress();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"addresses[i].hostAddress");
                        CharSequence charSequence = string;
                        boolean bl = false;
                        if (charSequence.length() > 0) {
                            String string2 = ((InetAddress)addresses.get((int)i2)).getHostAddress();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"addresses[i].hostAddress");
                            dnsHosts.add(string2);
                        }
                        ++i2;
                    }
                    logger.info(TAG, "Get " + dnsHosts.size() + " DNS addresses.");
                }
            }
            catch (Exception e) {
                logger.error(TAG, "Failed to get active DNS address.");
            }
        } else {
            try {
                Class<?> SystemProperties = Class.forName("android.os.SystemProperties");
                Method method = SystemProperties.getMethod("get", String.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"SystemProperties.getMeth\u2026get\", String::class.java)");
                Method method2 = method;
                for (String name : new String[]{"net.dns1", "net.dns2"}) {
                    Object object = method2.invoke(null, name);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    String value = (String)object;
                    CharSequence charSequence = value;
                    boolean bl = false;
                    if (!(charSequence.length() > 0)) continue;
                    dnsHosts.add(value);
                }
                logger.info(TAG, "Get " + dnsHosts.size() + " DNS addresses,");
            }
            catch (Exception e) {
                logger.error(TAG, "Failed to get active DNS address.");
            }
        }
        Collection $this$toTypedArray$iv = dnsHosts;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private DNSServerUtils() {
    }

    static {
        DNSServerUtils dNSServerUtils;
        INSTANCE = dNSServerUtils = new DNSServerUtils();
        TAG = TAG;
    }
}

