/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video.gl;

import android.graphics.Matrix;
import android.opengl.GLES20;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0010J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u000eJ\u000e\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nJ\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/GlUtil;", "", "()V", "FULL_RECTANGLE_TEXTURE_COORDINATES", "Ljava/nio/FloatBuffer;", "getFULL_RECTANGLE_TEXTURE_COORDINATES", "()Ljava/nio/FloatBuffer;", "FULL_RECTANGLE_VERTEX_COORDINATES", "getFULL_RECTANGLE_VERTEX_COORDINATES", "SIZEOF_FLOAT", "", "checkGlError", "", "op", "", "convertToGlTransformMatrix", "", "matrix", "Landroid/graphics/Matrix;", "convertToMatrix", "transformMatrix", "createFloatBuffer", "coords", "createProgram", "vertexSource", "fragmentSource", "generateTexture", "target", "loadShader", "shaderType", "source", "amazon-chime-sdk_release"})
public final class GlUtil {
    @NotNull
    private static final FloatBuffer FULL_RECTANGLE_VERTEX_COORDINATES;
    @NotNull
    private static final FloatBuffer FULL_RECTANGLE_TEXTURE_COORDINATES;
    private static final int SIZEOF_FLOAT = 4;
    public static final GlUtil INSTANCE;

    @NotNull
    public final FloatBuffer getFULL_RECTANGLE_VERTEX_COORDINATES() {
        return FULL_RECTANGLE_VERTEX_COORDINATES;
    }

    @NotNull
    public final FloatBuffer getFULL_RECTANGLE_TEXTURE_COORDINATES() {
        return FULL_RECTANGLE_TEXTURE_COORDINATES;
    }

    public final void checkGlError(@NotNull String op) {
        Intrinsics.checkParameterIsNotNull((Object)op, (String)"op");
        int error = GLES20.glGetError();
        if (error != 0) {
            throw (Throwable)new RuntimeException(op + ": OpenGLES error " + error);
        }
    }

    public final int generateTexture(int target) {
        int[] textureArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureArray, (int)0);
        int textureId = textureArray[0];
        GLES20.glBindTexture((int)target, (int)textureId);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729);
        GLES20.glTexParameterf((int)target, (int)10242, (float)33071);
        GLES20.glTexParameterf((int)target, (int)10243, (float)33071);
        this.checkGlError("Failed to generate texture");
        return textureId;
    }

    @NotNull
    public final float[] convertToGlTransformMatrix(@NotNull Matrix matrix) {
        Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
        float[] values = new float[9];
        matrix.getValues(values);
        return new float[]{values[0], values[3], 0.0f, values[6], values[1], values[4], 0.0f, values[7], 0.0f, 0.0f, 1.0f, 0.0f, values[2], values[5], 0.0f, values[8]};
    }

    @NotNull
    public final Matrix convertToMatrix(@NotNull float[] transformMatrix) {
        Intrinsics.checkParameterIsNotNull((Object)transformMatrix, (String)"transformMatrix");
        float[] values = new float[]{transformMatrix[0], transformMatrix[4], transformMatrix[12], transformMatrix[1], transformMatrix[5], transformMatrix[13], transformMatrix[3], transformMatrix[7], transformMatrix[15]};
        Matrix matrix = new Matrix();
        matrix.setValues(values);
        return matrix;
    }

    public final int createProgram(@NotNull String vertexSource, @NotNull String fragmentSource) {
        Intrinsics.checkParameterIsNotNull((Object)vertexSource, (String)"vertexSource");
        Intrinsics.checkParameterIsNotNull((Object)fragmentSource, (String)"fragmentSource");
        int vertexShader = this.loadShader(35633, vertexSource);
        int fragmentShader = this.loadShader(35632, fragmentSource);
        int program = GLES20.glCreateProgram();
        this.checkGlError("Failed to create program");
        GLES20.glAttachShader((int)program, (int)vertexShader);
        this.checkGlError("Failed to attach vertex shader");
        GLES20.glAttachShader((int)program, (int)fragmentShader);
        this.checkGlError("Failed to attach pixel shader");
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            String infoLog = GLES20.glGetProgramInfoLog((int)program);
            GLES20.glDeleteProgram((int)program);
            throw (Throwable)new InvalidParameterException("Could not link program; info log: " + infoLog);
        }
        return program;
    }

    private final int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        this.checkGlError("Failed to create shader with type " + shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            String infoLog = GLES20.glGetShaderInfoLog((int)shader);
            GLES20.glDeleteProgram((int)shader);
            throw (Throwable)new InvalidParameterException("Could not link program; info log: " + infoLog);
        }
        return shader;
    }

    private final FloatBuffer createFloatBuffer(float[] coords) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(coords.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(coords);
        floatBuffer.position(0);
        FloatBuffer floatBuffer2 = floatBuffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)floatBuffer2, (String)"floatBuffer");
        return floatBuffer2;
    }

    private GlUtil() {
    }

    static {
        GlUtil glUtil;
        INSTANCE = glUtil = new GlUtil();
        FULL_RECTANGLE_VERTEX_COORDINATES = glUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
        FULL_RECTANGLE_TEXTURE_COORDINATES = glUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    }
}

