/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video.gl;

import android.graphics.Matrix;
import android.opengl.GLES20;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameI420Buffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultGlVideoFrameDrawer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultGlVideoFrameDrawer$WhenMappings;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlVideoFrameDrawer;
import com.xodee.client.video.YuvUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0015\n\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0003+,-B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J:\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\rH\u0016J:\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J:\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J<\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u001a\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00042\b\u0010\"\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010*\u001a\u00020\u0015H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/GlVideoFrameDrawer;", "()V", "currentShaderType", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$Companion$ShaderType;", "i420Uploader", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$I420BufferTextureUploader;", "program", "", "renderDestinationPoints", "", "renderHeight", "renderMatrix", "Landroid/graphics/Matrix;", "renderWidth", "rgbaUploader", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$RGBABufferTextureUploader;", "textureCoordinateLocation", "textureMatrixLocation", "vertexPositionLocation", "calculateTransformedRenderSize", "", "frameWidth", "frameHeight", "drawFrame", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "viewportX", "viewportY", "viewportWidth", "viewportHeight", "additionalRenderMatrix", "drawTexture2d", "textureId", "texMatrix", "drawTextureOes", "oesTextureId", "drawYuv", "yuvTextures", "", "prepareShader", "shaderType", "release", "Companion", "I420BufferTextureUploader", "RGBABufferTextureUploader", "amazon-chime-sdk_release"})
public final class DefaultGlVideoFrameDrawer
implements GlVideoFrameDrawer {
    private Companion.ShaderType currentShaderType;
    private int program = -1;
    private int vertexPositionLocation;
    private int textureCoordinateLocation;
    private int textureMatrixLocation;
    private final Matrix renderMatrix = new Matrix();
    private final float[] renderDestinationPoints = new float[6];
    private int renderWidth;
    private int renderHeight;
    private I420BufferTextureUploader i420Uploader = new I420BufferTextureUploader();
    private RGBABufferTextureUploader rgbaUploader = new RGBABufferTextureUploader();
    private static final float[] srcPoints;
    private static final String INPUT_VERTEX_COORDINATE_NAME = "aPosition";
    private static final String INPUT_TEXTURE_COORDINATE_NAME = "aTextureCoordinate";
    private static final String TEXTURE_MATRIX_NAME = "uTextureMatrix";
    private static final String VERTEX_SHADER = "\n        varying vec2 vTextureCoordinate;\n        attribute vec4 aPosition;\n        attribute vec4 aTextureCoordinate;\n        uniform mat4 uTextureMatrix;\n        void main() {\n            gl_Position = aPosition;\n            vTextureCoordinate = (uTextureMatrix * aTextureCoordinate).xy;\n        }\n        ";
    private static final String INPUT_TEXTURE_NAME = "sTexture";
    private static final String FRAGMENT_SHADER_OES = "\n        #extension GL_OES_EGL_image_external : require\n        precision mediump float;\n        varying vec2 vTextureCoordinate;\n        uniform samplerExternalOES sTexture;\n        void main() {\n            gl_FragColor = texture2D(sTexture, vTextureCoordinate);\n        }\n        ";
    private static final String FRAGMENT_SHADER_RGB = "\n        precision mediump float;\n        varying vec2 vTextureCoordinate;\n        uniform sampler2D sTexture;\n        void main() {\n            gl_FragColor = texture2D(sTexture, vTextureCoordinate);\n        }\n        ";
    private static final String INPUT_TEXTURE_Y_NAME = "sTextureY";
    private static final String INPUT_TEXTURE_U_NAME = "sTextureU";
    private static final String INPUT_TEXTURE_V_NAME = "sTextureV";
    private static final String FRAGMENT_SHADER_YUV = "\n        precision mediump float;\n        varying vec2 vTextureCoordinate;\n        uniform sampler2D sTextureY;\n        uniform sampler2D sTextureU;\n        uniform sampler2D sTextureV;\n        vec4 sample(vec2 p) {\n            float y = texture2D(sTextureY, p).r * 1.16438;\n            float u = texture2D(sTextureU, p).r;\n            float v = texture2D(sTextureV, p).r;\n            return vec4(y + 1.59603 * v - 0.874202,\n                        y - 0.391762 * u - 0.812968 * v + 0.531668,\n                        y + 2.01723 * u - 1.08563, 1);\n        }\n        void main() {\n            gl_FragColor = sample(vTextureCoordinate);\n        }\n        ";
    public static final Companion Companion;

    @Override
    public void drawFrame(@NotNull VideoFrame frame, int viewportX, int viewportY, int viewportWidth, int viewportHeight, @Nullable Matrix additionalRenderMatrix) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        boolean isTextureFrame = frame.getBuffer() instanceof VideoFrameTextureBuffer;
        int width = frame.getRotatedWidth();
        int height = frame.getRotatedHeight();
        this.calculateTransformedRenderSize(width, height, additionalRenderMatrix);
        if (this.renderWidth <= 0 || this.renderHeight <= 0) {
            return;
        }
        this.renderMatrix.reset();
        this.renderMatrix.preTranslate(0.5f, 0.5f);
        if (frame.getBuffer() instanceof VideoFrameI420Buffer) {
            this.renderMatrix.preScale(1.0f, -1.0f);
        }
        this.renderMatrix.preRotate((float)frame.getRotation().getDegrees());
        this.renderMatrix.preTranslate(-0.5f, -0.5f);
        if (additionalRenderMatrix != null) {
            this.renderMatrix.preConcat(additionalRenderMatrix);
        }
        if (isTextureFrame) {
            VideoFrameBuffer videoFrameBuffer = frame.getBuffer();
            if (videoFrameBuffer == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer");
            }
            VideoFrameTextureBuffer textureBuffer = (VideoFrameTextureBuffer)videoFrameBuffer;
            Matrix finalMatrix = new Matrix(textureBuffer.getTransformMatrix());
            finalMatrix.preConcat(this.renderMatrix);
            float[] finalGlMatrix = GlUtil.INSTANCE.convertToGlTransformMatrix(finalMatrix);
            switch (DefaultGlVideoFrameDrawer$WhenMappings.$EnumSwitchMapping$0[textureBuffer.getType().ordinal()]) {
                case 1: {
                    this.drawTextureOes(textureBuffer.getTextureId(), finalGlMatrix, viewportX, viewportY, viewportWidth, viewportHeight);
                    break;
                }
                case 2: {
                    this.drawTexture2d(textureBuffer.getTextureId(), finalGlMatrix, viewportX, viewportY, viewportWidth, viewportHeight);
                }
            }
        } else if (frame.getBuffer() instanceof VideoFrameI420Buffer) {
            if (this.i420Uploader == null) {
                this.i420Uploader = new I420BufferTextureUploader();
            }
            I420BufferTextureUploader i420BufferTextureUploader = this.i420Uploader;
            if (i420BufferTextureUploader != null) {
                I420BufferTextureUploader textureBuffer = i420BufferTextureUploader;
                boolean bl = false;
                boolean bl2 = false;
                I420BufferTextureUploader it = textureBuffer;
                boolean bl3 = false;
                it.uploadFromBuffer((VideoFrameI420Buffer)frame.getBuffer());
                this.drawYuv(it.getYuvTextures(), GlUtil.INSTANCE.convertToGlTransformMatrix(this.renderMatrix), viewportX, viewportY, viewportWidth, viewportHeight);
            }
        } else if (frame.getBuffer() instanceof VideoFrameRGBABuffer) {
            Integer textureId;
            RGBABufferTextureUploader rGBABufferTextureUploader = this.rgbaUploader;
            Integer n = textureId = rGBABufferTextureUploader != null ? Integer.valueOf(rGBABufferTextureUploader.uploadFromBuffer((VideoFrameRGBABuffer)frame.getBuffer())) : null;
            if (textureId != null) {
                this.drawTexture2d(textureId, GlUtil.INSTANCE.convertToGlTransformMatrix(this.renderMatrix), viewportX, viewportY, viewportWidth, viewportHeight);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateTransformedRenderSize(int frameWidth, int frameHeight, Matrix renderMatrix) {
        if (renderMatrix == null) {
            this.renderWidth = frameWidth;
            this.renderHeight = frameHeight;
            return;
        }
        renderMatrix.mapPoints(this.renderDestinationPoints, srcPoints);
        int n = 0;
        int n2 = 2;
        while (n <= n2) {
            void i2;
            this.renderDestinationPoints[i2 * 2 + false] = this.renderDestinationPoints[i2 * 2 + false] * (float)frameWidth;
            this.renderDestinationPoints[i2 * 2 + true] = this.renderDestinationPoints[i2 * 2 + true] * (float)frameHeight;
            ++i2;
        }
        calculateTransformedRenderSize.1 $fun$distance$1 = calculateTransformedRenderSize.1.INSTANCE;
        this.renderWidth = $fun$distance$1.invoke(this.renderDestinationPoints[0], this.renderDestinationPoints[1], this.renderDestinationPoints[2], this.renderDestinationPoints[3]);
        this.renderHeight = $fun$distance$1.invoke(this.renderDestinationPoints[0], this.renderDestinationPoints[1], this.renderDestinationPoints[4], this.renderDestinationPoints[5]);
    }

    private final void drawTextureOes(int oesTextureId, float[] texMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(Companion.ShaderType.TEXTURE_OES, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)oesTextureId);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.INSTANCE.checkGlError("Failed to draw GL_TEXTURE_EXTERNAL_OES texture");
        GLES20.glBindTexture((int)36197, (int)0);
    }

    private final void drawTexture2d(int textureId, float[] texMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(Companion.ShaderType.TEXTURE_2D, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.INSTANCE.checkGlError("Failed to draw GL_TEXTURE_2D texture");
        GLES20.glBindTexture((int)3553, (int)0);
    }

    private final void drawYuv(int[] yuvTextures, float[] texMatrix, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        int i2;
        this.prepareShader(Companion.ShaderType.YUV, texMatrix);
        int n = 0;
        int n2 = 2;
        while (n <= n2) {
            GLES20.glActiveTexture((int)(33984 + i2));
            if (yuvTextures == null) {
                Intrinsics.throwNpe();
            }
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i2]);
            ++i2;
        }
        GLES20.glViewport((int)viewportX, (int)viewportY, (int)viewportWidth, (int)viewportHeight);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtil.INSTANCE.checkGlError("Failed to draw YUV textures");
        n2 = 2;
        for (i2 = 0; i2 <= n2; ++i2) {
            GLES20.glActiveTexture((int)(33984 + i2));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    private final void prepareShader(Companion.ShaderType shaderType, float[] texMatrix) {
        if (this.currentShaderType != shaderType) {
            Companion.ShaderType shaderType2;
            String string;
            Ref.ObjectRef fragmentShader = new Ref.ObjectRef();
            Companion.ShaderType shaderType3 = shaderType;
            DefaultGlVideoFrameDrawer defaultGlVideoFrameDrawer = this;
            boolean bl = false;
            boolean bl2 = false;
            Companion.ShaderType it = shaderType3;
            boolean bl3 = false;
            switch (DefaultGlVideoFrameDrawer$WhenMappings.$EnumSwitchMapping$1[shaderType.ordinal()]) {
                case 1: {
                    string = FRAGMENT_SHADER_OES;
                    break;
                }
                case 2: {
                    string = FRAGMENT_SHADER_RGB;
                    break;
                }
                case 3: {
                    string = FRAGMENT_SHADER_YUV;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            fragmentShader.element = string;
            defaultGlVideoFrameDrawer.currentShaderType = shaderType2 = shaderType3;
            if (this.program != -1) {
                GLES20.glDeleteProgram((int)this.program);
            }
            this.program = GlUtil.INSTANCE.createProgram(VERTEX_SHADER, (String)fragmentShader.element);
            GLES20.glUseProgram((int)this.program);
            GlUtil.INSTANCE.checkGlError("Failed to create program");
            if (shaderType == Companion.ShaderType.YUV) {
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_Y_NAME), (int)0);
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_U_NAME), (int)1);
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_V_NAME), (int)2);
            } else {
                GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)this.program, (String)INPUT_TEXTURE_NAME), (int)0);
            }
            GlUtil.INSTANCE.checkGlError("Failed to setup program texture inputs");
            this.textureMatrixLocation = GLES20.glGetUniformLocation((int)this.program, (String)TEXTURE_MATRIX_NAME);
            this.vertexPositionLocation = GLES20.glGetAttribLocation((int)this.program, (String)INPUT_VERTEX_COORDINATE_NAME);
            this.textureCoordinateLocation = GLES20.glGetAttribLocation((int)this.program, (String)INPUT_TEXTURE_COORDINATE_NAME);
            if (this.textureMatrixLocation == -1 || this.vertexPositionLocation == -1 || this.textureCoordinateLocation == -1) {
                throw (Throwable)new InvalidParameterException("Failed to get shader locations");
            }
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.INSTANCE.checkGlError("Failed to use program");
        GLES20.glEnableVertexAttribArray((int)this.vertexPositionLocation);
        GLES20.glVertexAttribPointer((int)this.vertexPositionLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)GlUtil.INSTANCE.getFULL_RECTANGLE_VERTEX_COORDINATES());
        GLES20.glEnableVertexAttribArray((int)this.textureCoordinateLocation);
        GLES20.glVertexAttribPointer((int)this.textureCoordinateLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)GlUtil.INSTANCE.getFULL_RECTANGLE_TEXTURE_COORDINATES());
        GLES20.glUniformMatrix4fv((int)this.textureMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GlUtil.INSTANCE.checkGlError("Failed to upload shader inputs");
    }

    @Override
    public void release() {
        I420BufferTextureUploader i420BufferTextureUploader = this.i420Uploader;
        if (i420BufferTextureUploader != null) {
            i420BufferTextureUploader.release();
        }
        this.i420Uploader = null;
        RGBABufferTextureUploader rGBABufferTextureUploader = this.rgbaUploader;
        if (rGBABufferTextureUploader != null) {
            rGBABufferTextureUploader.release();
        }
        this.rgbaUploader = null;
        this.currentShaderType = null;
        if (this.program != -1) {
            GLES20.glUseProgram((int)0);
            GLES20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
    }

    static {
        Companion = new Companion(null);
        srcPoints = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        INPUT_VERTEX_COORDINATE_NAME = INPUT_VERTEX_COORDINATE_NAME;
        INPUT_TEXTURE_COORDINATE_NAME = INPUT_TEXTURE_COORDINATE_NAME;
        TEXTURE_MATRIX_NAME = TEXTURE_MATRIX_NAME;
        VERTEX_SHADER = VERTEX_SHADER;
        INPUT_TEXTURE_NAME = INPUT_TEXTURE_NAME;
        FRAGMENT_SHADER_OES = FRAGMENT_SHADER_OES;
        FRAGMENT_SHADER_RGB = FRAGMENT_SHADER_RGB;
        INPUT_TEXTURE_Y_NAME = INPUT_TEXTURE_Y_NAME;
        INPUT_TEXTURE_U_NAME = INPUT_TEXTURE_U_NAME;
        INPUT_TEXTURE_V_NAME = INPUT_TEXTURE_V_NAME;
        FRAGMENT_SHADER_YUV = FRAGMENT_SHADER_YUV;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ3\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$I420BufferTextureUploader;", "", "()V", "copyBuffer", "Ljava/nio/ByteBuffer;", "yuvTextures", "", "getYuvTextures", "()[I", "setYuvTextures", "([I)V", "release", "", "uploadFromBuffer", "buffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameI420Buffer;", "uploadYuvData", "width", "", "height", "strides", "planes", "", "(II[I[Ljava/nio/ByteBuffer;)[I", "amazon-chime-sdk_release"})
    private static final class I420BufferTextureUploader {
        private ByteBuffer copyBuffer;
        @Nullable
        private int[] yuvTextures;

        @Nullable
        public final int[] getYuvTextures() {
            return this.yuvTextures;
        }

        public final void setYuvTextures(@Nullable int[] nArray) {
            this.yuvTextures = nArray;
        }

        @NotNull
        public final int[] uploadFromBuffer(@NotNull VideoFrameI420Buffer buffer2) {
            Intrinsics.checkParameterIsNotNull((Object)buffer2, (String)"buffer");
            int[] strides = new int[]{buffer2.getStrideY(), buffer2.getStrideU(), buffer2.getStrideV()};
            ByteBuffer[] planes = new ByteBuffer[]{buffer2.getDataY(), buffer2.getDataU(), buffer2.getDataV()};
            return this.uploadYuvData(buffer2.getWidth(), buffer2.getHeight(), strides, planes);
        }

        public final void release() {
            block0: {
                this.copyBuffer = null;
                if (this.yuvTextures == null) break block0;
                int[] nArray = this.yuvTextures;
                boolean bl = false;
                boolean bl2 = false;
                int[] it = nArray;
                boolean bl3 = false;
                GLES20.glDeleteTextures((int)3, (int[])it, (int)0);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final int[] uploadYuvData(int width, int height, int[] strides, ByteBuffer[] planes) {
            boolean bl;
            int n;
            int[] planeWidths = new int[]{width, width / 2, width / 2};
            int[] planeHeights = new int[]{height, height / 2, height / 2};
            int copyCapacityNeeded = 0;
            int n2 = 0;
            int n3 = 2;
            while (n2 <= n3) {
                void i2;
                if (strides[i2] > planeWidths[i2]) {
                    n = planeWidths[i2] * planeHeights[i2];
                    bl = false;
                    copyCapacityNeeded = Math.max(copyCapacityNeeded, n);
                }
                ++i2;
            }
            ByteBuffer byteBuffer = this.copyBuffer;
            if ((byteBuffer != null ? byteBuffer.capacity() : 0) < copyCapacityNeeded) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            int[] nArray = this.yuvTextures;
            if (this.yuvTextures == null) {
                I420BufferTextureUploader i420BufferTextureUploader = this;
                n = 0;
                bl = false;
                I420BufferTextureUploader $this$run = i420BufferTextureUploader;
                boolean bl2 = false;
                int[] nArray2 = new int[3];
                I420BufferTextureUploader i420BufferTextureUploader2 = $this$run;
                boolean bl3 = false;
                boolean bl4 = false;
                int[] it = nArray2;
                boolean bl5 = false;
                int n4 = 0;
                int n5 = 2;
                while (n4 <= n5) {
                    void i3;
                    it[i3] = GlUtil.INSTANCE.generateTexture(3553);
                    ++i3;
                }
                int[] nArray3 = nArray2;
                i420BufferTextureUploader2.yuvTextures = nArray3;
                nArray = $this$run.yuvTextures;
                if ($this$run.yuvTextures == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.IntArray");
                }
            }
            int[] validYuvTextures = nArray;
            n3 = 0;
            n = 2;
            while (n3 <= n) {
                ByteBuffer byteBuffer2;
                void i4;
                GLES20.glActiveTexture((int)(33984 + i4));
                GLES20.glBindTexture((int)3553, (int)validYuvTextures[i4]);
                if (strides[i4] == planeWidths[i4]) {
                    byteBuffer2 = planes[i4];
                } else {
                    YuvUtil.copyPlane((ByteBuffer)planes[i4], (int)strides[i4], (ByteBuffer)this.copyBuffer, (int)planeWidths[i4], (int)planeWidths[i4], (int)planeHeights[i4]);
                    byteBuffer2 = this.copyBuffer;
                    if (byteBuffer2 == null) {
                        return new int[0];
                    }
                }
                ByteBuffer packedByteBuffer = byteBuffer2;
                GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)planeWidths[i4], (int)planeHeights[i4], (int)0, (int)6409, (int)5121, (Buffer)packedByteBuffer);
                ++i4;
            }
            return validYuvTextures;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ(\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0006H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$RGBABufferTextureUploader;", "", "()V", "copyBuffer", "Ljava/nio/ByteBuffer;", "textureId", "", "getTextureId", "()I", "setTextureId", "(I)V", "release", "", "uploadFromBuffer", "buffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameRGBABuffer;", "uploadRgbaData", "width", "height", "data", "stride", "amazon-chime-sdk_release"})
    private static final class RGBABufferTextureUploader {
        private ByteBuffer copyBuffer;
        private int textureId;

        public final int getTextureId() {
            return this.textureId;
        }

        public final void setTextureId(int n) {
            this.textureId = n;
        }

        public final int uploadFromBuffer(@NotNull VideoFrameRGBABuffer buffer2) {
            Intrinsics.checkParameterIsNotNull((Object)buffer2, (String)"buffer");
            return this.uploadRgbaData(buffer2.getWidth(), buffer2.getHeight(), buffer2.getData(), buffer2.getStride());
        }

        public final void release() {
            this.copyBuffer = null;
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.textureId}, (int)0);
            this.textureId = 0;
        }

        private final int uploadRgbaData(int width, int height, ByteBuffer data, int stride) {
            ByteBuffer byteBuffer;
            int copyCapacityNeeded = 0;
            if (stride > width * 4) {
                int n = width * 4 * height;
                boolean bl = false;
                copyCapacityNeeded = Math.max(copyCapacityNeeded, n);
            }
            ByteBuffer byteBuffer2 = this.copyBuffer;
            if ((byteBuffer2 != null ? byteBuffer2.capacity() : 0) < copyCapacityNeeded) {
                this.copyBuffer = ByteBuffer.allocateDirect(copyCapacityNeeded);
            }
            int textureId = this.textureId == 0 ? GlUtil.INSTANCE.generateTexture(3553) : this.textureId;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureId);
            if (stride == width * 4) {
                byteBuffer = data;
            } else {
                YuvUtil.copyPlane((ByteBuffer)data, (int)stride, (ByteBuffer)this.copyBuffer, (int)(width * 4), (int)width, (int)height);
                byteBuffer = this.copyBuffer;
                if (byteBuffer == null) {
                    return 0;
                }
            }
            ByteBuffer packedByteBuffer = byteBuffer;
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (Buffer)packedByteBuffer);
            return textureId;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$Companion;", "", "()V", "FRAGMENT_SHADER_OES", "", "FRAGMENT_SHADER_RGB", "FRAGMENT_SHADER_YUV", "INPUT_TEXTURE_COORDINATE_NAME", "INPUT_TEXTURE_NAME", "INPUT_TEXTURE_U_NAME", "INPUT_TEXTURE_V_NAME", "INPUT_TEXTURE_Y_NAME", "INPUT_VERTEX_COORDINATE_NAME", "TEXTURE_MATRIX_NAME", "VERTEX_SHADER", "srcPoints", "", "ShaderType", "amazon-chime-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer$Companion$ShaderType;", "", "(Ljava/lang/String;I)V", "TEXTURE_OES", "TEXTURE_2D", "YUV", "amazon-chime-sdk_release"})
        private static final class ShaderType
        extends Enum<ShaderType> {
            public static final /* enum */ ShaderType TEXTURE_OES;
            public static final /* enum */ ShaderType TEXTURE_2D;
            public static final /* enum */ ShaderType YUV;
            private static final /* synthetic */ ShaderType[] $VALUES;

            static {
                ShaderType[] shaderTypeArray = new ShaderType[3];
                ShaderType[] shaderTypeArray2 = shaderTypeArray;
                shaderTypeArray[0] = TEXTURE_OES = new ShaderType();
                shaderTypeArray[1] = TEXTURE_2D = new ShaderType();
                shaderTypeArray[2] = YUV = new ShaderType();
                $VALUES = shaderTypeArray;
            }

            public static ShaderType[] values() {
                return (ShaderType[])$VALUES.clone();
            }

            public static ShaderType valueOf(String string) {
                return Enum.valueOf(ShaderType.class, string);
            }
        }
    }
}

