/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video;

import android.content.Context;
import android.opengl.EGLContext;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.PrimaryMeetingPromotionObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.RemoteVideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSubscriptionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultCameraCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultSurfaceTextureCaptureSourceFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDevice;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.AppInfoUtil;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientLifecycleHandler;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientStateController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoSourceAdapter;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionCredentials;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatus;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.google.gson.Gson;
import com.xodee.client.video.RemoteVideoSourceInternal;
import com.xodee.client.video.VideoClient;
import com.xodee.client.video.VideoClientConfig;
import com.xodee.client.video.VideoClientConfigBuilder;
import com.xodee.client.video.VideoPriorityInternal;
import com.xodee.client.video.VideoResolutionInternal;
import com.xodee.client.video.VideoSubscriptionConfigurationInternal;
import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020.H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u00020\fH\u0016J\b\u00103\u001a\u00020.H\u0016J\u0018\u00104\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J \u00109\u001a\u00020.2\u0006\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0015H\u0016J\u0018\u0010>\u001a\u00020.2\u0006\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\u0015H\u0016J\b\u0010A\u001a\u00020.H\u0016J\b\u0010B\u001a\u00020.H\u0016J\u0010\u0010B\u001a\u00020.2\u0006\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020.H\u0016J\b\u0010F\u001a\u00020.H\u0016J\b\u0010G\u001a\u00020.H\u0016J\b\u0010H\u001a\u00020.H\u0002J\b\u0010I\u001a\u00020.H\u0016J\b\u0010J\u001a\u00020.H\u0016J\b\u0010K\u001a\u00020.H\u0016J\b\u0010L\u001a\u00020.H\u0016J/\u0010M\u001a\u00020.2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020Q0O2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020P0SH\u0016\u00a2\u0006\u0002\u0010TR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/DefaultVideoClientController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientLifecycleHandler;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "videoClientStateController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientStateController;", "videoClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;", "configuration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "videoClientFactory", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientFactory;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientStateController;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientFactory;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;)V", "DATA_MAX_SIZE", "", "TAG", "", "TOPIC_REGEX", "Lkotlin/text/Regex;", "VIDEO_CLIENT_FLAG_DISABLE_CAPTURER", "VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P", "VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS", "VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE", "VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS", "VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER", "VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX", "cameraCaptureSource", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultCameraCaptureSource;", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "gson", "Lcom/google/gson/Gson;", "isUsingInternalCaptureSource", "", "videoClient", "Lcom/xodee/client/video/VideoClient;", "videoSourceAdapter", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter;", "demoteFromPrimaryMeeting", "", "destroyVideoClient", "getActiveCamera", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "getConfiguration", "initializeVideoClient", "promoteToPrimaryMeeting", "credentials", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/PrimaryMeetingPromotionObserver;", "sendDataMessage", "topic", "data", "", "lifetimeMs", "setRemotePaused", "isPaused", "videoId", "start", "startLocalVideo", "source", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "startRemoteVideo", "startVideoClient", "stopAndDestroy", "stopInternalCaptureSourceIfRunning", "stopLocalVideo", "stopRemoteVideo", "stopVideoClient", "switchCamera", "updateVideoSourceSubscriptions", "addedOrUpdated", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSubscriptionConfiguration;", "removed", "", "(Ljava/util/Map;[Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;)V", "amazon-chime-sdk_release"})
public final class DefaultVideoClientController
implements VideoClientController,
VideoClientLifecycleHandler {
    private final int DATA_MAX_SIZE = 2048;
    private final Regex TOPIC_REGEX;
    private final String TAG = "DefaultVideoClientController";
    private final int VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE = 32;
    private final int VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER = 64;
    private final int VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS = 4096;
    private final int VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P = 16384;
    private final int VIDEO_CLIENT_FLAG_DISABLE_CAPTURER = 0x100000;
    private final int VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX = 0x1000000;
    private final int VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS = 0x4000000;
    private final Gson gson;
    private final DefaultCameraCaptureSource cameraCaptureSource;
    private VideoSourceAdapter videoSourceAdapter;
    private boolean isUsingInternalCaptureSource;
    private VideoClient videoClient;
    private EglCore eglCore;
    private final Context context;
    private final Logger logger;
    private final VideoClientStateController videoClientStateController;
    private final VideoClientObserver videoClientObserver;
    private final MeetingSessionConfiguration configuration;
    private final VideoClientFactory videoClientFactory;
    private final EglCoreFactory eglCoreFactory;
    private final EventAnalyticsController eventAnalyticsController;

    @Override
    public void start() {
        if (this.eglCore == null) {
            this.eglCore = this.eglCoreFactory.createEglCore();
        }
        this.videoClientStateController.start();
    }

    @Override
    public void stopAndDestroy() {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultVideoClientController this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        DefaultVideoClientController.access$getVideoClientObserver$p(this.this$0).setPrimaryMeetingPromotionObserver(null);
                        DefaultVideoClientController.access$getVideoClientStateController$p(this.this$0).stop();
                        EglCore eglCore = DefaultVideoClientController.access$getEglCore$p(this.this$0);
                        if (eglCore != null) {
                            eglCore.release();
                        }
                        DefaultVideoClientController.access$setEglCore$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultVideoClientController;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void startLocalVideo() {
        if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
            return;
        }
        this.videoSourceAdapter.setSource(this.cameraCaptureSource);
        this.logger.info(this.TAG, "Setting external video source in media client to internal camera source");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            EglCore eglCore = this.eglCore;
            videoClient.setExternalVideoSource((com.xodee.client.video.VideoSource)this.videoSourceAdapter, (EGLContext)(eglCore != null ? eglCore.getEglContext() : null));
        }
        VideoClient videoClient2 = this.videoClient;
        if (videoClient2 != null) {
            videoClient2.setSending(Boolean.valueOf(true));
        }
        this.cameraCaptureSource.start();
        this.isUsingInternalCaptureSource = true;
    }

    @Override
    public void startLocalVideo(@NotNull VideoSource source) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            this.stopInternalCaptureSourceIfRunning();
            this.videoSourceAdapter.setSource(source);
            this.logger.info(this.TAG, "Setting external video source in media client to custom source");
            VideoClient videoClient = this.videoClient;
            if (videoClient != null) {
                EglCore eglCore = this.eglCore;
                videoClient.setExternalVideoSource((com.xodee.client.video.VideoSource)this.videoSourceAdapter, (EGLContext)(eglCore != null ? eglCore.getEglContext() : null));
            }
            VideoClient videoClient2 = this.videoClient;
            if (videoClient2 == null) break block2;
            videoClient2.setSending(Boolean.valueOf(true));
        }
    }

    @Override
    public void stopLocalVideo() {
        if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
            return;
        }
        this.logger.info(this.TAG, "Stopping local video");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            videoClient.setSending(Boolean.valueOf(false));
        }
        this.stopInternalCaptureSourceIfRunning();
    }

    @Override
    public void startRemoteVideo() {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            this.logger.info(this.TAG, "Starting remote video");
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.setReceiving(Boolean.valueOf(true));
        }
    }

    @Override
    public void stopRemoteVideo() {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            this.logger.info(this.TAG, "Stopping remote video");
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.setReceiving(Boolean.valueOf(false));
        }
    }

    @Override
    @Nullable
    public MediaDevice getActiveCamera() {
        if (this.isUsingInternalCaptureSource) {
            return this.cameraCaptureSource.getDevice();
        }
        return null;
    }

    @Override
    public void switchCamera() {
        this.cameraCaptureSource.switchCamera();
    }

    @Override
    public void setRemotePaused(boolean isPaused, int videoId) {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.STARTED)) {
                return;
            }
            this.logger.info(this.TAG, "Set pause for videoId: " + videoId + ", isPaused: " + isPaused);
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.setRemotePause(videoId, isPaused);
        }
    }

    @Override
    @NotNull
    public MeetingSessionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void sendDataMessage(@NotNull String topic, @NotNull Object data, int lifetimeMs) {
        block9: {
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)topic, (String)"topic");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            if (!this.videoClientStateController.canAct(VideoClientState.STARTED)) {
                return;
            }
            Object object = data;
            if (!(object instanceof byte[])) {
                object = null;
            }
            if ((byArray = (byte[])object) == null) {
                boolean bl;
                Charset charset;
                String string;
                if (data instanceof String) {
                    string = (String)data;
                    charset = Charsets.UTF_8;
                    bl = false;
                    byte[] byArray2 = string.getBytes(charset);
                    byArray = byArray2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                } else {
                    String string2 = this.gson.toJson(data);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gson.toJson(data)");
                    string = string2;
                    charset = Charsets.UTF_8;
                    bl = false;
                    String string3 = string;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray3 = string3.getBytes(charset);
                    byArray = byArray3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
                }
            }
            byte[] byteArray = byArray;
            if (!this.TOPIC_REGEX.matches((CharSequence)topic)) {
                throw (Throwable)new InvalidParameterException("Invalid topic");
            }
            if (byteArray.length > this.DATA_MAX_SIZE) {
                throw (Throwable)new InvalidParameterException("Data size has to be less than or equal to 2048 bytes");
            }
            if (lifetimeMs < 0) {
                throw (Throwable)new InvalidParameterException("The life time of the message has to be non negative");
            }
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block9;
            videoClient.sendDataMessage(topic, byteArray, lifetimeMs);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateVideoSourceSubscriptions(@NotNull Map<RemoteVideoSource, VideoSubscriptionConfiguration> addedOrUpdated, @NotNull RemoteVideoSource[] removed) {
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(addedOrUpdated, (String)"addedOrUpdated");
            Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                return;
            }
            for (RemoteVideoSource key : addedOrUpdated.keySet()) {
                VideoSubscriptionConfiguration videoSubscriptionConfiguration = addedOrUpdated.get(key);
                VideoSubscriptionConfiguration videoSubscriptionConfiguration2 = addedOrUpdated.get(key);
                this.logger.info(this.TAG, "Adding/updating video sources subscription: " + key.getAttendeeId() + " with priority: " + (Object)((Object)(videoSubscriptionConfiguration != null ? videoSubscriptionConfiguration.getPriority() : null)) + ' ' + "targetResolution: " + (Object)((Object)(videoSubscriptionConfiguration2 != null ? videoSubscriptionConfiguration2.getTargetResolution() : null)));
            }
            for (RemoteVideoSource key : removed) {
                this.logger.info(this.TAG, "Removing video source subscription: " + key.getAttendeeId());
            }
            int n = 0;
            Map addedOrUpdatedInternal = new LinkedHashMap();
            Object object = addedOrUpdated;
            boolean bl = false;
            Iterator<Map.Entry<RemoteVideoSource, VideoSubscriptionConfiguration>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void source;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl2 = false;
                object = (RemoteVideoSource)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                VideoSubscriptionConfiguration config = (VideoSubscriptionConfiguration)entry2.getValue();
                addedOrUpdatedInternal.put(new RemoteVideoSourceInternal(source.getAttendeeId()), new VideoSubscriptionConfigurationInternal(new VideoPriorityInternal(config.getPriority().getValue()), new VideoResolutionInternal(config.getTargetResolution().getWidth(), config.getTargetResolution().getHeight())));
            }
            RemoteVideoSource[] $this$map$iv = removed;
            boolean $i$f$map = false;
            RemoteVideoSource[] config = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var10_17 = $this$mapTo$iv$iv;
            int n2 = ((void)var10_17).length;
            for (int j = 0; j < n2; ++j) {
                void source;
                void item$iv$iv;
                void var14_21 = item$iv$iv = var10_17[j];
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                RemoteVideoSourceInternal remoteVideoSourceInternal = new RemoteVideoSourceInternal(source.getAttendeeId());
                collection.add(remoteVideoSourceInternal);
            }
            List removedInternal = (List)destination$iv$iv;
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block5;
            videoClient.updateVideoSourceSubscriptions(addedOrUpdatedInternal, removedInternal);
        }
    }

    @Override
    public void promoteToPrimaryMeeting(@NotNull MeetingSessionCredentials credentials, @NotNull PrimaryMeetingPromotionObserver observer) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
            Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) {
                observer.onPrimaryMeetingPromotion(new MeetingSessionStatus(MeetingSessionStatusCode.AudioServiceUnavailable));
                return;
            }
            this.videoClientObserver.setPrimaryMeetingPromotionObserver(observer);
            VideoClient videoClient = this.videoClient;
            if (videoClient == null) break block1;
            videoClient.promoteToPrimaryMeeting(credentials.getAttendeeId(), credentials.getExternalUserId(), credentials.getJoinToken());
        }
    }

    @Override
    public void demoteFromPrimaryMeeting() {
        block1: {
            if (!this.videoClientStateController.canAct(VideoClientState.INITIALIZED)) break block1;
            VideoClient videoClient = this.videoClient;
            if (videoClient != null) {
                videoClient.demoteFromPrimaryMeeting();
            }
        }
    }

    @Override
    public void initializeVideoClient() {
        this.logger.info(this.TAG, "Initializing video client");
        AppInfoUtil.INSTANCE.initializeVideoClientAppDetailedInfo(this.context);
        VideoClient.javaInitializeGlobals((Context)this.context);
        this.videoClient = this.videoClientFactory.getVideoClient(this.videoClientObserver);
    }

    @Override
    public void startVideoClient() {
        block2: {
            this.logger.info(this.TAG, "Starting video client");
            VideoClient videoClient = this.videoClient;
            if (videoClient != null) {
                videoClient.setReceiving(Boolean.valueOf(false));
            }
            int flag = 0;
            flag |= this.VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE;
            flag |= this.VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER;
            flag |= this.VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS;
            flag |= this.VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P;
            flag |= this.VIDEO_CLIENT_FLAG_DISABLE_CAPTURER;
            flag |= this.VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX;
            VideoClientConfigBuilder videoClientConfigBuilder = new VideoClientConfigBuilder().setMeetingId(this.configuration.getMeetingId()).setToken(this.configuration.getCredentials().getJoinToken()).setFlags(flag |= this.VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS);
            EglCore eglCore = this.eglCore;
            VideoClientConfig videoClientConfig = videoClientConfigBuilder.setSharedEglContext((EGLContext)(eglCore != null ? eglCore.getEglContext() : null)).setSignalingUrl(this.configuration.getUrls().getSignalingURL()).createVideoClientConfig();
            Intrinsics.checkExpressionValueIsNotNull((Object)videoClientConfig, (String)"VideoClientConfigBuilder\u2026createVideoClientConfig()");
            VideoClientConfig videoClientConfig2 = videoClientConfig;
            VideoClient videoClient2 = this.videoClient;
            if (videoClient2 != null) {
                videoClient2.start(videoClientConfig2);
            }
            VideoSourceAdapter videoSourceAdapter = this.videoSourceAdapter;
            boolean bl = false;
            boolean bl2 = false;
            VideoSourceAdapter it = videoSourceAdapter;
            boolean bl3 = false;
            VideoClient videoClient3 = this.videoClient;
            if (videoClient3 == null) break block2;
            EglCore eglCore2 = this.eglCore;
            videoClient3.setExternalVideoSource((com.xodee.client.video.VideoSource)it, (EGLContext)(eglCore2 != null ? eglCore2.getEglContext() : null));
        }
    }

    @Override
    public void stopVideoClient() {
        this.logger.info(this.TAG, "Stopping video client");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            videoClient.javaStopService();
        }
        this.stopInternalCaptureSourceIfRunning();
    }

    @Override
    public void destroyVideoClient() {
        this.logger.info(this.TAG, "Destroying video client");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            videoClient.destroy();
        }
        this.videoClient = null;
        VideoClient.finalizeGlobals();
    }

    private final void stopInternalCaptureSourceIfRunning() {
        if (this.isUsingInternalCaptureSource) {
            this.cameraCaptureSource.stop();
            this.isUsingInternalCaptureSource = false;
        }
    }

    public DefaultVideoClientController(@NotNull Context context, @NotNull Logger logger, @NotNull VideoClientStateController videoClientStateController, @NotNull VideoClientObserver videoClientObserver, @NotNull MeetingSessionConfiguration configuration, @NotNull VideoClientFactory videoClientFactory, @NotNull EglCoreFactory eglCoreFactory, @NotNull EventAnalyticsController eventAnalyticsController) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)videoClientStateController, (String)"videoClientStateController");
        Intrinsics.checkParameterIsNotNull((Object)videoClientObserver, (String)"videoClientObserver");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)videoClientFactory, (String)"videoClientFactory");
        Intrinsics.checkParameterIsNotNull((Object)eglCoreFactory, (String)"eglCoreFactory");
        Intrinsics.checkParameterIsNotNull((Object)eventAnalyticsController, (String)"eventAnalyticsController");
        this.context = context;
        this.logger = logger;
        this.videoClientStateController = videoClientStateController;
        this.videoClientObserver = videoClientObserver;
        this.configuration = configuration;
        this.videoClientFactory = videoClientFactory;
        this.eglCoreFactory = eglCoreFactory;
        this.eventAnalyticsController = eventAnalyticsController;
        this.DATA_MAX_SIZE = 2048;
        String string = "^[a-zA-Z0-9_-]{1,36}$";
        DefaultVideoClientController defaultVideoClientController = this;
        boolean bl = false;
        defaultVideoClientController.TOPIC_REGEX = object = new Regex(string);
        this.TAG = "DefaultVideoClientController";
        this.VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE = 32;
        this.VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER = 64;
        this.VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS = 4096;
        this.VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P = 16384;
        this.VIDEO_CLIENT_FLAG_DISABLE_CAPTURER = 0x100000;
        this.VIDEO_CLIENT_FLAG_EXCLUDE_SELF_CONTENT_IN_INDEX = 0x1000000;
        this.VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS = 0x4000000;
        this.gson = new Gson();
        this.videoSourceAdapter = new VideoSourceAdapter();
        this.videoClientStateController.bindLifecycleHandler(this);
        DefaultSurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory = new DefaultSurfaceTextureCaptureSourceFactory(this.logger, this.eglCoreFactory);
        DefaultCameraCaptureSource defaultCameraCaptureSource = new DefaultCameraCaptureSource(this.context, this.logger, surfaceTextureCaptureSourceFactory, null, 8, null);
        defaultVideoClientController = this;
        boolean bl2 = false;
        boolean bl3 = false;
        DefaultCameraCaptureSource $this$apply = defaultCameraCaptureSource;
        boolean bl4 = false;
        $this$apply.setEventAnalyticsController(this.eventAnalyticsController);
        object = defaultCameraCaptureSource;
        defaultVideoClientController.cameraCaptureSource = object;
    }

    public static final /* synthetic */ VideoClientObserver access$getVideoClientObserver$p(DefaultVideoClientController $this) {
        return $this.videoClientObserver;
    }

    public static final /* synthetic */ VideoClientStateController access$getVideoClientStateController$p(DefaultVideoClientController $this) {
        return $this.videoClientStateController;
    }

    public static final /* synthetic */ EglCore access$getEglCore$p(DefaultVideoClientController $this) {
        return $this.eglCore;
    }

    public static final /* synthetic */ void access$setEglCore$p(DefaultVideoClientController $this, EglCore eglCore) {
        $this.eglCore = eglCore;
    }
}

