/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.backgroundblur;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.os.Handler;
import android.os.HandlerThread;
import android.renderscript.RenderScript;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.BackgroundFilterVideoFrameProcessor;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.backgroundblur.BackgroundBlurConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.backgroundfilter.backgroundblur.BlurProcessor;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.GlUtil;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.JniUtil;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0018\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.J\u0010\u0010/\u001a\u00020(2\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u00100\u001a\u00020(J\u0010\u00101\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0002H\u0016J\b\u00102\u001a\u00020(H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundblur/BackgroundBlurVideoFrameProcessor;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "context", "Landroid/content/Context;", "configurations", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundblur/BackgroundBlurConfiguration;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundblur/BackgroundBlurConfiguration;)V", "BLUR_MAX_SUPPORTED_RADIUS", "", "BLUR_MIN_SUPPORTED_RADIUS", "DUMMY_PBUFFER_OFFSET", "", "TAG", "", "backgroundFilterVideoFrameProcessor", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/BackgroundFilterVideoFrameProcessor;", "blurProcessor", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundblur/BlurProcessor;", "getConfigurations", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundblur/BackgroundBlurConfiguration;", "setConfigurations", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/backgroundfilter/backgroundblur/BackgroundBlurConfiguration;)V", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "handler", "Landroid/os/Handler;", "sinks", "", "thread", "Landroid/os/HandlerThread;", "addVideoSink", "", "sink", "getBackgroundBlurredBitmap", "Landroid/graphics/Bitmap;", "inputBitmap", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "onVideoFrameReceived", "release", "removeVideoSink", "validateConfigs", "amazon-chime-sdk_release"})
public final class BackgroundBlurVideoFrameProcessor
implements VideoSource,
VideoSink {
    @NotNull
    private final VideoContentHint contentHint;
    private final float BLUR_MIN_SUPPORTED_RADIUS = 0.0f;
    private final float BLUR_MAX_SUPPORTED_RADIUS = 25.0f;
    private final String TAG = "BackgroundBlurVideoFrameProcessor";
    private final int DUMMY_PBUFFER_OFFSET = 0;
    private EglCore eglCore;
    private final HandlerThread thread;
    private final Handler handler;
    private final Set<VideoSink> sinks;
    private final BackgroundFilterVideoFrameProcessor backgroundFilterVideoFrameProcessor;
    private final BlurProcessor blurProcessor;
    private final Logger logger;
    private final EglCoreFactory eglCoreFactory;
    @Nullable
    private BackgroundBlurConfiguration configurations;

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        frame.retain();
        this.handler.post(new Runnable(this, frame){
            final /* synthetic */ BackgroundBlurVideoFrameProcessor this$0;
            final /* synthetic */ VideoFrame $frame;

            public final void run() {
                ByteBuffer rgbaData = BackgroundBlurVideoFrameProcessor.access$getBackgroundFilterVideoFrameProcessor$p(this.this$0).getByteBufferFromInputVideoFrame(this.$frame);
                Bitmap inputBitmap = BackgroundBlurVideoFrameProcessor.access$getBackgroundFilterVideoFrameProcessor$p(this.this$0).getInputBitmap(this.$frame);
                Bitmap backgroundBlurredBitmap = this.this$0.getBackgroundBlurredBitmap(inputBitmap, this.$frame);
                VideoFrame processedFrame = BackgroundBlurVideoFrameProcessor.access$getBackgroundFilterVideoFrameProcessor$p(this.this$0).getProcessedFrame(this.$frame, backgroundBlurredBitmap, rgbaData);
                this.$frame.release();
                Iterable $this$forEach$iv = BackgroundBlurVideoFrameProcessor.access$getSinks$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    VideoSink it = (VideoSink)element$iv;
                    boolean bl = false;
                    it.onVideoFrameReceived(processedFrame);
                }
                processedFrame.release();
                JniUtil.nativeFreeByteBuffer((ByteBuffer)rgbaData);
            }
            {
                this.this$0 = backgroundBlurVideoFrameProcessor;
                this.$frame = videoFrame;
            }
        });
    }

    @Nullable
    public final Bitmap getBackgroundBlurredBitmap(@NotNull Bitmap inputBitmap, @NotNull VideoFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)inputBitmap, (String)"inputBitmap");
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Bitmap scaledInputBitmap = this.backgroundFilterVideoFrameProcessor.getScaledInputBitmap(frame, inputBitmap);
        Bitmap outputBitmap = this.backgroundFilterVideoFrameProcessor.getSegmentationMask(scaledInputBitmap);
        BackgroundBlurConfiguration backgroundBlurConfiguration = this.configurations;
        if (backgroundBlurConfiguration != null) {
            BackgroundBlurConfiguration backgroundBlurConfiguration2 = backgroundBlurConfiguration;
            boolean bl = false;
            boolean bl2 = false;
            BackgroundBlurConfiguration it = backgroundBlurConfiguration2;
            boolean bl3 = false;
            this.blurProcessor.initialize(scaledInputBitmap.getWidth(), scaledInputBitmap.getHeight(), it.getBlurStrength());
        }
        Bitmap blurredBitmap = this.blurProcessor.process(scaledInputBitmap);
        return this.backgroundFilterVideoFrameProcessor.drawImageWithMask(scaledInputBitmap, outputBitmap, blurredBitmap);
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    private final void validateConfigs() {
        if (this.configurations == null) {
            this.configurations = new BackgroundBlurConfiguration(0.0f, 1, null);
        }
        BackgroundBlurConfiguration backgroundBlurConfiguration = this.configurations;
        if (backgroundBlurConfiguration != null) {
            float f = backgroundBlurConfiguration.getBlurStrength();
            boolean bl = false;
            boolean bl2 = false;
            float it = f;
            boolean bl3 = false;
            if (it <= this.BLUR_MIN_SUPPORTED_RADIUS || it > this.BLUR_MAX_SUPPORTED_RADIUS) {
                String msg = "Blur Strength should be in the range (" + this.BLUR_MIN_SUPPORTED_RADIUS + " < blurStrength <= " + this.BLUR_MAX_SUPPORTED_RADIUS + ")." + "See https://developer.android.com/reference/android/renderscript/ScriptIntrinsicBlur#setRadius(float) for reference.";
                throw (Throwable)new InvalidParameterException(msg);
            }
        }
    }

    public final void release() {
        this.handler.post(new Runnable(this){
            final /* synthetic */ BackgroundBlurVideoFrameProcessor this$0;

            public final void run() {
                BackgroundBlurVideoFrameProcessor.access$getLogger$p(this.this$0).info(BackgroundBlurVideoFrameProcessor.access$getTAG$p(this.this$0), "Releasing " + BackgroundBlurVideoFrameProcessor.access$getTAG$p(this.this$0) + " source");
                BackgroundBlurVideoFrameProcessor.access$getBlurProcessor$p(this.this$0).release();
                BackgroundBlurVideoFrameProcessor.access$getBackgroundFilterVideoFrameProcessor$p(this.this$0).release();
                BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this.this$0).release();
                BackgroundBlurVideoFrameProcessor.access$getHandler$p(this.this$0).getLooper().quit();
            }
            {
                this.this$0 = backgroundBlurVideoFrameProcessor;
            }
        });
    }

    @Nullable
    public final BackgroundBlurConfiguration getConfigurations() {
        return this.configurations;
    }

    public final void setConfigurations(@Nullable BackgroundBlurConfiguration backgroundBlurConfiguration) {
        this.configurations = backgroundBlurConfiguration;
    }

    @JvmOverloads
    public BackgroundBlurVideoFrameProcessor(@NotNull Logger logger, @NotNull EglCoreFactory eglCoreFactory, @NotNull Context context, @Nullable BackgroundBlurConfiguration configurations) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)eglCoreFactory, (String)"eglCoreFactory");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.logger = logger;
        this.eglCoreFactory = eglCoreFactory;
        this.configurations = configurations;
        this.contentHint = VideoContentHint.Motion;
        this.BLUR_MAX_SUPPORTED_RADIUS = 25.0f;
        this.TAG = "BackgroundBlurVideoFrameProcessor";
        this.thread = new HandlerThread(this.TAG);
        this.sinks = ConcurrentSet.Companion.createConcurrentSet();
        this.backgroundFilterVideoFrameProcessor = new BackgroundFilterVideoFrameProcessor(this.logger, context, this.TAG);
        RenderScript renderScript = RenderScript.create((Context)context);
        Intrinsics.checkExpressionValueIsNotNull((Object)renderScript, (String)"RenderScript.create(context)");
        this.blurProcessor = new BlurProcessor(renderScript);
        this.validateConfigs();
        this.thread.start();
        this.handler = new Handler(this.thread.getLooper());
        this.handler.post(new Runnable(){

            @Override
            public final void run() {
                eglCore = eglCoreFactory.createEglCore();
                int[] surfaceAttribs = new int[]{12375, 1, 12374, 1, 12344};
                EglCore eglCore = BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this);
                EGLSurface eGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this).getEglDisplay(), (EGLConfig)BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this).getEglConfig(), (int[])surfaceAttribs, (int)DUMMY_PBUFFER_OFFSET);
                Intrinsics.checkExpressionValueIsNotNull((Object)eGLSurface, (String)"EGL14.eglCreatePbufferSu\u2026FFER_OFFSET\n            )");
                eglCore.setEglSurface(eGLSurface);
                EGL14.eglMakeCurrent((EGLDisplay)BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this).getEglDisplay(), (EGLSurface)BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this).getEglSurface(), (EGLSurface)BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this).getEglSurface(), (EGLContext)BackgroundBlurVideoFrameProcessor.access$getEglCore$p(this).getEglContext());
                GlUtil.INSTANCE.checkGlError("Failed to set dummy surface to initialize surface texture video source");
                logger.info(TAG, "Created " + TAG);
            }
        });
    }

    public static final /* synthetic */ BackgroundFilterVideoFrameProcessor access$getBackgroundFilterVideoFrameProcessor$p(BackgroundBlurVideoFrameProcessor $this) {
        return $this.backgroundFilterVideoFrameProcessor;
    }

    public static final /* synthetic */ Set access$getSinks$p(BackgroundBlurVideoFrameProcessor $this) {
        return $this.sinks;
    }

    public static final /* synthetic */ BlurProcessor access$getBlurProcessor$p(BackgroundBlurVideoFrameProcessor $this) {
        return $this.blurProcessor;
    }

    public static final /* synthetic */ EglCore access$getEglCore$p(BackgroundBlurVideoFrameProcessor $this) {
        EglCore eglCore = $this.eglCore;
        if (eglCore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eglCore");
        }
        return eglCore;
    }

    public static final /* synthetic */ Handler access$getHandler$p(BackgroundBlurVideoFrameProcessor $this) {
        return $this.handler;
    }
}

