/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.session;

import com.amazonaws.services.chime.sdk.meetings.session.CreateAttendeeResponse;
import com.amazonaws.services.chime.sdk.meetings.session.CreateMeetingResponse;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionCredentials;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionURLs;
import com.amazonaws.services.chime.sdk.meetings.utils.ModalityType;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B@\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012'\b\u0002\u0010\u0006\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\f\u00a2\u0006\u0002\u0010\rB\u001f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B'\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0015J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0010H\u00c6\u0003J\t\u0010 \u001a\u00020\u0012H\u00c6\u0003J3\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u000e\u001a\u00020\b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001J\u0006\u0010\"\u001a\u00020\u0000J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "", "createMeetingResponse", "Lcom/amazonaws/services/chime/sdk/meetings/session/CreateMeetingResponse;", "createAttendeeResponse", "Lcom/amazonaws/services/chime/sdk/meetings/session/CreateAttendeeResponse;", "urlRewriter", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "url", "Lcom/amazonaws/services/chime/sdk/meetings/session/URLRewriter;", "(Lcom/amazonaws/services/chime/sdk/meetings/session/CreateMeetingResponse;Lcom/amazonaws/services/chime/sdk/meetings/session/CreateAttendeeResponse;Lkotlin/jvm/functions/Function1;)V", "meetingId", "credentials", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;", "urls", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionURLs;", "(Ljava/lang/String;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionURLs;)V", "externalMeetingId", "(Ljava/lang/String;Ljava/lang/String;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionURLs;)V", "getCredentials", "()Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionCredentials;", "getExternalMeetingId", "()Ljava/lang/String;", "getMeetingId", "getUrls", "()Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionURLs;", "component1", "component2", "component3", "component4", "copy", "createContentShareMeetingSessionConfiguration", "equals", "", "other", "hashCode", "", "toString", "amazon-chime-sdk_release"})
public final class MeetingSessionConfiguration {
    @NotNull
    private final String meetingId;
    @Nullable
    private final String externalMeetingId;
    @NotNull
    private final MeetingSessionCredentials credentials;
    @NotNull
    private final MeetingSessionURLs urls;

    @NotNull
    public final MeetingSessionConfiguration createContentShareMeetingSessionConfiguration() {
        String contentModality = "#" + ModalityType.Content.getValue();
        return new MeetingSessionConfiguration(this.meetingId, this.externalMeetingId, new MeetingSessionCredentials(this.credentials.getAttendeeId() + contentModality, this.credentials.getExternalUserId(), this.credentials.getJoinToken() + contentModality), this.urls);
    }

    @NotNull
    public final String getMeetingId() {
        return this.meetingId;
    }

    @Nullable
    public final String getExternalMeetingId() {
        return this.externalMeetingId;
    }

    @NotNull
    public final MeetingSessionCredentials getCredentials() {
        return this.credentials;
    }

    @NotNull
    public final MeetingSessionURLs getUrls() {
        return this.urls;
    }

    public MeetingSessionConfiguration(@NotNull String meetingId, @Nullable String externalMeetingId, @NotNull MeetingSessionCredentials credentials, @NotNull MeetingSessionURLs urls) {
        Intrinsics.checkParameterIsNotNull((Object)meetingId, (String)"meetingId");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)urls, (String)"urls");
        this.meetingId = meetingId;
        this.externalMeetingId = externalMeetingId;
        this.credentials = credentials;
        this.urls = urls;
    }

    @JvmOverloads
    public MeetingSessionConfiguration(@NotNull CreateMeetingResponse createMeetingResponse, @NotNull CreateAttendeeResponse createAttendeeResponse, @NotNull Function1<? super String, String> urlRewriter) {
        Intrinsics.checkParameterIsNotNull((Object)createMeetingResponse, (String)"createMeetingResponse");
        Intrinsics.checkParameterIsNotNull((Object)createAttendeeResponse, (String)"createAttendeeResponse");
        Intrinsics.checkParameterIsNotNull(urlRewriter, (String)"urlRewriter");
        this(createMeetingResponse.getMeeting().getMeetingId(), createMeetingResponse.getMeeting().getExternalMeetingId(), new MeetingSessionCredentials(createAttendeeResponse.getAttendee().getAttendeeId(), createAttendeeResponse.getAttendee().getExternalUserId(), createAttendeeResponse.getAttendee().getJoinToken()), new MeetingSessionURLs(createMeetingResponse.getMeeting().getMediaPlacement().getAudioFallbackUrl(), createMeetingResponse.getMeeting().getMediaPlacement().getAudioHostUrl(), createMeetingResponse.getMeeting().getMediaPlacement().getTurnControlUrl(), createMeetingResponse.getMeeting().getMediaPlacement().getSignalingUrl(), urlRewriter, createMeetingResponse.getMeeting().getMediaPlacement().getEventIngestionUrl()));
    }

    public /* synthetic */ MeetingSessionConfiguration(CreateMeetingResponse createMeetingResponse, CreateAttendeeResponse createAttendeeResponse, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(createMeetingResponse, createAttendeeResponse, (Function1<? super String, String>)function1);
    }

    @JvmOverloads
    public MeetingSessionConfiguration(@NotNull CreateMeetingResponse createMeetingResponse, @NotNull CreateAttendeeResponse createAttendeeResponse) {
        this(createMeetingResponse, createAttendeeResponse, null, 4, null);
    }

    public MeetingSessionConfiguration(@NotNull String meetingId, @NotNull MeetingSessionCredentials credentials, @NotNull MeetingSessionURLs urls) {
        Intrinsics.checkParameterIsNotNull((Object)meetingId, (String)"meetingId");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)urls, (String)"urls");
        this(meetingId, null, credentials, urls);
    }

    @NotNull
    public final String component1() {
        return this.meetingId;
    }

    @Nullable
    public final String component2() {
        return this.externalMeetingId;
    }

    @NotNull
    public final MeetingSessionCredentials component3() {
        return this.credentials;
    }

    @NotNull
    public final MeetingSessionURLs component4() {
        return this.urls;
    }

    @NotNull
    public final MeetingSessionConfiguration copy(@NotNull String meetingId, @Nullable String externalMeetingId, @NotNull MeetingSessionCredentials credentials, @NotNull MeetingSessionURLs urls) {
        Intrinsics.checkParameterIsNotNull((Object)meetingId, (String)"meetingId");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)urls, (String)"urls");
        return new MeetingSessionConfiguration(meetingId, externalMeetingId, credentials, urls);
    }

    public static /* synthetic */ MeetingSessionConfiguration copy$default(MeetingSessionConfiguration meetingSessionConfiguration, String string, String string2, MeetingSessionCredentials meetingSessionCredentials, MeetingSessionURLs meetingSessionURLs, int n, Object object) {
        if ((n & 1) != 0) {
            string = meetingSessionConfiguration.meetingId;
        }
        if ((n & 2) != 0) {
            string2 = meetingSessionConfiguration.externalMeetingId;
        }
        if ((n & 4) != 0) {
            meetingSessionCredentials = meetingSessionConfiguration.credentials;
        }
        if ((n & 8) != 0) {
            meetingSessionURLs = meetingSessionConfiguration.urls;
        }
        return meetingSessionConfiguration.copy(string, string2, meetingSessionCredentials, meetingSessionURLs);
    }

    @NotNull
    public String toString() {
        return "MeetingSessionConfiguration(meetingId=" + this.meetingId + ", externalMeetingId=" + this.externalMeetingId + ", credentials=" + this.credentials + ", urls=" + this.urls + ")";
    }

    public int hashCode() {
        String string = this.meetingId;
        String string2 = this.externalMeetingId;
        MeetingSessionCredentials meetingSessionCredentials = this.credentials;
        MeetingSessionURLs meetingSessionURLs = this.urls;
        return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (meetingSessionCredentials != null ? ((Object)meetingSessionCredentials).hashCode() : 0)) * 31 + (meetingSessionURLs != null ? ((Object)meetingSessionURLs).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MeetingSessionConfiguration)) break block3;
                MeetingSessionConfiguration meetingSessionConfiguration = (MeetingSessionConfiguration)object;
                if (!Intrinsics.areEqual((Object)this.meetingId, (Object)meetingSessionConfiguration.meetingId) || !Intrinsics.areEqual((Object)this.externalMeetingId, (Object)meetingSessionConfiguration.externalMeetingId) || !Intrinsics.areEqual((Object)this.credentials, (Object)meetingSessionConfiguration.credentials) || !Intrinsics.areEqual((Object)this.urls, (Object)meetingSessionConfiguration.urls)) break block3;
            }
            return true;
        }
        return false;
    }
}

