/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video.gl;

import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultEglRenderer$sam$i$java_lang_Runnable$0;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.DefaultGlVideoFrameDrawer;
import com.amazonaws.services.chime.sdk.meetings.internal.video.gl.EglRenderer;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.android.HandlerDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001dH\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u001bH\u0016J\b\u0010)\u001a\u00020\"H\u0016J\b\u0010*\u001a\u00020\"H\u0016J\b\u0010+\u001a\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultEglRenderer;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/EglRenderer;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "TAG", "", "value", "", "aspectRatio", "getAspectRatio", "()F", "setAspectRatio", "(F)V", "drawMatrix", "Landroid/graphics/Matrix;", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "frameDrawer", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/gl/DefaultGlVideoFrameDrawer;", "mirror", "", "getMirror", "()Z", "setMirror", "(Z)V", "pendingFrame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "pendingFrameLock", "", "renderHandler", "Landroid/os/Handler;", "surface", "createEglSurface", "", "inputSurface", "init", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "onVideoFrameReceived", "frame", "release", "releaseEglSurface", "renderPendingFrame", "amazon-chime-sdk_release"})
public final class DefaultEglRenderer
implements EglRenderer {
    private EglCore eglCore;
    private Object surface;
    private Handler renderHandler;
    private final Matrix drawMatrix;
    private VideoFrame pendingFrame;
    private final Object pendingFrameLock;
    private boolean mirror;
    private float aspectRatio;
    private DefaultGlVideoFrameDrawer frameDrawer;
    private final String TAG = "DefaultEglRenderer";
    private final Logger logger;

    @Override
    public boolean getMirror() {
        return this.mirror;
    }

    @Override
    public void setMirror(boolean bl) {
        this.mirror = bl;
    }

    @Override
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAspectRatio(float value) {
        Float f = Float.valueOf(this.getAspectRatio());
        boolean bl = false;
        boolean bl2 = false;
        synchronized (f) {
            boolean bl3 = false;
            this.logger.info(this.TAG, "Setting aspect ratio from " + this.aspectRatio + " to " + value);
            this.aspectRatio = value;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void init(@NotNull EglCoreFactory eglCoreFactory) {
        Intrinsics.checkParameterIsNotNull((Object)eglCoreFactory, (String)"eglCoreFactory");
        this.logger.info(this.TAG, "Initializing EGL renderer");
        if (this.renderHandler != null) {
            this.logger.warn(this.TAG, "Already initialized");
            return;
        }
        HandlerThread thread = new HandlerThread("EglRenderer");
        thread.start();
        Handler handler = this.renderHandler = new Handler(thread.getLooper());
        if (handler == null) {
            throw (Throwable)new UnknownError("No handler in init");
        }
        Handler validRenderHandler = handler;
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)validRenderHandler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, eglCoreFactory, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultEglRenderer this$0;
            final /* synthetic */ EglCoreFactory $eglCoreFactory;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        DefaultEglRenderer.access$setEglCore$p(this.this$0, this.$eglCoreFactory.createEglCore());
                        Object object2 = DefaultEglRenderer.access$getSurface$p(this.this$0);
                        if (object2 != null) {
                            Object object3 = object2;
                            boolean bl = false;
                            boolean bl2 = false;
                            Object it = object3;
                            boolean bl3 = false;
                            DefaultEglRenderer.access$getLogger$p(this.this$0).info(DefaultEglRenderer.access$getTAG$p(this.this$0), "View already has surface, triggering EGL surface creation");
                            this.this$0.createEglSurface(it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultEglRenderer;
                this.$eglCoreFactory = eglCoreFactory;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.logger.info(this.TAG, "Releasing EGL renderer");
        Handler handler = this.renderHandler;
        if (handler == null) {
            DefaultEglRenderer defaultEglRenderer = this;
            boolean bl = false;
            boolean bl2 = false;
            DefaultEglRenderer $this$run = defaultEglRenderer;
            boolean bl3 = false;
            $this$run.logger.warn($this$run.TAG, "Already released");
            return;
        }
        Handler validRenderHandler = handler;
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)validRenderHandler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultEglRenderer this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        EglCore eglCore = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                        if (eglCore != null) {
                            eglCore.release();
                        }
                        DefaultEglRenderer.access$setEglCore$p(this.this$0, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultEglRenderer;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        Object object = this.pendingFrameLock;
        boolean bl = false;
        boolean bl4 = false;
        synchronized (object) {
            boolean bl5 = false;
            VideoFrame videoFrame = this.pendingFrame;
            if (videoFrame != null) {
                videoFrame.release();
            }
            this.pendingFrame = null;
            validRenderHandler.getLooper().quitSafely();
            this.renderHandler = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void createEglSurface(@NotNull Object inputSurface) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)inputSurface, (String)"inputSurface");
            boolean bl = inputSurface instanceof SurfaceTexture || inputSurface instanceof Surface;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Surface must be SurfaceTexture or Surface";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            this.surface = inputSurface;
            Handler handler = this.renderHandler;
            if (handler == null) break block1;
            handler.post(new Runnable(this){
                final /* synthetic */ DefaultEglRenderer this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    DefaultEglRenderer.access$getLogger$p(this.this$0).info(DefaultEglRenderer.access$getTAG$p(this.this$0), "Request on handler thread to create EGL surface from input surface " + DefaultEglRenderer.access$getSurface$p(this.this$0));
                    if (DefaultEglRenderer.access$getEglCore$p(this.this$0) != null) {
                        EglCore eglCore = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                        if (Intrinsics.areEqual((Object)(eglCore != null ? eglCore.getEglSurface() : null), (Object)EGL14.EGL_NO_SURFACE) && DefaultEglRenderer.access$getSurface$p(this.this$0) != null) {
                            int[] surfaceAttributess = new int[]{12344};
                            EglCore eglCore2 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                            if (eglCore2 != null) {
                                EglCore eglCore3 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                                EglCore eglCore4 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                                EGLSurface eGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)(eglCore3 != null ? eglCore3.getEglDisplay() : null), (EGLConfig)(eglCore4 != null ? eglCore4.getEglConfig() : null), (Object)DefaultEglRenderer.access$getSurface$p(this.this$0), (int[])surfaceAttributess, (int)0);
                                Intrinsics.checkExpressionValueIsNotNull((Object)eGLSurface, (String)"EGL14.eglCreateWindowSur\u2026tess, 0\n                )");
                                eglCore2.setEglSurface(eGLSurface);
                            }
                            EglCore eglCore5 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                            EglCore eglCore6 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                            EglCore eglCore7 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                            EglCore eglCore8 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                            EGL14.eglMakeCurrent((EGLDisplay)(eglCore5 != null ? eglCore5.getEglDisplay() : null), (EGLSurface)(eglCore6 != null ? eglCore6.getEglSurface() : null), (EGLSurface)(eglCore7 != null ? eglCore7.getEglSurface() : null), (EGLContext)(eglCore8 != null ? eglCore8.getEglContext() : null));
                            GLES20.glPixelStorei((int)3317, (int)1);
                        }
                    }
                    Object object = DefaultEglRenderer.access$getPendingFrameLock$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = false;
                    synchronized (object) {
                        boolean bl3 = false;
                        VideoFrame videoFrame = DefaultEglRenderer.access$getPendingFrame$p(this.this$0);
                        if (videoFrame != null) {
                            videoFrame.release();
                        }
                        DefaultEglRenderer.access$setPendingFrame$p(this.this$0, null);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                {
                    this.this$0 = defaultEglRenderer;
                }
            });
        }
    }

    @Override
    public void releaseEglSurface() {
        this.surface = null;
        Handler handler = this.renderHandler;
        if (handler == null) {
            return;
        }
        Handler validRenderHandler = handler;
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)validRenderHandler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultEglRenderer this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        DefaultEglRenderer.access$getLogger$p(this.this$0).info(DefaultEglRenderer.access$getTAG$p(this.this$0), "Releasing EGL surface");
                        DefaultEglRenderer.access$getFrameDrawer$p(this.this$0).release();
                        EglCore eglCore = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                        EGL14.eglMakeCurrent((EGLDisplay)(eglCore != null ? eglCore.getEglDisplay() : null), (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLSurface)EGL14.EGL_NO_SURFACE, (EGLContext)EGL14.EGL_NO_CONTEXT);
                        EglCore eglCore2 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                        EglCore eglCore3 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                        EGL14.eglDestroySurface((EGLDisplay)(eglCore2 != null ? eglCore2.getEglDisplay() : null), (EGLSurface)(eglCore3 != null ? eglCore3.getEglSurface() : null));
                        EglCore eglCore4 = DefaultEglRenderer.access$getEglCore$p(this.this$0);
                        if (eglCore4 != null) {
                            EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
                            Intrinsics.checkExpressionValueIsNotNull((Object)eGLSurface, (String)"EGL14.EGL_NO_SURFACE");
                            eglCore4.setEglSurface(eGLSurface);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultEglRenderer;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Object object = this.pendingFrameLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Object object2;
            boolean bl3 = false;
            if (this.pendingFrame != null) {
                VideoFrame videoFrame = this.pendingFrame;
                if (videoFrame != null) {
                    videoFrame.release();
                }
            }
            if (this.renderHandler != null) {
                VideoFrame videoFrame = this.pendingFrame = frame;
                if (videoFrame != null) {
                    videoFrame.retain();
                }
                Handler handler = this.renderHandler;
                if (handler != null) {
                    Function0 function0 = (Function0)new Function0<Unit>(this){

                        public final void invoke() {
                            DefaultEglRenderer.access$renderPendingFrame((DefaultEglRenderer)this.receiver);
                        }

                        public final KDeclarationContainer getOwner() {
                            return Reflection.getOrCreateKotlinClass(DefaultEglRenderer.class);
                        }

                        public final String getName() {
                            return "renderPendingFrame";
                        }

                        public final String getSignature() {
                            return "renderPendingFrame()V";
                        }
                    };
                    object2 = handler.post((Runnable)new DefaultEglRenderer$sam$i$java_lang_Runnable$0(function0));
                } else {
                    object2 = null;
                }
            } else {
                this.logger.warn(this.TAG, "Skipping frame render request, no render handler thread");
                object2 = Unit.INSTANCE;
            }
            Unit unit = object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void renderPendingFrame() {
        float frameAspectRatio;
        Object object;
        boolean bl;
        if (this.eglCore == null) {
            this.logger.warn(this.TAG, "Skipping frame render, no EGL core");
            return;
        }
        EglCore eglCore = this.eglCore;
        if (Intrinsics.areEqual((Object)(eglCore != null ? eglCore.getEglSurface() : null), (Object)EGL14.EGL_NO_SURFACE)) {
            this.logger.verbose(this.TAG, "Skipping frame render, no EGL surface");
            return;
        }
        Ref.ObjectRef frame = new Ref.ObjectRef();
        Object object2 = this.pendingFrameLock;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object2) {
            bl = false;
            if (this.pendingFrame == null) {
                this.logger.verbose(this.TAG, "Skipping frame render, no pending frame to render");
                return;
            }
            VideoFrame videoFrame = this.pendingFrame;
            if (videoFrame == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame");
            }
            frame.element = videoFrame;
            this.pendingFrame = null;
            object = Unit.INSTANCE;
        }
        float drawnAspectRatio = frameAspectRatio = (float)((VideoFrame)frame.element).getRotatedWidth() / (float)((VideoFrame)frame.element).getRotatedHeight();
        object = Float.valueOf(this.getAspectRatio());
        bl = false;
        boolean bl4 = false;
        synchronized (object) {
            boolean bl5 = false;
            if (this.getAspectRatio() != 0.0f) {
                drawnAspectRatio = this.getAspectRatio();
            }
            Unit unit = Unit.INSTANCE;
        }
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        if (frameAspectRatio > drawnAspectRatio) {
            scaleX = drawnAspectRatio / frameAspectRatio;
            scaleY = 1.0f;
        } else {
            scaleX = 1.0f;
            scaleY = frameAspectRatio / drawnAspectRatio;
        }
        this.drawMatrix.reset();
        this.drawMatrix.preTranslate(0.5f, 0.5f);
        this.drawMatrix.preScale(this.getMirror() ? -1.0f : 1.0f, 1.0f);
        this.drawMatrix.preScale(scaleX, scaleY);
        this.drawMatrix.preTranslate(-0.5f, -0.5f);
        int[] widthArray = new int[1];
        EglCore eglCore2 = this.eglCore;
        EglCore eglCore3 = this.eglCore;
        EGL14.eglQuerySurface((EGLDisplay)(eglCore2 != null ? eglCore2.getEglDisplay() : null), (EGLSurface)(eglCore3 != null ? eglCore3.getEglSurface() : null), (int)12375, (int[])widthArray, (int)0);
        int[] heightArray = new int[1];
        EglCore eglCore4 = this.eglCore;
        EglCore eglCore5 = this.eglCore;
        EGL14.eglQuerySurface((EGLDisplay)(eglCore4 != null ? eglCore4.getEglDisplay() : null), (EGLSurface)(eglCore5 != null ? eglCore5.getEglSurface() : null), (int)12374, (int[])heightArray, (int)0);
        try {
            this.frameDrawer.drawFrame((VideoFrame)frame.element, 0, 0, widthArray[0], heightArray[0], this.drawMatrix);
            EglCore eglCore6 = this.eglCore;
            EglCore eglCore7 = this.eglCore;
            EGL14.eglSwapBuffers((EGLDisplay)(eglCore6 != null ? eglCore6.getEglDisplay() : null), (EGLSurface)(eglCore7 != null ? eglCore7.getEglSurface() : null));
        }
        catch (Throwable e) {
            this.logger.verbose(this.TAG, "Failed to draw frame, ignore...");
        }
        ((VideoFrame)frame.element).release();
    }

    public DefaultEglRenderer(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.drawMatrix = new Matrix();
        this.pendingFrameLock = new Object();
        this.frameDrawer = new DefaultGlVideoFrameDrawer();
        this.TAG = "DefaultEglRenderer";
    }

    public static final /* synthetic */ EglCore access$getEglCore$p(DefaultEglRenderer $this) {
        return $this.eglCore;
    }

    public static final /* synthetic */ void access$setEglCore$p(DefaultEglRenderer $this, EglCore eglCore) {
        $this.eglCore = eglCore;
    }

    public static final /* synthetic */ Object access$getSurface$p(DefaultEglRenderer $this) {
        return $this.surface;
    }

    public static final /* synthetic */ void access$setSurface$p(DefaultEglRenderer $this, Object object) {
        $this.surface = object;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultEglRenderer $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultEglRenderer $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Object access$getPendingFrameLock$p(DefaultEglRenderer $this) {
        return $this.pendingFrameLock;
    }

    public static final /* synthetic */ VideoFrame access$getPendingFrame$p(DefaultEglRenderer $this) {
        return $this.pendingFrame;
    }

    public static final /* synthetic */ void access$setPendingFrame$p(DefaultEglRenderer $this, VideoFrame videoFrame) {
        $this.pendingFrame = videoFrame;
    }

    public static final /* synthetic */ DefaultGlVideoFrameDrawer access$getFrameDrawer$p(DefaultEglRenderer $this) {
        return $this.frameDrawer;
    }

    public static final /* synthetic */ void access$setFrameDrawer$p(DefaultEglRenderer $this, DefaultGlVideoFrameDrawer defaultGlVideoFrameDrawer) {
        $this.frameDrawer = defaultGlVideoFrameDrawer;
    }

    public static final /* synthetic */ void access$renderPendingFrame(DefaultEglRenderer $this) {
        $this.renderPendingFrame();
    }
}

