/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database;

import android.content.ContentValues;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.DirtyEventDao;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.DirtyMeetingEventItem;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.EventTypeConverters;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseManager;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.database.DatabaseTable;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001eH\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u001e2\u0006\u0010$\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DirtyEventSQLiteDao;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/DirtyEventDao;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseTable;", "databaseManager", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseManager;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/database/DatabaseManager;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "TAG", "", "columns", "", "getColumns", "()Ljava/util/Map;", "dataColumnName", "dataColumnType", "idColumnName", "idColumnType", "primaryKey", "Lkotlin/Pair;", "getPrimaryKey", "()Lkotlin/Pair;", "tableName", "getTableName", "()Ljava/lang/String;", "ttlColumnName", "ttlColumnType", "deleteDirtyEventsByIds", "", "ids", "", "insertDirtyMeetingEventItems", "", "dirtyEvents", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/DirtyMeetingEventItem;", "listDirtyMeetingEventItems", "size", "amazon-chime-sdk_release"})
public final class DirtyEventSQLiteDao
implements DirtyEventDao,
DatabaseTable {
    @NotNull
    private final String tableName = "DirtyEvents";
    private final String TAG = "DirtyEventSQLiteDao";
    private final String idColumnName = "id";
    private final String dataColumnName = "data";
    private final String ttlColumnName = "ttl";
    private final String idColumnType = "TEXT";
    private final String dataColumnType = "TEXT NOT NULL";
    private final String ttlColumnType = "INTEGER NOT NULL";
    private final DatabaseManager databaseManager;
    private final Logger logger;

    @Override
    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @Override
    @NotNull
    public Map<String, String> getColumns() {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)this.dataColumnName, (Object)this.dataColumnType), TuplesKt.to((Object)this.ttlColumnName, (Object)this.ttlColumnType)});
    }

    @Override
    @NotNull
    public Pair<String, String> getPrimaryKey() {
        return TuplesKt.to((Object)this.idColumnName, (Object)this.idColumnType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<DirtyMeetingEventItem> listDirtyMeetingEventItems(int size) {
        void $this$mapTo$iv$iv;
        List<Map<String, Object>> retrievedDataList = this.databaseManager.query(this.getTableName(), size);
        Iterable $this$map$iv = retrievedDataList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void retrievedData;
            Map map = (Map)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v = retrievedData.get(this.idColumnName);
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            Object v2 = retrievedData.get(this.dataColumnName);
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            Object v3 = retrievedData.get(this.ttlColumnName);
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
            }
            DirtyMeetingEventItem dirtyMeetingEventItem = new DirtyMeetingEventItem((String)v, EventTypeConverters.INSTANCE.toMeetingEvent((String)v2), (Long)v3);
            collection.add(dirtyMeetingEventItem);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public int deleteDirtyEventsByIds(@NotNull List<String> ids) {
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        return this.databaseManager.delete(this.getTableName(), this.idColumnName, ids);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean insertDirtyMeetingEventItems(@NotNull List<DirtyMeetingEventItem> dirtyEvents) {
        Collection<ContentValues> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(dirtyEvents, (String)"dirtyEvents");
        Iterable iterable = dirtyEvents;
        String string = this.getTableName();
        DatabaseManager databaseManager = this.databaseManager;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void dirtyEvent;
            DirtyMeetingEventItem dirtyMeetingEventItem = (DirtyMeetingEventItem)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ContentValues contentValues = new ContentValues();
            boolean bl2 = false;
            boolean bl3 = false;
            ContentValues $this$apply = contentValues;
            boolean bl4 = false;
            $this$apply.put(this.idColumnName, dirtyEvent.getId());
            $this$apply.put(this.dataColumnName, EventTypeConverters.INSTANCE.fromMeetingEvent(dirtyEvent.getData()));
            $this$apply.put(this.ttlColumnName, Long.valueOf(dirtyEvent.getTtl()));
            ContentValues contentValues2 = contentValues;
            collection.add(contentValues2);
        }
        collection = (List)destination$iv$iv;
        return databaseManager.insert(string, (List<ContentValues>)collection);
    }

    public DirtyEventSQLiteDao(@NotNull DatabaseManager databaseManager, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)databaseManager, (String)"databaseManager");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.databaseManager = databaseManager;
        this.logger = logger;
        this.tableName = "DirtyEvents";
        this.TAG = "DirtyEventSQLiteDao";
        this.idColumnName = "id";
        this.dataColumnName = "data";
        this.ttlColumnName = "ttl";
        this.idColumnType = "TEXT";
        this.dataColumnType = "TEXT NOT NULL";
        this.ttlColumnType = "INTEGER NOT NULL";
        this.databaseManager.createTable(this);
    }
}

