/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.contentshare;

import android.content.Context;
import android.opengl.EGLContext;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.contentshare.ContentShareObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCore;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.gl.EglCoreFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.contentshare.ContentShareVideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.contentshare.ContentShareVideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.contentshare.DefaultContentShareVideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.AppInfoUtil;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientFactory;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoSourceAdapter;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.video.VideoClient;
import com.xodee.client.video.VideoClientConfig;
import com.xodee.client.video.VideoClientConfigBuilder;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u001cH\u0002J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020%H\u0016J\u0010\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001fH\u0016J\u0010\u0010-\u001a\u00020%2\u0006\u0010,\u001a\u00020\u001fH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/contentshare/DefaultContentShareVideoClientController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/contentshare/ContentShareVideoClientController;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "contentShareVideoClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/contentshare/ContentShareVideoClientObserver;", "configuration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "videoClientFactory", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientFactory;", "eglCoreFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/contentshare/ContentShareVideoClientObserver;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientFactory;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCoreFactory;)V", "TAG", "", "VIDEO_CLIENT_FLAG_DISABLE_CAPTURER", "", "VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P", "VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS", "VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE", "VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS", "VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER", "VIDEO_CLIENT_FLAG_IS_CONTENT", "eglCore", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/gl/EglCore;", "isSharing", "", "observers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/contentshare/ContentShareObserver;", "videoClient", "Lcom/xodee/client/video/VideoClient;", "videoSourceAdapter", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter;", "initializeVideoClient", "", "startVideoClient", "startVideoShare", "videoSource", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "stopVideoShare", "subscribeToVideoClientStateChange", "observer", "unsubscribeFromVideoClientStateChange", "amazon-chime-sdk_release"})
public final class DefaultContentShareVideoClientController
implements ContentShareVideoClientController {
    private final Set<ContentShareObserver> observers;
    private final VideoSourceAdapter videoSourceAdapter;
    private VideoClient videoClient;
    private EglCore eglCore;
    private boolean isSharing;
    private final String TAG = "DefaultContentShareVideoClientController";
    private final int VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE = 32;
    private final int VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER = 64;
    private final int VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS = 4096;
    private final int VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P = 16384;
    private final int VIDEO_CLIENT_FLAG_DISABLE_CAPTURER = 0x100000;
    private final int VIDEO_CLIENT_FLAG_IS_CONTENT = 0x800000;
    private final int VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS = 0x4000000;
    private final Context context;
    private final Logger logger;
    private final ContentShareVideoClientObserver contentShareVideoClientObserver;
    private final MeetingSessionConfiguration configuration;
    private final VideoClientFactory videoClientFactory;
    private final EglCoreFactory eglCoreFactory;

    @Override
    public void startVideoShare(@NotNull VideoSource videoSource) {
        Intrinsics.checkParameterIsNotNull((Object)videoSource, (String)"videoSource");
        if (this.eglCore == null) {
            this.logger.debug(this.TAG, "Creating EGL core");
            this.eglCore = this.eglCoreFactory.createEglCore();
        }
        if (!this.isSharing) {
            if (this.videoClient == null) {
                this.initializeVideoClient();
            }
            if (!this.startVideoClient()) {
                ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, startVideoShare.1.INSTANCE);
                return;
            }
        }
        this.logger.debug(this.TAG, "Setting external video source to content share source");
        this.videoSourceAdapter.setSource(videoSource);
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            EglCore eglCore = this.eglCore;
            videoClient.setExternalVideoSource((com.xodee.client.video.VideoSource)this.videoSourceAdapter, (EGLContext)(eglCore != null ? eglCore.getEglContext() : null));
        }
        this.logger.debug(this.TAG, "Setting sending to true");
        VideoClient videoClient2 = this.videoClient;
        if (videoClient2 != null) {
            videoClient2.setSending(Boolean.valueOf(true));
        }
        this.isSharing = true;
    }

    private final void initializeVideoClient() {
        block0: {
            this.logger.info(this.TAG, "Initializing content share video client");
            AppInfoUtil.INSTANCE.initializeVideoClientAppDetailedInfo(this.context);
            VideoClient.javaInitializeGlobals((Context)this.context);
            VideoClient videoClient = this.videoClient = this.videoClientFactory.getVideoClient(this.contentShareVideoClientObserver);
            if (videoClient == null) break block0;
            videoClient.setReceiving(Boolean.valueOf(false));
        }
    }

    private final boolean startVideoClient() {
        this.logger.info(this.TAG, "Starting content share video client for content share");
        int flag = 0;
        flag |= this.VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE;
        flag |= this.VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER;
        flag |= this.VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS;
        flag |= this.VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P;
        flag |= this.VIDEO_CLIENT_FLAG_DISABLE_CAPTURER;
        flag |= this.VIDEO_CLIENT_FLAG_IS_CONTENT;
        VideoClientConfigBuilder videoClientConfigBuilder = new VideoClientConfigBuilder().setMeetingId(this.configuration.getMeetingId()).setToken(this.configuration.getCredentials().getJoinToken()).setAudioHostUrl(this.configuration.getUrls().getAudioHostURL()).setFlags(flag |= this.VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS);
        EglCore eglCore = this.eglCore;
        VideoClientConfig videoClientConfig = videoClientConfigBuilder.setSharedEglContext((EGLContext)(eglCore != null ? eglCore.getEglContext() : null)).setSignalingUrl(this.configuration.getUrls().getSignalingURL()).createVideoClientConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)videoClientConfig, (String)"VideoClientConfigBuilder\u2026createVideoClientConfig()");
        VideoClientConfig videoClientConfig2 = videoClientConfig;
        VideoClient videoClient = this.videoClient;
        boolean result = videoClient != null ? videoClient.start(videoClientConfig2) : false;
        this.logger.info(this.TAG, "Content share video client start result: " + result);
        return result;
    }

    @Override
    public void stopVideoShare() {
        this.logger.info(this.TAG, "Stopping content share video client");
        VideoClient videoClient = this.videoClient;
        if (videoClient != null) {
            videoClient.javaStopService();
        }
        VideoClient videoClient2 = this.videoClient;
        if (videoClient2 != null) {
            videoClient2.destroy();
        }
        this.videoClient = null;
        this.isSharing = false;
        EglCore eglCore = this.eglCore;
        if (eglCore != null) {
            eglCore.release();
        }
        this.eglCore = null;
    }

    @Override
    public void subscribeToVideoClientStateChange(@NotNull ContentShareObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.observers.add(observer);
        this.contentShareVideoClientObserver.subscribeToVideoClientStateChange(observer);
    }

    @Override
    public void unsubscribeFromVideoClientStateChange(@NotNull ContentShareObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.observers.remove(observer);
        this.contentShareVideoClientObserver.unsubscribeFromVideoClientStateChange(observer);
    }

    public DefaultContentShareVideoClientController(@NotNull Context context, @NotNull Logger logger, @NotNull ContentShareVideoClientObserver contentShareVideoClientObserver, @NotNull MeetingSessionConfiguration configuration, @NotNull VideoClientFactory videoClientFactory, @NotNull EglCoreFactory eglCoreFactory) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)contentShareVideoClientObserver, (String)"contentShareVideoClientObserver");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)videoClientFactory, (String)"videoClientFactory");
        Intrinsics.checkParameterIsNotNull((Object)eglCoreFactory, (String)"eglCoreFactory");
        this.context = context;
        this.logger = logger;
        this.contentShareVideoClientObserver = contentShareVideoClientObserver;
        this.configuration = configuration;
        this.videoClientFactory = videoClientFactory;
        this.eglCoreFactory = eglCoreFactory;
        DefaultContentShareVideoClientController defaultContentShareVideoClientController = this;
        boolean bl = false;
        defaultContentShareVideoClientController.observers = set = (Set)new LinkedHashSet();
        this.videoSourceAdapter = new VideoSourceAdapter();
        this.TAG = "DefaultContentShareVideoClientController";
        this.VIDEO_CLIENT_FLAG_ENABLE_SEND_SIDE_BWE = 32;
        this.VIDEO_CLIENT_FLAG_ENABLE_USE_HW_DECODE_AND_RENDER = 64;
        this.VIDEO_CLIENT_FLAG_ENABLE_TWO_SIMULCAST_STREAMS = 4096;
        this.VIDEO_CLIENT_FLAG_DISABLE_SIMULCAST_P2P = 16384;
        this.VIDEO_CLIENT_FLAG_DISABLE_CAPTURER = 0x100000;
        this.VIDEO_CLIENT_FLAG_IS_CONTENT = 0x800000;
        this.VIDEO_CLIENT_FLAG_ENABLE_INBAND_TURN_CREDS = 0x4000000;
    }
}

