/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.Surface;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.CaptureSourceObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.DefaultScreenCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.SurfaceTextureCaptureSourceFactory;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.VideoCaptureSource;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ObserverUtils;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.android.HandlerDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020$H\u0016J\u0010\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0002H\u0016J\u0010\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\b\u00101\u001a\u00020\nH\u0002J\u0010\u00102\u001a\u00020+2\u0006\u00103\u001a\u000204H\u0016J\u0006\u00105\u001a\u00020+J\u0010\u00106\u001a\u00020+2\u0006\u0010,\u001a\u00020$H\u0016J\u0010\u00107\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0002H\u0016J\b\u00108\u001a\u00020+H\u0016J\b\u00109\u001a\u00020\u001eH\u0002J\b\u0010:\u001a\u00020+H\u0016J\b\u0010;\u001a\u00020+H\u0002R\u000e\u0010\u0012\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/DefaultScreenCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "surfaceTextureCaptureSourceFactory", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;", "activityResultCode", "", "activityData", "Landroid/content/Intent;", "displayManager", "Landroid/hardware/display/DisplayManager;", "mediaProjectionManager", "Landroid/media/projection/MediaProjectionManager;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSourceFactory;ILandroid/content/Intent;Landroid/hardware/display/DisplayManager;Landroid/media/projection/MediaProjectionManager;)V", "MIN_FPS", "TAG", "", "contentHint", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "getContentHint", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoContentHint;", "displayMetrics", "Landroid/util/DisplayMetrics;", "handler", "Landroid/os/Handler;", "isOrientationInPortrait", "", "isRestartingForOrientationChange", "mediaProjection", "Landroid/media/projection/MediaProjection;", "observers", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/CaptureSourceObserver;", "sinks", "surfaceTextureSource", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/SurfaceTextureCaptureSource;", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "addCaptureSourceObserver", "", "observer", "addVideoSink", "sink", "alignNumberBy16", "number", "getStatusBarHeight", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "release", "removeCaptureSourceObserver", "removeVideoSink", "start", "startInternal", "stop", "stopInternal", "amazon-chime-sdk_release"})
public final class DefaultScreenCaptureSource
implements VideoCaptureSource,
VideoSink {
    private DisplayMetrics displayMetrics;
    private VirtualDisplay virtualDisplay;
    private SurfaceTextureCaptureSource surfaceTextureSource;
    private final int MIN_FPS = 15;
    private MediaProjection mediaProjection;
    private final Handler handler;
    private final Set<CaptureSourceObserver> observers;
    private final Set<VideoSink> sinks;
    @NotNull
    private final VideoContentHint contentHint;
    private boolean isOrientationInPortrait;
    private boolean isRestartingForOrientationChange;
    private final String TAG = "DefaultScreenCaptureSource";
    private final Context context;
    private final Logger logger;
    private final SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory;
    private final int activityResultCode;
    private final Intent activityData;
    private final DisplayManager displayManager;
    private final MediaProjectionManager mediaProjectionManager;

    @Override
    @NotNull
    public VideoContentHint getContentHint() {
        return this.contentHint;
    }

    @Override
    public void start() {
        this.handler.post(new Runnable(this){
            final /* synthetic */ DefaultScreenCaptureSource this$0;

            public final void run() {
                boolean success = DefaultScreenCaptureSource.access$startInternal(this.this$0);
                DefaultScreenCaptureSource.access$setRestartingForOrientationChange$p(this.this$0, false);
                if (success) {
                    ObserverUtils.Companion.notifyObserverOnMainThread(DefaultScreenCaptureSource.access$getObservers$p(this.this$0), start.1.INSTANCE);
                }
            }
            {
                this.this$0 = defaultScreenCaptureSource;
            }
        });
    }

    private final int alignNumberBy16(int number) {
        int maxIntAlignedBy16 = 0x7FFFFFF0;
        return number & maxIntAlignedBy16;
    }

    private final boolean startInternal() {
        VirtualDisplay virtualDisplay;
        if (this.mediaProjection != null) {
            this.logger.warn(this.TAG, "Screen capture has not been stopped before start request, stopping to release resources");
            this.stop();
        }
        this.logger.info(this.TAG, "Starting screen capture source");
        try {
            this.mediaProjection = this.mediaProjectionManager.getMediaProjection(this.activityResultCode, this.activityData);
        }
        catch (SecurityException exception) {
            this.logger.error(this.TAG, "Failed to retrieve media projection due to SecurityException. The foreground service may not have finished starting before start was called.");
            ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, startInternal.1.INSTANCE);
            return false;
        }
        if (this.mediaProjection == null) {
            this.logger.error(this.TAG, "Failed to retrieve media projection. The resultCode or data may have been invalid.");
            ObserverUtils.Companion.notifyObserverOnMainThread(this.observers, startInternal.2.INSTANCE);
            return false;
        }
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Intrinsics.checkExpressionValueIsNotNull((Object)displayMetrics, (String)"context.resources.displayMetrics");
        this.displayMetrics = displayMetrics;
        Display display = this.displayManager.getDisplay(0);
        if (display == null) {
            throw (Throwable)new RuntimeException("No display found.");
        }
        Display display2 = display;
        DisplayMetrics displayMetrics2 = this.displayMetrics;
        if (displayMetrics2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
        }
        display2.getRealMetrics(displayMetrics2);
        int rotation = display2.getRotation();
        this.isOrientationInPortrait = rotation == 0 || rotation == 2;
        DisplayMetrics displayMetrics3 = this.displayMetrics;
        if (displayMetrics3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
        }
        int width = displayMetrics3.widthPixels;
        DisplayMetrics displayMetrics4 = this.displayMetrics;
        if (displayMetrics4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
        }
        int height = displayMetrics4.heightPixels;
        SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource = this.surfaceTextureCaptureSourceFactory.createSurfaceTextureCaptureSource(this.alignNumberBy16(width - (this.isOrientationInPortrait ? 0 : this.getStatusBarHeight())), this.alignNumberBy16(height), this.getContentHint());
        if (surfaceTextureCaptureSource != null) {
            surfaceTextureCaptureSource.setMinFps(this.MIN_FPS);
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource2 != null) {
            surfaceTextureCaptureSource2.addVideoSink(this);
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource3 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource3 != null) {
            surfaceTextureCaptureSource3.start();
        }
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            DisplayMetrics displayMetrics5 = this.displayMetrics;
            if (displayMetrics5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"displayMetrics");
            }
            SurfaceTextureCaptureSource surfaceTextureCaptureSource4 = this.surfaceTextureSource;
            virtualDisplay = mediaProjection.createVirtualDisplay(this.TAG, width, height, displayMetrics5.densityDpi, 16, (Surface)(surfaceTextureCaptureSource4 != null ? surfaceTextureCaptureSource4.getSurface() : null), new VirtualDisplay.Callback(this){
                final /* synthetic */ DefaultScreenCaptureSource this$0;

                public void onStopped() {
                    if (!DefaultScreenCaptureSource.access$isRestartingForOrientationChange$p(this.this$0)) {
                        ObserverUtils.Companion.notifyObserverOnMainThread(DefaultScreenCaptureSource.access$getObservers$p(this.this$0), startInternal.onStopped.1.INSTANCE);
                    }
                }
                {
                    this.this$0 = $outer;
                }
            }, this.handler);
        } else {
            virtualDisplay = null;
        }
        this.virtualDisplay = virtualDisplay;
        this.logger.info(this.TAG, "Media projection adapter activity succeeded, virtual display created");
        return true;
    }

    @Override
    public void stop() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultScreenCaptureSource this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        DefaultScreenCaptureSource.access$stopInternal(this.this$0);
                        DefaultScreenCaptureSource.access$setRestartingForOrientationChange$p(this.this$0, false);
                        ObserverUtils.Companion.notifyObserverOnMainThread(DefaultScreenCaptureSource.access$getObservers$p(this.this$0), stop.1.INSTANCE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultScreenCaptureSource;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final void stopInternal() {
        this.logger.info(this.TAG, "Stopping screen capture source");
        MediaProjection mediaProjection = this.mediaProjection;
        if (mediaProjection != null) {
            mediaProjection.stop();
        }
        this.mediaProjection = null;
        VirtualDisplay virtualDisplay = this.virtualDisplay;
        if (virtualDisplay != null) {
            virtualDisplay.release();
        }
        this.virtualDisplay = null;
        SurfaceTextureCaptureSource surfaceTextureCaptureSource = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource != null) {
            surfaceTextureCaptureSource.removeVideoSink(this);
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource2 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource2 != null) {
            surfaceTextureCaptureSource2.stop();
        }
        SurfaceTextureCaptureSource surfaceTextureCaptureSource3 = this.surfaceTextureSource;
        if (surfaceTextureCaptureSource3 != null) {
            surfaceTextureCaptureSource3.release();
        }
        this.surfaceTextureSource = null;
    }

    @Override
    public void addCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.observers.add(observer);
    }

    @Override
    public void removeCaptureSourceObserver(@NotNull CaptureSourceObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.observers.remove(observer);
    }

    @Override
    public void addVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    @Override
    public void removeVideoSink(@NotNull VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        boolean isOrientationInPortrait;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Display display = this.displayManager.getDisplay(0);
        if (display == null) {
            throw (Throwable)new RuntimeException("No display found.");
        }
        Display display2 = display;
        int rotation = display2.getRotation();
        boolean bl = isOrientationInPortrait = rotation == 0 || rotation == 2;
        if (this.isOrientationInPortrait != isOrientationInPortrait) {
            this.isRestartingForOrientationChange = true;
            this.logger.info(this.TAG, "Orientation changed from " + (this.isOrientationInPortrait ? "portrait" : "landscape") + ' ' + "to " + (isOrientationInPortrait ? "portrait" : "landscape") + ", restarting screen capture to update dimensions");
            this.handler.post(new Runnable(this){
                final /* synthetic */ DefaultScreenCaptureSource this$0;

                public final void run() {
                    if (DefaultScreenCaptureSource.access$isRestartingForOrientationChange$p(this.this$0)) {
                        DefaultScreenCaptureSource.access$stopInternal(this.this$0);
                        DefaultScreenCaptureSource.access$startInternal(this.this$0);
                        DefaultScreenCaptureSource.access$setRestartingForOrientationChange$p(this.this$0, false);
                    }
                }
                {
                    this.this$0 = defaultScreenCaptureSource;
                }
            });
            return;
        }
        if (this.isRestartingForOrientationChange) {
            return;
        }
        Iterable $this$forEach$iv = this.sinks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VideoSink it = (VideoSink)element$iv;
            boolean bl2 = false;
            it.onVideoFrameReceived(frame);
        }
    }

    public final void release() {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)HandlerDispatcherKt.from$default((Handler)this.handler, null, (int)1, null).getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultScreenCaptureSource this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$runBlocking = this.p$;
                        DefaultScreenCaptureSource.access$getLogger$p(this.this$0).info(DefaultScreenCaptureSource.access$getTAG$p(this.this$0), "Stopping handler looper");
                        DefaultScreenCaptureSource.access$getHandler$p(this.this$0).removeCallbacksAndMessages(null);
                        DefaultScreenCaptureSource.access$getHandler$p(this.this$0).getLooper().quit();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultScreenCaptureSource;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final int getStatusBarHeight() {
        int n;
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Resources resources2 = resources;
        int resourceId = resources2.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            n = resources2.getDimensionPixelSize(resourceId);
        } else {
            float f = (float)(Build.VERSION.SDK_INT >= 23 ? 24 : 25) * resources2.getDisplayMetrics().density;
            boolean bl = false;
            n = (int)Math.ceil(f);
        }
        return n;
    }

    public DefaultScreenCaptureSource(@NotNull Context context, @NotNull Logger logger, @NotNull SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, int activityResultCode, @NotNull Intent activityData, @NotNull DisplayManager displayManager, @NotNull MediaProjectionManager mediaProjectionManager) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)surfaceTextureCaptureSourceFactory, (String)"surfaceTextureCaptureSourceFactory");
        Intrinsics.checkParameterIsNotNull((Object)activityData, (String)"activityData");
        Intrinsics.checkParameterIsNotNull((Object)displayManager, (String)"displayManager");
        Intrinsics.checkParameterIsNotNull((Object)mediaProjectionManager, (String)"mediaProjectionManager");
        this.context = context;
        this.logger = logger;
        this.surfaceTextureCaptureSourceFactory = surfaceTextureCaptureSourceFactory;
        this.activityResultCode = activityResultCode;
        this.activityData = activityData;
        this.displayManager = displayManager;
        this.mediaProjectionManager = mediaProjectionManager;
        this.MIN_FPS = 15;
        DefaultScreenCaptureSource defaultScreenCaptureSource = this;
        boolean bl = false;
        defaultScreenCaptureSource.observers = set = (Set)new LinkedHashSet();
        this.sinks = ConcurrentSet.Companion.createConcurrentSet();
        this.contentHint = VideoContentHint.Text;
        this.isOrientationInPortrait = true;
        this.TAG = "DefaultScreenCaptureSource";
        HandlerThread thread = new HandlerThread(this.TAG);
        thread.start();
        this.handler = new Handler(thread.getLooper());
    }

    public /* synthetic */ DefaultScreenCaptureSource(Context context, Logger logger, SurfaceTextureCaptureSourceFactory surfaceTextureCaptureSourceFactory, int n, Intent intent, DisplayManager displayManager, MediaProjectionManager mediaProjectionManager, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            Object object = context.getSystemService("display");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
            }
            displayManager = (DisplayManager)object;
        }
        if ((n2 & 0x40) != 0) {
            Object object = context.getSystemService("media_projection");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
            }
            mediaProjectionManager = (MediaProjectionManager)object;
        }
        this(context, logger, surfaceTextureCaptureSourceFactory, n, intent, displayManager, mediaProjectionManager);
    }

    public static final /* synthetic */ boolean access$startInternal(DefaultScreenCaptureSource $this) {
        return $this.startInternal();
    }

    public static final /* synthetic */ boolean access$isRestartingForOrientationChange$p(DefaultScreenCaptureSource $this) {
        return $this.isRestartingForOrientationChange;
    }

    public static final /* synthetic */ void access$setRestartingForOrientationChange$p(DefaultScreenCaptureSource $this, boolean bl) {
        $this.isRestartingForOrientationChange = bl;
    }

    public static final /* synthetic */ Set access$getObservers$p(DefaultScreenCaptureSource $this) {
        return $this.observers;
    }

    public static final /* synthetic */ void access$stopInternal(DefaultScreenCaptureSource $this) {
        $this.stopInternal();
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultScreenCaptureSource $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultScreenCaptureSource $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ Handler access$getHandler$p(DefaultScreenCaptureSource $this) {
        return $this.handler;
    }
}

