/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.video;

import android.graphics.Matrix;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoContentHint;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoFrame;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSink;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameBuffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameI420Buffer;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameTextureBuffer;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.ConcurrentSet;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoSourceAdapter$VideoFrameTextureBufferAdapter$WhenMappings;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoSourceAdapter$WhenMappings;
import com.xodee.client.video.ContentHint;
import com.xodee.client.video.VideoFrameRGBABuffer;
import com.xodee.client.video.VideoFrameTextureBuffer;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u0017\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSink;", "Lcom/xodee/client/video/VideoSource;", "()V", "sinks", "", "Lcom/xodee/client/video/VideoSink;", "value", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "source", "getSource", "()Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "setSource", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;)V", "addSink", "", "sink", "getContentHint", "Lcom/xodee/client/video/ContentHint;", "onVideoFrameReceived", "frame", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoFrame;", "removeSink", "VideoFrameI420BufferAdapter", "VideoFrameRGBABufferAdapter", "VideoFrameTextureBufferAdapter", "amazon-chime-sdk_release"})
public final class VideoSourceAdapter
implements VideoSink,
com.xodee.client.video.VideoSource {
    @Nullable
    private VideoSource source;
    private Set<com.xodee.client.video.VideoSink> sinks = ConcurrentSet.Companion.createConcurrentSet();

    @Nullable
    public final VideoSource getSource() {
        return this.source;
    }

    public final void setSource(@Nullable VideoSource value) {
        block1: {
            VideoSource videoSource = this.source;
            if (videoSource != null) {
                videoSource.removeVideoSink(this);
            }
            VideoSource videoSource2 = this.source = value;
            if (videoSource2 == null) break block1;
            videoSource2.addVideoSink(this);
        }
    }

    public void addSink(@NotNull com.xodee.client.video.VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.add(sink);
    }

    public void removeSink(@NotNull com.xodee.client.video.VideoSink sink) {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        this.sinks.remove(sink);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public ContentHint getContentHint() {
        ContentHint contentHint;
        VideoSource videoSource = this.source;
        VideoContentHint videoContentHint = videoSource != null ? videoSource.getContentHint() : null;
        if (videoContentHint != null) {
            switch (VideoSourceAdapter$WhenMappings.$EnumSwitchMapping$0[videoContentHint.ordinal()]) {
                case 1: {
                    contentHint = ContentHint.NONE;
                    return contentHint;
                }
                case 2: {
                    contentHint = ContentHint.MOTION;
                    return contentHint;
                }
                case 3: {
                    contentHint = ContentHint.DETAIL;
                    return contentHint;
                }
                case 4: {
                    contentHint = ContentHint.TEXT;
                    return contentHint;
                }
            }
        }
        contentHint = ContentHint.NONE;
        return contentHint;
    }

    @Override
    public void onVideoFrameReceived(@NotNull VideoFrame frame) {
        com.xodee.client.video.VideoFrameBuffer videoFrameBuffer;
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        VideoFrameBuffer videoFrameBuffer2 = frame.getBuffer();
        if (videoFrameBuffer2 instanceof VideoFrameTextureBuffer) {
            videoFrameBuffer = (com.xodee.client.video.VideoFrameBuffer)new VideoFrameTextureBufferAdapter((VideoFrameTextureBuffer)frame.getBuffer());
        } else if (videoFrameBuffer2 instanceof VideoFrameI420Buffer) {
            videoFrameBuffer = (com.xodee.client.video.VideoFrameBuffer)new VideoFrameI420BufferAdapter((VideoFrameI420Buffer)frame.getBuffer());
        } else if (videoFrameBuffer2 instanceof com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer) {
            videoFrameBuffer = (com.xodee.client.video.VideoFrameBuffer)new VideoFrameRGBABufferAdapter((com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer)frame.getBuffer());
        } else {
            throw (Throwable)new InvalidParameterException("Media SDK only supports texture, I420, and RGBA video frame buffers");
        }
        com.xodee.client.video.VideoFrameBuffer buffer2 = videoFrameBuffer;
        com.xodee.client.video.VideoFrame videoClientFrame = new com.xodee.client.video.VideoFrame(frame.getWidth(), frame.getHeight(), frame.getTimestampNs(), frame.getRotation().getDegrees(), buffer2);
        Iterable $this$forEach$iv = this.sinks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            com.xodee.client.video.VideoSink it = (com.xodee.client.video.VideoSink)element$iv;
            boolean bl = false;
            it.onFrameCaptured(videoClientFrame);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter$VideoFrameTextureBufferAdapter;", "Lcom/xodee/client/video/VideoFrameTextureBuffer;", "textureBuffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameTextureBuffer;", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameTextureBuffer;)V", "getHeight", "", "getTextureId", "getTransformMatrix", "Landroid/graphics/Matrix;", "getType", "Lcom/xodee/client/video/VideoFrameTextureBuffer$Type;", "getWidth", "release", "", "retain", "amazon-chime-sdk_release"})
    public static final class VideoFrameTextureBufferAdapter
    implements com.xodee.client.video.VideoFrameTextureBuffer {
        private final VideoFrameTextureBuffer textureBuffer;

        public int getWidth() {
            return this.textureBuffer.getWidth();
        }

        public int getHeight() {
            return this.textureBuffer.getHeight();
        }

        @NotNull
        public VideoFrameTextureBuffer.Type getType() {
            VideoFrameTextureBuffer.Type type;
            switch (VideoSourceAdapter$VideoFrameTextureBufferAdapter$WhenMappings.$EnumSwitchMapping$0[this.textureBuffer.getType().ordinal()]) {
                case 1: {
                    type = VideoFrameTextureBuffer.Type.OES;
                    break;
                }
                case 2: {
                    type = VideoFrameTextureBuffer.Type.RGB;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return type;
        }

        @Nullable
        public Matrix getTransformMatrix() {
            return this.textureBuffer.getTransformMatrix();
        }

        public int getTextureId() {
            return this.textureBuffer.getTextureId();
        }

        public void release() {
            this.textureBuffer.release();
        }

        public void retain() {
            this.textureBuffer.retain();
        }

        public VideoFrameTextureBufferAdapter(@NotNull VideoFrameTextureBuffer textureBuffer) {
            Intrinsics.checkParameterIsNotNull((Object)textureBuffer, (String)"textureBuffer");
            this.textureBuffer = textureBuffer;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter$VideoFrameRGBABufferAdapter;", "Lcom/xodee/client/video/VideoFrameRGBABuffer;", "rgbaBuffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameRGBABuffer;", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameRGBABuffer;)V", "getData", "Ljava/nio/ByteBuffer;", "getHeight", "", "getStride", "getWidth", "release", "", "retain", "amazon-chime-sdk_release"})
    public static final class VideoFrameRGBABufferAdapter
    implements VideoFrameRGBABuffer {
        private final com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer rgbaBuffer;

        public int getWidth() {
            return this.rgbaBuffer.getWidth();
        }

        public int getHeight() {
            return this.rgbaBuffer.getHeight();
        }

        @Nullable
        public ByteBuffer getData() {
            return this.rgbaBuffer.getData();
        }

        public int getStride() {
            return this.rgbaBuffer.getStride();
        }

        public void retain() {
            this.rgbaBuffer.retain();
        }

        public void release() {
            this.rgbaBuffer.release();
        }

        public VideoFrameRGBABufferAdapter(@NotNull com.amazonaws.services.chime.sdk.meetings.audiovideo.video.buffer.VideoFrameRGBABuffer rgbaBuffer) {
            Intrinsics.checkParameterIsNotNull((Object)rgbaBuffer, (String)"rgbaBuffer");
            this.rgbaBuffer = rgbaBuffer;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoSourceAdapter$VideoFrameI420BufferAdapter;", "Lcom/xodee/client/video/VideoFrameI420Buffer;", "i420Buffer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameI420Buffer;", "(Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/buffer/VideoFrameI420Buffer;)V", "getDataU", "Ljava/nio/ByteBuffer;", "getDataV", "getDataY", "getHeight", "", "getStrideU", "getStrideV", "getStrideY", "getWidth", "release", "", "retain", "amazon-chime-sdk_release"})
    public static final class VideoFrameI420BufferAdapter
    implements com.xodee.client.video.VideoFrameI420Buffer {
        private final VideoFrameI420Buffer i420Buffer;

        public int getWidth() {
            return this.i420Buffer.getWidth();
        }

        public int getHeight() {
            return this.i420Buffer.getHeight();
        }

        @Nullable
        public ByteBuffer getDataY() {
            return this.i420Buffer.getDataY();
        }

        @Nullable
        public ByteBuffer getDataU() {
            return this.i420Buffer.getDataU();
        }

        @Nullable
        public ByteBuffer getDataV() {
            return this.i420Buffer.getDataV();
        }

        public int getStrideY() {
            return this.i420Buffer.getStrideY();
        }

        public int getStrideU() {
            return this.i420Buffer.getStrideU();
        }

        public int getStrideV() {
            return this.i420Buffer.getStrideV();
        }

        public void retain() {
            this.i420Buffer.retain();
        }

        public void release() {
            this.i420Buffer.release();
        }

        public VideoFrameI420BufferAdapter(@NotNull VideoFrameI420Buffer i420Buffer) {
            Intrinsics.checkParameterIsNotNull((Object)i420Buffer, (String)"i420Buffer");
            this.i420Buffer = i420Buffer;
        }
    }
}

