/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.audiovideo;

import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoConfiguration;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoControllerFacade;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.metric.MetricsObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.RemoteVideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSource;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.VideoSubscriptionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.metric.ClientMetricsCollector;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.video.VideoClientObserver;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionConfiguration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\b\u0010 \u001a\u00020\u0010H\u0016J/\u0010!\u001a\u00020\u00102\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020$0'H\u0016\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/DefaultAudioVideoController;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoControllerFacade;", "audioClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;", "audioClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "clientMetricsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;", "configuration", "Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;", "videoClientController", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;", "videoClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;Lcom/amazonaws/services/chime/sdk/meetings/internal/metric/ClientMetricsCollector;Lcom/amazonaws/services/chime/sdk/meetings/session/MeetingSessionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientController;Lcom/amazonaws/services/chime/sdk/meetings/internal/video/VideoClientObserver;)V", "addAudioVideoObserver", "", "observer", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoObserver;", "addMetricsObserver", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/metric/MetricsObserver;", "removeAudioVideoObserver", "removeMetricsObserver", "start", "audioVideoConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/AudioVideoConfiguration;", "startLocalVideo", "source", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSource;", "startRemoteVideo", "stop", "stopLocalVideo", "stopRemoteVideo", "updateVideoSourceSubscriptions", "addedOrUpdated", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/VideoSubscriptionConfiguration;", "removed", "", "(Ljava/util/Map;[Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/RemoteVideoSource;)V", "amazon-chime-sdk_release"})
public final class DefaultAudioVideoController
implements AudioVideoControllerFacade {
    private final AudioClientController audioClientController;
    private final AudioClientObserver audioClientObserver;
    private final ClientMetricsCollector clientMetricsCollector;
    private final MeetingSessionConfiguration configuration;
    private final VideoClientController videoClientController;
    private final VideoClientObserver videoClientObserver;

    @Override
    public void start() {
        this.start(new AudioVideoConfiguration(null, 1, null));
    }

    @Override
    public void start(@NotNull AudioVideoConfiguration audioVideoConfiguration) {
        Intrinsics.checkParameterIsNotNull((Object)audioVideoConfiguration, (String)"audioVideoConfiguration");
        this.audioClientController.start(this.configuration.getUrls().getAudioFallbackURL(), this.configuration.getUrls().getAudioHostURL(), this.configuration.getMeetingId(), this.configuration.getCredentials().getAttendeeId(), this.configuration.getCredentials().getJoinToken(), audioVideoConfiguration.getAudioMode());
        this.videoClientController.start();
    }

    @Override
    public void stop() {
        this.audioClientController.stop();
        this.videoClientController.stopAndDestroy();
    }

    @Override
    public void startLocalVideo() {
        this.videoClientController.startLocalVideo();
    }

    @Override
    public void startLocalVideo(@NotNull VideoSource source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.videoClientController.startLocalVideo(source);
    }

    @Override
    public void stopLocalVideo() {
        this.videoClientController.stopLocalVideo();
    }

    @Override
    public void startRemoteVideo() {
        this.videoClientController.startRemoteVideo();
    }

    @Override
    public void stopRemoteVideo() {
        this.videoClientController.stopRemoteVideo();
    }

    @Override
    public void addAudioVideoObserver(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.audioClientObserver.subscribeToAudioClientStateChange(observer);
        this.videoClientObserver.subscribeToVideoClientStateChange(observer);
    }

    @Override
    public void removeAudioVideoObserver(@NotNull AudioVideoObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.audioClientObserver.unsubscribeFromAudioClientStateChange(observer);
        this.videoClientObserver.unsubscribeFromVideoClientStateChange(observer);
    }

    @Override
    public void addMetricsObserver(@NotNull MetricsObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.clientMetricsCollector.subscribeToMetrics(observer);
    }

    @Override
    public void removeMetricsObserver(@NotNull MetricsObserver observer) {
        Intrinsics.checkParameterIsNotNull((Object)observer, (String)"observer");
        this.clientMetricsCollector.unsubscribeFromMetrics(observer);
    }

    @Override
    public void updateVideoSourceSubscriptions(@NotNull Map<RemoteVideoSource, VideoSubscriptionConfiguration> addedOrUpdated, @NotNull RemoteVideoSource[] removed) {
        Intrinsics.checkParameterIsNotNull(addedOrUpdated, (String)"addedOrUpdated");
        Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
        this.videoClientController.updateVideoSourceSubscriptions(addedOrUpdated, removed);
    }

    public DefaultAudioVideoController(@NotNull AudioClientController audioClientController, @NotNull AudioClientObserver audioClientObserver, @NotNull ClientMetricsCollector clientMetricsCollector, @NotNull MeetingSessionConfiguration configuration, @NotNull VideoClientController videoClientController, @NotNull VideoClientObserver videoClientObserver) {
        Intrinsics.checkParameterIsNotNull((Object)audioClientController, (String)"audioClientController");
        Intrinsics.checkParameterIsNotNull((Object)audioClientObserver, (String)"audioClientObserver");
        Intrinsics.checkParameterIsNotNull((Object)clientMetricsCollector, (String)"clientMetricsCollector");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)videoClientController, (String)"videoClientController");
        Intrinsics.checkParameterIsNotNull((Object)videoClientObserver, (String)"videoClientObserver");
        this.audioClientController = audioClientController;
        this.audioClientObserver = audioClientObserver;
        this.clientMetricsCollector = clientMetricsCollector;
        this.configuration = configuration;
        this.videoClientController = videoClientController;
        this.videoClientObserver = videoClientObserver;
    }
}

