/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.ingestion;

import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventBuffer;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventClientConfiguration;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventReporter;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionConfiguration;
import com.amazonaws.services.chime.sdk.meetings.ingestion.MeetingEventClientConfiguration;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.SDKEvent;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/ingestion/DefaultEventReporter;", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventReporter;", "ingestionConfiguration", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionConfiguration;", "eventBuffer", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventBuffer;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "timer", "Ljava/util/Timer;", "(Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionConfiguration;Lcom/amazonaws/services/chime/sdk/meetings/ingestion/EventBuffer;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Ljava/util/Timer;)V", "TAG", "", "isStarted", "", "report", "", "event", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/SDKEvent;", "start", "stop", "amazon-chime-sdk_release"})
public final class DefaultEventReporter
implements EventReporter {
    private final String TAG = "DefaultEventReporter";
    private boolean isStarted;
    private final IngestionConfiguration ingestionConfiguration;
    private final EventBuffer eventBuffer;
    private final Logger logger;
    private final Timer timer;

    @Override
    public void report(@NotNull SDKEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        EventClientConfiguration eventClientConfiguration = this.ingestionConfiguration.getClientConfiguration();
        if (eventClientConfiguration instanceof MeetingEventClientConfiguration) {
            event.getEventAttributes().putAll(MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.meetingId), (Object)((MeetingEventClientConfiguration)this.ingestionConfiguration.getClientConfiguration()).getMeetingId()), TuplesKt.to((Object)((Object)EventAttributeName.attendeeId), (Object)((MeetingEventClientConfiguration)this.ingestionConfiguration.getClientConfiguration()).getAttendeeId())}));
        }
        this.eventBuffer.add(event);
    }

    @Override
    public void start() {
        if (this.isStarted) {
            return;
        }
        this.timer.scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ DefaultEventReporter this$0;

            public void run() {
                DefaultEventReporter.access$getEventBuffer$p(this.this$0).process();
            }
            {
                this.this$0 = $outer;
            }
        }, this.ingestionConfiguration.getFlushIntervalMs(), this.ingestionConfiguration.getFlushIntervalMs());
    }

    @Override
    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.timer.cancel();
    }

    public DefaultEventReporter(@NotNull IngestionConfiguration ingestionConfiguration, @NotNull EventBuffer eventBuffer, @NotNull Logger logger, @NotNull Timer timer) {
        Intrinsics.checkParameterIsNotNull((Object)ingestionConfiguration, (String)"ingestionConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)eventBuffer, (String)"eventBuffer");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)timer, (String)"timer");
        this.ingestionConfiguration = ingestionConfiguration;
        this.eventBuffer = eventBuffer;
        this.logger = logger;
        this.timer = timer;
        this.TAG = "DefaultEventReporter";
        this.start();
    }

    public /* synthetic */ DefaultEventReporter(IngestionConfiguration ingestionConfiguration, EventBuffer eventBuffer, Logger logger, Timer timer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            timer = new Timer("DefaultEventReporter", false);
        }
        this(ingestionConfiguration, eventBuffer, logger, timer);
    }

    public static final /* synthetic */ EventBuffer access$getEventBuffer$p(DefaultEventReporter $this) {
        return $this.eventBuffer;
    }
}

