/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion;

import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.ingestion.EventClientType;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionEvent;
import com.amazonaws.services.chime.sdk.meetings.ingestion.IngestionRecord;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.DirtyMeetingEventItem;
import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.MeetingEventItem;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.EventAttributesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\fJ\u0014\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00120\fJ0\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0014j\u0002`\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0014j\u0002`\u0017H\u0002J \u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0014j\u0002`\u00152\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J \u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0014j\u0002`\u00152\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J \u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001bj\u0002`\u001c2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/IngestionEventConverter;", "", "()V", "ID_KEY", "", "NAME_KEY", "TIMESTAMP_KEY", "TTL_KEY", "attributesToFilter", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributeName;", "eventMetadataAttributeNames", "", "fromDirtyMeetingEventItems", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionRecord;", "items", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/DirtyMeetingEventItem;", "fromMeetingEventItems", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/MeetingEventItem;", "toIngestionMetadata", "", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionMetadata;", "eventAttributes", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributes;", "dirtyEventItem", "eventItem", "toIngestionPayload", "", "Lcom/amazonaws/services/chime/sdk/meetings/ingestion/IngestionPayload;", "dirtyEvent", "event", "amazon-chime-sdk_release"})
public final class IngestionEventConverter {
    private static final String NAME_KEY = "name";
    private static final String TIMESTAMP_KEY = "ts";
    private static final String ID_KEY = "id";
    private static final String TTL_KEY = "ttl";
    private static final Set<EventAttributeName> attributesToFilter;
    private static final List<EventAttributeName> eventMetadataAttributeNames;
    public static final IngestionEventConverter INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IngestionRecord fromDirtyMeetingEventItems(@NotNull List<DirtyMeetingEventItem> items) {
        void $this$mapTo$iv$iv;
        Map dirtyMeetingEventsByMeetingId;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (items.isEmpty()) {
            List list;
            boolean bl = false;
            Map map = new LinkedHashMap();
            bl = false;
            List list2 = list = CollectionsKt.emptyList();
            Map map2 = map;
            return new IngestionRecord(map2, list2);
        }
        Iterable $this$groupBy$iv = items;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String string;
            DirtyMeetingEventItem it = (DirtyMeetingEventItem)element$iv$iv;
            boolean bl = false;
            Object object2 = it.getData().getEventAttributes().get((Object)EventAttributeName.meetingId);
            if (!(object2 instanceof String)) {
                object2 = null;
            }
            if ((string = (String)object2) == null) {
                string = "";
            }
            String key$iv$iv = string;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = dirtyMeetingEventsByMeetingId = destination$iv$iv;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_18 = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry item$iv$iv : var9_18.entrySet()) {
            Collection<Map<String, Object>> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            $this$getOrPut$iv$iv$iv = item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl3 = false;
            value$iv$iv$iv = (Iterable)it.getValue();
            Map<EventAttributeName, Object> map = INSTANCE.toIngestionMetadata((DirtyMeetingEventItem)CollectionsKt.first((List)((List)it.getValue())));
            EventClientType eventClientType = EventClientType.Meet;
            boolean $i$f$map2 = false;
            void var21_31 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void meetingEventItem;
                DirtyMeetingEventItem dirtyMeetingEventItem = (DirtyMeetingEventItem)item$iv$iv2;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                Map<String, Object> map3 = INSTANCE.toIngestionPayload((DirtyMeetingEventItem)meetingEventItem);
                collection.add(map3);
            }
            collection = (List)destination$iv$iv3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            int n2 = 0;
            List list = collection;
            Map<EventAttributeName, Object> map4 = map;
            EventClientType eventClientType2 = eventClientType;
            IngestionEvent ingestionEvent = new IngestionEvent(eventClientType2, map4, list, n2, n, defaultConstructorMarker);
            collection2.add(ingestionEvent);
        }
        List ingestionEvents = (List)destination$iv$iv2;
        Map<EventAttributeName, Object> rootMetadata = EventAttributesUtils.INSTANCE.getCommonAttributes();
        return new IngestionRecord(rootMetadata, ingestionEvents);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IngestionRecord fromMeetingEventItems(@NotNull List<MeetingEventItem> items) {
        void $this$mapTo$iv$iv;
        Map meetingEventsByMeetingId;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (items.isEmpty()) {
            List list;
            boolean bl = false;
            Map map = new LinkedHashMap();
            bl = false;
            List list2 = list = CollectionsKt.emptyList();
            Map map2 = map;
            return new IngestionRecord(map2, list2);
        }
        Iterable $this$groupBy$iv = items;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            String string;
            MeetingEventItem it = (MeetingEventItem)element$iv$iv;
            boolean bl = false;
            Object object2 = it.getData().getEventAttributes().get((Object)EventAttributeName.meetingId);
            if (!(object2 instanceof String)) {
                object2 = null;
            }
            if ((string = (String)object2) == null) {
                string = "";
            }
            String key$iv$iv = string;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = meetingEventsByMeetingId = destination$iv$iv;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_18 = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry item$iv$iv : var9_18.entrySet()) {
            Collection<Map<String, Object>> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void it;
            $this$getOrPut$iv$iv$iv = item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl3 = false;
            value$iv$iv$iv = (Iterable)it.getValue();
            Map<EventAttributeName, Object> map = INSTANCE.toIngestionMetadata((MeetingEventItem)CollectionsKt.first((List)((List)it.getValue())));
            EventClientType eventClientType = EventClientType.Meet;
            boolean $i$f$map2 = false;
            void var21_31 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void meetingEventItem;
                MeetingEventItem meetingEventItem2 = (MeetingEventItem)item$iv$iv2;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                Map<String, Object> map3 = INSTANCE.toIngestionPayload((MeetingEventItem)meetingEventItem);
                collection.add(map3);
            }
            collection = (List)destination$iv$iv3;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            int n2 = 0;
            List list = collection;
            Map<EventAttributeName, Object> map4 = map;
            EventClientType eventClientType2 = eventClientType;
            IngestionEvent ingestionEvent = new IngestionEvent(eventClientType2, map4, list, n2, n, defaultConstructorMarker);
            collection2.add(ingestionEvent);
        }
        List ingestionEvents = (List)destination$iv$iv2;
        Map<EventAttributeName, Object> rootMetadata = EventAttributesUtils.INSTANCE.getCommonAttributes();
        return new IngestionRecord(rootMetadata, ingestionEvents);
    }

    private final Map<EventAttributeName, Object> toIngestionMetadata(MeetingEventItem eventItem) {
        return this.toIngestionMetadata(eventItem.getData().getEventAttributes());
    }

    private final Map<EventAttributeName, Object> toIngestionMetadata(DirtyMeetingEventItem dirtyEventItem) {
        return this.toIngestionMetadata(dirtyEventItem.getData().getEventAttributes());
    }

    private final Map<EventAttributeName, Object> toIngestionMetadata(Map<EventAttributeName, Object> eventAttributes) {
        boolean bl = false;
        Map ingestionMetadata = new LinkedHashMap();
        for (EventAttributeName attributeName : eventMetadataAttributeNames) {
            Object object;
            Object value = eventAttributes.get((Object)attributeName);
            if (value == null) continue;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            ingestionMetadata.put(attributeName, it);
        }
        return ingestionMetadata;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toIngestionPayload(MeetingEventItem event) {
        void $this$filterNotTo$iv$iv;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)NAME_KEY, (Object)event.getData().getName());
        Object object = event.getData().getEventAttributes().get((Object)EventAttributeName.timestampMs);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
        }
        pairArray[1] = TuplesKt.to((Object)TIMESTAMP_KEY, (Object)((long)((Double)object).doubleValue()));
        pairArray[2] = TuplesKt.to((Object)ID_KEY, (Object)event.getId());
        Map payload = MapsKt.mutableMapOf((Pair[])pairArray);
        Map $this$filterNot$iv = event.getData().getEventAttributes();
        boolean $i$f$filterNot = false;
        Map map = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        void var8_10 = $this$filterNotTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_10.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (attributesToFilter.contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl4 = false;
            payload.put(((EventAttributeName)((Object)it.getKey())).name(), it.getValue());
        }
        return payload;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> toIngestionPayload(DirtyMeetingEventItem dirtyEvent) {
        void $this$filterNotTo$iv$iv;
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)NAME_KEY, (Object)dirtyEvent.getData().getName());
        pairArray[1] = TuplesKt.to((Object)TTL_KEY, (Object)dirtyEvent.getTtl());
        Object object = dirtyEvent.getData().getEventAttributes().get((Object)EventAttributeName.timestampMs);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
        }
        pairArray[2] = TuplesKt.to((Object)TIMESTAMP_KEY, (Object)((long)((Double)object).doubleValue()));
        pairArray[3] = TuplesKt.to((Object)ID_KEY, (Object)dirtyEvent.getId());
        Map payload = MapsKt.mutableMapOf((Pair[])pairArray);
        Map $this$filterNot$iv = dirtyEvent.getData().getEventAttributes();
        boolean $i$f$filterNot = false;
        Map map = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        void var8_10 = $this$filterNotTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_10.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (attributesToFilter.contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl4 = false;
            payload.put(((EventAttributeName)((Object)it.getKey())).name(), it.getValue());
        }
        return payload;
    }

    private IngestionEventConverter() {
    }

    static {
        IngestionEventConverter ingestionEventConverter;
        INSTANCE = ingestionEventConverter = new IngestionEventConverter();
        attributesToFilter = SetsKt.setOf((Object[])new EventAttributeName[]{EventAttributeName.meetingId, EventAttributeName.attendeeId});
        eventMetadataAttributeNames = CollectionsKt.listOf((Object[])new EventAttributeName[]{EventAttributeName.meetingId, EventAttributeName.attendeeId});
    }
}

