/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.ingestion;

import com.amazonaws.services.chime.sdk.meetings.internal.ingestion.SDKEvent;
import com.google.gson.Gson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/EventTypeConverters;", "", "()V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "fromMeetingEvent", "", "event", "Lcom/amazonaws/services/chime/sdk/meetings/internal/ingestion/SDKEvent;", "toMeetingEvent", "data", "amazon-chime-sdk_release"})
public final class EventTypeConverters {
    @NotNull
    private static final Gson gson;
    public static final EventTypeConverters INSTANCE;

    @NotNull
    public final Gson getGson() {
        return gson;
    }

    @NotNull
    public final SDKEvent toMeetingEvent(@NotNull String data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Object object = gson.fromJson(data, SDKEvent.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(data, SDKEvent::class.java)");
        return (SDKEvent)object;
    }

    @NotNull
    public final String fromMeetingEvent(@NotNull SDKEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = gson.toJson((Object)event);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(event)");
        return string;
    }

    private EventTypeConverters() {
    }

    static {
        EventTypeConverters eventTypeConverters;
        INSTANCE = eventTypeConverters = new EventTypeConverters();
        gson = new Gson();
    }
}

