/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.internal.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAnalyticsController;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.EventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.AudioVideoObserver;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.audio.AudioMode;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientObserver;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.AudioClientState;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientController;
import com.amazonaws.services.chime.sdk.meetings.internal.audio.DefaultAudioClientController$WhenMappings;
import com.amazonaws.services.chime.sdk.meetings.internal.utils.AppInfoUtil;
import com.amazonaws.services.chime.sdk.meetings.session.MeetingSessionStatusCode;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import com.xodee.client.audio.audioclient.AppInfo;
import com.xodee.client.audio.audioclient.AudioClient;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 32\u00020\u0001:\u00013B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001e\u001a\u00020\u0010H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0010H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0014H\u0016J8\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)H\u0016J\b\u00102\u001a\u00020!H\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientController;", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientController;", "context", "Landroid/content/Context;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "audioClientObserver", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;", "audioClient", "Lcom/xodee/client/audio/audioclient/AudioClient;", "meetingStatsCollector", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;", "eventAnalyticsController", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;", "(Landroid/content/Context;Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientObserver;Lcom/xodee/client/audio/audioclient/AudioClient;Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAnalyticsController;)V", "AUDIO_CLIENT_RESULT_SUCCESS", "", "AUDIO_PORT_OFFSET", "DEFAULT_PORT", "DEFAULT_PRESENTER", "", "TAG", "", "audioManager", "Landroid/media/AudioManager;", "audioModePreCall", "muteMicAndSpeaker", "speakerphoneStatePreCall", "uiScope", "Lkotlinx/coroutines/CoroutineScope;", "getRoute", "isVoiceFocusEnabled", "notifyStop", "", "resetAudioManager", "setMute", "isMuted", "setRoute", "route", "setUpAudioConfiguration", "audioMode", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/audio/AudioMode;", "setVoiceFocusEnabled", "enabled", "start", "audioFallbackUrl", "audioHostUrl", "meetingId", "attendeeId", "joinToken", "stop", "Companion", "amazon-chime-sdk_release"})
public final class DefaultAudioClientController
implements AudioClientController {
    private final String TAG = "DefaultAudioClientController";
    private final int DEFAULT_PORT = 0;
    private final int AUDIO_PORT_OFFSET = 200;
    private final boolean DEFAULT_PRESENTER = true;
    private final int AUDIO_CLIENT_RESULT_SUCCESS = 0;
    private boolean muteMicAndSpeaker;
    private final CoroutineScope uiScope;
    private final AudioManager audioManager;
    private int audioModePreCall;
    private boolean speakerphoneStatePreCall;
    private final Context context;
    private final Logger logger;
    private final AudioClientObserver audioClientObserver;
    private final AudioClient audioClient;
    private final MeetingStatsCollector meetingStatsCollector;
    private final EventAnalyticsController eventAnalyticsController;
    @NotNull
    private static AudioClientState audioClientState;
    public static final Companion Companion;

    private final void setUpAudioConfiguration(AudioMode audioMode) {
        int n;
        int n2;
        int nativeSR = AudioTrack.getNativeOutputSampleRate((int)1);
        this.audioClient.sendMessage(4, nativeSR);
        switch (DefaultAudioClientController$WhenMappings.$EnumSwitchMapping$0[audioMode.ordinal()]) {
            case 1: {
                n2 = 16000;
                break;
            }
            case 2: {
                n2 = 48000;
                break;
            }
            case 3: {
                n2 = 48000;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int samplingRateConfig = n2;
        this.audioClient.sendMessage(5, samplingRateConfig);
        switch (DefaultAudioClientController$WhenMappings.$EnumSwitchMapping$1[audioMode.ordinal()]) {
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 12;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int outputChannelConfig = n;
        int spkMinBufSizeInSamples = AudioTrack.getMinBufferSize((int)nativeSR, (int)outputChannelConfig, (int)2) / 2;
        int micMinBufSizeInSamples = AudioRecord.getMinBufferSize((int)nativeSR, (int)16, (int)2) / 2;
        this.logger.info(this.TAG, "spkMinBufSizeInSamples " + spkMinBufSizeInSamples + " micMinBufSizeInSamples " + micMinBufSizeInSamples);
        this.audioClient.sendMessage(2, micMinBufSizeInSamples);
        this.audioClient.sendMessage(3, spkMinBufSizeInSamples);
        this.audioClient.sendMessage(6, 1);
        this.audioClient.sendMessage(7, 0);
        this.audioClient.sendMessage(8, 0);
    }

    @Override
    public int getRoute() {
        return this.audioClient.getRoute();
    }

    @Override
    public boolean setRoute(int route) {
        if (this.getRoute() == route) {
            return true;
        }
        this.logger.info(this.TAG, "Setting route to " + route);
        return this.audioClient.setRoute(route) == this.AUDIO_CLIENT_RESULT_SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start(@NotNull String audioFallbackUrl, @NotNull String audioHostUrl, @NotNull String meetingId, @NotNull String attendeeId, @NotNull String joinToken, @NotNull AudioMode audioMode) {
        void host;
        int it2;
        List iterator$iv2;
        List list;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)audioFallbackUrl, (String)"audioFallbackUrl");
        Intrinsics.checkParameterIsNotNull((Object)audioHostUrl, (String)"audioHostUrl");
        Intrinsics.checkParameterIsNotNull((Object)meetingId, (String)"meetingId");
        Intrinsics.checkParameterIsNotNull((Object)attendeeId, (String)"attendeeId");
        Intrinsics.checkParameterIsNotNull((Object)joinToken, (String)"joinToken");
        Intrinsics.checkParameterIsNotNull((Object)((Object)audioMode), (String)"audioMode");
        if (audioClientState != AudioClientState.INITIALIZED && audioClientState != AudioClientState.STOPPED) {
            this.logger.warn(this.TAG, "Current audio client state " + (Object)((Object)audioClientState) + " is invalid to start audio, ignoring");
            return;
        }
        CharSequence charSequence = audioHostUrl;
        String string = ":";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl2 = false;
        Object $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv2 = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv2.hasPrevious()) {
                String it2 = (String)iterator$iv2.previous();
                bl = false;
                CharSequence charSequence2 = it2;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv2.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        List audioUrlParts = list;
        List it2 = iterator$iv2 = audioUrlParts.size() == 2 ? audioUrlParts : CollectionsKt.listOf((Object[])new String[]{(String)audioUrlParts.get(0), String.valueOf(this.AUDIO_PORT_OFFSET)});
        bl = false;
        $this$dropLastWhile$iv = (String)it2.get(0);
        it2 = iterator$iv2;
        bl = false;
        String portStr = (String)it2.get(1);
        try {
            it2 = Integer.parseInt(portStr) - this.AUDIO_PORT_OFFSET;
        }
        catch (Exception exception) {
            this.logger.warn(this.TAG, "Error parsing int. Using default value. Exception: " + exception.getMessage());
            it2 = this.DEFAULT_PORT;
        }
        int port = it2;
        this.setUpAudioConfiguration(audioMode);
        EventAnalyticsController.DefaultImpls.publishEvent$default(this.eventAnalyticsController, EventName.meetingStartRequested, null, 2, null);
        this.audioClientObserver.notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)start.1.INSTANCE));
        this.audioManager.setMode(3);
        AppInfo appInfo = AppInfoUtil.INSTANCE.initializeAudioClientAppInfo(this.context);
        BuildersKt.launch$default((CoroutineScope)this.uiScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, audioMode, (String)host, port, joinToken, meetingId, attendeeId, audioFallbackUrl, appInfo, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultAudioClientController this$0;
            final /* synthetic */ AudioMode $audioMode;
            final /* synthetic */ String $host;
            final /* synthetic */ int $port;
            final /* synthetic */ String $joinToken;
            final /* synthetic */ String $meetingId;
            final /* synthetic */ String $attendeeId;
            final /* synthetic */ String $audioFallbackUrl;
            final /* synthetic */ AppInfo $appInfo;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        AudioClient.AudioModeInternal audioModeInternal;
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        switch (DefaultAudioClientController$WhenMappings.$EnumSwitchMapping$2[this.$audioMode.ordinal()]) {
                            case 1: {
                                audioModeInternal = AudioClient.AudioModeInternal.MONO_16K;
                                break;
                            }
                            case 2: {
                                audioModeInternal = AudioClient.AudioModeInternal.MONO_48K;
                                break;
                            }
                            case 3: {
                                audioModeInternal = AudioClient.AudioModeInternal.STEREO_48K;
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        AudioClient.AudioModeInternal audioModeInternal2 = audioModeInternal;
                        int res = DefaultAudioClientController.access$getAudioClient$p(this.this$0).startSessionV2(3, this.$host, this.$port, this.$joinToken, this.$meetingId, this.$attendeeId, DefaultAudioClientController.access$getMuteMicAndSpeaker$p(this.this$0), DefaultAudioClientController.access$getMuteMicAndSpeaker$p(this.this$0), DefaultAudioClientController.access$getDEFAULT_PRESENTER$p(this.this$0), this.$audioFallbackUrl, null, this.$appInfo, audioModeInternal2);
                        if (res != DefaultAudioClientController.access$getAUDIO_CLIENT_RESULT_SUCCESS$p(this.this$0)) {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).error(DefaultAudioClientController.access$getTAG$p(this.this$0), "Failed to start audio session. Response code: " + res);
                            EventAnalyticsController.DefaultImpls.publishEvent$default(DefaultAudioClientController.access$getEventAnalyticsController$p(this.this$0), EventName.meetingStartFailed, null, 2, null);
                        } else {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).info(DefaultAudioClientController.access$getTAG$p(this.this$0), "Started audio session.");
                            DefaultAudioClientController.Companion.setAudioClientState(AudioClientState.STARTED);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultAudioClientController;
                this.$audioMode = audioMode;
                this.$host = string;
                this.$port = n;
                this.$joinToken = string2;
                this.$meetingId = string3;
                this.$attendeeId = string4;
                this.$audioFallbackUrl = string5;
                this.$appInfo = appInfo;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void stop() {
        if (audioClientState != AudioClientState.STARTED) {
            this.logger.error(this.TAG, "Current audio client state " + (Object)((Object)audioClientState) + " is invalid to stop audio, ignoring");
            return;
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ DefaultAudioClientController this$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        int res = DefaultAudioClientController.access$getAudioClient$p(this.this$0).stopSession();
                        if (res != DefaultAudioClientController.access$getAUDIO_CLIENT_RESULT_SUCCESS$p(this.this$0)) {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).error(DefaultAudioClientController.access$getTAG$p(this.this$0), "Failed to stop audio session. Response code: " + res);
                        } else {
                            DefaultAudioClientController.access$getLogger$p(this.this$0).info(DefaultAudioClientController.access$getTAG$p(this.this$0), "Stopped audio session.");
                            DefaultAudioClientController.Companion.setAudioClientState(AudioClientState.STOPPED);
                            DefaultAudioClientController.access$resetAudioManager(this.this$0);
                            DefaultAudioClientController.access$notifyStop(this.this$0);
                            DefaultAudioClientController.access$getAudioClientObserver$p(this.this$0).notifyAudioClientObserver((Function1<? super AudioVideoObserver, Unit>)((Function1)stop.1.INSTANCE));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = defaultAudioClientController;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void notifyStop() {
        this.eventAnalyticsController.publishEvent(EventName.meetingEnded, MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)EventAttributeName.meetingStatus), (Object)((Object)MeetingSessionStatusCode.OK))}));
        this.meetingStatsCollector.resetMeetingStats();
    }

    private final void resetAudioManager() {
        AudioManager audioManager = this.audioManager;
        boolean bl = false;
        boolean bl2 = false;
        AudioManager $this$apply = audioManager;
        boolean bl3 = false;
        $this$apply.setBluetoothScoOn(false);
        $this$apply.stopBluetoothSco();
        this.audioManager.setMode(this.audioModePreCall);
        this.audioManager.setSpeakerphoneOn(this.speakerphoneStatePreCall);
    }

    @Override
    public boolean setMute(boolean isMuted) {
        return audioClientState == AudioClientState.STARTED && this.audioClient.setMicMute(isMuted) == 0;
    }

    @Override
    public boolean setVoiceFocusEnabled(boolean enabled) {
        if (audioClientState == AudioClientState.STARTED) {
            return this.audioClient.setVoiceFocusNoiseSuppression(enabled) == 0;
        }
        this.logger.error(this.TAG, "Failed to set VoiceFocus to " + enabled + "; audio client state is " + (Object)((Object)audioClientState));
        return false;
    }

    @Override
    public boolean isVoiceFocusEnabled() {
        if (audioClientState == AudioClientState.STARTED) {
            return this.audioClient.getVoiceFocusNoiseSuppression();
        }
        this.logger.error(this.TAG, "Failed to get VoiceFocus enabled state; audio client state is " + (Object)((Object)audioClientState));
        return false;
    }

    public DefaultAudioClientController(@NotNull Context context, @NotNull Logger logger, @NotNull AudioClientObserver audioClientObserver, @NotNull AudioClient audioClient, @NotNull MeetingStatsCollector meetingStatsCollector, @NotNull EventAnalyticsController eventAnalyticsController) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)audioClientObserver, (String)"audioClientObserver");
        Intrinsics.checkParameterIsNotNull((Object)audioClient, (String)"audioClient");
        Intrinsics.checkParameterIsNotNull((Object)meetingStatsCollector, (String)"meetingStatsCollector");
        Intrinsics.checkParameterIsNotNull((Object)eventAnalyticsController, (String)"eventAnalyticsController");
        this.context = context;
        this.logger = logger;
        this.audioClientObserver = audioClientObserver;
        this.audioClient = audioClient;
        this.meetingStatsCollector = meetingStatsCollector;
        this.eventAnalyticsController = eventAnalyticsController;
        this.TAG = "DefaultAudioClientController";
        this.AUDIO_PORT_OFFSET = 200;
        this.DEFAULT_PRESENTER = true;
        this.uiScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain()));
        Object object = this.context.getSystemService("audio");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.media.AudioManager");
        }
        this.audioManager = (AudioManager)object;
        this.audioModePreCall = this.audioManager.getMode();
        this.speakerphoneStatePreCall = this.audioManager.isSpeakerphoneOn();
    }

    static {
        Companion = new Companion(null);
        audioClientState = AudioClientState.INITIALIZED;
    }

    public static final /* synthetic */ AudioClient access$getAudioClient$p(DefaultAudioClientController $this) {
        return $this.audioClient;
    }

    public static final /* synthetic */ boolean access$getMuteMicAndSpeaker$p(DefaultAudioClientController $this) {
        return $this.muteMicAndSpeaker;
    }

    public static final /* synthetic */ void access$setMuteMicAndSpeaker$p(DefaultAudioClientController $this, boolean bl) {
        $this.muteMicAndSpeaker = bl;
    }

    public static final /* synthetic */ boolean access$getDEFAULT_PRESENTER$p(DefaultAudioClientController $this) {
        return $this.DEFAULT_PRESENTER;
    }

    public static final /* synthetic */ int access$getAUDIO_CLIENT_RESULT_SUCCESS$p(DefaultAudioClientController $this) {
        return $this.AUDIO_CLIENT_RESULT_SUCCESS;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultAudioClientController $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getTAG$p(DefaultAudioClientController $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ EventAnalyticsController access$getEventAnalyticsController$p(DefaultAudioClientController $this) {
        return $this.eventAnalyticsController;
    }

    public static final /* synthetic */ void access$resetAudioManager(DefaultAudioClientController $this) {
        $this.resetAudioManager();
    }

    public static final /* synthetic */ void access$notifyStop(DefaultAudioClientController $this) {
        $this.notifyStop();
    }

    public static final /* synthetic */ AudioClientObserver access$getAudioClientObserver$p(DefaultAudioClientController $this) {
        return $this.audioClientObserver;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/DefaultAudioClientController$Companion;", "", "()V", "audioClientState", "Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientState;", "getAudioClientState", "()Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientState;", "setAudioClientState", "(Lcom/amazonaws/services/chime/sdk/meetings/internal/audio/AudioClientState;)V", "amazon-chime-sdk_release"})
    public static final class Companion {
        @NotNull
        public final AudioClientState getAudioClientState() {
            return audioClientState;
        }

        public final void setAudioClientState(@NotNull AudioClientState audioClientState) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)audioClientState), (String)"<set-?>");
            DefaultAudioClientController.audioClientState = audioClientState;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

