/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.device;

import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Size;
import com.amazonaws.services.chime.sdk.meetings.audiovideo.video.capture.VideoCaptureFormat;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDevice$WhenMappings;
import com.amazonaws.services.chime.sdk.meetings.device.MediaDeviceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\fH\u00d6\u0001J\b\u0010\u0019\u001a\u00020\u0003H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "", "label", "", "type", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDeviceType;", "id", "(Ljava/lang/String;Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDeviceType;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getLabel", "order", "", "getOrder", "()I", "getType", "()Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDeviceType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "amazon-chime-sdk_release"})
public final class MediaDevice {
    private final int order;
    @NotNull
    private final String label;
    @NotNull
    private final MediaDeviceType type;
    @Nullable
    private final String id;
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    public static final Companion Companion = new Companion(null);

    public final int getOrder() {
        return this.order;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    @NotNull
    public final MediaDeviceType getType() {
        return this.type;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public MediaDevice(@NotNull String label, @NotNull MediaDeviceType type, @Nullable String id) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.label = label;
        this.type = type;
        this.id = id;
        switch (MediaDevice$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 5: {
                n = 3;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 7: {
                n = 5;
                break;
            }
            case 8: {
                n = 6;
                break;
            }
            default: {
                n = 99;
            }
        }
        this.order = n;
    }

    public /* synthetic */ MediaDevice(String string, MediaDeviceType mediaDeviceType, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(string, mediaDeviceType, string2);
    }

    static {
        NANO_SECONDS_PER_SECOND = 1.0E9;
    }

    @NotNull
    public final String component1() {
        return this.label;
    }

    @NotNull
    public final MediaDeviceType component2() {
        return this.type;
    }

    @Nullable
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final MediaDevice copy(@NotNull String label, @NotNull MediaDeviceType type, @Nullable String id) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return new MediaDevice(label, type, id);
    }

    public static /* synthetic */ MediaDevice copy$default(MediaDevice mediaDevice, String string, MediaDeviceType mediaDeviceType, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = mediaDevice.label;
        }
        if ((n & 2) != 0) {
            mediaDeviceType = mediaDevice.type;
        }
        if ((n & 4) != 0) {
            string2 = mediaDevice.id;
        }
        return mediaDevice.copy(string, mediaDeviceType, string2);
    }

    public int hashCode() {
        String string = this.label;
        MediaDeviceType mediaDeviceType = this.type;
        String string2 = this.id;
        return ((string != null ? string.hashCode() : 0) * 31 + (mediaDeviceType != null ? ((Object)((Object)mediaDeviceType)).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MediaDevice)) break block3;
                MediaDevice mediaDevice = (MediaDevice)object;
                if (!Intrinsics.areEqual((Object)this.label, (Object)mediaDevice.label) || !Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)mediaDevice.type)) || !Intrinsics.areEqual((Object)this.id, (Object)mediaDevice.id)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice$Companion;", "", "()V", "NANO_SECONDS_PER_SECOND", "", "listSupportedVideoCaptureFormats", "", "Lcom/amazonaws/services/chime/sdk/meetings/audiovideo/video/capture/VideoCaptureFormat;", "cameraManager", "Landroid/hardware/camera2/CameraManager;", "mediaDevice", "Lcom/amazonaws/services/chime/sdk/meetings/device/MediaDevice;", "listVideoDevices", "amazon-chime-sdk_release"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<MediaDevice> listVideoDevices(@NotNull CameraManager cameraManager) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)cameraManager, (String)"cameraManager");
            String[] stringArray = cameraManager.getCameraIdList();
            Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"cameraManager.cameraIdList");
            String[] $this$map$iv = stringArray;
            boolean $i$f$map = false;
            String[] stringArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int j = 0; j < n; ++j) {
                MediaDevice mediaDevice;
                CameraCharacteristics characteristics;
                void id;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)cameraManager.getCameraCharacteristics((String)id), (String)"cameraManager.getCameraCharacteristics(id)");
                if ((Integer)characteristics.get(CameraCharacteristics.LENS_FACING) != null) {
                    Integer n2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Integer it = n2;
                    boolean bl4 = false;
                    Integer n3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"it");
                    MediaDeviceType type = MediaDeviceType.Companion.fromCameraMetadata(n3);
                    mediaDevice = new MediaDevice((String)id + " (" + (Object)((Object)type) + ')', type, (String)id);
                } else {
                    mediaDevice = new MediaDevice((String)id + " (" + MediaDeviceType.Companion + ".OTHER)", MediaDeviceType.OTHER, (String)id);
                }
                MediaDevice mediaDevice2 = mediaDevice;
                collection.add(mediaDevice2);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VideoCaptureFormat> listSupportedVideoCaptureFormats(@NotNull CameraManager cameraManager, @NotNull MediaDevice mediaDevice) {
            void $this$mapTo$iv$iv;
            Size[] nativeSizes;
            Intrinsics.checkParameterIsNotNull((Object)cameraManager, (String)"cameraManager");
            Intrinsics.checkParameterIsNotNull((Object)mediaDevice, (String)"mediaDevice");
            String string = mediaDevice.getId();
            if (string == null) {
                return CollectionsKt.emptyList();
            }
            CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)cameraCharacteristics, (String)"cameraManager.getCameraC\u2026id ?: return emptyList())");
            CameraCharacteristics characteristics = cameraCharacteristics;
            StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (streamConfigurationMap == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)streamConfigurationMap, (String)"characteristics.get(Came\u2026    ?: return emptyList()");
            StreamConfigurationMap streamMap = streamConfigurationMap;
            Size[] sizeArray = streamMap.getOutputSizes(SurfaceTexture.class);
            if (sizeArray == null) {
                return CollectionsKt.emptyList();
            }
            Size[] $this$map$iv = nativeSizes = sizeArray;
            boolean $i$f$map = false;
            Size[] sizeArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var11_11 = $this$mapTo$iv$iv;
            int n = ((void)var11_11).length;
            for (int j = 0; j < n; ++j) {
                void size;
                void item$iv$iv;
                void var15_15 = item$iv$iv = var11_11[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v4 = size;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"size");
                long minFrameDurationNs = streamMap.getOutputMinFrameDuration(SurfaceTexture.class, new Size(v4.getWidth(), size.getHeight()));
                int maxFps = MathKt.roundToInt((double)(NANO_SECONDS_PER_SECOND / (double)minFrameDurationNs));
                VideoCaptureFormat videoCaptureFormat = new VideoCaptureFormat(size.getWidth(), size.getHeight(), maxFps);
                collection.add(videoCaptureFormat);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

