/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.sdk.meetings.analytics;

import com.amazonaws.services.chime.sdk.meetings.analytics.EventAttributeName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEvent;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingHistoryEventName;
import com.amazonaws.services.chime.sdk.meetings.analytics.MeetingStatsCollector;
import com.amazonaws.services.chime.sdk.meetings.utils.logger.Logger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0016J\u0018\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016j\u0002`\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/amazonaws/services/chime/sdk/meetings/analytics/DefaultMeetingStatsCollector;", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingStatsCollector;", "logger", "Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;", "(Lcom/amazonaws/services/chime/sdk/meetings/utils/logger/Logger;)V", "historyEvents", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEvent;", "maxVideoTileCount", "", "meetingStartTimeMs", "", "poorConnectionCount", "retryCount", "addMeetingHistoryEvent", "", "historyEventName", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/MeetingHistoryEventName;", "timestampMs", "getMeetingHistory", "", "getMeetingStatsEventAttributes", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributeName;", "", "Lcom/amazonaws/services/chime/sdk/meetings/analytics/EventAttributes;", "incrementPoorConnectionCount", "incrementRetryCount", "resetMeetingStats", "updateMaxVideoTile", "videoTileCount", "updateMeetingStartTimeMs", "amazon-chime-sdk_release"})
public final class DefaultMeetingStatsCollector
implements MeetingStatsCollector {
    private long meetingStartTimeMs;
    private int retryCount;
    private int poorConnectionCount;
    private int maxVideoTileCount;
    private final List<MeetingHistoryEvent> historyEvents;
    private final Logger logger;

    @Override
    public void incrementRetryCount() {
        int n = this.retryCount;
        this.retryCount = n + 1;
    }

    @Override
    public void incrementPoorConnectionCount() {
        int n = this.poorConnectionCount;
        this.poorConnectionCount = n + 1;
    }

    @Override
    public void updateMaxVideoTile(int videoTileCount) {
        this.maxVideoTileCount = RangesKt.coerceAtLeast((int)videoTileCount, (int)this.maxVideoTileCount);
    }

    @Override
    public void updateMeetingStartTimeMs() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        this.meetingStartTimeMs = calendar.getTimeInMillis();
    }

    @Override
    public void resetMeetingStats() {
        this.meetingStartTimeMs = 0L;
        this.retryCount = 0;
        this.poorConnectionCount = 0;
        this.maxVideoTileCount = 0;
    }

    @Override
    @NotNull
    public Map<EventAttributeName, Object> getMeetingStatsEventAttributes() {
        long l;
        Pair[] pairArray = new Pair[4];
        pairArray[0] = TuplesKt.to((Object)((Object)EventAttributeName.maxVideoTileCount), (Object)this.maxVideoTileCount);
        pairArray[1] = TuplesKt.to((Object)((Object)EventAttributeName.retryCount), (Object)this.retryCount);
        pairArray[2] = TuplesKt.to((Object)((Object)EventAttributeName.poorConnectionCount), (Object)this.poorConnectionCount);
        if (this.meetingStartTimeMs == 0L) {
            l = 0L;
        } else {
            Calendar calendar = Calendar.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
            l = calendar.getTimeInMillis() - this.meetingStartTimeMs;
        }
        pairArray[3] = TuplesKt.to((Object)((Object)EventAttributeName.meetingDurationMs), (Object)l);
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Override
    public void addMeetingHistoryEvent(@NotNull MeetingHistoryEventName historyEventName, long timestampMs) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)historyEventName), (String)"historyEventName");
        this.historyEvents.add(new MeetingHistoryEvent(historyEventName, timestampMs));
    }

    @Override
    @NotNull
    public List<MeetingHistoryEvent> getMeetingHistory() {
        return this.historyEvents;
    }

    public DefaultMeetingStatsCollector(@NotNull Logger logger) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        DefaultMeetingStatsCollector defaultMeetingStatsCollector = this;
        boolean bl = false;
        defaultMeetingStatsCollector.historyEvents = list = (List)new ArrayList();
    }
}

