/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Supplier;
import software.amazon.smithy.jmespath.ast.LiteralExpression;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.traits.RangeTrait;

final class ModelRuntimeTypeGenerator
implements ShapeVisitor<Object> {
    private final Model model;
    private Set<MemberShape> visited = new HashSet<MemberShape>();

    ModelRuntimeTypeGenerator(Model model) {
        this.model = model;
    }

    public Object blobShape(BlobShape shape) {
        return "blob";
    }

    public Object booleanShape(BooleanShape shape) {
        return true;
    }

    public Object byteShape(ByteShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object shortShape(ShortShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object integerShape(IntegerShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object longShape(LongShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object floatShape(FloatShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object doubleShape(DoubleShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object bigIntegerShape(BigIntegerShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object bigDecimalShape(BigDecimalShape shape) {
        return this.computeRange((Shape)shape);
    }

    public Object documentShape(DocumentShape shape) {
        return LiteralExpression.ANY;
    }

    public Object stringShape(StringShape shape) {
        int chars = this.computeLength((Shape)shape);
        return new String(new char[chars]).replace("\u0000", "a");
    }

    public Object listShape(ListShape shape) {
        return this.withCopiedVisitors(() -> {
            int size = this.computeLength((Shape)shape);
            ArrayList<Object> result = new ArrayList<Object>(size);
            Object memberValue = shape.getMember().accept((ShapeVisitor)this);
            if (memberValue != null) {
                for (int i = 0; i < size; ++i) {
                    result.add(memberValue);
                }
            }
            return result;
        });
    }

    private Object withCopiedVisitors(Supplier<Object> supplier) {
        HashSet<MemberShape> visitedCopy = new HashSet<MemberShape>(this.visited);
        Object result = supplier.get();
        this.visited = visitedCopy;
        return result;
    }

    public Object mapShape(MapShape shape) {
        return this.withCopiedVisitors(() -> {
            int size = this.computeLength((Shape)shape);
            HashMap<String, Object> result = new HashMap<String, Object>();
            String key = (String)shape.getKey().accept((ShapeVisitor)this);
            Object memberValue = shape.getValue().accept((ShapeVisitor)this);
            for (int i = 0; i < size; ++i) {
                result.put(key + i, memberValue);
            }
            return result;
        });
    }

    public Object structureShape(StructureShape shape) {
        return this.structureOrUnion((Shape)shape);
    }

    public Object unionShape(UnionShape shape) {
        return this.structureOrUnion((Shape)shape);
    }

    private Object structureOrUnion(Shape shape) {
        return this.withCopiedVisitors(() -> {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (MemberShape member : shape.members()) {
                Object memberValue = member.accept((ShapeVisitor)this);
                result.put(member.getMemberName(), memberValue);
            }
            return result;
        });
    }

    public Object memberShape(MemberShape shape) {
        if (!this.visited.add(shape)) {
            return LiteralExpression.ANY;
        }
        return this.model.getShape(shape.getTarget()).map(target -> target.accept((ShapeVisitor)this)).orElse(LiteralExpression.ANY);
    }

    public Object timestampShape(TimestampShape shape) {
        return LiteralExpression.NUMBER;
    }

    public Object operationShape(OperationShape shape) {
        throw new UnsupportedOperationException(shape.toString());
    }

    public Object resourceShape(ResourceShape shape) {
        throw new UnsupportedOperationException(shape.toString());
    }

    public Object serviceShape(ServiceShape shape) {
        throw new UnsupportedOperationException(shape.toString());
    }

    private int computeLength(Shape shape) {
        int chars = 2;
        if (shape.hasTrait(LengthTrait.class)) {
            LengthTrait trait = (LengthTrait)shape.expectTrait(LengthTrait.class);
            if (trait.getMin().isPresent()) {
                chars = Math.max(chars, ((Long)trait.getMin().get()).intValue());
            }
            if (trait.getMax().isPresent()) {
                chars = Math.min(chars, ((Long)trait.getMax().get()).intValue());
            }
        }
        return chars;
    }

    private double computeRange(Shape shape) {
        double i = 8.0;
        if (shape.hasTrait(RangeTrait.class)) {
            RangeTrait trait = (RangeTrait)shape.expectTrait(RangeTrait.class);
            if (trait.getMin().isPresent()) {
                i = Math.max(i, ((BigDecimal)trait.getMin().get()).doubleValue());
            }
            if (trait.getMax().isPresent()) {
                i = Math.min(i, ((BigDecimal)trait.getMax().get()).doubleValue());
            }
        }
        return i;
    }
}

