/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.waiters;

import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.waiters.PathMatcher;

public abstract class Matcher<T>
implements ToNode {
    private Matcher() {
    }

    public abstract T getValue();

    public abstract String getMemberName();

    public abstract <U> U accept(Visitor<U> var1);

    public final int hashCode() {
        return Objects.hash(this.getMemberName(), this.getValue());
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher)o;
        return this.getMemberName().equals(other.getMemberName()) && this.getValue().equals(other.getValue());
    }

    public static Matcher<?> fromNode(Node node) {
        ObjectNode value = node.expectObjectNode();
        if (value.size() != 1) {
            throw new ExpectationNotMetException("Union value must have exactly one value set", (FromSourceLocation)node);
        }
        Map.Entry entry = value.getMembers().entrySet().iterator().next();
        String entryKey = ((StringNode)entry.getKey()).getValue();
        Node entryValue = (Node)entry.getValue();
        switch (entryKey) {
            case "output": {
                return new OutputMember(PathMatcher.fromNode(entryValue));
            }
            case "inputOutput": {
                return new InputOutputMember(PathMatcher.fromNode(entryValue));
            }
            case "success": {
                return new SuccessMember(entryValue.expectBooleanNode().getValue());
            }
            case "errorType": {
                return new ErrorTypeMember(entryValue.expectStringNode().getValue());
            }
        }
        return new UnknownMember(entryKey, entryValue);
    }

    public static final class OutputMember
    extends PathMatcherMember {
        public OutputMember(PathMatcher value) {
            super("output", value);
        }

        @Override
        public <U> U accept(Visitor<U> visitor) {
            return visitor.visitOutput(this);
        }
    }

    public static final class InputOutputMember
    extends PathMatcherMember {
        public InputOutputMember(PathMatcher value) {
            super("inputOutput", value);
        }

        @Override
        public <U> U accept(Visitor<U> visitor) {
            return visitor.visitInputOutput(this);
        }
    }

    public static final class SuccessMember
    extends Matcher<Boolean> {
        private final boolean value;

        public SuccessMember(boolean value) {
            this.value = value;
        }

        @Override
        public String getMemberName() {
            return "success";
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }

        public Node toNode() {
            return Node.objectNode().withMember(this.getMemberName(), (ToNode)Node.from((boolean)this.value));
        }

        @Override
        public <U> U accept(Visitor<U> visitor) {
            return visitor.visitSuccess(this);
        }
    }

    public static final class ErrorTypeMember
    extends Matcher<String> {
        private final String value;

        public ErrorTypeMember(String value) {
            this.value = value;
        }

        @Override
        public String getMemberName() {
            return "errorType";
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public Node toNode() {
            return Node.objectNode().withMember(this.getMemberName(), (ToNode)Node.from((String)this.value));
        }

        @Override
        public <U> U accept(Visitor<U> visitor) {
            return visitor.visitErrorType(this);
        }
    }

    public static final class UnknownMember
    extends Matcher<Node> {
        private final String key;
        private final Node value;

        public UnknownMember(String key, Node value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getMemberName() {
            return this.key;
        }

        @Override
        public Node getValue() {
            return this.value;
        }

        public Node toNode() {
            return Node.objectNode().withMember(this.getMemberName(), (ToNode)this.getValue());
        }

        @Override
        public <U> U accept(Visitor<U> visitor) {
            return visitor.visitUnknown(this);
        }
    }

    private static abstract class PathMatcherMember
    extends Matcher<PathMatcher> {
        private final String memberName;
        private final PathMatcher value;

        private PathMatcherMember(String memberName, PathMatcher value) {
            this.memberName = memberName;
            this.value = value;
        }

        @Override
        public final String getMemberName() {
            return this.memberName;
        }

        @Override
        public final PathMatcher getValue() {
            return this.value;
        }

        public final Node toNode() {
            return Node.objectNode().withMember(this.getMemberName(), (ToNode)this.value.toNode());
        }
    }

    public static interface Visitor<T> {
        public T visitOutput(OutputMember var1);

        public T visitInputOutput(InputOutputMember var1);

        public T visitSuccess(SuccessMember var1);

        public T visitErrorType(ErrorTypeMember var1);

        public T visitUnknown(UnknownMember var1);
    }
}

