/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

public class CycleException
extends RuntimeException {
    private final List<?> sortedNodes;
    private final Set<?> cyclicNodes;
    private final Class<?> nodeType;

    public <T> CycleException(List<T> sortedNodes, Set<T> cyclicNodes) {
        super(String.format("Cycle(s) detected amongst: [%s]", cyclicNodes.stream().map(Object::toString).collect(Collectors.joining(", "))));
        this.sortedNodes = ListUtils.copyOf(sortedNodes);
        this.cyclicNodes = SetUtils.orderedCopyOf(cyclicNodes);
        if (this.cyclicNodes.isEmpty()) {
            throw new IllegalArgumentException("Cyclic nodes cannot be empty");
        }
        this.nodeType = this.cyclicNodes.iterator().next().getClass();
    }

    public <T> Set<T> getCyclicNodes(Class<T> expectedNodeType) {
        if (expectedNodeType.isAssignableFrom(this.nodeType)) {
            return this.cyclicNodes;
        }
        throw new IllegalArgumentException(String.format("Expected node type %s is not assignable from actual node type %s", expectedNodeType.getName(), this.nodeType.getName()));
    }

    public <T> List<T> getSortedNodes(Class<T> expectedNodeType) {
        if (expectedNodeType.isAssignableFrom(this.nodeType)) {
            return this.sortedNodes;
        }
        throw new IllegalArgumentException(String.format("Expected node type %s is not assignable from actual node type %s", expectedNodeType.getName(), this.nodeType.getName()));
    }
}

