/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IoUtils {
    private static final Logger LOGGER = Logger.getLogger(IoUtils.class.getName());
    private static final int BUFFER_SIZE = 8192;

    private IoUtils() {
    }

    public static byte[] toByteArray(InputStream is) {
        byte[] byArray;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            int n;
            byte[] b = new byte[8192];
            while ((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }
            byArray = output.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        output.close();
        return byArray;
    }

    public static String toUtf8String(InputStream is) {
        return new String(IoUtils.toByteArray(is), StandardCharsets.UTF_8);
    }

    public static String readUtf8File(String path) {
        return IoUtils.readUtf8File(Paths.get(path, new String[0]));
    }

    public static String readUtf8File(Path path) {
        try {
            return new String(Files.readAllBytes(path.toRealPath(new LinkOption[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readUtf8Resource(ClassLoader classLoader, String resourcePath) {
        return IoUtils.readUtf8Url(classLoader.getResource(resourcePath));
    }

    public static String readUtf8Resource(Class<?> clazz, String resourcePath) {
        return IoUtils.readUtf8Url(clazz.getResource(resourcePath));
    }

    public static String readUtf8Url(URL url) {
        String string;
        block8: {
            InputStream is = url.openStream();
            try {
                string = IoUtils.toUtf8String(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return string;
    }

    public static String runCommand(String command) {
        return IoUtils.runCommand(command, Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    public static String runCommand(String command, Path directory) {
        StringBuilder sb = new StringBuilder();
        int exitValue = IoUtils.runCommand(command, directory, sb);
        if (exitValue != 0) {
            throw new RuntimeException(String.format("Command `%s` failed with exit code %d and output:%n%n%s", command, exitValue, sb));
        }
        return sb.toString();
    }

    public static int runCommand(String command, Path directory, Appendable output) {
        return IoUtils.runCommand(command, directory, output, Collections.emptyMap());
    }

    public static int runCommand(String command, Path directory, Appendable output, Map<String, String> env) {
        List<String> finalizedCommand = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows") ? Arrays.asList("cmd.exe", "/c", command) : Arrays.asList("sh", "-c", command);
        return IoUtils.runCommand(finalizedCommand, directory, output, env);
    }

    public static int runCommand(List<String> args, Path directory, Appendable output, Map<String, String> env) {
        return IoUtils.runCommand(args, directory, null, output, env);
    }

    public static int runCommand(List<String> args, Path directory, InputStream input, Appendable output, Map<String, String> env) {
        ProcessBuilder processBuilder = new ProcessBuilder(args).directory(Objects.requireNonNull(directory.toFile(), "Process directory cannot be null")).redirectErrorStream(true);
        processBuilder.environment().putAll(env);
        try {
            Process process = processBuilder.start();
            if (input != null) {
                OutputStream outputStream = process.getOutputStream();
                IoUtils.copyInputToOutput(input, outputStream);
                IoUtils.quietlyCloseStream(args, outputStream);
            }
            try (BufferedReader bufferedStdoutReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = bufferedStdoutReader.readLine()) != null) {
                    output.append(line).append(System.lineSeparator());
                }
            }
            return process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyInputToOutput(InputStream source, OutputStream sink) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = source.read(buffer, 0, 8192)) >= 0) {
            sink.write(buffer, 0, read);
        }
    }

    private static void quietlyCloseStream(List<String> args, OutputStream outputStream) {
        try {
            outputStream.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to close outputStream for " + args, e);
        }
    }

    public static boolean rmdir(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        try {
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return Files.isSymbolicLink(dir) ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting directory: " + dir + ": " + e.getMessage(), e);
        }
        return true;
    }
}

