/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.function.Function;

interface CopyOnWriteRef<T> {
    public T get();

    public T peek();

    public static <T> CopyOnWriteRef<T> fromBorrowed(final T borrowedValue, final Function<T, T> copyFunction) {
        return new CopyOnWriteRef<T>(){
            private T copy;

            @Override
            public T peek() {
                return this.copy != null ? this.copy : borrowedValue;
            }

            @Override
            public T get() {
                Object result = this.copy;
                if (result == null) {
                    this.copy = result = copyFunction.apply(borrowedValue);
                }
                return result;
            }
        };
    }

    public static <T> CopyOnWriteRef<T> fromOwned(final T owned) {
        return new CopyOnWriteRef<T>(){

            @Override
            public T peek() {
                return owned;
            }

            @Override
            public T get() {
                return owned;
            }
        };
    }
}

