/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class CodeWriterFormatterContainer {
    static final char[] VALID_FORMATTER_CHARS = new char[]{'!', '#', '%', '&', '*', '+', ',', '-', '.', '/', ';', '=', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '^', '_', '`', '~'};
    private final Map<Character, BiFunction<Object, String, String>> formatters = new HashMap<Character, BiFunction<Object, String, String>>();
    private final CodeWriterFormatterContainer parent;

    CodeWriterFormatterContainer() {
        this(null);
    }

    CodeWriterFormatterContainer(CodeWriterFormatterContainer parent) {
        this.parent = parent;
    }

    void putFormatter(Character identifier, BiFunction<Object, String, String> formatFunction) {
        if (Arrays.binarySearch(VALID_FORMATTER_CHARS, identifier.charValue()) < 0) {
            throw new IllegalArgumentException("Invalid formatter identifier: " + identifier);
        }
        this.formatters.put(identifier, formatFunction);
    }

    BiFunction<Object, String, String> getFormatter(char identifier) {
        BiFunction<Object, String, String> result = this.formatters.get(Character.valueOf(identifier));
        if (result == null && this.parent != null) {
            result = this.parent.getFormatter(identifier);
        }
        return result;
    }
}

