/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.io.IOException;
import java.io.StringReader;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.utils.MediaType;
import software.amazon.smithy.utils.StringUtils;

public final class ProtocolTestValidationUtils {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    private ProtocolTestValidationUtils() {
    }

    public static Optional<Exception> validateMediaType(String body, String rawMediaType) {
        if (StringUtils.isEmpty((CharSequence)body) || StringUtils.isEmpty((CharSequence)rawMediaType)) {
            return Optional.empty();
        }
        MediaType mediaType = MediaType.from((String)rawMediaType);
        if (ProtocolTestValidationUtils.isXml(mediaType)) {
            return ProtocolTestValidationUtils.validateXml(body);
        }
        if (ProtocolTestValidationUtils.isJson(mediaType)) {
            return ProtocolTestValidationUtils.validateJson(body);
        }
        return Optional.empty();
    }

    private static boolean isXml(MediaType mediaType) {
        return mediaType.getSubtype().equals("xml") || mediaType.getSuffix().orElse("").equals("xml");
    }

    private static Optional<Exception> validateXml(String body) {
        try {
            DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            builder.parse(new InputSource(new StringReader(body)));
            return Optional.empty();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return Optional.of(e);
        }
    }

    private static boolean isJson(MediaType mediaType) {
        return mediaType.getSubtype().equals("json") || mediaType.getSuffix().orElse("").equals("json");
    }

    private static Optional<Exception> validateJson(String body) {
        try {
            Node.parse((String)body);
            return Optional.empty();
        }
        catch (ModelSyntaxException e) {
            return Optional.of(e);
        }
    }

    static {
        try {
            DOCUMENT_BUILDER_FACTORY.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DOCUMENT_BUILDER_FACTORY.setXIncludeAware(false);
            DOCUMENT_BUILDER_FACTORY.setExpandEntityReferences(false);
            DOCUMENT_BUILDER_FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DOCUMENT_BUILDER_FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

