/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.protocoltests.traits;

import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.protocoltests.traits.HttpMalformedResponseBodyDefinition;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.SmithyUnstableApi;
import software.amazon.smithy.utils.ToSmithyBuilder;

@SmithyUnstableApi
public final class HttpMalformedResponseDefinition
implements ToNode,
ToSmithyBuilder<HttpMalformedResponseDefinition> {
    private static final String BODY = "body";
    private static final String CODE = "code";
    private static final String HEADERS = "headers";
    private final HttpMalformedResponseBodyDefinition body;
    private final int code;
    private final Map<String, String> headers;

    private HttpMalformedResponseDefinition(Builder builder) {
        this.body = builder.body;
        this.code = builder.code;
        this.headers = (Map)builder.headers.copy();
    }

    public Optional<HttpMalformedResponseBodyDefinition> getBody() {
        return Optional.ofNullable(this.body);
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static HttpMalformedResponseDefinition fromNode(Node node) {
        Builder builder = HttpMalformedResponseDefinition.builder();
        ObjectNode o = node.expectObjectNode();
        o.getObjectMember(BODY).ifPresent(body -> builder.body(HttpMalformedResponseBodyDefinition.fromNode((Node)body)));
        o.getNumberMember(CODE).ifPresent(numberNode -> builder.code(numberNode.getValue().intValue()));
        o.getObjectMember(HEADERS).ifPresent(headers -> headers.getStringMap().forEach((k, v) -> builder.putHeader((String)k, v.expectStringNode().getValue())));
        return builder.build();
    }

    public Node toNode() {
        return Node.objectNodeBuilder().withOptionalMember(BODY, this.getBody().map(HttpMalformedResponseBodyDefinition::toNode)).withMember(CODE, (Number)this.getCode()).withOptionalMember(HEADERS, this.headers.isEmpty() ? Optional.empty() : Optional.of(ObjectNode.fromStringMap(this.getHeaders()))).build();
    }

    public Builder toBuilder() {
        Builder builder = HttpMalformedResponseDefinition.builder().headers(this.getHeaders()).code(this.getCode());
        this.getBody().ifPresent(builder::body);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements SmithyBuilder<HttpMalformedResponseDefinition> {
        private HttpMalformedResponseBodyDefinition body;
        private int code;
        private final BuilderRef<Map<String, String>> headers = BuilderRef.forOrderedMap();

        private Builder() {
        }

        public Builder body(HttpMalformedResponseBodyDefinition body) {
            this.body = body;
            return this;
        }

        public Builder code(int code) {
            this.code = code;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers.clear();
            headers.forEach(this::putHeader);
            return this;
        }

        public Builder putHeader(String key, String value) {
            ((Map)this.headers.get()).put(key, value);
            return this;
        }

        public HttpMalformedResponseDefinition build() {
            return new HttpMalformedResponseDefinition(this);
        }
    }
}

